;; -*- coding: utf-8-gb-er -*-
;; $Id: cjk-4corner.el,v 1.1 2002-12-19 12:38:51 tomo Exp $

;;; Code:

(require 'quail)

(quail-define-package "cjk-4corner" "CJK" "cjk-4corner"
 t
 "Chinese National Standard planes 3-7 + Big 5
four corner input package
mechanically extracted from the cefdb database of the
KanjiBase for Windows package written by Christian Wittern.
Extended with some add. chars and conv to UTF-8 by CW 2001-09-29"
 '(
  (">" . quail-next-translation-block)
  ("<" . quail-prev-translation-block)
  ("." . quail-next-translation-block)
  ("," . quail-prev-translation-block)
  (" " . quail-select-current)
  )
 nil nil nil nil)

;;
(quail-define-rules
;; 2FF0│ ⿰  ⿱  ⿲  ⿳  ⿴  ⿵  ⿶  ⿷  ⿸  ⿹  ⿺  ⿻  ⿼  ⿽  ⿾  ⿿ 

;; operators

("p" "⿰⿱⿲⿳⿴⿵⿶⿷⿸⿹⿺⿻")
("*" "⿰")
("/" "⿱")
("+" "⿲⿳")
("@" "⿴⿵⿶⿷⿸⿹⿺")
("%" "⿻")

("s01" "一丨丶丿乀乁乙乚乛亅")
("s02" "㐅丁丂七丄丅丆丩丷乂乃乄乜九了二亠人亻儿入八冂冖冫几凵刀刁刂力勹匕匚匸十卜卩厂厶又讠力了")
("s03" "夂夊夕大夨女子孑孒孓宀寸小尢尣尸屮山巛巜川工己已巳巾干幺广廴廾弋弓彐彑彡彳忄扌才氵犭纟门阝飞饣马女兀")
("s04" "㐊㐋㐧㓀㓁㓅㔫㔹㕕㕚㕛㝉㞢㠪㢧㲸㸦不与丏丐丑丒专丗丬中丮丯丰丹为之乌乢乣乤乥书予云互亓五井亖亢亣什仁仂仃仄仅仆仇仈仉今介仌仍从仏仐仑仒仓允兂元內公六兮兯冃冄内円冇冈冗冘凤凶刅分切刈劝办勻勼勽勾勿匀匁匂化匹区卅卆升午卝卞卬厃厄厅历厷厸厹及友双反収圠圡壬夃天太夫夬夭孔尐少尤尹尺屯屲巴巿帀币幻廿开弌弔引弖心必忆戈戶户戸手扎支攴攵文斗斤方无日曰月木朩欠止歹殳毋毌比毛氏气水火灬爪爫父爻爿片牙牛牜犬犮王罓虍见计订讣认讥贝车辶闩韦风丹不六什切")
("s05" "㐀㐌㐍㐎㐏㐰㐱㐲㐳㐴㐵㐶㐷㒰㒱㓚㓛㓜㔓㕣㕤㕥㘝㘞㘦㚈㚎㚢㝊㝋㝳㞋㞤㞥㞦㞧㠯㠲㠳㣔㣺㧃㧄㧅㲹㲺㲻㲼䍏䢳䦹䦺且丕世丘丙业丛东丝丱主丼乍乎乏乐乧亗仔仕他仗付仙仚仛仜仝仞仟仠仡仢代令以仦仧仨仩仪仫们仭兄充兰冉冊冋册写冚冬冭冮冯凥処凧凷凸凹出击刉刊刋刌刍功加务劢匃匄包匆匇北匛匜匝匞卉半卌卟占卡卢卭卮卯厇厈厉厺去厼叏叐发古句另叧叨叩只叫召叭叮可台叱史右叴叵叶号司叹叺叻叼叽叾囘囙囚四囜圢圣圤圥圦圧壭处外夗夘央夯夰失夲夳头奴奵奶孕宁宂它宄对尒尓尔尕尻尼屳屴屵屶屷左巧巨市布帄帅平幼庀庁庂広弁弍弗弘归忇忉忊戉戊戋戹扐扑扒打扔払扖斥旡旦旧曱未末本札朮术朰正歺母氐民氕氶氷永氹氺氻氾氿汀汁汃汄汅汇汈汉灭犯犰玄玉玊玌玍瓜瓦甘生用甩田由甲申甴电疋疒癶白皮皿目矛矢石示礻禸禾穴立纠罒肊讦讧讨让讪讫讬训议讯记讱轧辷邒邓钅长闪阞队饤饥驭鸟龙句北令立")
("s06" "㐁㐂㐆㐐㐑㐒㐓㐔㐕㐪㐫㐸㐹㐺㐻㐼㐽㐾㐿㑀㒫㒲㓆㓇㓙㓝㓞㔔㔕㔖㔺㔻㕂㕃㕄㕜㕦㕧㕨㘟㚏㚐㚑㚣㚤㚥㚦㚧㚨㜽㝌㝍㝼㞌㞍㞨㞩㞪㞫㞬㞭㞮㞯㠩㠴㠵㠶㡯㡰㡱㢟㢨㢩㢪㢫㣉㣕㣻㣼㣾㣿㧆㧇㧈㪲㪳㫃㫐㫑㬰㭁㱏㱙㲌㲽㲿㶡㶢㸨㺨㺩㺪㺫䂖䇂䏌䏍䒑䖈䢴䦻丞丟丠両丢乑乒乓乔乨乩乪乫乬乭乮乯买争亘亙亚交亥亦产仮仯仰仱仲仳仴仵件价仸仹仺任仼份仾仿伀企伂伃伄伅伆伇伈伉伊伋伌伍伎伏伐休伒伓伔伕伖众优伙会伛伜伝伞伟传伡伢伣伤伥伦伧伨伩伪伫伬佤兆兇先光兊全共兲关兴再冎军农冰冱冲决冴凨凩凪凫凼刎刏刐刑划刓刔刕刖列刘则刚创劣劤劥劦劧动匈匟匠匡匢卋卍华协卐印危厊压厌厍厽厾叒叿吀吁吂吃各吅吆吇合吉吊吋同名后吏吐向吒吓吔吕吖吗囝回囟因囡团団在圩圪圫圬圭圮圯地圱圲圳圴圵圶圷圸圹场壮夅夙多夛夵夶夷夸夹夺夻夼奷奸她奺奻奼好奾奿妀妁如妃妄妅妆妇妈孖字存孙宅宆宇守安寺寻导尖尗尘尥尦尧尽屰屸屹屺屻屼屽屾屿岀岁岂岃州巟巩巪帆帇师年幵庄庅庆廵异弎式弐弙弚弛弜当彴彵忈忋忏忓忔忕忖忘忚忛戌戍戎戏扏扗托扙扚扛扜扝扞扠扡扢扣扤扥扦执扨扩扪扫扬攰收攷旨早旪旫旬旭旮旯曲曳有朱朲朳朴朵朶朷朸朹机朻朼朽朾朿杀杁杂权次欢此死毎毕氒氖気氘氼氽求汆汊汋汌汍汎汏汐汑汒汓汔汕汗汘汙汚汛汜汝江池污汢汣汤灮灯灰灱灲灳炇爷牝牞牟犱犲犳犴犵状犷犸玎玏玐玑甪甶百癿礼穵竹米糸糹纡红纣纤纥约级纨纩纪纫纶缶网羊羽老耂考而耒耳聿肀肉肋肌肍肎臣自至臼舌舛舟艮色艸艹虎虏虫血行衣衤襾西覀观讲讳讴讵讶讷许讹论讻讼讽设访诀贞负贠轨辸边辺辻込辽邔邖邗邘邙邚邛邜邝钆钇闫闬闭问闯阠阡阢阣阤页饦饧驮驯驰齐老肋年列劣吏宅行礼羽")

("t01" "⺃⺄")
("t02" "⺅𠂉")
("t03" "")
("t04" "")
("t05" "")
("t06" "⾆")
("t07" "")
("t08" "&CDP-8C49;")
("t09" "")
("t10" "")
("t11" "")
("t12" "")
("t13" "")
("t14" "")

("r001" "一")
("r002" "丨")
("r003" "丶")
("r004" "丿")
("r005" "乙⺂⺃⺄")
("r006" "亅")
("r007" "二")
("r008" "亠")
("r009" "人亻⺅𠂉")
("r010" "儿")
("r011" "入")
("r012" "八")
("r013" "冂")
("r014" "冖")
("r015" "冫")
("r016" "几⺇")
("r017" "凵")
("r018" "刀⺈刂")
("r019" "力")
("r020" "勹")
("r021" "匕")
("r022" "匚")
("r023" "匸")
("r024" "十")
("r025" "卜⺊")
("r026" "卩⺋")
("r027" "厂⺁")
("r028" "厶")
("r029" "又")
("r030" "口")
("r031" "囗")
("r032" "土")
("r033" "士")
("r034" "夂")
("r035" "夊")
("r036" "夕")
("r037" "大")
("r038" "女")
("r039" "子")
("r040" "宀")
("r041" "寸")
("r042" "小⺌⺍")
("r043" "尢⺎⺏⺐⺑")
("r044" "尸")
("r045" "屮")
("r046" "山")
("r047" "巛")
("r048" "工")
("r049" "己")
("r050" "巾")
("r051" "干")
("r052" "幺")
("r053" "广")
("r054" "廴")
("r055" "廾")
("r056" "弋")
("r057" "弓")
("r058" "彐⺔⺕")
("r059" "彡")
("r060" "彳")
("r061" "心⺖⺗")
("r062" "戈")
("r063" "戶")
("r064" "手⺘")
("r065" "支")
("r066" "攴⺙")
("r067" "文")
("r068" "斗")
("r069" "斤")
("r070" "方")
("r071" "无")
("r072" "日⺜")
("r073" "曰")
("r074" "月⺝")
("r075" "木")
("r076" "欠")
("r077" "止")
("r078" "歹⺞")
("r079" "殳")
("r080" "毋")
("r081" "比")
("r082" "毛")
("r083" "氏")
("r084" "气")
("r085" "水⺡⺢")
("r086" "火⺣")
("r087" "爪")
("r088" "父")
("r089" "爻")
("r090" "爿⺦")
("r091" "片")
("r092" "牙")
("r093" "牛⺧")
("r094" "犬⺨")
("r095" "玄")
("r096" "玉⺩")
("r097" "瓜")
("r098" "瓦")
("r099" "甘")
("r100" "生")
("r101" "用")
("r102" "田")
("r103" "疋⺪")
("r104" "疒")
("r105" "癶")
("r106" "白")
("r107" "皮")
("r108" "皿")
("r109" "目⺫")
("r110" "矛")
("r111" "矢")
("r112" "石")
("r113" "示⺬⺭")
("r114" "禸")
("r115" "禾")
("r116" "穴")
("r117" "立")
("r118" "竹⺮")
("r119" "米")
("r120" "糸⺯⺰")
("r121" "缶")
("r122" "网⺱⺲⺳⺴")
("r123" "羊⺶")
("r124" "羽")
("r125" "老⺹")
("r126" "而")
("r127" "耒")
("r128" "耳")
("r129" "聿⺺⺻")
("r130" "肉⺼")
("r131" "臣")
("r132" "自")
("r133" "至")
("r134" "臼⺽")
("r135" "舌")
("r136" "舛")
("r137" "舟")
("r138" "艮")
("r139" "色")
("r140" "艸⺾⺿⻀")
("r141" "虍⻁")
("r142" "虫")
("r143" "血")
("r144" "行")
("r145" "衣⻂")
("r146" "襾⻃⻄")
("r147" "見⻅")
("r148" "角⻆⻇")
("r149" "言⻈")
("r150" "谷")
("r151" "豆")
("r152" "豕")
("r153" "豸")
("r154" "貝⻉")
("r155" "赤")
("r156" "走")
("r157" "足⻊")
("r158" "身")
("r159" "車⻋")
("r160" "辛")
("r161" "辰")
("r162" "辵⻌⻍⻎")
("r163" "邑⻏")
("r164" "酉")
("r165" "釆")
("r166" "里")
("r167" "金⻐")
("r168" "長⻑⻒⻓")
("r169" "門⻔")
("r170" "阜⻕⻖")
("r171" "隶")
("r172" "隹")
("r173" "雨⻗")
("r174" "靑⻘")
("r175" "非")
("r176" "面")
("r177" "革")
("r178" "韋⻙")
("r179" "韭")
("r180" "音")
("r181" "頁⻚")
("r182" "風⻛")
("r183" "飛⻜")
("r184" "食⻝⻞⻟⻠")
("r185" "首⻡")
("r186" "香")
("r187" "馬⻢")
("r188" "骨⻣")
("r189" "高")
("r190" "髟")
("r191" "鬥")
("r192" "鬯")
("r193" "鬲")
("r194" "鬼⻤")
("r195" "魚⻥")
("r196" "鳥⻦")
("r197" "鹵⻧")
("r198" "鹿")
("r199" "麥⻨")
("r200" "麻")
("r201" "黃⻩")
("r202" "黍")
("r203" "黑")
("r204" "黹")
("r205" "黽⻪")
("r206" "鼎")
("r207" "鼓")
("r208" "鼠")
("r209" "鼻")
("r210" "齊⻫⻬")
("r211" "齒⻭⻮")
("r212" "龍⻯⻰")
("r213" "龜⻱⻲⻳")
("r214" "龠")
("0010" "㙜㙶㻾䜃䥆主亶堃壅斖疒立童衁銮鏖韲亹𥁃𥂓𥂬𥃂𡔞𤣴𠆊&M-45326;𥂡𥂶𥪽𥪿𥫍&C7-5A2A;𣁫&M-47716;")
("0011" "㽵㽸㾃㾌㾏㾖㾚㾠㾣㾤㾩㾮㾷㿈㿑㿖㿚㿛疕疘疙疟疣疤疪疯疰疱疵疶疸疽痄痆症痉痊痓痖痘痙痜痝痤痥痱痷痽瘂瘇瘋瘎瘗瘞瘟瘣瘥瘧瘪瘫瘽癃癍癕癙癧癯癰癱竝𤴦癨𤴱𤴯𤵀𤴸𥩣𤷀𤶶𤶨𤷄𤷊𤷅𤷏𤷉𤷾𤸱𤺄𤺺𤼃𤴥𤵁𤵛𤵙𤵞𤵾𤶁𤵻𤷁𤶚𤶛𤶜𤷷𤸩𤸸𤸳𤹩𤹡𤺌𤺷𤻜𤻷𤼘𤴪𤴰𤴴𤴺𤵔𤵦𤵩𤵚𤵢𤵿𠅪𤶢𤶙𠅰𤷋𤷂𥪐𥪑&C6-5970;𤸙𤸇𤹍𤸰𤹪𤹻𤺝𤺙&M-33641;𤻕𤻸&C7-5572;&C7-5B23;𤼐")
("0012" "㽱㽲㾅㾍㾐㾓㾙㾟㾡㾨㾫㾶㾸㾺㾿㿃㿕㿜疓疔疖疗疠疡疥疨疴疹疿痀病痈痌痏痑痛痟痡痢痧痨痫痬痭痸痹痾瘉瘌瘍瘑瘠瘮瘳瘸瘹瘺癆癇癎癘癟癠癤癵鸾疞𤴽𤴾𤵼㾰𤸒𤷽𤺉𤸋𤸷𤺊𤺗𤻈𤻚𤻞𤼒𤵠𤷗𤷔𤷸𤸀𤸎𤸹𤸮𤸼𤹞𤹧𤹢𤺖𤺩𤺎𤺐𤺻𤺼𤻝𤻶𤴫𤴮𥀿𤴹𤵇𤵗𤷛𤷥𤸶𤸾𤹟𤺜𤺋𤺹𤺛𤺨𤺇𤺿𤻉𤻨𤼑𤼡")
("0013" "㽷㽿㾀㾉㾗㾜㾯㾼㾽㾾㿆㿙䖟䗸䘇疜疦疺疼疾痃痋痍痕痣痮瘀瘃瘈瘊瘐瘓瘙瘛瘜瘝瘯瘱瘼瘾癄癊癋癒癔癢癮蚉蛮蝱螡瘬癑癏𤷜𤸁𤸄𤸬𤹤𤻘𤻱𧕢𤵂𤴻𤵘𤵨𤶝&M-33055;𤷿𤸖𤸉𤸊𤸗𤸲𤹛𤺀𤹨&M-33387;𤺸𤻄𤺾𤼂&M-33884;𤴩𤵋𤵑&C6-4232;𤶉𤶅𤶊&M-32948;&M-34229;𤶩𤶥𤶗𤷚𢞱𤸂𤸕𤸤𤸌𤸽𤹏𤹶𤺑&M-33474;𤻗𤻮𤻹𤻴&M-33764;&M-33803;&C7-5922;𤼖𤼚𤼝&M-33923;𤼠&C7-625A;𤼣𤼤")
("0014" "㽴㽹㽺㽻㾆㾈㾕㾘㾛㾥㿁㿂㿄㿒䇏疛疧疩疫疲疷痔痚痠痵痺痿瘁瘕瘘瘢瘦瘴瘷瘿癁癈癓癖癜癥癭瘻𤴨𤵤𤵧𤶀𤸑𤸵𤹣𤻂𤻢𤻖𤴧𤴳𤵟𤵽𤶤𤶖𤷌𤷖𤷹𤷙𤷘𤷎𤸓𤹥𤹴𤹬𤺓𤺅𤻅𤻁𤻙𤵍𤵣𤵡𤶌𤵷𤶟𤶡𤶣𤷠𤸃𤸟𤸞𤹉𤸿𤹱𤹫𤹹𤺍𤻺𤼄𥫉")
("0015" "㾝㿍㿏痒痗瘒癉癬癴𤷇𤷃𤸪𤹝𤴿𤵃𤸻𤻀𤼋𤵝𤵭𤵺𤵸𤶪𤶞𤸆𤺁𤺽𤻯𤻛𤻵")
("0016" "㽽㾂㾄㾇㾑㾒㾔㾞㾦㾪㾬㿇㿊㿘痁痂痐痞痦痴痻痼瘏瘔瘖瘡瘤瘩癅癐癗癚𤸅𤸠𤺈𤶓𤵹𤶘𤶕𤷑𤸈𤷼𤸔𩠾𤷻𤹜𤺏𤻃𤼅𤼁𤼍𤶷𤷐𤹦𤺦𤺧𤺒𤻣𤻳")
("0017" "㽾㾎疝疳痯癌𤶆𤸢𤹳𤻥")
("0018" "㾭㿅㿉㿌㿎㿓㿗疚疢疻痎痪痰痶瘚瘨瘲瘶癡癩癪癲𥩲𤸫𤸭𤺕癀𤴼𤷍𤺆𤺔𤻆𤻇𤻍𤼌𤼗𤼢𤷓𤸘𤸺𤹠𤺘𤼟")
("0019" "㾁㾊㾋㾢㾧㾻㿋痲痳瘭瘰瘵療癛𤷈𤸯㾹𤻲𤵥𤶔𤶠𤷆𤷕𤸴𤼀𤴷𤵫𤵜𤶫𤸏𤸍𤺚𤼆𤼙")
("0020" "䇂亨亭广弯庐夣𠅘&C5-6040;𠅠")
("0021" "𢌔&C5-7C46;𢇜𢇠𠑽𥩕𢇸𢇹𢇼&M-34096;𢈗𢈌𠅙𠅞𢈥𢉕𠅟𠅫𢉬𢊃𣨻&C6-5A51;𣩇&C6-6070;&M-33347;𡑤𥪰&C7-3523;&C7-3524;&C7-3664;𡣍𢋓𢋔&M-47632;&M-35869;&C7-444F;&M-34648;𦏞&C7-553A;&M-40955;&C7-5C45;&M-43262;&C7-5E3A;𡔏𢌒𢌓")
("0022" "㠵㡻㢁㢊㢋㢌㢏㢐㢗㢙㢚䯧䳸䵉亣商啇市帝帟席庁庈庍庎序庛庯庸庽廁廊廌廓廖廗廝廟廫彥彦斉斋方旁离肓育脔腐膏膺裔高髙鷹鹰麡齊齋齌齍齎齏齐齑斎䐡𢈉𢊯𢉨𢉿𢊁𩾦𪗅𪗆䶒𪗉𪗌䯢𪗍𧥛𠅈𢇴𢈋𢉁𢉢𢉥𢉞𠞧&M-47894;𢋄𢊶𧮼&M-47895;𢋚&M-47627;&M-47905;𦠕&C5-6B50;𢋿&M-34664;&C5-7536;&M-46471;&M-47693;&C5-7974;&C5-7A23;𡿫𢂋𢇺育&C6-2D6A;&M-34095;𢂚𢂪𢂠&C6-337B;&C6-342A;𢈭&C6-3B7A;𢉀𢈷𢉠&C6-4D39;𠹧廊𠆂𠾃𠆏𦠃&C7-362E;&M-47609;&C7-3D4A;&C7-3D4B;&M-45334;&M-47646;&C7-4622;𡃬𢑸&C7-487B;&M-47911;𡄚𢋽&M-33733;&M-47683;&M-47918;𡅟𥫐&C7-5D65;")
("0023" "㡵㡷㡾㢃㢍㢘㢜䗪䴪亷卞広庚庝庡庶康庹庾廉廕廡廰廳応應爢螷蠯豙豪麃麎麼庶麽㦄𢇗𢇻𢊗𢊕𧱏𩫕𩞁𪋐𪋚𪋗𪋝𪎭𢇨𢇤𢈝𢈙𢈸𢈳𢉭𢉝𢉟𢊇𢊅𢊒𢊜𠆁𤔨&M-47596;&M-47615;&M-47902;&M-47903;&M-47631;&C5-6D6A;𢌍𢇝𣱵&C6-2553;𢇭𢇫𢈅𣁃𢈟&M-47587;𢉛𢉶𢉡𢊔𢊭&M-47595;&M-47604;𢋜&M-47628;&M-47630;𢋪𢋭𢣽&M-45336;𢌀&C7-5151;𢌆𢌇&M-34694;&M-47694;&C7-6056;&M-47699;&M-33937;")
("0024" "㡰㡳㡿㢅㢑㢓夜庋庌底府庤度庨庪庭庰庱庳廀廄廈廋廏廒廔廚廠廢廦廮慶麛麝麞黀𢇷𢊰𢋇𦗕𢇘𢇥𢇳𢈲𢈡𢈼𢈾𢉆𢊄𡡉𢊘𢊵𡢜𢋌𢋒𢋣&M-47651;𢋻𢇛𢇙𢇩𢇯𢇪&C6-3F45;&C6-3F46;𢈹𢋁&M-49944;&M-47599;&M-47597;&C7-3E5C;&M-47635;𢌂𢌉")
("0025" "㡲㡽库庠庫廨廯摩摩犘麙&M-09299;𢈤𢈢𢈽𢉦𢳁&M-47603;𢋼&M-47685;𢈿𢳅&M-38392;&M-49757;𢋑𠆝𪎮")
("0026" "㢖䜆䴥䴦唐店庘庙庮庴廂廇廜廥廧磨譍麏麐麔麕麘黁庿麢𢇞𢉜𢉃𪋏𢇶𢇵𢈈𢈛𢈚𢉩𢊓𢋂&M-47897;𥉵&M-47619;&M-47626;&M-43303;&M-47692;&C5-786E;唐𢈬𢈞𢈣𢈺𠷗𢉧𢊂𢊉&M-35450;𢊺𢊴𢋦𢋢𢋧𢋡𥊹&M-47644;&C7-456C;𣋴𢋾")
("0027" "㢂㢎𢈂𢉂𡻤𢌕𠅏𡱀𢈊𠅡𢉈𤯌𤯎&M-47671;&M-47676;")
("0028" "㡱㡶㢔㢛㢞㸏庂庻廎廙廞廣焤賡赓黂𢊮𪎖𪎰𢉘𢈻𢊱𢋆𢋅𢒲&M-47647;𢋲𢋸&M-47919;&M-47703;𢇣𢉙𢉄𢉴𢊎𢊐𢊝𢊼&M-37835;&M-47920;&M-47922;&M-38006;")
("0029" "㢀㢝䴢床庥庩庲廩廪穈糜緳縻麖麻庺䴩𢈠𢉤𢊲𢇲𢈴𣒷𢊖𡮰𢋝&M-47913;&C6-463E;𡮎𢉫𢉣𢉪𢊆𥹺𥹹𢊨𢊪𢊻𢊳𦄐𦄊𢋯𢋰&M-47662;&M-47678;𢌋𢌑")
("0031" "𩁈")
("0032" "鴍&M-46943;&M-44920;")
("0033" "忘忞恋恴悥意懬烹亦𢡃𢣑𡿮𢗻𢛫𢜖𢝃𢞢𤍍𢢦𢥗𤓥")
("0040" "㛳䘚享卒变妄妾娈孪文斊率章辛斈変𤕚&M-43141;𠆎𢌸&C6-292B;𠅖𡕨𠆀𦕺&M-45322;𠆆𦎧𩫏&M-43166;&M-48577;交")
("0041" "亴離𨿡&M-45321;&M-44006;")
("0042" "𩫱𤰎")
("0043" "䯨䴠奕麌𩫀𠅌𡙩𥏉&M-35315;𠆇")
("0044" "㝇㦚㵷弃弈瓣竎辡辦辧辨辩辫辬辮辯㸤𥌊𤀲&C5-6536;&M-38668;𠆉&C7-4A75;")
("0050" "㪯挛牽𦎫𣫭𨐌&M-38366;𢶜")
("0051" "&C7-5973;")
("0052" "𣫺")
("0055" "𠱗𢤴𦏝")
("0060" "㐭㕻㖖㽫亯吂吝咅啻暜畗畜盲言音𠲯𥩶𠶷𤾕𦤘𪊨𠱫𠲩&C5-5825;𣋿𪗐𣅀𤰡𠅓𥄈𣁎𥆕&M-14312;𠆒𠆌𥗱&M-38611;")
("0061" "註誰譠𧬤&M-35430;&M-35904;&C5-794E;&M-35562;&M-35560;&C7-3522;&M-35870;&M-36166;")
("0062" "䜞朚竒訪諦諪諺謗謞謧謪謫𥪼𥩭𥩮")
("0063" "䜇䪰詃誸謶譙譧譩譹讁讓𧪠&C7-4338;&C7-5937;&M-36180;")
("0064" "䛨詨誶諄謢𧨱𧩧&M-35422;&M-35670;&C6-4E6A;&M-43280;&M-35779;&M-35717;&C7-5936;&M-36127;")
("0066" "䛸䪭誩諳譶讟𣞇&M-35742;𧪄&M-35910;&M-35965;&M-38676;&M-49728;&M-36046;&M-36146;&M-38681;")
("0068" "該𩑈&M-35918;&M-35895;")
("0069" "諒&M-35619;")
("0071" "亳毫甕竜雍亡𠅢𪓖&M-34173;𠅔")
("0073" "㐮䘱䙝哀玄玆衣衮衰衺袌袞袠袤袬袲裏裒裛裦裵裹褎褏褒褢褭褱褻襃襄饔𧙃𧙩𧚤𧜈𠫓𤇯&M-34157;&C5-303A;&M-34161;&M-34223;&M-34270;&M-34518;&M-34609;&M-34103;&M-34113;&M-34117;&M-34124;&M-34158;&M-34116;&M-34148;&M-34126;&M-34193;&M-34217;&M-34266;&M-34268;&M-34313;&C6-5829;&M-34322;&M-34389;&M-34351;&M-34398;&C6-622E;&M-34464;&M-34447;&C7-285B;&C7-3328;&M-34490;&M-34532;&M-49707;&M-34559;&M-34591;&C7-4321;&C7-4323;&M-34651;&M-34656;&M-34653;&C7-4B7E;&C7-547C;&M-34720;&M-34758;")
("0074" "麚𣱅")
("0077" "㐫峦罋𪘘𧥜&M-48817;𦦏")
("0080" "䝺賌亥六𤆴𡖍𠔚&M-42599;&M-37494;&M-36808;&M-36893;&M-36897;𥫈")
("0088" "𠅃")
("0090" "㪰京亰杗栾棄椉槀稁稟稾紊麇麋麜亲禀𣏋𣚏𣠛𣐇𣐽𥾻𣓀𣖇")
("0091" "雜")
("0099" "𣡥𦇨")
("0110" "壟&M-48840;𡔕")
("0111" "㼿竰𣥢𤮜")
("0112" "䇕竵𥩤&M-45001;")
("0113" "蠪")
("0114" "竨")
("0116" "䇉站竡")
("0118" "顫颤&C5-4B35;&M-43670;𥪙&C7-263E;")
("0120" "&C7-6439;")
("0121" "㡣㼚㼺㼾瓬甋龍龖龘𤮊𤭕&M-48846;𤮇𤮢")
("0122" "&C5-6B68;&M-47600;&M-44698;&M-48833;")
("0123" "䴫")
("0124" "敲𢾬𢿇𣀫𣀯&C7-6221;&C7-652F;")
("0126" "𣃷")
("0128" "䫕䫯䯪頏顏顔顡颃颜𩒘𩔴𩕲𩖆&M-43481;&M-43638;&M-43667;&M-43654;&C5-756C;&M-43668;&M-49889;&M-49893;&C7-5D4D;𣄫")
("0129" "𣄔")
("0132" "驡鸗")
("0133" "戅𢤲")
("0140" "聾")
("0141" "虠𤭞𤭢𤮩𩫧&M-49834;")
("0142" "&M-44611;")
("0143" "龑")
("0144" "龏𦪿𣀦&M-48835;")
("0148" "贑頝顇&C5-6E57;")
("0150" "𢸭")
("0160" "礱讋𡃡&M-36181;")
("0161" "䚰䚹䛃䛠䛩䪦䪫瓿訌訨証訿詎誆誈誑誙誣誹諕諲謔謯謳譃讈讍𧥮䚾𧧰𧧺𩐛𧩦&M-35563;&M-35671;&M-35669;&M-36092;&C5-7C3F;&M-35247;&C6-4E6F;𧯹&M-35859;&M-35937;&M-36062;&C7-593E;")
("0162" "䛔䛿訂訶謌謣韴𧨂譳&M-35246;&M-35400;&C5-5122;&C5-5124;&M-35818;&M-35232;&M-35665;&M-35977;&M-36018;&M-36055;&M-36089;")
("0163" "䚶䛫䜑誫諑&M-35305;&M-36081;&M-35255;&M-35317;&M-35443;")
("0164" "䛀䜡訏訐訝訮評詽誀諏謼譚讘&M-35481;&M-35629;&M-43298;&M-35250;&M-35326;𢿪&M-35811;")
("0165" "𧬨&C7-5035;")
("0166" "䜜詀詣語諧諨𧧍𧩤𧫓&M-35661;&C7-2877;&C7-3346;")
("0167" "&M-35631;")
("0168" "䜖䫓謓𩐵&M-35707;&M-35657;&C7-4A2A;")
("0169" "謜謤𧧌&M-43282;&M-35969;")
("0171" "𤮨𣥊")
("0173" "襲&M-34708;&C7-664D;")
("0174" "𣀤𣀮")
("0177" "𡾩")
("0178" "&M-43407;")
("0180" "龔&C5-7655;")
("0188" "頦颏")
("0190" "㰍龒")
("0191" "𣄵𣄶")
("0200" "刻")
("0210" "㔊𠟍")
("0211" "氃氈竓竳𩙼𣯓")
("0212" "竬端𥪄")
("0213" "𥪦𥪌")
("0214" "竏竔𥪍")
("0215" "竫")
("0219" "𥪕")
("0220" "剂剤剫剷劆劑劘剷𠚷𠞥𠠎𠚳𠛍𠝡𠠒𠠣")
("0221" "㲥𣬵𩫁𣮒𣯟")
("0222" "㣑㫂𢒹&C7-6557;")
("0223" "&M-47691;")
("0224" "䴣䴧&M-47640;𣄁")
("0225" "&M-47900;")
("0226" "𩡕&C5-5E5E;&M-44546;&M-44509;")
("0228" "&M-43697;")
("0229" "𪋫")
("0240" "㜪刘𠞩𡣎𠜇")
("0241" "㲔㲞乵𧰄𨐐𧯺𠢖")
("0242" "彣彰斒&C6-454F;")
("0260" "䚯剖訆訓訠詶誗𧩲&M-35439;&M-35520;&M-35621;𠞌")
("0261" "䚽䚾䛘䛢䜅䜝託誂諈諥謕證&C5-3C3D;&M-35786;&M-36011;&M-36083;&M-35279;&M-35407;&M-35465;&M-35488;&M-35841;&M-49725;")
("0262" "䚲訢誘諯譌譑讗𧬜&M-43273;&M-35785;&M-49721;&M-35813;&C7-5942;")
("0263" "畆訞訴謑讔&M-35349;𤬃&M-35591;&M-36065;&M-43320;&M-35573;&M-35984;")
("0264" "䛵詆詜誔誕諉諼𧦝&C5-694E;")
("0265" "諍譏")
("0266" "䛡詬話誻諙譒䛻&M-35693;")
("0267" "䛽訕訩詘謟韷&C6-446E;&M-35772;&M-36035;")
("0268" "䜠")
("0269" "䜈訸&M-35789;&C5-6D63;&M-36094;&C5-7469;&M-35493;&M-36047;")
("0270" "𠛑𠞬𠟼𠜆")
("0271" "㲤瓤𣰶𤣧")
("0280" "刻")
("0290" "剠𠟇")
("0291" "𣮭")
("0292" "新𣂺")
("0310" "𥩖𡑠")
("0311" "竩")
("0312" "竚鹫𥪀")
("0313" "竢竤")
("0314" "竣𥩦")
("0315" "䇅𥩡𥩱𢨒")
("0318" "𥫎")
("0321" "𠅣𡯶𢅛&C7-507C;")
("0322" "&M-45339;")
("0323" "𤡎")
("0324" "𡕧𣄎&C7-4C72;")
("0325" "旘𢧳")
("0326" "𣄏")
("0332" "鷲")
("0341" "&C5-3624;")
("0344" "斌𩫯")
("0345" "𢨊𩫨")
("0360" "訃訫&M-35377;&M-36128;")
("0361" "䛎䛷訧詑詫誼諠謐&M-35891;&M-35927;&M-35528;&M-36025;")
("0362" "䛪詝誧諞謆謲𧭈𧭠&C5-427D;&C7-3B7A;&M-35920;")
("0363" "䛑䜢詠誏誒讞𧧷𤟞𤱶&C7-5530;")
("0364" "詙試誜𧫒&M-35457;&M-35673;&M-35711;&M-35844;&M-35497;&M-35574;&M-36032;")
("0365" "䛋䜗䜟戠誐誠誡諓諴識讖𧨺&M-35483;&M-35307;&M-35537;&M-35771;&M-49727;")
("0366" "詒讅&M-43316;&M-36147;")
("0367" "&M-35689;")
("0368" "𧮈")
("0369" "訹誴&M-35931;&C7-552A;")
("0375" "&M-34462;")
("0380" "贇蹵")
("0385" "𤎷𢨞")
("0391" "就𡰔𡰜")
("0395" "𦁋")
("0410" "䇆竍𣂂")
("0411" "𥪯𥪘")
("0412" "勭勯𠢻𦒭")
("0413" "竑𥪂")
("0414" "攱皽𥩾𥩳")
("0416" "䇎")
("0418" "𥪧&M-49420;")
("0420" "𣂁𣂆𣂉𣁼")
("0421" "蒬𣃾𠡌𦓄")
("0422" "劥旑𠢹𠢗")
("0423" "&M-47629;")
("0424" "㿶𥀔&M-47641;𡦵𥀱")
("0426" "&C7-4C74;")
("0428" "麒")
("0440" "対")
("0442" "効")
("0444" "㿰")
("0446" "&C5-5162;&C5-5875;𡦡𩫭")
("0448" "𪏆")
("0460" "䃞䚵䛂計討詂謝譵&M-35646;")
("0461" "䛳訅訑訛訦詍詵詿諶謊謹譊讙䪧𧦭𧪞&M-35950;&M-36067;&M-35248;&M-35251;&M-35571;&M-35734;&M-35888;&M-43318;&C7-5536;")
("0462" "䛥䛴䜏䜕勏訥詏詴誇諵譪誵𧦞𧫚&M-35557;&M-36101;&M-35710;&M-35705;&M-35769;&M-35836;&M-35911;&M-35985;&M-36145;")
("0463" "䛟䜁䜉䜔詓誌謨讌韺讛𧧵𧬧&M-35675;&M-35866;&M-43317;&M-36057;&M-35550;&M-35632;&C7-5F55;&M-36165;")
("0464" "䚳䛭䪬訤詖詩誖誟護譸頀𧬕&M-35668;&M-35770;&M-35842;&C5-6D60;𢻕&M-35600;&C7-433D;")
("0465" "諱諽譁&M-35475;&M-36074;")
("0466" "詁詰誥諎諸諾譆譇&M-35804;&C5-7831;&M-35915;")
("0467" "詌")
("0468" "詼諆讀讚&M-43281;&M-36122;")
("0469" "䛙䜍䜓誺諃諜謀&C5-6626;&C5-6A59;&M-36082;&M-35677;&M-35980;")
("0472" "勷")
("0474" "𥀶")
("0482" "劾")
("0490" "𡬱")
("0491" "𡰗")
("0492" "勍𠡽")
("0494" "𥀏")
("0510" "塾")
("0512" "靖𥪁")
("0513" "䇐螤")
("0514" "竱")
("0519" "竦")
("0521" "𩪿𣄟")
("0523" "𣃝")
("0524" "旔")
("0529" "&M-47906;")
("0533" "熟")
("0541" "㝄孰𨐶")
("0543" "𡥹𩫠")
("0548" "𤒆")
("0549" "辣")
("0550" "&M-43083;")
("0553" "&M-43073;")
("0554" "𩫰")
("0560" "訲訷𧥸𧧅&M-35301;&M-35630;&M-35490;")
("0561" "訙訰&M-35249;&C6-4472;𠅩&M-35822;")
("0562" "䛍䛣請&M-43274;&C5-6629;")
("0563" "䛱訣詄詇諘謰譓譨譴譿讉𧥱&M-35758;")
("0564" "䛕謱𧦦&M-49722;")
("0565" "䛖講&M-35825;")
("0566" "䛆䜊譖")
("0567" "&M-35837;")
("0568" "䜋誱謮讃𧨸")
("0569" "䛶䛾誄誅誎諌諫謋𧧒&M-43294;")
("0611" "䚒")
("0612" "竭")
("0614" "䇑𥪳𥪎")
("0618" "䇍")
("0621" "覫&C5-4270;&M-45776;&M-45777;")
("0622" "𡃯&M-47910;")
("0624" "髜麣&M-49912;")
("0629" "髞")
("0641" "&M-45345;")
("0644" "&C7-2964;𡦟&M-45346;𩫫𥫖")
("0645" "䯬嚲")
("0660" "䛛䛜訵詯𧥣𧦤&M-35287;")
("0661" "䛰詚誢諻謉郶韹詋𧨚&M-35830;&M-36129;&M-35568;&M-35570;")
("0662" "䛲䛺諤諹謁謂𧪦𧭮&M-43322;&M-35364;&M-35612;&C7-2875;&M-36031;&M-36103;")
("0663" "䜙䜚誤諰謥譞𧬮𧭤&M-35798;&M-35820;&M-35840;&M-36079;&M-49729;&M-36152;")
("0664" "䛞䜂諀諿謖謾譯讝𧫝𧮞&M-36022;&M-43328;&M-36138;")
("0665" "䛅譂𧫤")
("0666" "誯讄")
("0667" "𧬌")
("0668" "䛊䛤諟韻𧧾𧬂")
("0669" "課譟&M-35862;&M-43319;&M-36159;&M-36175;")
("0672" "𤣨")
("0681" "䚔")
("0691" "親&M-34899;&M-49714;")
("0710" "䀍望望𡎿𥩿𡒼𧗛𧗜")
("0711" "䇃䇈竌颯飒𥩙𥩥𥩢&M-48867;&M-48309;&M-48875;")
("0712" "䇋䴀竘翊鴗鸇𨝯𦒜𥩘𥪃&M-46771;𦒍&C6-3430;𥪥&M-39730;")
("0713" "斔𥪋𥪬")
("0714" "䇇殶竐竧竮𥪏𣪪竮")
("0717" "𥪊")
("0721" "䒍髛𩙒&C5-663A;&C5-6F4A;&M-47590;")
("0722" "䣌䲳邟邡鄗鄘鄜鄺鄽鴋鵺鶊鶙鶮鶶鷓鷛鹧鄌𨙶𨟖𪄲𪇵𦐄&M-39549;&M-39589;&M-39605;&M-46856;&M-47064;&M-47151;&M-47138;&M-47246;&M-47415;&C5-7864;𢊙&M-39615;&M-47602;&M-46899;&M-39710;𦒮&M-47448;")
("0724" "毃毅𣫖𦗤𣫚")
("0725" "𣄈")
("0726" "𣄤")
("0728" "㰠㱂歊歒𣣎𢌃")
("0732" "鷾𨚳𠨛")
("0733" "戆戇")
("0740" "嬜&M-43315;𡣼𣫡")
("0741" "&C5-4440;𠙇𡔊")
("0742" "斓斕郊郭鄣鳼鵁鶉鹑𦑋&M-39590;&M-46991;&M-47274;&M-47469;&M-47480;𠞻&M-39727;&M-39744;&C7-5A68;&M-47277;&M-49934;&M-47414;&M-49942;")
("0743" "㪱")
("0744" "竷𠮒")
("0748" "㰵贛赣贛")
("0751" "𦏧")
("0752" "&M-39758;")
("0760" "䤗")
("0761" "䚼䛄䛌䛏䛼䜀䜛訉訊記詛詭誽諷譅譝讒𧧓𧫢𧫺𧭸&M-43278;&M-35319;&M-35489;&M-35494;&M-35681;&M-35692;&M-35763;&C7-432A;&M-36049;")
("0762" "䚮䚴䛬䪨䪮䳝訋訒訽詗詞詡詢詷詾誃誦誷調諊諝諣謅謬謻謿譋譎讇讕部鄐鶕韵𧥺𧧜𧪜𧮑&M-35318;&M-35285;&M-35565;&M-35678;&M-43287;&C5-6467;&M-35257;𠹪𦟁&M-35572;&M-49723;&M-35676;&M-35662;&M-35838;&M-35849;&M-36033;&M-36038;&C7-5033;&M-47374;&C7-5F59;")
("0763" "䛹䜒詪誋認諛韼𧩨𧪅𧩶&M-35639;&M-35808;&C5-6D61;&C5-764B;&M-35745;&M-35701;&M-35777;&M-35839;&C7-5149;&C7-552C;")
("0764" "䛉訍設訯詉誛諁諔謏謘譭讂𧩱&M-35313;&M-35399;&M-35455;&M-43288;&M-35929;𠭇&M-35478;&C7-287C;&M-35765;&M-35913;&M-35916;")
("0765" "䛁䜄諢韸&M-43283;&M-35479;&M-35576;&M-36161;")
("0766" "䛯詔詺詻諮謵譫韶𧬅&M-43297;&M-43308;&M-35834;&M-36105;&M-36155;")
("0767" "䛝誳諂謠𧥤𧧆𧧖&M-35484;&M-35393;&M-35487;&M-36030;")
("0768" "㰴䚿歆畝謴譔譺𧭍𩑅&M-35762;&M-36131;")
("0769" "𧨇𧩴𧫕&C5-427B;&M-35652;&M-43293;")
("0772" "䲻邙&M-39741;")
("0773" "𦫋")
("0774" "氓")
("0778" "𣢅")
("0782" "郂𦐤𠜨")
("0784" "㱾")
("0788" "欬")
("0791" "&C7-3D72;")
("0792" "鶁&M-39411;&C5-3068;&M-47346;")
("0810" "墪鐜𥂦𥪱𡒱𡒋&M-41089;")
("0812" "竕")
("0813" "䗐䗠竛&M-33507;&C6-643E;&M-33445;")
("0814" "竴𥪚𥩵")
("0815" "𥫃")
("0816" "竲𥩻𥪶")
("0820" "㫃&C5-754E;")
("0821" "斻施旄旊旌旎旐旒旜𣄑𣄙𣃢𠙟𣃿𣄀&M-44002;𣄢&C7-4B47;")
("0822" "㫅㫊斺斾旂旆旓旖膂𣃘𣃦膐𣃽𢄲𢄧&M-36410;𣃩𣄊𣄐𣄘&C7-453E;𣄨")
("0823" "於旅旍族旞𣄠𣄧𣄚𣄦")
("0824" "㪣㫍㫏䵇放敵斿旃旇𢾛𢾅𣀊𣃯𣃼")
("0825" "㫋㫎𣃵𣃻𣄞")
("0826" "旛旝𣃳𣃧𢂷𣄉")
("0828" "旋旗旟𣄝𣃨𣄡𣄪")
("0829" "旚&M-47645;")
("0832" "鷟𪆃")
("0833" "憝&M-46421;𢥲")
("0834" "𢼜𢽯")
("0840" "𡟕")
("0843" "&C5-5F2C;")
("0844" "效敦")
("0848" "&M-36986;")
("0850" "撉𢳈")
("0853" "𢥦")
("0860" "䃦")
("0861" "訖詐詤詮說説諡諩謚𧦧𧨀𧧻𧩹𧪘&M-35807;&M-36075;&M-35299;&M-35584;")
("0862" "䚷䚸䪩訜訡診論諭謭譾讑𧬈&M-36073;諭&M-36036;&M-36076;")
("0863" "䛈訟詅諗謙譕譢&M-35871;&M-43331;&M-35486;&M-35499;&M-35764;&M-43295;&M-35940;&C7-502D;")
("0864" "㪟䚺䜘敨許誁謸譀譈譐譤𢾚𧩼&M-35748;&M-35921;")
("0865" "詳誨議")
("0866" "䛇䛦䛮詥誝謒譄譗譜譮𩐧𧬆&M-43285;&C5-583F;&M-35908;&M-49726;")
("0868" "譣&M-43296;&M-35314;")
("0869" "&M-35512;&M-35339;&M-35338;")
("0873" "玈&M-34595;&C5-717D;&C7-3D74;")
("0874" "𢻬")
("0877" "𡼖")
("0880" "䞄")
("0894" "𢾣𢽮𢽺𢾉")
("0912" "䇌")
("0922" "髝")
("0925" "麟𪋲&M-47710;")
("0928" "𤒼")
("0960" "䚱")
("0961" "䛧&M-43286;")
("0962" "䜎訬誚&M-35628;")
("0963" "謎讜")
("0965" "詊")
("0966" "譡")
("0968" "談𧭓𧭢")
("0969" "詸")
("0972" "玅")
("0982" "𡭹")
("1000" "一")
("1010" "㘸㠪㱏㿻㿼䀃䙵三丕二互五亖亘亙亚亜亞噩坖坙垔垩堊壐巠工巫正歪玉玊王琧璽畺盂盃至豆霯靈𨸖亟雴霊𡉙𠄮𡊞𥁁𥩠靊𤣩𧟡𠄭𡊵𤯚𡌥𣄱𧖬&C5-5F59;&C5-7161;&C5-7B6C;𠄞𠄟𠄠𢀑𢀓&M-49299;𠄣𡉊𢒄𤣪𤯔𠄢𠀥𠄨𡉝𦤳𡿱𣅯𣥔𣥒&M-22951;𥁄𡊹𤰱𠄵𡋲𧖯𠄹𧟪𥁶𧟴&C6-637A;𧟿&C7-4434;&C7-4462;&C7-557C;𡔈&C7-5978;")
("1011" "巰珫琉琟璄璮疏翋雿霏霔霪霮靋䨙䨟𨾊𠀢𦑏霃&C5-5241;&C5-5949;𦥏𤪮&C5-6A41;&C5-745B;&C5-7955;&M-48881;&C6-3C71;&C6-5973;&C6-636D;&C6-636F;&C7-2A5C;&C7-2A5D;&C7-2A69;&C7-2A6A;𦗓䨪")
("1012" "㻽䨒璃璾聤霈霘霠霶𦏺𤧭𩂧𩅠𦗍𦗑&C5-656F;&C5-7662;&C7-6021;")
("1013" "䨧玹璡瓋瓌瓖虿蝁蟸蠒蠠霐霗𧈫𧏾&M-33111;𤧠&C5-495D;&C5-594A;𦗐𤪿&M-33750;&M-32872;&M-33068;&C7-3538;&M-33712;&C7-4F78;")
("1014" "㻭䝄䨵玟珓琗璋䨕𩆓䨴𤥿𦐹&C5-523C;&C5-5F5E;&C5-656C;&C5-715E;&C5-715F;&M-38640;𤨘𣦞&C7-4B50;&C7-5D3B;&C7-654A;")
("1015" "霵䨰𩆷&C5-7844;𢑶")
("1016" "䜾琂琣瑭霑露𤲾𦖢&C7-512F;")
("1017" "雪䨮")
("1018" "霟䨏𩆯𦘅")
("1019" "琼翞霂䨬")
("1020" "丁丂丅丐严亍亏歹𣦶&C5-3070;&C5-5243;&C6-4633;&C6-5033;")
("1021" "㱞㱻䂌䝑䨌䰟䴡兀元死覔雡霍霓霾靂靃靇龗䨔䨘霳𩂒𩅄䨳𠄱𣨀&C5-4424;&M-43272;&C5-443F;𣩏&C5-5F5B;&C5-6566;&C5-6568;&C5-6667;𠘲𠀘𠑺𠘶𠀡𧟣&M-43334;𠁈𣦂&C6-5971;&C6-5978;&C6-6371;&C6-6379;𧟽&C7-4551;𢀯&C7-5975;&C7-5F7E;&C7-642F;")
("1022" "㫄䨜䨝万丌丙両两亓兩奡帀爾甭而襾豴雨雰雱雳雺需霁霄霌霧霽鬲霛䨦霱䨶𧟦𦙂𣩅𩂪𢀘𢎷𧗩&M-41215;𣨉𠸲𦓔&C5-3D40;𢐊𤌎&M-41317;&C5-594C;&C5-6E44;&C5-745E;&C5-7A43;&M-33949;𢁓𢁳𢁴𣃙𣍡𣧁𢂇𠱩𣃟𣃪𧟩&C6-3C66;𣨹&C6-5721;&C6-5A4E;䨖&C6-637E;&M-36439;𡂦&M-36457;&C7-4444;𠠢&C7-557D;&C7-5663;&C7-627C;")
("1023" "䨸下弦汞沗泵豕豖震霢霥䨎靀䨹霡𩅧𩅽𤓯&C5-4426;&C5-5F5C;&C5-5F5D;&C5-6565;𢐿&M-36335;𣳳&M-36344;&M-39803;𠪕𣸞&M-38690;&C7-5133;&C7-5137;&C7-5D6F;&C7-5F7D;&C7-627B;")
("1024" "㱸䰚夏弴憂牙覆覈霞霨霰霺雭霚䨱䨷𣨛𧟱𧱙𩅢𠅗㢺𣨜𣨲&C5-5244;&C5-5245;&C5-656D;𧠂𠙚𢙴&C7-335B;&C7-335C;𢐻𧠃&M-36470;&M-43669;")
("1025" "䨩&C5-6569;&C5-656E;&M-36456;")
("1026" "殕霿&M-36446;𣨌&C7-5132;")
("1027" "𢨥&C7-3537;&C7-5130;")
("1028" "彍豥𩰶𥎥")
("1029" "弶䨯𩅩𣨣&C5-594E;𢏲𢏸𣨚𢑀")
("1030" "䨤䨨覂零&C5-4425;𡚑&C7-445C;&C7-4464;&C7-4B55;&C7-5979;")
("1031" "&C7-5573;")
("1032" "焉&M-46636;")
("1033" "㤅㤪㥑㶨忈忑忢恧恶悪惡炁𢘑𢛆𩂈𢙂𢝊𢖶𢖽𢛤𢟜𢞘&M-46009;𢤏")
("1034" "&C5-6A44;")
("1035" "𩆵")
("1040" "㔻㪅䨗䨥于夒婱干平耍耳要覃雯雽霆霋霎鞷𡕢𩁻𩃀䨫孁𡕠&C5-4422;&C5-6A45;&C5-7A44;𠄡𠦓𡛍𡛎𠭍&M-35223;&C6-4632;𧟹&C7-2A6C;𡕾𡕿&C7-4457;𡖁𩈽𣍙&M-42681;𠮕")
("1041" "䧲无旡雃䬠𩅀&C5-5F58;𡯊&C6-462F;&C6-636E;&C7-3D3B;&C7-3D3E;&C7-5125;&C7-5135;&C7-654B;")
("1042" "雾霩䨞𠢤𠀅")
("1043" "䙲天奀耎𧟧&C5-594D;&C5-6A47;𡙎&C6-5032;𦗠𦘄")
("1044" "再孬开弄聂聶𠕂𧟨&C5-4A7E;&C5-4B23;&C5-523E;&C5-6567;&C5-6A43;&C5-6A46;&C5-745D;𢍐𢍗𢍞𢍦𢍮&C7-4B58;&C7-646C;")
("1046" "𡥪")
("1048" "孩")
("1049" "𣄴")
("1050" "戛戞更霉𢆍䨣𤘔&C5-3D3F;&C5-523F;&C5-6E45;𢀝𠄙&M-49120;&C6-597C;")
("1052" "覉覊霸覇&C5-4421;&C5-5242;𧟳&C7-445A;&C7-615B;")
("1053" "雵霙䨑𩃔&C5-3D3E;")
("1054" "&C7-2A6B;𧠄")
("1055" "再𩂨䨍𧟲")
("1060" "㐁㫘䂖否吾晉晋畐畱百石矿西酉雷霅霤霫面靣雼𠮛𠮴𦣻𩂣䨐䨓𩅨𩆁𣄮𠰶𤰳𥄓𠳄𣇩&C5-4B21;&C5-523D;&M-42669;&C5-745A;&C5-745F;𣄼𥐖&C6-253F;𣅆𠀬𠀮𠄰𣆛𠵥&M-35306;𣉩&M-35543;&C7-3D4C;&C7-3D4E;&C7-445F;&C7-597A;&C7-6323;")
("1061" "䂯䃙䃥䃪䃺砊砫砬硫碓酼醀醯釄𥐞䃷&M-40056;𥗭&M-39791;&C7-4B4B;&M-42694;&M-42709;")
("1062" "可哥奣碠碲碻磅醨靄霷𩃼𨣧&M-39977;𥑈𥕐&C7-353A;&C7-4B51;")
("1063" "䃵䃶䩌礁醮醷釀𥖝𥑴𥕎𥕦𥗝&M-40014;𥖾&M-42696;")
("1064" "䂭砇碎礔礮醇醉霹辞&M-39855;&C5-656A;&C5-745C;&M-40083;&M-40086;")
("1065" "𥗂&M-42702;")
("1066" "䂴䤃碚磄磊醅醕醣霝靁靐𩆮&C5-656B;&M-42671;&C6-637D;&C7-4461;&C7-5136;𥗲&M-42706;&C7-6651;")
("1068" "礦硋")
("1069" "䣼䩋磼醾醿𨣿")
("1071" "䙴瓦雹電黿鼋䨋雮䨢𩃗𠀀&C5-3D41;𡙶&C5-7160;&C5-7A42;&M-48312;𢀒𠄢𦣽𠀻𠒞𤭗&C6-637C;&C7-353B;&M-48849;&C7-3D4D;𡂧𡂤&C7-4B54;&C7-5579;&C7-557E;𤮮&C7-654C;&C7-662D;")
("1072" "㔿丏雩霭䨠𠀒𤣫𠣣")
("1073" "丟云雲䬩䨺𩅣&M-41114;&C5-7956;𠫔𥘖&M-34188;")
("1074" "𣱉𢀣𠮎")
("1077" "丣函画雸䨡𩃹𡶪&C5-4423;&C5-7663;𠚇𤮻&M-42619;𤘈&C7-353C;&C7-445D;&C7-4B52;&C7-4B57;𦉣")
("1080" "㶣㶪㶮㶾䎡䙳兲灭貢賈贾趸霣霬頁页霣𩇉𠀔&C5-4A28;&C5-5850;&C5-594B;&C5-6A42;𠆣𤴓𤴕𠔐𤆱&M-37366;𤈨&M-36674;𤊗&M-36768;&C7-2937;&C7-4463;&C7-4B53;&C7-4B56;&C7-557A;&C7-5624;𤴤")
("1081" "𧟼")
("1085" "&C7-557B;")
("1088" "𩅼𩖏&C5-4B22;&C5-6A48;&C7-664E;")
("1090" "䅇不栗示票粟䂞雬𣎴𩂆𩃵𣠞𡭚𢆚𠁃&C5-5240;&C5-6A49;𥤋𡭕𥘅𠀚𣑨&C7-445E;𣡷")
("1091" "𣠁䊲")
("1092" "霦䨛&C5-7957;")
("1093" "&C7-5131;")
("1094" "&C7-3539;&C7-445B;&C7-5134;")
("1096" "霜&C7-4459;")
("1098" "𥜟")
("1099" "霖&C7-4465;")
("1110" "㐀㘳㻗㻹䥸丠埾瓕韭𡋭𡌦𤥷&C5-3371;𡏵𧰓&M-41035;𤤘𠤢𡍳𧯧𤮵")
("1111" "㠭㺿䎎斑玒玨玩玭玼珁珏班琥琲瓏瓐瓑瓨甄疆羾耻聇臦臸虣豇非北𣥠𤦐𤫩𦔸𦖧𤩩𤩭𦘊𤮱𤫣&M-48945;𠁩𤤍&M-42586;𤤻&M-42588;𤦦𤭓𤭎𤭾&M-38367;𤮔𧰁𤪾𤮹")
("1112" "㺮㺰㻉㻬巧玎珂珩瑡瑪瓀𧯫𤩋𩢳")
("1113" "琢瑌璩璱耺蜚蝅蠶蠺𧉥𦕷𤤈𦔿&M-33232;𦗂𤪴&M-33736;&M-33889;&M-33925;&M-33927;&M-33944;&M-36495;")
("1114" "㺳㻯䜴玕玗玡玶珥琸瓇𦏹𦔼𤥙𩐅𤫕𤨹𢿤𦗡𤫘𦤺𤩁")
("1116" "䎸玷珸瑎瑨璢璿𦕒𤩅𦑞&M-39841;")
("1117" "䄘𤥗")
("1118" "䪹䫍䫷項頊頙頚頨頭頸顳项顼颈頙瑱𩒐𩓩&C5-4432;𦖦&C7-2B27;&M-43477;𦗩")
("1119" "环瑮璖䏇𦤹𤩰𢑽")
("1120" "琴𢏗")
("1121" "㢾㣆㱹㱺㼗㼧䝈䰛䶬兠尫弡弫弳彄彊殌殛殭豗麉麗弬𠤥𣧐𢏯&M-43239;𥍻&C5-497E;&C5-6047;𢎸𡯝𢏉𤭃&M-36382;&C6-596E;𢐝&M-36407;𥧐&C7-3635;𢐸𢑃𣤲𪚗&M-47681;")
("1122" "㢪㣂㱙㱛㱤䰜彌翡背脊臩丽𩱇𣧤&M-36339;𢬫𣩙𥎘𥎖𠀙𢎰丽𢂖𣧰&M-42591;𢃻𤦠&M-42600;𤩟&C7-3636;𦓠&M-40752;")
("1123" "張豩𥎔&C5-6B25;&M-36471;𢏁𢏾𤦡&M-36476;")
("1124" "㢨䝕弙弭豜豣𣧏𣀷𣧹𢽪&M-36438;&M-36427;𣦿𣧒𢼿𠭼𣀑")
("1125" "𢧖𣩪")
("1126" "㢶㣅&M-47539;𢐀𢐈𥍾𢐡𢐤&M-35917;")
("1127" "𣨇")
("1128" "㱜䫱頂預頑顟顶顽预颥顬𩄠&M-43348;&M-43345;&M-43503;&M-43487;𣪀&C7-5222;")
("1129" "豲㣄𢐕")
("1132" "䲾&M-46986;&M-45080;")
("1133" "㤍䵤悲瑟𢘠𢣓&C5-7533;&M-46577;𤨝")
("1134" "𢾧")
("1138" "䫮")
("1140" "㚽㜷㢟婓婯廼斐𢽄𩇫𢌫𡕶𢌨𡠈𡡜𥨏")
("1141" "㼛㼞㼲孲䏊𣄰𠤜&C6-4221;&M-48821;")
("1142" "孺耵聏𡦘𤨍𢆊&M-44586;𠣃")
("1143" "奜猆&M-36340;&M-36455;𦕇𡚌")
("1144" "幵敠敪聑顨𦖩𢏘𢆛𢍳&M-48836;")
("1146" "𡦌")
("1147" "𦖂𦕼")
("1148" "頇頮頲&M-43346;&C5-4435;&C5-4B37;&M-43495;&M-43587;&C7-2B24;")
("1150" "㹃㹕揅羋軰輩辈𦍋𤘿&M-42595;")
("1152" "𣂡")
("1158" "䪳")
("1160" "㬜䛒朁酽𥇖𩇸&M-40100;𥐫𥅝&M-42602;&M-42610;")
("1161" "㼣㽌䂗䂣䃁䃌䣥䣰䣿䩃矹矼砋砒砡砸硜礓礭礰翫醧釃砈礲𥕑𥑣&M-39780;𤭑&C5-436A;𥔂&M-39864;𤭻𥕇&M-42654;𥕰𣍒𤮚𥖬&M-40054;𤮸&M-39802;𥓚&M-39910;𥖋&M-40088;𥘃&C7-6578;")
("1162" "䃒䃻矴砢碼磭礝礪酊酠酾醹𨢌&M-42634;&M-44873;&M-39788;𥕷&M-40020;")
("1163" "䂻硺碝酝醵𥖼𥐺&M-39801;𥖟&M-40047;")
("1164" "㪮䂽䣵矸砑研砰硦硬磹酐酑醰𥕕𥒀𥔮𡭋𣀀𥒔&M-39819;&M-42623;𢾇𢾵𥔈𢿟")
("1165" "䤏")
("1166" "㽬䃈䃡䣶䤄䤐䩇疈皕砧砳硒磠礌礵酟酯醽䨻𩈙𣗁𥔁𥔨𦧖𦧥𥕉&M-42670;𠠦𥗉&C7-5F6D;")
("1167" "𥔫&C7-6465;")
("1168" "䫊碩碽磌頵𩔁𩔞&M-43406;&M-43508;𥕲&M-39990;&C5-7A48;&M-43526;𥊾")
("1169" "磲醥磦&M-39783;𥓼𥓽")
("1171" "㼱䨽䩁琵琶瓪靟𩇯𨛬𦓓𣬏𤬮𤧲𤧰&M-48291;")
("1172" "𠀩𢐓")
("1173" "餥裴𩇔&M-34680;&C7-3562;&M-34610;&M-34682;")
("1174" "敮𢻽𢾸")
("1177" "戼𠙿𡷒")
("1178" "顄䪱&M-43449;")
("1180" "䩀冀烎燛燹珡&C5-4332;𤐱&M-42594;&M-36803;&M-36799;&C7-434C;")
("1184" "𣀒")
("1188" "&M-43594;")
("1190" "䉾䊙栞棐琹𣓁𣝚𣕓𤦲𥺟&M-42606;")
("1191" "㼼𤬭𧇘")
("1194" "𥜯𥜹")
("1198" "顙顠𩑢&C7-2B2D;&C7-4B70;")
("1201" "飞𠫕𠃧")
("1210" "㓚㔁㔋㺫㻝䎺刭刯到剄剅剕坔型泴玔琍登銐型㺩𠜲𦥊𠚧𢀙𠛙𠜉𠝙𥁟𠞯𠞐𡏸𡒐𠠱")
("1211" "㲪㻔毭玌珧璀璒耴聎𦖋𦒦𠃖𠃡𤣯𦗨𧰐𣬾&M-44001;𦐭𣯰𤩫𤪩")
("1212" "㣉㼇濷琇琌瑀瑞瓗聥𣂪𦕶𣃆𦒓")
("1213" "㺨䗺璞聧蜑𧊿𤤐𦔷&M-33645;&M-33660;𤣵𤣺&M-33039;")
("1214" "㻑珳珽琈瑗璦翪𦕑𦑛𦐊")
("1215" "㼄琤璣𤪫𤤓𤤵")
("1216" "㻈䎓䎽䪤琘瑙璠聒𤩣𢑵")
("1217" "瑫瑶聯𦑣𡷆𤤼")
("1218" "㻄瓆𤨏")
("1219" "䏈璅瓅𦗔𤧮&C7-4063;")
("1220" "㔇刓列剢剹劀劌引𠚥𠜐𠝃𠟺𠛥𠛖𣧿𢏮𦓎𠜝𣨸𠠛𠠫𠠰")
("1221" "㱯䝓凳卍氄豟𠚯𣭲𢐋𥍽𧱻𩅞&M-36400;𣩑𣩟𣰿𣧇𣧃𣧭𣭅𢏴𤘑&C6-6368;𥎇&C7-3637;𣩶")
("1222" "㡂㱶䝎彲歽耏𥍧𣩠𣨊𣨋&M-36351;𥍭𥍪𢐒𢐟𢒁𢎺𣂕𤘐𦓘&C7-5C6C;&C7-614D;")
("1223" "㴇㵘弘张弧殀水沝淼癶豯𠚦𣸐𣹳𣻤𣻣𢐩")
("1224" "㱣弢弤歼殍發鬷㢻𣨙𣨅𥍺𣧶𤼲&M-36434;&C7-5D70;")
("1225" "弾𢏰")
("1226" "殙𥍿𢐠𤼰")
("1227" "𣧑𣧽𣨡&M-36370;𥎐𣧪")
("1228" "&M-36836;&M-36731;𢐏&M-43431;")
("1229" "𢑈𢑄𣩓𣩫")
("1230" "𠟨𠟦𠛂")
("1231" "𠃞")
("1232" "鴷&M-44735;")
("1233" "㤠愻烈鮤𢙰𢥍")
("1240" "㓴䏀刊刑刵剟姴廵延廷癹𠛬𠜘𠚿𠦂𢌛𤼧𤼬")
("1241" "孔毦毲飛飝𡥑𥎲𦔽𦕖𦕿")
("1242" "㝂劽形形𠭴𡥶")
("1243" "孤癸聫聮𤬉&M-33443;𥎨𤼩")
("1244" "聨𤼪𦖀")
("1246" "𦕾")
("1247" "聉")
("1249" "孫𦕱𦘈")
("1250" "犟&C7-2330;")
("1255" "𤼷")
("1260" "㔏㴅㽝䂰䃗刟副呇沓沯矵硎酬硎𥒁𥒂&M-39894;𥅮&M-35312;&M-49787;𥓑")
("1261" "䂡䂪䂷䃬䣴矺硾磃磑磪磴酕𥕹𨢉䃳𥗿𥐕𥑽𣬸𥑉𥓕𥓱𥚜𣯮&M-39928;𥖌")
("1262" "㪼斫碋磞礄酳硶𨠇𥒱𥕶𢃆𥕌𥕱&C7-396D;")
("1263" "䤆砅砭砯磎醭醺𥑔𥒜𥕈&M-42647;𥒩&M-39811;")
("1264" "砥硸酹酻醱釂硟&M-39799;𥒫𥓻&M-39887;&M-42658;𣱇𥓔&M-39920;&M-40112;")
("1265" "䤒碀磯&M-39985;")
("1266" "䂿碯磻碈&M-39888;")
("1267" "酗𥓾𥒤")
("1268" "碳礩&M-49792;")
("1269" "䤕礫酥𥕘礏𥑓𥒶&C5-4B24;&M-40002;𥕆𥡰&M-40091;")
("1271" "氹𤼥𦫔𦣮")
("1272" "𢎜𣂱")
("1273" "裂")
("1274" "靉𤼼")
("1277" "㳫䶛&M-48804;𡵾𡶳&M-48802;")
("1280" "烮𤆲𤳓𥤾𤼯&M-44008;")
("1281" "&M-43337;")
("1282" "㔌𩑘")
("1284" "𤼺𤼹")
("1289" "𢑲")
("1290" "㔄剽刴𠞉𣔽𠟕𥙊𠞨")
("1291" "𣮪𣯼")
("1292" "彯𥙏𢒴")
("1293" "瓢")
("1294" "𣱊")
("1310" "㺪䎵䥒恥珌")
("1311" "珑琬瑄豌𤨖𤧺𦒨")
("1312" "㻞䎍聹𦒊")
("1313" "㺴㻠球琅瓛𤩨𤨚")
("1314" "㺹䎔䏁武玳瑏珷𤤒𦏵𦐗𤧪𦖪")
("1315" "䎀䎉䎒戤珬珴珹琖琙瑊聀職臹𦐂𦑌𦖎𧯱𢦐")
("1316" "珆瑢𤦮")
("1317" "琯")
("1318" "琔璌璸")
("1319" "㺷琮聺𤥾𦥅")
("1321" "㱧兘殧&M-36350;&M-36401;&M-36422;𣩴&M-45903;𡬘&C7-606D;")
("1322" "豧鬴𢐃𣨈&C7-2929;")
("1323" "㱢強殏𥍫𤣅𢏦&C5-7678;𢏓𤣉")
("1324" "㱰𣧧𢏤𥍬𣧆&C7-3E3D;")
("1325" "㦷戮戳殘殲残𣧡𣧌𣧵𣨤𥎕𢦧𥍥𢧈&C6-6464;𢨌&M-36485;")
("1326" "殆𥎆𣩐&M-49731;")
("1328" "㱨殡殥殯")
("1329" "䝋&M-36409;")
("1340" "𡠥")
("1341" "䏄聜𦗃")
("1342" "勥聍")
("1343" "𦕹")
("1344" "&C6-605D;")
("1345" "㦸戣聝𦕵")
("1346" "孡")
("1349" "孮")
("1360" "謽𠧙𥐚&M-39831;")
("1361" "䣾䤉䩊砣砨硥硿碗碹酡醡𥓗&M-39984;&M-42666;&M-40049;&M-42630;𥕅&M-39954;&M-40078;")
("1362" "䩉碜碥磣酺醦𥒰𥔪𥔱&M-42680;&M-39914;&C7-4430;𥖽")
("1363" "䣭硠硡酿𥒲&M-40043;&M-42690;&M-39832;𥓎𥕃𥕺&M-40075;&M-42685;&M-40093;")
("1364" "㢦䣧䣮䣲䤇碔酧酸&M-39814;𥔉𢎄&C7-3D50;&M-40074;")
("1365" "㦻䂝䂸䃭䃱䃸䣬䣹䤘戨戩戬硪碊碱磩醆醎𢦪𥑳𥒪&M-39843;𥖘𥖙&M-42704;𥔃&M-40061;&M-40085;")
("1366" "䃔碦磍&M-40018;")
("1367" "&M-42664;𥖚&M-39995;")
("1368" "碇礗")
("1369" "碂䃰𥒬")
("1374" "𩃶𩃷𢎁")
("1380" "䝾𤐦")
("1384" "貮")
("1385" "𢨙")
("1394" "𢎊")
("1400" "𣁬")
("1410" "㪷𥂹𥂘𥪻𥂧")
("1411" "玴珗珪瑾璂瓂瓘耽𤣰𦏸𦐕𦑎𦖈𢑫𤨛𤪣𦒒&C7-512D;&M-43261;")
("1412" "㻟功劲勁勐玏珕珛琋琦璊璓𤨕𤩲𦖊𤫨𠡕𠣋")
("1413" "珐琺瑛瓍瓙耾聗聽𦗟𦐌𦒅𤩵&C7-3B4A;")
("1414" "䜵玻珔璹瓁翄翍臶豉𡚽𢑒𤿿")
("1415" "瑋𤪍")
("1416" "䜺琽聐聕𦖿")
("1417" "玵")
("1418" "珙琪瑱璜瓄瓒瓚𦕠𦗀𤪃𧯯𤪬")
("1419" "㻷琜琳瑹璙𤪌𤩒𧰉")
("1420" "㪴弣耐𠦇𢒥𡭁&C6-6463;")
("1421" "㝴㱡䝅䝔弛殑殖殗殣殪豷𣩄𥎊𣩱𢎫&M-36379;&C5-5A3B;𢑆𠣉𢎩𣧅𢏶𣩲𥎚")
("1422" "㔝㣁㱦劢勈勠殢豨𢑁䝐𠣊𢎭𣧍𣧦𣧥&C5-5849;𠣀𢐳&C5-646A;&M-36473;𣦺&M-49088;𣧻𥍰&M-36399;&M-36431;&M-36479;")
("1423" "㢬殎𣧂𣩎𣨠𣨘𥍼𣩷&C5-6D68;&M-36995;&M-36349;")
("1424" "㢰㱟㱥䰙𧰿𧱐&M-36369;𥎂𥀘𥀫𡠢𢐖")
("1426" "㱠矠豬𢏆𥍱&C7-2B5F;𣩳𢑳")
("1427" "𢑇")
("1428" "㣀㱵䂎彉殰豶&M-36393;𢑊")
("1429" "殐殜弽𣩢𢏼𢐇𣨴𣩣𣩨")
("1432" "𠢯")
("1433" "&M-42651;")
("1434" "彠")
("1441" "𦖅")
("1442" "聈")
("1443" "聴聼")
("1444" "𤿐𡥃𤿊𢻍")
("1447" "𦕐")
("1460" "㪶䂤酎酙𥑙𦧌&M-35404;&M-42621;")
("1461" "䃊䤁硅硭碪碴確磕磽礷酏酖酰醃醓醘醛醢硽礚𥑄𥑰&M-42628;&C5-5F61;𥗪𥒒𥑻𥒴𥔐&M-39915;𥘁")
("1462" "䂶䃎䃣䤍劭劯勔碕磡礍𥑢𥑑酭𩈏𨡯𥑿𥑹𥕾𥗀𥘄𥓿𥗺")
("1463" "䃮䤓砝硤碤磢礞酞醼礠𥐪𥕓𠳊&M-39989;&M-40030;𥔵")
("1464" "䂚䣫䤊䩅破砵硣碐礟礡酔酵醻𥖪𥑾𢻊&M-39800;&M-39952;")
("1465" "䩏礣&M-40034;&M-40082;𥗘")
("1466" "䃴硈硞碏礂酤酷醋醏𨡱𥔇&M-49790;&M-39970;𥖛")
("1467" "酣")
("1468" "䤑磺礎礸𥖿&C7-257B;")
("1469" "䂾䤂䩍碄碟礤醂𨢬𩈶&C5-4A65;&M-39951;𥖜&M-40027;𦧤𥕴&M-42663;")
("1471" "𤮳&C7-512E;&C7-5578;")
("1472" "动&C5-5948;")
("1474" "㩺妀𢻗")
("1477" "𡻧")
("1489" "&C7-3D64;")
("1490" "櫫𦀧𡬽")
("1491" "𣞵")
("1492" "勡𥍲𠢢")
("1510" "㻀䎈䎴䎶玤珅珒翀𤤺𤣸𦕏𦕽𤦯𦘞")
("1511" "珄璶")
("1512" "璛聘聙靕𦑊𤨸")
("1513" "㻖䎚玞玦璉翐翴𦐍𦔾𦒎&M-32832;𦑐𦗳")
("1514" "瑼㻲𧰃𤤏")
("1515" "珃琫𦐘&M-49301;𤪆")
("1516" "㻸䏆瑃")
("1517" "㻰𦒄")
("1518" "琠璝璳瓉聵𦑈&M-36858;")
("1519" "㻋㻧䎷䜹珠瑓瑧疎臻𦐣𤤹")
("1520" "肂𩰫&M-36389;")
("1521" "殅虺豘甤𥎓&M-36345;")
("1522" "彇𣧨𢄥")
("1523" "䂈殃殔甤融𣧎𣧞𢎹&M-36385;&M-36428;𣨃𣧴&M-33947;")
("1524" "𥍹䝏")
("1525" "𣨞")
("1526" "𣩒")
("1528" "㱴䝊殨𧲆𥎍𢏵𣩬")
("1529" "㱫殊殝𣧣𣧮")
("1540" "廸建&M-32839;𤯳&C7-5C6E;")
("1541" "孻")
("1542" "𡦗𦕊𦕚")
("1544" "聃𡦕")
("1548" "聩𦖌")
("1549" "𡥛")
("1550" "甦&M-43150;")
("1560" "䂜砷硉硨𥑏&C5-4428;𥔴&M-40045;")
("1561" "䣨䣩醠醴𥑯&M-39949;")
("1562" "䣪砩碃&M-39830;")
("1563" "䃛䃩砆醲砄𥑇𥗾𥒏&M-39834;")
("1564" "䃓磚䃀𥕍")
("1565" "碡")
("1566" "醩&M-40110;")
("1568" "碘碛磧靧𨢦𥓐&M-39892;&M-40060;")
("1569" "䣷硃磔𥑘𥑶")
("1571" "霕𤮍&C7-2A68;")
("1572" "&C5-5F5A;𠄴")
("1573" "靆霴&M-34620;")
("1576" "&C7-5D3C;")
("1578" "靅")
("1590" "𥙍")
("1610" "㺺㻁㻒珀珈珚聖𤤨𦐚")
("1611" "䚈䚖珵現理琨瑆瑝瑥瑰聭覡覴䰱𦑀𦕸&M-34855;𦑠𦖤𤥛&M-34880;&M-39478;𤪄")
("1612" "㻿䶍琄琾瑒𦑼")
("1613" "㻍䏉䝃瑔璁環聰𦑶𦗣𤪹𤧖𤨔𦒠")
("1614" "琕琝瓔聛豍𤥚𤦑")
("1615" "㻫玾瑇𧰆")
("1616" "琩瑁瓃")
("1617" "𤫥")
("1618" "䎌䜻珼珿瑅𧯩𦑧𦐖𦑰𦒖")
("1619" "璟璪𦖍𦗵𤫤")
("1620" "𥍡𣧝𥎙")
("1621" "㱱䚕䰭殟覼豱䰪𥎡䰰𧢮&M-45862;𣩿𣨆&C6-5377;&M-45772;&M-36408;&M-39445;&M-36419;&M-45920;")
("1622" "弲𣨟𥍣𣨵")
("1623" "㱬䂍强彋殠𥎋𥎅&M-36426;𣩯𤃄&M-36477;")
("1624" "彏殬矡𣩡𣨨")
("1625" "彃彈殫")
("1628" "殒殞𢐂𢅦")
("1632" "&M-47443;")
("1633" "𢙢")
("1640" "廹廻廽𦕻𡠝")
("1641" "䙹䚓覌&M-34920;")
("1644" "孾")
("1648" "职")
("1660" "䂩砶硇硱碅碧𥑆𥕏𥓁&M-39837;𥔆")
("1661" "䃏䙼硯磇磈覗覠酲醒醖醜醞靦醌䃂𥗬𩵀𥒵𥗒𥗫𥑲𥓀&M-39437;&M-39878;&M-42633;&C7-3460;𥗴&M-34989;&C7-646E;")
("1662" "䃇碣碭𥔲䣺𥖠𥔅&M-39913;")
("1663" "䤖碨礘𥔯&C5-6548;&M-42675;𦌺")
("1664" "碍碑磾礋礹醳釅𥓓𥕸&M-40035;&M-39908;&M-39993;&M-40052;")
("1665" "𥑐&M-39988;&M-40026;&M-42683;")
("1666" "礧𥗟")
("1668" "碮磒醍𥒭&M-42657;𦧧")
("1669" "䂺磥𥓖")
("1671" "乪魂𠮞")
("1677" "𦉦")
("1678" "𤭍")
("1681" "覝&C6-4E5D;&C7-5552;")
("1691" "𧢄&M-45791;")
("1698" "𥛴")
("1699" "𥽹𥚌")
("1703" "乀乁&M-00110;")
("1710" "㿿䍿䥐丞卫圣孟盁盄盈翌銎丑彐𡊼𥁂𤤶𡎳𥔊𥂨𠀄𡔛𠯉𦤵𥁛𥁜𥁏&C6-3C61;𥁪𧯢&M-40333;&M-43240;𡐲𤧬&C7-2A42;𥂔&M-40550;𡒍")
("1711" "㺬㺲㻊䎂䎲䜸歰玘玸珇珟珮璏虱觋巩𤣲𡈾𢀜𤤲𦐆𥏰𤩃&C5-7B24;𤥕𦐙𤫅&C7-563D;&M-35002;")
("1712" "㓛㢧䎳䎻䣁䣆䲨䲹䳾䴒刁卭弱玓玥玽珋珝珣珦琊琱瑘瑚瑦瑯璆璚瓓羽翑翵耶聊邛邳邶郅郖鄄鄧鳿鴊鵄鵐鵛鵡鵶鶸鹉𡤼𨙺𨚑𦏼𧯠𨜏𪃋𦘍𤤑𤤱&C5-2B58;𦕀𤧗𦖉𦖐𦖼𦗒𦗖&M-46962;&C5-6A22;&M-46987;𢎥&M-45633;&C6-2D24;𦏲𤤪&M-39402;&C6-3468;&M-39395;𤥸&C6-4562;𡍯𡖩𦐥𦐱𤧢𤦳&M-46651;𦑟𤩉𤩈&C7-3645;&M-46830;&M-46778;𤩬&M-46896;𦒛𦒔𦒇&M-47063;&M-49784;&C7-6378;")
("1713" "㻱䎑䎼䖥录珢琭瑍瑑瑵璭瓈翭聦蚤蛋蛩蝨蟊𩸇𤧙𤧫&M-33226;&M-33836;𢑘&M-32951;&M-33038;&M-49683;𢑨𦑚𦖹&M-33718;&M-33878;")
("1714" "㺭㻓㻵䏂䑒䜷取玬珉珊珘琡瑕瑖璕璻瓊𤣻𣪌𦐩𤩴𦔹𤩮𡥆𣪅𤥜𤥘𤥱𦐷𠭱𤧯𤩆𤪢𣫟")
("1715" "䜶珲琿耼𦑩𤣹𤦥")
("1716" "䝀玿珞珺琚瑂瑉瑠璐臵𤦱𦗗𦐦𤩇𤪅")
("1717" "㻕瑤𤤷𧯰𠃠𡖈𢑑𥸨&M-40117;𢑰")
("1718" "㰯㰳㱌㺵䏃歅玖瑻璵瓎𤫌𤩄")
("1719" "㻮䏅琛瑈璨珎𤤸𤦰𤨺")
("1720" "㚉了予夛弓翏𠄎𢎟𠬯𢏚𦏻𢇊")
("1721" "䂇䲫卼孒弝弪殂殈翟豝豠𢃳𩘷䨲𢎪𢀶𣧊𣳣𥍨&M-36357;𠒢&M-45805;𣩰𠁽𠑻𣦽𠭌𣧼𢏱𦫣&M-36396;𦒏&C7-563E;&C7-5640;")
("1722" "㐨㢩㢽㱚䂆䣓䰞䲮䲯乃刀刕夃帚帬弜弸弻弼歾殉殦沀甬矛矞粥翮翯胥脀豞邒邧邪邴郦鄁鄝鄠鄹鄾酈鬻鳭鳾鴉鴯鶺鷊鷚鷸鸍鸐鸖鸝鸸鹂鹨鹬鼐𠚪𣨍𧱁𩰲𢐲𦒑𩱍𩱚𩱡𩱠𩱫𩱳𢎻𥍞𠜦𠱛𢏕𣧬𢏧&M-39444;𢐆𣨳&M-36394;&M-46709;&C5-5F38;𢐷&M-46972;𢐾&M-36462;&M-47039;&M-47067;&C5-7262;&C5-7527;&C5-753D;&C5-7679;&C5-7A50;&C5-7A56;&C5-7B31;&C5-7C24;𠂏𢎨𢒀𠄕𢎱𢁨𣍣𣧀𠨓𣍤𣧓𣧔&C6-2D61;𢂫𥍤𠝧&M-36360;&M-39496;𠄛𢐁𢐅𣨥&M-36376;&M-39537;𢐌㣃𣨱𠭾𢑪&M-45323;𣩍𥯵𩿎𠄝𠮇𢐥𢐨𣩝𣩞𢐬&M-33553;&M-36449;𢐴𢐹𢐼𢐺&C7-5224;𣩼&C7-5662;&C7-5664;&C7-5666;&C7-5D71;&C7-5D72;&C7-5D73;&M-39760;&C7-603B;𢑌&C7-616B;&C7-616C;&C7-632C;&C7-632D;&C7-6478;&C7-6479;&C7-647A;&C7-654F;&C7-6630;&C7-664A;")
("1723" "䂊承氶聚豤豫㸧𣧩𣨶䂉𥎌𣧾𢐄𦓖𥎒𤃻&M-36337;𢑙𠹩𥍶𥍷&C7-292A;")
("1724" "㢯㱭䝌及及歿殁豛豭𣧟𥍟𧰵𣪃𣧱𦐅&M-48962;𥍯&C5-4A21;𢎤𣧉𣪏𣪣&M-36403;𣩗&C7-292B;")
("1725" "䝍𧰷𥍮&M-36388;𥎎𣩌")
("1726" "㱪弨暦鬸𣧳")
("1727" "𢏷𣨢𡰣𢏈")
("1728" "㰷㱊㱋䝒弞𥎉𩆂𣧋𣧸&M-36342;𣣌𣩔&M-36444;𣤩𥎗𣶙𣣺𣩆𥎤")
("1729" "𣧷殩𣧢")
("1730" "䎆")
("1731" "𢟃𢟄")
("1732" "䳱䴇鄢鄩鵋&M-39422;&M-44656;&M-44733;&M-46851;&M-47352;&M-47321;𢎚&M-39675;")
("1733" "㤂忌忍恐恿烝焄焏焣𤎘忍刅𢖫𢙎𢘅𢙷𢝭𢞔𢢧𢡆𤑜")
("1734" "㕚㝷寻尋")
("1740" "㕛㢠叉娶子孑孓孕孠廴翆翠翣𦕓𠬛𡕡𠦘𡕪𠦕𡛒𡥗𢌞𦏴𡝠𦐜&C7-5A7C;𪏬")
("1741" "㝃兔孢兔免卂𣄲𢁄𡤾𠬭𦕍&M-38678;")
("1742" "㜿䍾䳩丒勇覅邗邘邢郉郔郠郰鄈鳱鳵鳽鵽鷣刃勇刃鳮𣄸𨝸鳽&M-39424;&M-47062;&M-47118;&M-47183;𢑕𦕋𦕘&M-49778;𡦅&M-29743;&C7-2B77;&M-47328;")
("1743" "翜𢑱𥎫")
("1744" "双叒叕孖孨异彛羿翇𦐓&M-30487;𠬺𢌼𠭂𡥦𢆙𦐧")
("1745" "刄")
("1746" "聸𦗯")
("1747" "𦕔𦦖")
("1748" "㰢欼𣤻𦘋")
("1749" "𡦞𦇚")
("1750" "㧬㧭䡗尹羣翬鞏𢮝𤚉&M-38251;𣍇𣍛𢦝𢑖𢪻𢭤𦐪&M-38295;&M-49876;")
("1751" "丮𢩦")
("1752" "弔那&M-39678;𦐃")
("1760" "㗨䀾䂬䃧䛐召君呄唘圅孴習𠮯𡦏𥓆𥔩𥕔𤳕𠮢𠭀𡥨𠝽𡇶𣇶𥒽𦐲𦐮𦐯&M-35401;𦑥&M-35649;𡃠")
("1761" "䃘䃲䣯巶矶矾砜砠砲硊配靤飁碸𥐗𥒮𨠖𩈆𩈇𥑋&M-39857;&M-39854;𥔄&M-42661;&C5-6A26;𥑁𠭚&M-39793;𥓋&M-42629;𦫥&C7-5265;&M-48294;")
("1762" "㢴䂛䃖䃤䃹䎄䣱䤎䲽䳂卲司矽砀码砌硐硧确硼碉碙碢碿磆磟磶礀邵郚郡鄑酃酌酮醄醐醑醪鵘鶝𥐩𨛔𨟰𠷎𥔀𪀉𠯶𥐝𠣫𥑎&M-39779;&M-39785;𦐸𦑇𠾉&M-39895;𥕡&C5-5F62;&M-40039;&M-47041;&M-47176;&M-47254;𥗮𥐝&M-35208;&M-39353;𢑔𥐼𢑜𥑩𥑚𠭞&M-39534;&C6-503A;&C6-5947;&M-39859;𤾊𥔰&M-39649;𥕖𦒆&C7-3C75;&M-46941;&M-39738;𦒯&M-40080;&M-47316;&M-47367;&C7-6053;&M-47495;")
("1763" "䂢䤙硍碌碌碾磓礇醁𥔢&M-39812;&C5-594F;𥓏𦧫&M-39934;&M-39966;&M-40008;&M-40081;𥗷𥗸&C7-6379;")
("1764" "䂘䂥䃑矷砃砐砓砕碫碬磤酘醊醙𥗙𥑸𠭿𥑊𥑌𣆸&M-39804;𠭵𥓭&M-42638;&M-42649;𣪾")
("1765" "䂫砪&M-39925;")
("1766" "䃉䃫硌磂磖酩酪𠶱𦑾&M-39961;𥗻𠭎𦧱𡃭𥖷")
("1767" "𥓒&M-42648;𥑵&C7-2A6F;")
("1768" "㰤䃢欩歌砍礙礥䂹𨣦𥒧𣤊&M-39973;&M-42676;𥗓𣣻")
("1769" "䂧磉磜&M-39957;&C7-4431;")
("1771" "㼦乙卺己已巹毣𢀿𤬨𣬻𢬬𠃐𠤬𢀷𦐀𦏶𢏩𤭀𤭡𤭿&M-48281;&M-48288;")
("1772" "䢵䢻䲰邔邷邼鵮𨚏𢎘𢎙&M-39586;&M-46666;&M-47255;𢆱𢎝𢎠𢎧&M-39281;&C6-255B;𢏖&M-46750;&C7-5E2E;𢑍")
("1773" "裠&M-34271;&C5-6029;𠬟䬸")
("1774" "𣪐𣱏")
("1777" "㞪㞯㞼㠯凾𪘸𠙶𡴻𡵑𦈩𠨔&M-48785;")
("1778" "𣢇𣣖")
("1780" "㠱㢲㷅疋翨翼跫灵𤆄𢏅𤆆𠭨𤎧𤑨𤑵")
("1782" "&M-47222;&M-47385;&M-49783;")
("1788" "&M-36749;")
("1790" "䅃䊄尕彚柔桑棸綤𣘦𣏗𣓔𡥀𣎼𠬹𣏻𥞱𢑤𥹏𢑯𦃤𢑿")
("1791" "飄飘𥍳𠃥𥘲𥘱𥛠")
("1792" "翲鴀鶔鷅鸘𪅃𥸥&C5-3C7C;&M-39564;&M-39595;&M-39634;&M-47184;")
("1798" "𣤜")
("1810" "䜼堥玐鍪𥪛𡍶𤦀")
("1811" "瑳璼𦖬𤣮𤥖𤦴𤨜")
("1812" "䜽玠玢玪珍珶瑐瑜翂耹聄聬骛鹜𧟯𧯪")
("1813" "玜玲璑璲聆蝥豏聅𤥽𦖾𤥼&C7-3B3A;𤪪")
("1814" "㻂攻政敢玝玫璈璥璬璷聠致致𢾼𦒐𣀳𤩀")
("1815" "㻶珜珻𦍽")
("1816" "珨琀瑲璔璯𦗢𦗧𦐬𡅡")
("1817" "珤")
("1818" "琁瑽璇")
("1819" "㻌")
("1820" "𣦹&C5-6F4E;𢎢")
("1821" "㢮㱲䨁殓尶𣩈𥍸𥎃𠚮𥍢𣨎&M-36440;𢎲𣧫𢏬𣨐𣴳𠄄𣩋&C7-5223;")
("1822" "㡔務殄殇殤矜鬺𥍠𧱬&M-36415;&C5-7442;")
("1823" "㢳矝矤飱𣨝&C5-3C41;𥍵")
("1824" "㢸攷敄𢏳㪌𢽴㪬𢽰")
("1825" "弹殚𢏙")
("1826" "㢵䰝𢐞&M-44491;𥎄𥎏&C7-4A3E;")
("1828" "殮豵𧲌𢐔&C7-3C2E;&M-36481;")
("1829" "弥𣧠")
("1832" "騖鶩")
("1833" "㤵㥤䱯愗憨")
("1840" "㜈婺𡤿𢌦𢌝𡝡")
("1841" "𡦎")
("1842" "㜾䎾𡥩")
("1843" "奦聪聡")
("1844" "㪀孜攼𢼅𠭕")
("1846" "𦖣")
("1849" "𦕗")
("1850" "㬲鞪𦎦𣍏&M-38430;𦏃")
("1854" "𣀆")
("1860" "暓瞀𥐙&M-39932;𥓺𣊃")
("1861" "䂱䂳䤈䩆矻砟硂硷碒碰磋礛酢醝砤酫𨠑𥓌𨣨𥐬𥑅&M-40089;&M-39923;&M-40044;&M-40063;&M-40114;")
("1862" "䂦䃋䃠䤅䩂砎砏砱碖酚𨟹𨢩𥐤")
("1863" "䂼䃍䃚硹磀磁磏磸礈䂠𨠎𥕻𥒨𠾥&M-39889;&C5-6A28;&C6-6423;&M-39953;&M-39982;&M-42695;")
("1864" "䃝敔硑磝礅礉𢼔𢽏𥑺&M-42646;𥕵𥖻𢽤")
("1865" "䩈礒群酶")
("1866" "䣻䤌硆磳磰𥗁𥕼&M-39948;&M-42656;&M-40028;&M-49791;")
("1867" "𥖴")
("1868" "磫礆醶")
("1869" "硢酴𥑒")
("1871" "霼𤬯&C5-7B4B;𤬻𠄋")
("1872" "霒")
("1873" "餮饏")
("1874" "改")
("1877" "嵍")
("1880" "熃𤋄&M-37682;")
("1882" "䪾")
("1888" "𦕦")
("1889" "&M-43421;")
("1890" "㮗䋷楘𣖶𦁘")
("1894" "𢿖")
("1911" "珖")
("1912" "瑺𤩂")
("1914" "𤫉𤥎")
("1915" "璘𤪏")
("1916" "璫𦗴")
("1918" "䎿琰瑣耿")
("1921" "𣰲")
("1922" "㢼弰矟")
("1923" "𣧖𥎜")
("1925" "𧲂")
("1929" "𣧲")
("1933" "㷦𢞚")
("1940" "孙")
("1942" "𡙼")
("1948" "𤑶")
("1960" "𥉔")
("1961" "硄&M-39881;𥕚")
("1962" "砂硝磱&M-40033;")
("1963" "醚")
("1965" "磷𥑍")
("1966" "礑&M-40102;𥗞")
("1967" "&M-40059;")
("1968" "醈𥔭𨡲")
("1969" "礯")
("1972" "䨭")
("1973" "褧")
("1974" "𤮪")
("1975" "𦨆")
("1985" "䫰&M-43730;")
("2000" "丨丿亅")
("2001" "&C6-3C72;")
("2002" "牓牗𠃑𤗫𠀭")
("2004" "𤗈𤗪𤗺𤗙")
("2006" "𤗏")
("2009" "𤗊")
("2010" "㙑㸒䀉䪞丄垂埀壬盉纟纩重𡈼𡍮𣥋𢒉𡋧𥝍𤔊𡍴&M-49800;𤨐&M-43244;𧰌𡓱𤫔&M-43264;")
("2011" "䧳䨿乖统维缠雌雏𨿠𨿿𩁟𡊥𤓸&C7-2A6D;𣦟&C7-352E;&C7-4454;&C7-512B;&C7-512C;𪚼")
("2012" "纺缔缟缡鲂鲚鳙黐𪐏𤔁𧗔𧥘&C7-6640;")
("2013" "䖝䗞䗽䘉蚕蠥黍𧕲&C6-3B65;&M-32981;&C7-4264;&M-33960;&C7-6562;")
("2014" "㱖纹绞鲛")
("2017" "𤔌𠂜")
("2019" "鲸&C5-7154;&M-48030;")
("2020" "彡彳𠆲𥝘")
("2021" "㒕㒧㣶伉位住侂倠傡傩傹僮儃儺凣往徸禿覓觅讎隹雔雠雥雦魋魑秃𣬜𠉫𨿂𠿕𧇠𢓔𠊔𢔆𤡇&C5-4A7D;&C5-5138;&M-45822;&C5-604E;&C5-6D6C;&C5-7244;𢀠𣱞&M-36512;&C6-5979;&C6-6375;&C6-6376;𠾄𢀩𣩖𧣽&C7-2A63;&C7-2A66;𡁗&C7-3D46;&C7-3D49;𡗌&C7-5576;&C7-5577;𢖥&C7-5976;&C7-5F7A;&M-45933;")
("2022" "㑺㒀䨊乔仿侪俼偙停傍傐傭儁儕喬币彷徬為爲秀觹豸隽雋偐𤔔牅𧤍𧤪𧴄𠬦𠂥𠏰&C5-6559;&C5-6564;𠆼&C6-2D6C;𤔃𠋣𠌯𤔦𤔬&C7-273B;𤔰&C7-316E;𧤞𤔹&C7-417B;&M-36616;&C7-4B46;&M-45908;&M-33844;&M-48540;&M-33902;")
("2023" "㑊㑵㒅㒟乑伭依偯僬億儦儫儴忀爫𠂢𠐥𠐦𠐤𧥍&M-36336;𠌮𣩻𧣙𤖏𢖐&M-46498;")
("2024" "䚝佼俯倅傽僻愛觪辭𢓫𨐔𧳛𠋩𠌭𣁗𢕔𢕑&M-36570;&C5-797E;𠄒𠊒&M-38632;𠊴𠭧𢕒𢕾&C7-4373;𡖀&C7-5D6E;")
("2025" "舜𢕎&M-38566;")
("2026" "信倍偣傏傗𢕮𧪵&M-43279;&M-49720;𠋭&M-35988;&M-47575;")
("2027" "&M-48796;")
("2028" "㚊侅儣𧥌𠌿𤏀")
("2029" "倞𠉪𠍱𠍨&M-47891;𧤇")
("2030" "乏𡿨𤾤")
("2031" "䧷䱦魧鱣鵻鯍𩶶𡿾&C5-523A;&C5-7A51;&C7-363D;&M-46419;&M-46494;&M-46585;")
("2032" "䰽䱱䲱魴鰝鰟鱅鱭鴌鶭&C5-7250;&C5-7737;&C7-4C67;&M-46320;&M-47281;")
("2033" "㤁㥋㥯㦌䵡忎忝悉焦熏鮌𢣘𪆄𤇠&M-46595;𢛧𤋱&C7-3E47;&M-46535;𤓬&M-46627;")
("2034" "䱣寽魰鮫鯙鯜鱆𡬳𪁉𪇊&C5-7258;&M-46548;&C5-7A54;&C5-7B73;&M-46164;&M-46213;&M-47058;&C7-5671;&M-46462;")
("2036" "&M-46342;&M-46368;&M-46360;")
("2039" "鯨")
("2040" "䎹乎千受妥委孚季孼爱秊隻隼雙𠬪𠦬𤓴𤔂𡠓𤔣𤕀𠂷𡥞𡴘𠂿𤔐&C6-4630;𤔪𡢛𡦠𡕽𠧎𡕼&C7-4B4F;𠧏𠮗𠧐𤕍")
("2041" "䠴䡀兎航艟雛雞𨈢𦪇&M-38061;&C5-5D66;𡕬&C6-502B;&C6-502E;&M-30461;&C7-2A62;&C7-2A65;&C7-352D;&C7-3530;&C7-3531;&C7-3D47;")
("2042" "禹舫艕艩&M-30443;𠂍𠢏")
("2043" "夨夭奚舷躿𡗞&C6-5030;")
("2044" "䨇叐爰艭辤𢍏&C5-5F45;𢍃𥝯𢍒𤔠&M-30515;&C7-4437;")
("2046" "&M-30462;")
("2048" "䠹")
("2050" "手爭犨犫𤓾𠂯𠦚𠡦𤔇𤔒𢮣𢹭")
("2051" "㹌牤牨犝𤙵𢩥𤙫&C6-5977;&C7-2A64;")
("2052" "㸬㹍牥犒𤚰𤛑𤙂")
("2053" "犥𤜄𠂕")
("2054" "犉𤙡𢪖𤚃𤔤𤚮𤜀𤜃")
("2055" "掱爯")
("2056" "犃𢮏𤚵𤚫")
("2059" "㹁𤚊𤚒")
("2060" "㘜㸓㸔吞呑售噕昋番看舌讐香𠯑𤔱&M-40073;𠮮𣅌𠱦𥄥𥄃𠳅&M-44521;&M-40123;&M-49796;&C7-2A67;&M-47996;&M-44547;")
("2061" "䧼䴚雊雒𤽼𠴦𪋍&C7-3534;&C7-3D3F;&C7-512A;&M-48634;&M-47568;")
("2062" "皜&M-47580;")
("2063" "皫𤳯&C5-7B32;𤳼")
("2064" "皎辝辞")
("2065" "𣅲")
("2066" "馫舙𤕈")
("2068" "𤳲")
("2069" "𤾝𦧢")
("2071" "㠉㠧㲙㲝䶘乇乚嵼毛毰毳氊雝𣯍𣯤𠃋𠃉𠄌𠄏&C5-6B66;&M-48765;𡵀𠨟𣮍𣮣&C6-597A;&C6-5C3D;𣯊&M-40125;&C7-4456;𤮲&M-48708;&M-48790;")
("2072" "㟾䶩崹嵃嵃嵉嵪嵭齴𡽉𠂠𠂞𢎣𠌶𡼕𡽟&M-48571;")
("2073" "㠙㠡丢么厶嵻嶕𡻠𡻨𡾌&M-34118;&C6-502F;&C6-6378;𡾝&C7-5155;&C7-6427;")
("2074" "㞶崞崪嶂爵辥饺齩爵𪘧&M-40119;𥪵𡾼𠭡&C7-4546;𡾘&C7-5661;&M-48756;")
("2075" "𡾉")
("2076" "㟝嵣𡺈&C7-5B38;")
("2077" "㟀岙臿舀𠙺𦥲𦉈𠚟𠙻𠚏𡷩𦥛𦥫𤔘𦈼&M-49951;𦉥&M-48754;")
("2078" "峐𡾇")
("2079" "㠎𡻥")
("2080" "㸈䧶秂辵𤊙&M-36669;&M-36688;𤒞&M-37035;𤇫&M-49751;&M-37866;&M-38674;𤓪")
("2081" "𤒂𤒣")
("2088" "𠂹𢪐")
("2090" "㯔䄟乗乘櫱禾秉糱系釆采集雧𥝌𦃟𦓤𥟅𣙼&C5-592D;𥼛𠂲𤓽𥝩𥞆𡘸𣗷𤔥𦃃&M-49797;𦅽")
("2091" "䅊䆄䋁䌒䌱䌴䧽秔稚穜紸統綂維繵纏𦀠𥽀𥝕𥿼𦁙𦇺𥽽&C6-6374;&C7-352F;𦅅&C7-624D;")
("2092" "䄱䅭䅻稿穧紡締縍縞縭𦂃𩫥𥡦𦆉𦆈𦇽")
("2093" "䆂穅穛穮穰絃縗繶纕𦅃𣟼𥿹𦆆𥤂𦆌𦆪&C7-5C44;")
("2094" "䌟稕稡紋絞綧綷繂𦁉𦂀𥿺𥡢𥞯𦀓𣁝&C7-3437;𥤁𦈁")
("2095" "縴𦇑")
("2096" "䅧䅯䋨䌅稖稸𥞞")
("2098" "穬絯纊&C5-7454;𦆍")
("2099" "䌕䌖䢄穕綡𦇘𦂠𦁛")
("2101" "𤗑𤘃𤗋𤭘&M-48826;")
("2102" "师𤗦")
("2104" "版𤖳𤗭")
("2106" "𤗚㸟")
("2108" "順頥顺")
("2109" "𤖯")
("2110" "䇓上坒墍暨曁止盨衍街衘衝鈭銜鲈些㘹𪉖𧘂𡋪𡋬&M-43242;𡑸&M-47546;𣥌𣥕𣥗𡌓𧖭𡍏𧗪𣦄𡎱&M-40467;&M-47535;&M-39939;&M-47542;𥂷&M-40678;𡒴𥃍𥃎𧘆")
("2111" "此歫歮甀红绯缰頾鲱𤮘𪐌𣥖&M-48000;&C5-7B59;𣥓𣦙𣦕")
("2112" "与绗鲕鲡卐𩣷&C5-5A32;&M-49907;𦐳𧖹𦑴𦒕")
("2113" "䖪䘅纭螚𧍢&M-33006;&M-48019;&M-33837;&M-33950;&M-32863;&M-33336;&M-33365;&M-33843;")
("2114" "㪓㪖敱纡绠绰缏缛衈鲆鲠𢾫𢼟𢽃𧗈𧗌")
("2116" "䵗缅缙鲇黏")
("2117" "鳕")
("2118" "缬顗鳜頿頉𩓣&M-43560;&C7-2B2B;&M-43566;&M-43589;&C7-5A31;")
("2119" "缥衃鳔")
("2120" "㱔俨卢步歩歺亇𤕫𧗞𧗡𠤟𣥩𣥿")
("2121" "虤衏豾貆貙軀雐魉魎魒魖鼿齀齇虐偃佌豼躯𠑷伛𠨜𧲦𧣒𢕓𢕖𧣾&C4-4F74;𩳀𤮆𩳌𠐳𩳤𧥖𪗁𢆋𢓆𢓖𠈺𢓗𢓯𠋧𠌰𧢾𧆲𧇁&C5-5325;&M-45817;&M-45804;&C5-5A41;&M-45840;𠐶𤮙&M-45878;&M-45873;&M-36636;𤖢&M-48526;&M-45912;&M-48535;𤮰&M-45931;𤖦&M-48816;𠘩𠤐𢓊𠈄𣥪𧆬𧗨𧢸𠧽𢔉𧆧𧣂𠌩𠋿𤖊𤖋𧆳𧗬𧣰&M-49733;&M-45789;&M-45784;𠏂𢇒&C7-2A59;𤖙&C7-363A;𠐢𠐚&M-45851;𤮝𧈀&M-45876;&M-45866;𢖙&C7-4A3F;&M-45887;𥃈&C7-5227;𤮧&M-36650;&C7-603E;𧥕𤖥&C7-642E;𧥗")
("2122" "㑂㣔䖏䘙䚘仃何侕俩俪倆偝傌傿僃儞徏牁肯胔脣膚虏虜虧行衎衒衔衕衖衚衛衞衡衢觜鬳鼑卨儒肻𧆜𦙼虜𧗴𩢮𣦵𠇐𧢵𠄚𠍩𠨆𢄼𠧜𣥈𠧣𣥑𣥍𠂱𣬄𠉡𠤚𠧲𢂦𧆞𧢴𠧳𠧼𠧻𢃌𢔚𣥴&C6-4363;𧆪𠨀𠨁𠨂𥹟𠌹𢔵𢔸𧆿𧗳𧗲&M-44617;&M-44621;𠨈𢕱𤔧&M-36591;&C7-3622;&M-44719;&C7-362C;&C7-3A60;虧𧘀𧤜&C7-492A;𧈉𥤃&C7-5977;&C7-5D67;&M-36493;&C7-6546;")
("2123" "伝佧侲倀偄僫儢卡慮澃虙虞觨豦虑𠏡𧤲𠧛&M-34274;𠍪&C5-7A3A;𠧗𧆝𠧶𠧹𤕺𥎼𧣎&C6-4F22;𠍴𧣨𠏊𣻯𤖜𧤶𠑓&M-36644;𠑚𤖤&M-36483;")
("2124" "㑝㒤㪥㪭䖉䖍仠仮伢伻佞佴便倬偠傉優虔處虖豻鼾𠆸㿫𧲨𠌘𢾙𢿉𧣺𢓄𣬆𢼨𣥨𠋵𢽝𢕯𢿈&M-36574;𣀁𣀞𠆻𠧘𢁵𢓉𢼎𠊳𢔄𤖁𧣐𧣀𢔭𢾍𢾈&C6-5850;𧇆𢕶𢿊𢿑𥀍𢿮𥀡𧤧𢖒𧤿𠑍𠮘𥜷𢍷")
("2125" "䖗侢歲歳𧆥𠐡𧇱𢕺&M-36642;𠍬")
("2126" "佔佰価俉俖偕偪偭僭徆貊𢓲𧆨𧇄𡖞𢔡&M-36563;&M-36588;&M-48517;𧈘&M-48551;𠇙𠈇𢓕𠉦𤕻&M-39789;𧆱𧣔𧣮&M-36564;𧇕&M-36104;")
("2127" "𧆣𢖎&M-48801;")
("2128" "㑯䫂䫈䫉䫛䫥䫩䫵侦倾偵偼傾價徙潁虡須頠頹頻頽顀顓顪顱须颅频颓颛𠎮𢒩𧇽𧤼𠑘𠊤𢔤&M-43386;&M-43552;&M-43571;𠐺&M-43585;&M-43577;𠐾𢖤𠑯𧆩𤖈𧆾&M-36766;&M-43465;&M-43473;&M-43524;&M-43570;&M-43639;&M-43665;&M-49892;&M-43685;&M-43708;&M-43710;&M-43715;")
("2129" "㑐䝠伓偨傆僄僳徱傈䝣𠍲𥹐𠋾𠍞𧇃")
("2130" "衑&C6-4555;")
("2131" "䱌䱍䱎䱏䱭䱳䲔䳖䳼虢魟魭魮魱魾鮔鯡鰋鰸鱋鱷鱸鱺𩵏𩵪𩶆𩸋&M-46641;&C5-4B67;&M-46016;&M-46873;&M-46151;&M-46188;&M-46425;&M-46466;𣦘&M-46761;&M-46755;&M-46109;&M-46832;&M-46985;&C7-5A5B;&M-46603;&M-47468;")
("2132" "䲐䲗魳魺鮞鰢鰤鱱鴚鴜鶳鷌鱬&M-44574;&M-46033;&M-46181;&C5-724C;&C5-7C36;&M-45999;&M-46712;&M-46689;&M-46404;&M-46486;&C7-6336;")
("2133" "㤐㦣忐惩愆態毖点熊鮆鱁𢤧𢚎𢗓𢛂𢝐𧗺&M-46028;𤎴𤐸𤑅&M-38164;&C7-5A60;𢥨𤓜")
("2134" "魬鮃鯁鯾鰬鱏𩷹𢽨&M-46027;&M-46901;&C5-7B70;𢻭𢾓&M-46660;&M-46106;𡭑𧘄&M-46348;")
("2135" "鱥&M-46018;")
("2136" "鮎鮨鯂鯃鰏𩻛&C5-7166;")
("2137" "䱖鱈&M-46630;")
("2138" "頱頺顖顦鱖𩹸&C5-717A;&M-43644;&M-43696;")
("2139" "䱈鮛鰾𩵣𪆫&C5-6059;")
("2140" "㔬卓姕嬃攴舻顰颦𠤏𡥎𧗿𡛗𣬂𣥥𠧫𤿙𡤫𠦀𠧔&M-29312;𠧺𧗭𡠋𧗶𧗵&M-38085;𢻛&M-47540;&M-49891;&M-47559;&M-43755;")
("2141" "㼰䑢䑭瓾舡艫躽舭䡁𧗝𠤗𤮭𦫊𤭂&M-38046;𤭟&M-30452;&M-30534;&M-30583;&M-30585;&M-38165;&M-30389;&C6-6323;𧇢&C7-5C4C;")
("2142" "䑰歶舸艣駂𥜾𦨵𠬣&M-30356;𧇧&M-30375;𥜽𣦃駂𣦖&M-38144;&C7-4C4A;")
("2143" "奌𡘌𪉗𠧵𠤕𥎩&M-30392;𡙉𡙏𡙊&M-38092;&C7-4930;&M-30592;")
("2144" "㪏㪕䑲舨歬𧗦&M-38045;𢆢𢿎𢌱&M-09593;&M-49080;𣥎𢆒𣥭𣬊&M-30374;𢽅𢼻𧯭&M-38100;𣬓")
("2146" "舾𦫃&M-30473;&M-38118;")
("2147" "𧗢")
("2148" "䪻䫋䫌䫣䫧頯顊𩓀𦪘𩔹&M-43380;&M-30512;&C5-596C;&C5-662E;&C5-662F;&M-43748;𡡓&C7-2B2C;&M-43493;&M-43605;&M-43674;")
("2150" "䡓㧘𦍧𧗸𤘤𤜂𢪓𢮠&M-38594;")
("2151" "㹔牼𤛐𤘹𤙞𤛏𤜅𤘥𤚕𤜙")
("2152" "牱犡㹘&M-44777;𤘖𤙀𤚴&M-44743;𤜏")
("2153" "𤘠𤘳")
("2154" "㸩㹛𤘾𤙴𤚨𤘴𤚿𤚾𤚳𤛾𤛽")
("2155" "拜&M-43499;&C7-3D6D;")
("2156" "牺牾")
("2158" "䫇𩒰𩓞𤛦&M-43572;&M-43384;")
("2159" "㹉𤘢")
("2160" "㔽㫮䖜䜭占卣卤卥呰旨皆眥睿砦衙衜衟訾讆鹵𠮳𠯒𠧪𧭹𠧚𥓇𣦉𣉘𥉃𧗹&M-48700;𣅜𣑾𧗧&M-47529;𣥸𧮲𣉻𣦗𢒷")
("2161" "㼟㽃㿨瓵皉皬馡𤽊𤭧𣬈𣬖&M-42613;&M-43259;𤴅𤿅")
("2162" "㱒&M-44676;&C7-6434;&M-48770;")
("2163" "𤾨")
("2164" "敁皈𢾆𤽂𢾃&C5-722C;𤽐𢽿𢿥&M-44558;")
("2166" "啙𩠜&M-47538;𥕿𣥧𤾻𠨋")
("2168" "䪷䪿䫁䫝䫠頕頟頢頶𩔻𩕏𩕵&M-43410;&M-43488;𤾶")
("2169" "𤾛")
("2171" "㠊㠠㼘䖓䶙䶥匕屸屼岏岖岠岯峌峘崕嶇巄旣比毞毡毢毴齔齜旣𠧟𠧴𡷨𣯋𣱐𡾜𪗻𪘬𡿕𤬷𡹪𡹶𣯪𣰜𣰼𤮯&M-48761;&M-48800;𣥅𠒄𠧡𠧠𠧢𡶅𣬅𣭁𣭞&M-41609;𠨅𧗻𣯦𦫤&M-48591;&C7-4D2C;&M-48711;&M-48726;")
("2172" "㞹䶗峏嶀巁師𡹣𠧤𠧷𡹻&M-48602;&C7-516F;&M-48768;")
("2173" "䘡飺𧙁𧗫𢇌𡽣𡾅&M-41863;𡵮𣥏&C7-452B;&C7-5156;")
("2174" "㟁屽岅岈岍峺崾巎饵齖岍𪗙𢼌𢽭𡺷𢾱𢻲𢼍𡷟&M-41563;𢽥𣀎𡾂&M-48595;&M-48609;")
("2175" "𡼛")
("2176" "峿齬龉𡺽&M-48611;&M-48639;𡶌")
("2177" "䘖齒齿歯𧗣𣥼𦈬&M-48797;𡴸𠤔𣬃𠤛𣥫𠤞&C6-5A61;𦦈𠚝𡾐&M-47562;&C7-5746;")
("2178" "䪼䫜崸頃頧顷嵮𩓟𩓥𩖁&M-43341;&M-43344;𡺭&M-43402;&C5-7C45;&M-43354;&M-43383;𡼔&M-43604;&M-43611;")
("2179" "㟲㟳㟽𦅸𠂾&C7-6223;")
("2180" "仧歨眞真衠貞貲贙躗熋𧗟衠𤐧&C6-3456;𣢙&M-49764;𤈭𤈱𤉭&C6-5879;𤌺𤎵𧘃𧘅&M-39236;𤓞")
("2184" "𣀶𢿡𦗁")
("2186" "&M-40032;")
("2188" "熲顚顛𣥐𣦁𤍙&M-01505;")
("2190" "㭰㮚䘗䘘尗柴桌祡粊紫術䋕槩枈𣏔𣓨&C5-3D27;𡮙𣟉𥘈𣦅𧗱𣖴𠨇𣗴𥻆&M-27103;𦅓𣡼𥾄")
("2191" "㼡䆍䊺䊼䋊䋌䋔䋗䌔䌬䌳甈秕秠秬秷稏穊穲紅紕紪絙絚絰經緋緪緸緾繮纑纒纚𦀘穊𦃄𤮎𦆠𥝾𥞅𥚋𥟍𥠍𤭽𥠶𥡧𦇔𥤞𥝓𥝪𦀇𦀞𤨗𦄒𦄕𤪇𦆡𥤀")
("2192" "䊸䋍䋑䋪䋳䌤穪糽絎緉繻穤𥾝𦁗𦃔&M-44728;𥾎𥾦𥿶𦁥𦅏𥣭𦈀")
("2193" "䌢秐稬紜緛𦁄𦆄𥝮𥾬𥡤𥢴𥣘𦄖𦇼")
("2194" "䄨䄯䄰䅶䋙䌁䌄䌰敊秆秤稉紆綆綽緶縟纋𦂇𢾽𢿆&C5-5746;𥢏𣀝𥣯𦇸𥾍&M-49407;𢿹𦄱𥜱")
("2195" "穢𦅵𥢈𥾙")
("2196" "䄷䄼䄽䅾䋹䌮秥稫稭絔絤綇緬縉𦀡𦂄𥿕𥢋𥞶𦇢")
("2198" "㯋䅡䆊䋶穎緽縰纈顈颍颖頴𩒛𩓄𩓬𩓰𦄼𢀊𦇖𦁡𦅐𦅨")
("2199" "䅺䌚紑縓縹𦂘𧇥𦄽𥠲𦃊𥢕𥝣𥿴")
("2200" "刂卝川𣶒𣥂𤖺𠚩𠛁𤰃𠂵𤰆𢍖")
("2201" "㲏儿胤𤗢𤗯𠃕㸠𤗅")
("2202" "片㸞𦙍𣂔")
("2203" "𤖼𤗵𤖴")
("2204" "𤗳")
("2205" "&C6-4161;")
("2207" "牐𤗠")
("2209" "𤖱㸣")
("2210" "㞢㞬㞷㟵丝亗剝剥剴劙埊岦峑峚峜崟嵳纠豈鋫鑾𠜶𠝤𡾙𠚭𠚻𡸈𠞏𡎨𠠂𤖛&M-40583;𠠍𡿡𡳿𤯓𡉚𡴍𦤴𡷅𠜸𧯛𡍑𡹭&M-40139;&M-40242;&C6-5732;𡐪&M-40575;𠠞𧯽&M-40681;𡒽𡓚𣦱")
("2211" "㠑嶳歱纰缍𣥃𣬺𡷝𡾾&M-48878;&M-48021;&M-37353;")
("2212" "嵡巋绣鸶𦐉𡼜&M-48001;𡾕𣂠𣂸𡼍𣦜𣃔&C7-6340;")
("2213" "䖽蚩蚩蠫蠻蠿衇𧈪𪏭&C5-5060;𡿽𨒠&M-49686;&M-33842;𤬤&M-33929;")
("2214" "崶纤纸绥绶缓𡽵𡽂𥡭𡸘&M-48006;&M-48360;&C7-5B33;")
("2215" "嶯嶻𧗒𧗇𧰙&M-33417;")
("2216" "濌缁鲻𣥾𡽞𡽘")
("2217" "䵚绌鳐𢇍")
("2218" "崁嶔𩑙")
("2219" "缫鲧")
("2220" "㓩㓺㔒㞻㟥㣜䖌侀例侧俐倒側刎制刿剬剶剻剼劇劓屵岑嵾彎爿觓鼼𠛫𠨲𢒾𡿪𠛕𠩃𣧄𠛻𢓟𠝄𠝨𠋴𠞤𠞾𠟧𡾀𢆯𠆯𠛏𠛠𠛯𠛷𠛱𠜔𡷉𠉳𠊖𠜿𠝉𢫶𠂳𠞜𡻪𠎼𠟵𠟭𡼘")
("2221" "㒎㒥㞩㠕㣫䚦䠷亂仛任佻倕偅傂催僜儠兇凭岚岝峞崔崖崺嵐嵟嵬嶏嶐嶤巃彪毿郺鬽鬿魕齆𠉥𣭡𤕷𡺮𩲀𠎷𪖐𩴪𣦷𡶂𠈊𠊦𡷜𡸌&M-36521;&M-40140;𢕘&M-36560;&M-45775;𠏢𣯹&M-36598;𡽧&C5-604B;&C5-604C;&C5-604D;𡾛&M-48518;&M-45913;𢒽𠈁𠘽𢆻𡶢𧢳𠃲𢂮𢓩𢓸&C6-3C38;𡸔𡸢𢔎𠌠𠍧𢔝𧣜𢔷𠍮𢀂&M-36566;&C6-636A;&M-45790;𠎺𣯯𠏪𠙭𡽓&M-45830;&M-48502;𢀇𢀈&C7-4450;𦨁&M-45898;&C7-522B;𡿆𢇖&C7-5A4D;&M-48555;𢀐")
("2222" "㑜㒋㒞㞣㞧㠐㠿㡩㣐䚩伒侨侺偊偳偽傰僑僞儶岕岗峁峛峝峟崗崙崩嵛嵩嶲巂斨耑臠虨觽觿貒雟鼎𡿩𡵱𡸑𢕪𠆺𡴅𠕓𢓵𠊵𠌲𣂵𧣭&C5-527A;𧤗𢋱𡾱𠠪&C5-7B6E;𡿧𠈩𤕰𡶤&C6-2D6E;&M-30756;&C6-3B4E;𢒜𡹺𢃷𢄆&M-29481;&C6-4D55;&C6-4D67;&M-48316;𡻾&C6-5723;&C6-5A60;𠻭𡴥𢒪&M-49542;𢒭𢕷𡽐嶲𡽦&M-36619;𡾧𢀉𧈇𧈎&M-32458;&C7-5C47;&M-40108;")
("2223" "㑦㒚㣰㲻㴝䝖仏仫仸伥俬傒僁僕嵹嶽巚徯汖灓觚貕𤕯𡻬𤬛𦇥𣲂𠊥𠋳𠋷𤫻𡻚𤬌&M-31293;&M-36613;𤬘&M-36631;𤬝𣧕𢓽𠊾𡘶𡺒𡺙&M-36531;&M-36523;&M-38689;𤬈𠎻𢡊𢖃𧤷𡾯")
("2224" "㑗㑧㟼㠅㠔㣭䚨仟侹俀俘倭偁僾儍岌岸峳嶈巌巐巖彽後觗觝低㣦𠈶𢔏𡦄𡺲𠈰𢓰𡖲𡺵𥟿𡽄𥀺𠉔𠈯𡺰𡺿𧤔𧤋&C7-3362;𧰍")
("2225" "僟僢崴嵂嵅嵗巀𢪇𡸤𡹷𡾻𡿑&M-38408;")
("2226" "佸偱僠循𠉣𡹼𧲿𠉤𦧠&M-35522;𠈲𥅱𣨯&M-36600;&M-36584;𡾷𤖣")
("2227" "㑁㑎仙偛岿崫貀𧳀𠋯𢔣𣻮𣦧𡰮")
("2228" "㑟儨嵸嵿嶡炭𡸛𡽠&C5-646D;𧤫")
("2229" "㑿㒡㟜㟶䵈觻係倸㒒緜𤬖𧈈𢖟𡿛𠊻𤕽𠌀𤖉&C7-2931;𡿌𤾾")
("2230" "㞫䱨劁岺魝鯯鯻鰂𠜖𡴒𡹢𠞎𠞆&M-46680;𡽅𠚴&M-46118;")
("2231" "㲕㲬䰲䱄䱰䱺魠鮡鮿鷈𩵡𩹉&C5-6051;&M-46195;&C5-6B34;&M-46412;鱲𣯺&M-46279;")
("2232" "䰺䱑䱿䲉嶌鰞鱎鵀鷥鸞𩷒𪁐&C5-7B72;&M-46676;&M-46199;&M-46974;&C7-5673;&C7-6331;&M-46593;")
("2233" "㶵䱘䱥䳶䵩崽嶣巛巜恁悡懸戀煭紭𢇁𢛁𡿭𡷢𡹸𤉥&M-46341;𢗍𢙌𢚏𢛋𤉩𡴦𡼶𢠞𢠾𡽸&C7-422F;𢥁&M-46351;𢥩")
("2234" "䱐䱓䲬鮾鯚鯼鰀鱍鯅𩶅&M-46060;&M-46806;&M-46190;鯘&M-46294;")
("2235" "䱢&M-47330;𡿠")
("2236" "鮜鯔鱕&M-46196;&M-46221;𦧰")
("2237" "&C5-7253;&M-46079;")
("2238" "嶺")
("2239" "䲃穌鯀鱳𩼋&M-49924;")
("2240" "㚇㜽㞵㞿㟬㟺㪻刋劖孌孿屮崒崣嵏毕變屮妛𠬢𦨉𠜱𠞃𠝣𦸶卛𠮓𡝧𡹨𡼒𡥐𢆼𡜟𡥏𡥝𡿹𠭏𡴙𡴖𡷮𡹃𡸠𠙢𡴟𦋇𡺾𡻛𡦣𡽕&M-42615;&M-36112;𣀵")
("2241" "㲗䑬䠽乳巍𦨎𠛦𡸊𣭹𡦢&M-30498;&M-38113;𠮖𡿢𡴂&M-30358;𠃶𦕢&M-38066;𠄉&C7-5F78;")
("2242" "㪿䑣屴𡻙𢒛𣂟𣂣𥜿𡺺𣂲𥝁𣂹𥝄𢒸")
("2243" "㞺㼏奱𡸦&M-38107;&C5-5743;𡵗𡷪&M-30767;𡴝𡴨")
("2244" "㝈㟖䒂艀艇艐艸芔茻躷𠦅𦨢𦪑𡷓&M-38088;&M-30757;&M-31310;&M-31316;𢍬&C7-3226;&C7-3227;&M-32184;&M-32273;𢍶𡴬")
("2246" "𦧐&C5-3B54;&M-30542;&M-38074;&M-30513;&M-44543;")
("2247" "䠳舢&M-30505;")
("2248" "嶷炭&M-38168;&M-41917;")
("2249" "𦆰")
("2250" "㟦㸨㸪峯峷崋掣攣犁輋𡴋𠛃𢩬𡸪𤙲&M-38614;&M-43233;𡴀𡵞&C6-2C42;𠜕𡴑𡷏𡹆𡴕𡴛𡸚𡸵")
("2251" "嶊牝牦犣𤛲𣭣𤙔𩙲𤚏𤛍")
("2252" "㸫岪崭嶄巈犙犞𤙍𤫴𤙪")
("2253" "㹒𤚍")
("2254" "㸹牴𤘸𡷠𤙤𤚈")
("2255" "㠖峩掰搿𢪒&M-30655;𡷌𡻍&M-31312;𡽥")
("2256" "㸸&M-44510;")
("2257" "㟛𡵣")
("2260" "㓠㓯㞱㟒㟔㟯㠄䣸刣刮岧岩峀峇峉峕崮嵓嶜旹曫甾矕訔轡辔𠛎舏甾𧥥𡽜𩠹𠰛𠰕𠝘𠝪𡹤𡺊𠜜𠱭𠱧𡴏𡿸𡿷𤰫𡴗𡷚𥄾&M-44490;𡴜𡹍𡹏𡸟&M-35283;𡺚𤯧𠺤𣈤𡻲𡻦𣊆&M-39893;𡽔𣊨𥢺𣌇")
("2261" "乨乩乱嶉癿皑皚皠臫飜㲒㿞𡽛𤾢𠃭𦧔&M-31287;&M-47536;&M-48605;&M-47577;&M-47583;𡿣")
("2262" "㣌㣍㪾岢斪𡷧𤾡&M-31286;&C7-422E;&M-48732;")
("2263" "舔𤳤𤫱𤾣")
("2264" "皭舐馟䑛皧𦧝𦧦𡼋𤿃")
("2265" "畿")
("2266" "㿟䭬皤𦧟&M-44548;&M-47574;𦧗𦧵")
("2267" "䭯𤽆&M-44550;")
("2268" "𡾆")
("2269" "皪䌛𤾧&M-44529;&M-44531;𥢖&M-35833;𦅹")
("2270" "㠒䶡丩刨剀峢𡷘𡸉𠞇𠠗𠄍𡶭𠜼𠝞𠂈𠚸𠜷𠝀&M-48655;")
("2271" "㟅㟟㡭㲎㲱㽋䶣䶰乢乣岜岴崑崜嵦嶝巤邕饪鬯齓龇𡶆𡶰䍋𠄑𡳾𡴯𡵋𢆸𡸗𠃏𡴼𡴄𡵊𣬡𡶍𠥄𣭀𤬼𢀀𢁃𤔕&M-49582;&M-31317;𣯧&M-49959;𡴧𣰆𣰔𡾑𣰫&M-49962;𦇷&M-48794;&M-48795;")
("2272" "㟧㟨㠋㫁岇岓嵴嶃嶠断斷齗齭齲龋𡸎𡶹𢒕𣂢𣂯𣂶&M-41710;𡼰𡼙𢑂𢑉")
("2273" "㠢厸岆峎崀嵔嵠嶾幺製𢆶𩞟𡶉𢆾𡴁𡵏𡵰𤫪𣂭&M-34238;&C6-5041;&M-34390;𢇑𤬍&M-34467;&M-34747;")
("2274" "㞴㟊㟎岻嵈嵕嶭饭馁&C5-755D;𡽀&M-49849;𡾦&C7-4F47;")
("2275" "崢&M-48775;")
("2276" "匘崉崏崰嶓𪗽&M-48686;")
("2277" "㟗丱凵凶凷出凼山屾岀巒幽豳𠙵𪗨&C5-2129;𡴎𠚘𡺫&M-48690;&M-48728;𦦽𠙷𠙸𠁿𡴳𤮺𠚀𠚁𠙾𦣹𦥒𦣼𠚍𠚋𡶏𠚎𡶫𠚒𡺳𠚛&M-48592;&M-48753;&M-48779;&M-48805;")
("2278" "嵌饫𡼽")
("2279" "嵊繇𠃆")
("2280" "㞤㞥㠘劗災賃赀赁𡴆𤴗𡵖&M-36729;𠞿𠟓𠇿&C6-2C60;𠔖𠔛𤇲&M-36671;𤈹𡻗𤎚𠟮𡼝𤎾𤴠𡽽&M-36892;&M-49771;&M-36902;&M-49739;&C7-4375;")
("2281" "𡹽")
("2282" "崱𢒟")
("2285" "幾")
("2286" "㸋")
("2288" "㠌巅巔巓𡵝𡸓𤎸𡴫")
("2289" "𤑗")
("2290" "㓷㓽䅀䌃利剩剿岽崇崬嶚嶪巢栠梨樂欒祟糸糾紃紖絒粜剰𣎵𥞲𡻝𡼊㠍𦃖𡿈𠛩𥟻𦀣𡻰𥠉𣏁𠛴𥾜𥿟𡺼𣖃𣕐𥟸𥟜𡻭&M-08700;𠟫𠟾𡽭𡾍𡾚𣟾𡿜")
("2291" "㠇䄻䅜䅱䋃䌐乿嵀秅秏秹種糺紝絩綞緟繀繼絍𦃇𦁍𥠱𥢰𦆻𥾆𥾖𥾭𥞝𣮕𦁚𥠴𣰮𦇈𡿏")
("2292" "㣓䅎峲彩穚紤絼綉繃繑纗𦀦𥠄𥞄𡻣𦅈𦅧𣂫𥟞𦅂𦇜")
("2293" "䋬䌥崧私秗穏穙穩縘纀纁纞𥿯𥿊𦁔𤬇穏𦄘𦄾𥣜")
("2294" "䄭䅍䅑䅗䊹嵙秖秪稃稯穱紙綎綏綒綖綬緌緩緵𦆛𥿄𦇱𥿈𥟛𦂜𦃉𥤑𦇻")
("2295" "䋫嶘稱穖𦃱")
("2296" "䅔䅨䋸秮秳稲緇緍繙絬𥢌𡾽𥞸&C7-266A;𦅑𡿘")
("2297" "䅤秈稻絀縚𦤙𥞃𦂉𥠃𦇓")
("2298" "&M-32169;")
("2299" "䌜䜌秝絲綵縣繅纅繅𠬆𦃒𣞆&M-31323;𦂏𥡝&M-49760;𥣲𦇹")
("2300" "卜")
("2301" "𤗍𤗇")
("2302" "牖牑")
("2303" "𤗀𤗂")
("2304" "牔")
("2305" "牋")
("2310" "䘐亝叁叄垒垡盀𡊄𥂥&M-48008;𡊏𡊅𠫰𥁐𤯢𠬅𠬁𥁱𢨑𡒉")
("2311" "鱿鲩鸵")
("2312" "编鳊𧗋")
("2313" "䖸䘑獃𧊇𧒎𤝶&M-33229;")
("2314" "䘒绂缚鲅𢎍")
("2315" "线绒缄𧖻𢨡&C6-5864;")
("2316" "䘔绐绺缩鲐")
("2317" "绾")
("2318" "绽缤")
("2319" "综")
("2320" "仆伈佖参參外")
("2321" "㸜优伫佗侘侙俒倇倥僦僱僿允覚魃魆魊𠫞𩳐𩴳𠫨𠈵𡖢𧤎𠑅𠑙&M-45902;&C5-7528;𠫠𠒊𠫱𢓝𠋪𡖟𧣖𠎂𠎾𡰐𡰘𧇒&C7-5226;𥃓𧈚")
("2322" "㣷䠻佇俌傪儜帒徧偏傓𢕕𦙯&M-48538;𢁔䏍𠫦𠫼𢒏𠌌𢕗𥚪&C6-6072;𦓞&M-49690;&M-43254;")
("2323" "㒄伏俅俍俟傢彂狀獻觩𤕾𠊲&M-36544;𠏨&M-36638;𢓪𤞣𤟶𤟜𠎰𢖘")
("2324" "㑏㒃䝜代侒俊倂倵傅厳戱𢍿𤕳𢓭𧳵𢓀𠈸𠊢𢀁𢎎&M-36520;𠨢𠇞𠋢𠌗𦓗𧇭𠮍𢅢")
("2325" "㑘㣝㣤伐侔俄俴傶儎戕戯戲臧虥𠈋𧣼𠏯𠇘𠈭𠋰𢧠𠏃𤖞𠐲𢖝𠊭𢧁𤖆𠬂𧣱𠏔𢧶𧣴𧥄")
("2326" "佁傛僒𡖤𠊑&C6-3D35;")
("2327" "㑻倌")
("2328" "傧儐貁𠐻")
("2329" "㒍俕倧徖𠇲&M-36532;")
("2330" "鮅&M-46713;")
("2331" "魷鮀鮁鯇鴕&M-46191;&M-46928;&M-46281;&M-47258;&M-46137;&M-47037;&M-47077;&M-47378;")
("2332" "鯆鯿鰺鵞&M-46045;&M-46920;&M-46451;")
("2333" "叅怠然鯄黛𢘋𢛃𩹏&M-45997;&M-46731;&M-46170;𢞤&C7-5A55;&M-46508;")
("2334" "䳁鮟鮻鴏鵔𩹲𢎓&M-46878;&M-46580;")
("2335" "䰹䱛䱠䳘鰄鰔鱡鱤&M-46768;&M-46095;𪀚𢨓&M-46615;")
("2336" "鮐鰫𩿡&M-46311;")
("2337" "魲&M-46982;")
("2338" "鴥𩼧&M-46274;&M-46611;")
("2339" "鯮&M-46049;")
("2340" "㛷发斚夋𡜀𠬎")
("2341" "䑱舵𨉗𡴞")
("2342" "艑𠂣𢆲&M-38155;&M-38158;")
("2343" "矣艆躴𦨚𢽂&M-30413;&M-30478;&M-30551;&M-49574;𤢚")
("2344" "䑹弁&M-38059;𦤚&M-30367;𠦷&M-30445;&C6-6125;")
("2345" "軄艥𦨜𦨷&M-30474;&C5-502D;&M-30528;&M-38052;")
("2346" "䑿𦤬&M-30557;&M-38149;")
("2348" "軉&M-38161;")
("2350" "単挙牟牮軬𠫿𠫚𠫺𠫹&M-38619;")
("2351" "㸰牻𤘜𤘺")
("2352" "犏𤙭")
("2353" "菐㸻𤙠𤘲𠫪𤛤")
("2354" "㹑牸𤚽𤘚𤚔𤚠")
("2355" "我戦牫")
("2356" "犗")
("2359" "𤙷𤛡")
("2360" "䀤台畄畚諬馝𨠒𥢑𥑼𠧨&M-39827;𤲙𤲛𥡳")
("2361" "皖𦧊𦧑")
("2362" "&M-47558;𤲑")
("2363" "𪊄&M-44549;𤝡")
("2364" "馛𤳊")
("2365" "战皒馢鹹𢨟")
("2366" "𩡔𦧮")
("2368" "馪")
("2371" "㟌奙岮崆毧毪毬𡶃𡷗㲓𡻮𡼌𪘲𡵔𣬽𡸥𣮏𣰷𠫙𢆴𦥨𣮬𡻜&M-48618;&M-48763;")
("2372" "㠁峬𡸕𡾈𠫫𡹫")
("2373" "㕕㟈㟍厽厾峵巘袋𤟀𠫬𠤘𡸒𠬀&M-48661;&M-48814;")
("2374" "峖峻𪙍&M-48672;&M-47569;&M-49964;")
("2375" "㞽㟉㟞䶢䶪峨峸巇饯饿𪘪&M-48671;&M-41635;𡾟&M-48608;&M-48610;&M-48798;")
("2376" "嵱饴齝&M-48718;&C5-7A24;")
("2377" "岱嵆馆齾𡼿𡵘𡺴&M-48681;𦉧𠫻𡕜&C7-5079;")
("2378" "岤𡾰𡽆𥦶")
("2379" "嶫")
("2380" "炱貟貵貸贷𧸾𤇰&M-36767;𤆃&M-36683;𤊜&C6-4F2D;𠔩&M-36837;")
("2383" "𤝀𤟙")
("2385" "𢧾")
("2390" "㕘巣枲柋秘絫㕖𦁊𥡁𠫩")
("2391" "㞊䅝秺紌紽綄綩𦆼𥟚𦁈𦄔𦅺𥞒𥡔𥡫")
("2392" "䋠秿稨穇紵編縿𣝜𥣗𥡨")
("2393" "秫稂稼紎絥絿綋綟緿繈繎𦅒𦆥")
("2394" "䄩秡稄紱縛縡絣𥿋𥿮𥢔𥾐𥠵𦄎")
("2395" "㦵䄾䆎䋐稢稶絨絾綫緎緘縬織纎纖𥾮𥿵𥠆𥣩𢧍𢧹𦃎")
("2396" "稽紿縖縮𦁖𥡴𦄲")
("2397" "䌏嵇綰𥟓")
("2398" "䋉穦綻縯繽𦇰𥟐𦆯")
("2399" "秫絉綜𦂅𡮟𦅍")
("2400" "𠄓")
("2401" "𤖪𤗎𤗿")
("2402" "帅㸢𠠲")
("2404" "𤖷𤘀𤖩")
("2406" "𤖲")
("2408" "牍牘𤗸𤗶𤘄")
("2409" "牒𤗥")
("2410" "纣銺鲋鲥𡋩𥁒𡬪𣥲&M-40549;&M-47561;")
("2411" "绁豓靠鲑𧗀")
("2412" "㔞䵙動纳绔绮鲔鳓𧖩")
("2413" "鲢𧎬&M-33398;&M-33903;&M-49679;&M-33249;&M-33653;")
("2414" "䵾歧歭皱绫鲮鹱㩾𣥣𣥻𤿴&C5-534F;&C5-607D;𤯕𤿈𤿥𢻞𢻩&C7-3E66;")
("2415" "缂衊")
("2416" "结绪鳍𪏻𣦈𣦡")
("2417" "绀")
("2418" "续缜缵鲼&C5-7273;")
("2419" "缭鲽𣦨")
("2420" "㐼什付仪傠射斘斛豺𠏮𠐆𠦣&M-48515;")
("2421" "㒗㓄䖛䚚䚭䰫仇仕伳佐佬佳侁俺値值偡傕僅僥儓先兟勉壯徍徝甝觟貛躭鬾魁魌化齄他𠆶彵𢓂𡖓𧣁𩴞𩴓𩵄𠠷𠡞𢔂𧢽𡖪𡖬&M-36518;𠌱𧆻&M-45798;&M-45856;&C5-6664;𠐿&M-45886;&M-48527;&M-45922;&C5-7C40;𠇾𡉟𤕮𢓠𠊪&M-45759;&M-45773;&M-45795;𧇨&M-45837;&M-45857;&M-45882;𧈋&M-45897;𠣈𣦲&M-45943;")
("2422" "㐻㑃㒖㔧䝝仂佈侉侑俙俲倄倚偧備僀働儚儰劤勨勪勮勴徛觔觭豽躸䝡𢓬𧢹𪖥𠡔𠡢𢓢&M-36497;𦝭𧣩&M-36565;&M-32534;&C5-7141;𠇴𢓇𠡬&M-49533;&M-29415;𠋮&C6-505B;𤖐𠍰𤗩𧤓𧤌𠢼𧤦&C7-3E62;&C7-632E;")
("2423" "㐲㣵䏻佉侬俠傸傼徳德觾貘偀㒓𡚰&M-10116;𢕞𠏖&M-36625;𠎢𠎱&M-48534;&C7-5946;")
("2424" "㣥㩻㩼伎伖佊侟侼侾倖倰倴偫傇儔妝彼待皻侍㚢𡛝𢔁𥀃𥀵𠢅𧇉𧇡𧤣𠑛𤿡𧣄𠋽𥀄𠐎𧤱")
("2425" "㒝偉徫𧤒𩏣𠌾&M-43151;𧤻")
("2426" "㑤㣟䚛估佑佶俈借傄储傮僖儲夡徣牆觰貓偌偖𢔪𠎸𧤺㒂𧤮𣨁𧣗𠎲&M-36599;𠐧𤖠𠑫𤖧")
("2427" "佄𧣑")
("2428" "㷇䶑供倛偾僨儊儥儹徒傎僙觵𤖘𡖾𠏴𤖖𢖏𠏗&M-36634;&C7-5257;")
("2429" "㑣䚞䝗䝤休倈倷偞僚僸徠膫貅牀僷牃𧳟䚢𠋲𧤈𢆇")
("2430" "䲁鮒𣁷&M-46015;&M-46212;")
("2431" "魤魫鮜鮭鯥鰪鱙鱹𩵍𩸆&M-46102;&M-45967;&C6-646F;&M-49929;&M-46410;&M-49933;&M-47501;")
("2432" "䱂䲊勳魶鮪鮬鮳鰖鰳鳨𩶉𩻟𠡻𠢴𠢰&M-46705;&M-46107;&M-46218;&C5-7254;&M-46891;&C7-4C55;&M-46334;&M-46408;&M-46435;&M-46430;")
("2433" "㷶䲦䴌勲怤怹憄憅憊烋魼憇鰦&M-46161;&M-46316;&M-46428;𢘂𢣍𤏹𢤅&C7-6043;&M-46552;")
("2434" "䱁䲖鮍鯪鰣鱯&C5-605E;&M-46193;&M-46438;&M-46610;&C7-3E45;&M-46252;&M-46576;&M-47491;")
("2435" "鱴&M-46131;&M-46554;")
("2436" "䱜䲛鮕鮚鯌鯺鰭&M-46553;")
("2437" "魽")
("2438" "䱋鯕鱝鶀鱑")
("2439" "䱞鯠鰈&M-45998;&M-46510;&C7-4C50;&M-46407;")
("2440" "䠵升华姇娤舣𡞓")
("2441" "圱鼽勉&M-30550;&M-30444;&C6-587A;&M-30519;&M-38147;&C7-4A6B;")
("2442" "㔓㔜䠸舿艜𠣄&M-30437;&M-32018;&M-32042;")
("2443" "䒃奊奘艨𦨐舦𤞛&M-30566;")
("2444" "䑧皴皺艧軇𢍎&M-30391;&M-38047;&M-38053;&M-38071;")
("2445" "&M-38083;")
("2446" "艢")
("2448" "䑴䒈舼&C5-6379;&M-30591;")
("2449" "艓𦤧&M-30541;&C6-5921;")
("2450" "㸯犐𤛌&M-38324;𤚑")
("2451" "㹊㹏㹓牠牡犆𤘣𤜍𡊽𤙸𢴽")
("2452" "劧劮劺牞犄犕𤙒𤛩&C6-5E5E;𤛟𤛶")
("2453" "𤘬𤜒")
("2454" "㹀㹗特𤙢𤿪")
("2455" "𤛻𤜐𤛫")
("2456" "㸵牯牿𤚐")
("2458" "犊犢𤛥")
("2460" "㬱告𣁳𤽁𡬹𣈪&M-35690;")
("2461" "㿥皢馣&M-47556;𦧇&M-44566;")
("2462" "㔚䭲劬劰勂勓勫𤾸𤾘&M-44551;&C7-537B;𤾼")
("2463" "𤳖𤾬")
("2464" "㿧馞𦧉𤿟𤿩𤿝𤿘")
("2465" "皣𦧹𤾴")
("2466" "皓")
("2467" "甜")
("2468" "馩𤿀")
("2469" "䑜")
("2470" "㞳㠚&M-48588;")
("2471" "㟐䶔䶧峔崦嵁嵖嶢巏毨氁馇馑齛龀𣭟𡸜𣯏𣯩𣬼𣰬&M-48767;𣬢𣮲&M-41790;&M-48641;&M-48687;&M-48677;&M-48731;")
("2472" "㔡㟓岰崎崤嵽嶱帥幼齮㔘𪗝𪙰𠠳𠡒𡹰𡽝𡿥𠢒𡽇&C7-507A;&M-48682;")
("2473" "㠓䶝峽裝𡻯𡻟𡶱&C5-5263;𡵓&C6-5233;&M-34334;𦦕&C7-3D75;𡿋&M-46550;")
("2474" "㟑㟿㠛㠨岐岥峙崚崻嶹巕饽𢺵𡷸𤿷𥀈𥀰𤿎𡻴𥀉𡾲&M-48642;&C7-6632;")
("2475" "㠏")
("2476" "㟙䶜岵峼嶆齰𪗾𡼎")
("2477" "𡷥𡶑&M-48676;")
("2478" "䶞嵮巑馍齻齼")
("2479" "崊崍嶛𪘨齽𠁫")
("2480" "焋貨贊货赞𣢢𤈢&M-38715;𤏛")
("2481" "𤏝")
("2484" "𡞩")
("2488" "𤒧")
("2489" "爒")
("2490" "䊷䋽䌀科紁紂紏紨𢇔𥾅𡬧𡬟𡭫𥞂𣘳𦆝")
("2491" "䄬䅅䅒䅖䊵䊶䌍䌯稑稙穘紞紲絓繞𥡃𦀜𦁏&M-40124;𥡣𣠎𥤊&C6-3366;𦁱𦂔𦃑")
("2492" "䄲䅄䋭䋻䋾勦稀糼納絝絠絺綺𦀖𦅶𥢸𥤆𥿌𥟏𦂂𦂓𠢶𥡹𦃣𦃜𦇩")
("2493" "䅘䌭䌲紘紶綊綕縸繨繱纄𥞵𦄍𦇎𥡠𦅇𦆟𥿭𦀗")
("2494" "䅸䋂䌧秓秛秲稜穫紣紴綍綾緈縙穁𢻃𥾣𥞘𥞳𥢍𦁑𡤨")
("2495" "䅿䌩稦緙緯𥣫𦂡𦇪")
("2496" "䅦秙秸稓穡穯結緒緖繥繬䅲緢𦁎𥿍𣗺𦂍𥤜𥟾𦅁𦆏𦅷𥣱𦆶")
("2497" "紺𥾰")
("2498" "䅩稘稹穔穳綨縝續纘䌙𥟕𥢊𣞟𦆋𦄗𦆖𦆬")
("2499" "䅴䅷䊾䋱䌇䌝䌨綝緤繚𦁜𥢇𥢻𦃝")
("2500" "牛")
("2503" "失")
("2504" "𤗬𤽯")
("2506" "牰")
("2508" "𤗴𤗮&M-36920;")
("2509" "㸡𤗗𤗛𤗣")
("2510" "㘶䵓塦生绅𧗃")
("2511" "甡纨纯绕鳢𥣨")
("2512" "纬绋鲭&C6-597D;")
("2513" "䵜缱𡙇&M-33642;&C5-7742;&C5-7B5A;𧖫𡚆")
("2515" "&M-48015;𣥽")
("2516" "𤾭")
("2518" "歵绩缋𧗏&C5-5F46;")
("2519" "䵔练𪐓𤯡&M-48011;")
("2520" "仗仲件伸使侓俥倳律舛貄仹𡖝𧣈&M-36503;𢓐𠈐&M-36514;")
("2521" "䰠䰡伅侥僼儘夝徃魅𠌷𤯷𢓃&M-45780;&M-45836;&M-45835;&M-45846;")
("2522" "伂佛俜倩彿𢓳𠏬𢖊甧𤯝&C6-3479;𧢿𧣘𠍟𠍶𢑩&M-49732;")
("2523" "伕佒体佚侇侠俵傣僡儂儙儾觖触齂齈齉僆𠌼𨑊&M-36522;&M-36569;&C5-697C;𢖧&C6-5851;&M-41936;&M-48329;")
("2524" "俦健傋傳僂徤貗𧳅𢓒𠉕𠎹&M-36581;")
("2525" "俸𠉩")
("2526" "㑋㣙伷偆僣𠑤&M-48552;")
("2527" "䵻𠌴")
("2528" "㚍㣱倎倢债債僓儧徢穨𢖑𤖓&M-48537;")
("2529" "㑍㑛佅侏倲傃觫傑徚𠇱𠍷𢓣𠋖𠍀𡖯𧤛𧤠")
("2530" "䰷𩵠&M-46747;")
("2531" "魨鮏鱧")
("2532" "鮄鯖鱐&M-46081;&M-47049;&M-47332;")
("2533" "䱀䱃䳀怣鮧鰱鴃&M-46007;&M-46101;&C5-6F26;&M-47110;&M-46529;&C5-7B27;𢛭")
("2534" "鰎鱄䱾&C5-5A4C;&M-46507;")
("2536" "䲋鮋鰆鰽&M-46406;&M-46511;𤴋𤴎")
("2537" "&M-47259;")
("2538" "鰿&M-49927;&C7-6170;")
("2539" "䱅鮇鮢鯟鰊")
("2540" "肄舯&M-38070;𦕡&M-30417;&M-30488;&M-30486;")
("2542" "䑶&M-30396;𥏚&M-38084;&M-30539;&M-30577;")
("2543" "躰𦤕&M-41927;")
("2544" "艛軁&C7-317C;")
("2546" "舳艁艚")
("2548" "䠿&M-30457;&M-30538;&M-30581;")
("2550" "牪𢫰𤘧𤯟")
("2551" "牲𤘫𤘛")
("2552" "牬")
("2553" "𤙕")
("2554" "犍")
("2555" "犇𤘼")
("2559" "𤚩𤙨𣝖")
("2560" "吿眚𠱒𦧏𤯣𥅶𤯬")
("2562" "皘𤽌")
("2563" "𤱽𤱾&C5-6F48;&M-33592;")
("2565" "䭰舑")
("2566" "㿤")
("2568" "疀皟")
("2569" "皌&M-44569;&M-44524;")
("2570" "㞲峍齥𩰡𩰢𡵜𡶈𡷖&M-48613;")
("2571" "㠦毽饨饶鼄𣭴𣯭𡴿&M-32807;𣯫")
("2572" "崝𡶒")
("2573" "䶚岟峓峡嶩蚀馕𡿝&M-34206;&M-48624;")
("2574" "嶁")
("2576" "岫")
("2578" "㠝䶦崨馈𦦘")
("2579" "崠嵥𡶎&M-48685;")
("2580" "&M-39142;")
("2581" "𤯖")
("2589" "𦠁𤒗")
("2590" "䄿䋖朱桀种紳絏𥞁𥝫𥾒𥾫")
("2591" "䌡秇紈純繣𦄌𥾑𥡩")
("2592" "䄶䅢秭紼綪繍繡𥾧𥟗𦀔𦂈𦅎")
("2593" "䄮䄺䊽䊿秧秩穂穗穠紩紻絊縺繐繷繾𦁆𨽿𦇀𣗻𦅋𥝭𥞗&C7-444D;𦈃")
("2594" "䅹緀縳縷𦁰")
("2595" "𥠾")
("2596" "秞紬釉𥞴𦃠")
("2597" "𦄑𥡟")
("2598" "積緁績繢纉𥣪𥢼𦇅")
("2599" "䋘秣絑綀練縤縥𥿉𥠹𤐬")
("2600" "囟囪旧甶白自囱𤗄")
("2601" "覑")
("2602" "𤗱")
("2603" "牕")
("2604" "牌")
("2608" "𤗁𤗘")
("2610" "䵒堡皇皨细缃鲴𤽔𦤃𤽧𥁬𦤐")
("2611" "㿡䚄皩绲绳覬鲤鲲鳇𧢫&C5-354F;&M-34824;")
("2612" "䵘甥绢绵鳄鳎𧗗")
("2613" "㱗缌缳鳃𧓎𤾲&C5-782B;&M-33183;𧗂𧑉𢑾&M-48203;")
("2614" "缉缦鳗&M-48018;")
("2616" "鲳")
("2618" "织缇")
("2619" "缧缲鳏")
("2620" "㐰㑑㒁㣎伯伵伽佃佪侞俰倁個徊粤粵貃𠇂𧣛𠈈𠉢𠉬𡖣𢔊&M-36505;𧣕&M-36546;𣦦𤼽𦣺𢇆𠋼𦤒𢒤𠎡𧤯")
("2621" "㒦䑟䖑䖖䚁䚠䰦但侃侱俋俔俚倱偟傀儬儭儸児徎徨忂皃臰覤覰覶覷覻觛貌貍貔軆鬼魓𧳢𠐌𤽇&M-34797;𦣾𠋨&C5-4B62;𢅉&C5-506E;&M-45801;&M-45833;&M-45847;&M-45843;&M-45880;&M-34972;&M-39681;&M-45895;&C5-7247;&M-45930;&M-48544;&M-34992;&C5-7B51;&C5-7C25;𠇝𠒆&M-34798;𢓼𧆽𠏄𠏁&M-39488;&M-45850;&M-49779;&M-45875;&M-45867;&M-34967;&C7-5539;&M-45910;&M-48550;")
("2622" "㑥㒔㒙侽偈偒偔偶傝儩帛臱觸𠈉𢔥𤽃𢇋𧤃𧤉&M-36614;&C6-2D6D;𣆄𠌳𦤔𠎯𦤝&M-36579;𤾜&C7-3361;𠐈&M-48524;")
("2623" "䚡䚪俁俣偎偲儇儑儤忁泉灥齅傯𣹻𠑟𠋬𧤖𦣿𤰲𦤌𣶚𤲄𢕼𠐛𧤩𧤬𢖚&M-36639;𢀎")
("2624" "㣬䚜䚟䝢䝥俾偮傻僈儼得貋貏貜𢓴𧤏𢖦𠉶𠋻𢔠𢕚𠑩&M-36655;𠈷𠉖𠭛𢔌𢔶𢕃𧇤")
("2625" "僤觶貚軃𠌫𢕏")
("2626" "侣侶倡偘儡躳𠑪𡗈𠌜&C6-4D51;𠐨")
("2628" "䚣伿促倶偍傊徥䝦&M-37408;𠍸𧣫&M-36567;&M-36568;&M-36605;")
("2629" "㚌保倮傫儽躶僺𦤞𠋸𤖇𢒬")
("2630" "鮂鮊鮰鯝&M-46085;&M-46764;")
("2631" "䱇䱒䲅鯉鯤鯹鰉鰛鰮&M-46369;&C5-7B71;&C5-7C27;&M-46938;&M-46379;")
("2632" "鯣鰅鰐鰑鰨𩹄𪃁𪇆&C5-6F29;&M-46558;&M-46280;&M-46256;&M-46467;&C7-6046;&C7-647C;")
("2633" "㦝㦟䴋恖息悤惒憩繦鰁鰃鰓鰥鱞鸔𥄉𩶭𢤁𩹌&M-46505;𡿻𢘣𢝏𢞫𢡕𢡔&M-47171;&M-46555;")
("2634" "䱝鰻鵿𪈤&M-46159;&M-47011;&C7-566D;")
("2635" "魻鱓&M-46824;&M-46446;")
("2636" "鯧")
("2637" "&M-46476;")
("2638" "䳅鯷&M-47096;")
("2639" "鱢𩸄&M-49941;")
("2640" "卑皁皋皐睾臯舶辠卑𦤂&M-30376;&M-45825;&M-38135;𡕩&M-30410;&M-38081;")
("2641" "䚀䚌艃艎覣魏𣆶𥇅𧡩&C5-4972;&M-30471;&M-34912;&M-34922;&M-38117;𦤨𦪷&C7-2862;&M-30514;𦤡&M-38125;")
("2642" "䑽艊齃𤽖&C5-502F;𦤦𤽘𠢎&M-30482;&M-38156;")
("2643" "㚖吳臭&C5-422B;𡘻&M-38105;𡣉𤾪")
("2644" "鼻鼻&M-48499;𢍍𢍘𢍙𠧄&M-43256;&C7-6252;")
("2645" "舺")
("2646" "艒")
("2648" "&M-38060;&M-38094;&M-38095;")
("2649" "&C7-274E;")
("2650" "㸶牭犩&M-38278;𤘘")
("2651" "犤𤚪𤙝&M-39391;𤛂&M-45813;")
("2652" "㹇𤛯")
("2653" "犑犦𤚯𤜑")
("2654" "㹄𤙰𤜉")
("2655" "𤽛")
("2656" "𤜋𤜈")
("2657" "𤚞")
("2658" "㸽")
("2659" "㹎𤜌𤜖")
("2660" "䭳諐𤽙𤽻𣉭&M-35794;")
("2661" "䚃䴜覘馧魄馧&C5-4971;&M-47565;&M-34829;")
("2662" "㿣馤舓𦤫𤾉𦧭")
("2663" "𦤟&M-47552;")
("2664" "䴝皔皡皥𤽹")
("2665" "皞𤾠𦧴")
("2666" "皛&M-47549;")
("2670" "岶崓齫𪘩𡶐𡶯𡻢𡸙")
("2671" "㟴㠥岲峴崐崲嶵毸皀皂馄覒𣬣𣮎𣮐&C5-444E;&C5-506D;&M-34936;𡿇&C5-7B5D;𤼾𣌣𣬉𤱖𠃼𣮑𣮨𣯂𣯒𣯝&C7-297A;&C7-3B6B;&C7-3C64;&M-48659;&M-49963;𣱀&M-41076;")
("2672" "㡫崵崿嵎嵑皍齵齶𪘹𡷡𡹾𡼑&M-48546;")
("2673" "㟪㟫㿝&M-39670;&M-08066;𢆿𤽎𡷤𠂽𦤆𡹊𤱮&M-34621;&M-48742;")
("2674" "㟸䶫崥嶧巗馒巊𡷛𡽁𡹯𡻩&M-48774;𡹋𡼗")
("2675" "㠆岬𡻞𡻇&M-48771;")
("2676" "𡾊")
("2677" "𠂺𤽚𦤍&M-45766;𡿁")
("2678" "㔭崼齞齪龊")
("2679" "嵲𡸖𡻱𡿔")
("2680" "㒵煲賲𤽈𤽬&M-36765;")
("2681" "𦠺&M-49713;&C7-297B;")
("2684" "𤑹")
("2688" "臮")
("2690" "䄸和秵稇稒稛細絈絗絪綑緗臬䊬𥝿𥞚𦀝𥿳𦀙")
("2691" "䅐䅙䅣䆉䋎䋥䋲䌆䌉程絸緄緼縄縕繉纆纙𦀕&M-34853;𥠀𠬓𦃋𦈅&C5-7B6F;𥞷𦀚𥠎𥠺𦃰&C7-4425;𦆊")
("2692" "䅥䋵䌈稩穆絹綥綿緆緭䅌𥟘𦇧𦂕𦂢𥣰𥠇𦂝𥡆𦆅𦆂")
("2693" "䅰䆀䋿線緦總繯𥡥𦄿𦆿𥟔𦃞𦇏𥤓")
("2694" "䅞䅼䆁稈稗稷綼緝縵繌繓繹纓釋𥡅𥠋𦂆𣠏𥤘𥟑𦃍𦅳𦆎")
("2695" "縪繟𦅿")
("2696" "䅛稆絽𥣬𦃧𦄛𦇄")
("2698" "䅠积穓緹縜𥞺")
("2699" "稞綶緥縲繰纝𥡜")
("2701" "㸥𠁢𤖫")
("2702" "鳪𤖻𠁡𠚬𠧓𤖮𤖾𤖽𧣉&M-46637;")
("2703" "牎")
("2704" "𤖬𤗜𤖰")
("2706" "牊𤗻𤗨𤗌")
("2707" "归")
("2708" "㸝")
("2710" "㙰㚅㺱㺸坚坚垼墏墾壑彑玺玺盌盘盝盠盤血豋銞錅錖鎜鎥韰鱼冬堲𡐩𤪎𧯡𡑶𡉲𡔟&C6-3431;&M-40239;𡺻𥂃𤧧𤩤𡒰𡓬𧰥")
("2711" "䵛凱纪纽组经绝衄颽鲍鲣鲵鲺龜𪚭𣥇𧖵&C5-5A66;&M-48005;&M-48003;&M-48868;&M-48864;&C5-7752;𣥘𠤣&M-48872;&M-33658;&M-48873;&M-48874;&M-48857;&M-48855;&M-48858;")
("2712" "㔩㱕䘏䲼䳄䳡䳨䳯䵑乌勻匀卹歸约纫纲纾绑绚绷绸缪邬邹郵鲫鲷鸟鸳&MCS-00ECA296;衂𨙼𩾰𪏯䳠𠣏&M-39511;&M-39543;𦑝&M-46735;&M-39701;&M-48012;&M-47291;&C5-7C48;𠂶𠣙&M-39351;𠣡&C6-3469;𠝅𡖰&M-40122;&M-39667;&M-49781;𠤅&M-39717;𠤋&C7-5735;&M-47464;")
("2713" "䖤䖿䗍䘀彔终缒缘缝蛗螌螽螿蟹蠁蠡鳋黎蠁𧒂&M-33924;𢑗𣥦&M-32907;&M-33004;𧖷&M-33219;&M-33343;&M-33649;&M-49696;𥣥&M-33708;&M-33687;&M-33898;&M-48233;")
("2714" "级缀缎缨鲟鲰𣥹𣪱𣪰𠮋")
("2715" "绎绛𡒒𤛿")
("2716" "䵕绍络缗衉")
("2717" "䘓刍绉𡑈𧖾")
("2718" "㰣欰缑欤𣣷𣢑𣢡𣢃𣢻")
("2719" "绦绿鲦")
("2720" "厃夕多𧖪𧖧")
("2721" "㑉㒛㒠㒨䄐䖕䖘䰣䰨䰬䰯䳃䶌亿仉伔伹佩佹侐俛俷倪偑偓僶儳凫危夗徂觑觤觬貎魍鳧鳬麁径𠆩伲䶊𢒿䝚𩲪𠏫㒊𨿯䬌𧇿𢖞𩴇𠑗𠈬𢓞𠊣𡌪𧣃&M-36507;&C5-3645;𠌋𢄄&M-36530;&C5-3D53;𧆼&M-45763;&C5-444D;𢕙𧣬𧇝&M-45834;𠐊𢖈𢕬&C5-5E60;𤖗&M-45879;&C5-6A60;&M-45889;&M-45899;&C5-7142;&M-45911;𧥓&M-34990;&M-48558;𠆰𠘷𠑾𡖊𠙑𤕲𥸫𡕚𡖕𡲂𧣍𠍄𠍈𡖴𣨖𤖍&M-45769;𧇇𧇅&M-45786;𧇔𧣶𧇣&M-45832;&M-45874;&M-45877;&M-49930;𠑒𦫱&M-48523;&C7-5642;&C7-573E;&M-45936;")
("2722" "㐴㑚㑳㔃㔨㚋㠾㣇㣈㣘㣚㣯䎗䖚䚥䚧䢾䣀䣏䣙䣜䳌䳪䳰䳽䴂䴄仍仢们仰仴伃伄伆伨伺佝佣侈侗侚侷俑修們倗倜偦僇僩僪僴剓勿匇匍匔卶向嚮夘夠幋彴彻徇徟御甪甮翗翛翽肾虝角觺豹豿躬躹郷鄇鄊鄬酁酅鴴鵂鵚鵵鶨鷮鸆鸕鸬鸺齁仞胷𠣤𢂺𨛖𠊬𢇇𧢼𧣚𧳆𠣾𤔲𧳹𪀗𪀢𪀼𧤽𠐽䵼𦓐𠣑𠣒𠈀𢓋𠈕𤰅𡖑𡖒𡖜&M-39423;&M-39446;𠊰𠶰𢔇𢄇𢔱𢔴𧣣𧣡&M-39563;&M-39574;&M-39616;&M-39591;𠏈𦑙𧣷&C5-5137;&M-39638;&M-46697;𧇟𧤐&M-39679;&M-46804;𠐋&C5-5E62;&M-46835;&M-39721;&M-46921;&M-46979;&M-46946;&M-46990;&M-47016;𠑑𦡼&M-47080;&C5-6F43;&M-47407;&C5-7A21;&M-47499;𠚣𠆨𡕓𡖄𣍝𥤢𠕍&M-05757;𡗠𢁙𠇛𢓈𠜌&C6-2D6F;𧢲𠣠𢂟&C6-342B;𠉨𠜰𠣨𢃁𢓶𢓷䏑𧢺𢃝𢑞𢔘&C6-4361;&C6-4362;𧣏&M-36513;&M-39483;&C6-4631;𠋱𠋹&M-36524;&M-39512;𠍢𠌵𢄗𣤃&M-36541;&M-46645;𠍻𠎞𢑭𢕜𣨷𧇂&M-36557;&M-39599;𠏣𡖿𦑤&M-49730;&M-49780;&M-46737;&M-46686;𠤇𧤢&M-39680;&M-46794;𠤈&M-39703;&C7-3E71;&M-39725;&C7-442B;&M-46977;&M-46914;𢑷𧤾𧥁𤕅&C7-5665;&M-47292;&M-47370;&M-39761;&M-47406;&M-47460;&M-48895;&M-47517;")
("2723" "㑰㒩䝆䝟伬佟佷侯候偬偰像彖很洜漿矦觮象貇倏衆𠋺𠏀𢅞𣩕𧴂𧥂𠗆&C5-3C47;𢔳𤬂𧣢𡗁𢓘𠉘𢑛𠊱𠋂𠋫&M-36358;𤖅𤟌&M-36363;&C6-4F21;&M-36373;𡙝&M-48923;𢕝&M-33220;𣼙&M-36592;&C7-3521;𧈆")
("2724" "㑴㕟㲊䝘䶋仅仔伇伜伮侜侵俶假偋傁僝將岋彶役徦殷觙觼貈貑伋𠮉𣦼𧢷𠊫𠭯𧮸𨉣𣦻𠭉𠉧𠭝𣪈𠭗𧆤𡖫𢃺𢔧𣪶𧣸&M-36604;𧈑𤕭𠈧𠈍𤕱𠈿𢔀𠊩𠭣𠭠𢔃𢔨𣨏𢕛𢾨𧇈𢒫𣪽&M-36637;&M-48533;")
("2725" "㑄㑮伊佭徲解𢓱𧲾𠌬𡖔𡖭𠎿𢓏𢔦")
("2726" "㑼㑾佋佫佲侰俻倨偹儋崌觡詹貂貉𢓜㸛𧣻𢑦𢕍𢕻&M-36596;𦧕𤖕𤖝𧤝")
("2727" "佀倔傜徭𠈆𢔈𠈎")
("2728" "㐸㒜㰫㰾㱆俱俽偩僎僛儗欳歂歑歔佽𠍫𣢊𣢉𣢪𣣕𣣢𣣠&M-45968;𠏤𢕫𠏭𠏩𠐀𣤴𠈴𠈳𤕶𠊸𠊨𣢽𠋶𣣍𣣡&C7-2378;𣤙𣤠&M-48508;𧇻&M-48514;𠑎&M-36952;𢖣𧥊𥤒&M-36651;")
("2729" "你傺躲㑱𢔟𧤆𠈃𠋕&C7-335E;")
("2730" "冬")
("2731" "䰾䱉䳈䶱魢鮑鮠鮸鯢鯭鰹鱦鳦鶃鯴&M-45977;&M-46239;𦫯&M-46547;&M-46601;&M-46612;&M-46005;&M-46111;𡗃&M-46514;&M-48314;")
("2732" "䱡䱶䱻䳉䳿勺烏鄎鄔鄥駌魛魡魣魩鮈鮙鮣鮦鯒鯛鯞鯽鰗鱊鳥鴔鴛鵹鷠鷦鹪𠣵𤉢𩵌𩾒𩾡𨝱𪀊𪀓𩸀䱬鯽&C5-4B65;&M-46143;&M-46136;&M-46864;&M-46155;&M-46292;&M-46353;&M-47102;&M-47087;&M-47180;&M-47170;&M-46475;&M-47425;&M-47505;&M-47522;&M-46639;&M-46744;&M-46736;&M-46684;&M-46086;&M-46228;&M-46265;&M-47038;𡭒&M-47187;&M-47279;&C7-5E2D;")
("2733" "㤩㥎㶻䱗䱚䱮䱲䱼䲆䲜䳧忽急怨怱您惄惣惫懇炰熈魚鯬鯸鰠鱌鱻鴤鵦黧𢤂𢤰𪚰𩺰𪒀𩼈𤆒𢛦𢡈𢢍&M-47079;&C5-7B29;&M-46629;𡖋𤆐𢘵𤈕𤈖𢜷𤌝𤌉𤌈𢢣&M-46140;𢣕𤑊𢤕&M-46515;&M-46527;&M-46587;")
("2734" "䰵䱆䱙䱸魥鮼鯓鯫鰕鱂鱘𩶣&M-46702;&M-46149;&M-45965;&M-45995;&C7-522F;&M-46503;")
("2735" "䲒鯶𤚶&M-46078;")
("2736" "䱟鮉鮥鮶鰡鰼鴼&M-46395;&M-46375;")
("2737" "䱤鰩𩶧")
("2738" "㱍䲌䲚歍鱮𩵢𣤚&M-46483;&C5-7968;&M-46569;&M-46624;&M-46439;𣤿&C7-6333;")
("2739" "鰇鰶𩼇&M-46278;")
("2740" "㛑㝁夊夐妴媻敻身阜夂䴻𠥾𢑓𦔰𦕕&M-38035;𡕕&M-38036;𢻯𡛹𢻁𠭟𡕫𡟮𡕴𦥺𦖥")
("2741" "㕙免毚舤舥舧舰艉艋艬𦨲䑺𩗯&M-30351;&C5-5977;&C5-774A;𠓗𣬚𡤺&C6-2D75;&M-38040;&M-30412;𠄇&M-30465;&M-30451;𦫦𦫬")
("2742" "㔢䎇䑠䑦䑵䑼䠾䢴䣗䳕䳫䴈务勼匆匉匑翱翶翺舠芻郍郛郫鄅鄒鴁鴇鴘鵃鵎鵕鵢鵫鵯鶢鶵鶽鷄鷎鷱鸨鹎匆鄓𠣘𨚕𠣟𦨴𦩍𠢲𠤄𡚖𪃊𪃃𠣌𠡡&M-38041;&M-39421;𠣳&C5-3634;&M-38076;𠤀&C5-5740;&M-39672;𠤊&C5-5F21;𠚲𠣍&M-38037;&M-30359;&C6-3436;&C6-3437;𠡹𠣴&M-30416;𠣸&M-46647;𠣽𦑨𦑳&M-38130;&M-38126;&C7-3C6A;&M-41787;𦒢&M-39746;&M-47155;&M-39751;&M-47301;&M-47506;")
("2743" "㚟奐奥奧獎奬𩵋𤟭&M-30475;&M-30532;&M-30578;&M-30594;𠕹𡘅𡘠𢑣𤟏𤟒")
("2744" "㢡䑡䑥彝彝舟般艘𢌳𡦆&M-30446;𠔾𠂨𢍅𢍄&M-30371;&M-38050;&M-38051;𢍝𣪙𢍢&M-30441;𣪲&C7-5548;&C7-6279;")
("2745" "舽艂&M-38048;&M-38067;")
("2746" "䒁䒄嗠艪𦨣𨊍&M-36072;𦒣&M-38162;")
("2748" "㰿㱀欵欸疑𣢳&M-30563;𣤱𣤡")
("2749" "躱𥻊&M-30562;&M-09958;&M-30506;")
("2750" "争夆搫犂鞶夅𢮃&M-05699;𢪸𣬐𡕖𡕘𧢻𢳉𣬒&M-38411;𢴭𣬔&C7-3658;")
("2751" "㸭𤜇𤙌𤙊𤚄𦫝𤛹")
("2752" "牣物犅犓觕鴩鴾鵝鹅𠣮𤘞𤘽𤙓&C5-3635;𤚱𠣞𤘻&M-38180;𠣥𤙗&C6-3C5E;&M-39469;𤚂&M-46825;𤛴")
("2753" "㸾㹅𡙖𣬎𤙹𤛺")
("2754" "犌𤛧")
("2755" "㸼㹆䳗牳𤛳𤘟𠭘𤙉𡖚𠭮𤛰")
("2756" "𤙑𤛊𤙳")
("2757" "𤚭")
("2758" "㰱犋")
("2760" "㗽㫚㽜䀜䚻各名备曶眢睝督磐詧醬響魯鲁𥆛𥈼𧭐𥍁𥓍𣬕𥖞&C5-6953;𠮥𠯳𣅈𥅉&M-35330;&M-39902;&M-43284;&M-49925;𠤪𥖡")
("2761" "䴞䵶壡皅觇馜𩘅𤫀𦫙𤾫𦤊𦦃&M-47537;&C7-4D2E;𦧻")
("2762" "㔪䀏䎅䎊䎋䣎䳆匌匐匒句够旬甸的皗翻訇邭邰郇郋郜鄱鴝鴰鴲鵅鵠鶅鶛鷭鸲鸹鹄䑚𨝣&M-39349;𠣰𠣱𦠷𦧼&M-48776;𠣚𠣪&M-39427;𠣯𦐛&M-35304;&C6-4567;𣊸&M-49091;𤾦&M-46865;&M-47573;")
("2763" "𤽺")
("2764" "㕡叡&M-47532;𣅞𠭖&M-35476;&M-35482;𤳫")
("2765" "䑙𤾈")
("2766" "舚𤽥𥇠")
("2767" "𪉦")
("2768" "㰧㰬㰶欨𤴙𣢯𣣊𣣧𣤍𣤣")
("2770" "饣")
("2771" "㞦㞾㲋㲌㲧㼝䶕凯包屺岘岨峗巉彘毥毱氇氌色觊颻饥饱齙齟齯齷龃龅龌龟包𡵆亀𡸣𣮋𪓟㽈𡴭𠚱𠤓𡶋𡶄𣬬𣭇𡷕𡹥𤭜𣯜&M-39453;&M-48646;&M-48307;&M-48807;𡴱𠙋𢇀𡴓𡶮𢀹𡷭𣭜𣬋𣬌𡺡𣮓𣮴𣯑&M-48259;𣯥𣯲𦦁龜𡽡𣰞&M-46939;&C7-4577;&C7-525F;&M-48863;&M-48710;")
("2772" "㓜㟃㟘㟠㟹㠈䳭䶤勾匃匄匈匋匎匓卽屻岄岉岛岣峋峒峫島嵨嵺嶋幻邖鄉鄕饧饲饷鴢鴭鵖鷂鹞齣齺罁𠨒𨙵缷𨚔𣍧𠣹𡹔𩿂𪀨𪂓𪗪𪙀𪙑𠚨𠨍𢆳𠣖𠣗𡵙&M-39398;𡷙𡹲𡹬&M-46642;𠣿&C5-527B;&M-47194;&M-48658;&C5-7A5B;𠨐𠣎𡴰𠣔𡵺𣍢&C6-2931;𢏒𧖨&M-39352;𠨞卽𢏔𢏽𢔐𧣓&M-39524;𡻋&M-39575;&M-46677;𡼥𡼼𦑪&M-46725;&C7-3653;&M-46815;&M-46812;𠤉𦒩&C7-5725;&M-47211;&M-49932;&M-48709;&M-48735;&M-48734;&M-48815;")
("2773" "㠗䙚嶑裊裻褩餐饗齦龈𡷞𡹵𡻑&M-34330;&M-34361;&M-49704;𡺝&C6-5040;&C6-643D;&M-34468;&C7-5154;")
("2774" "㞨㲃岷馊齱収𡸨𠬳𡹧𡻁&M-48607;&M-48764;𠬞𣪕𠟳&M-48636;")
("2775" "峄峥峰嶰齳")
("2776" "㟭岹峈峮嵋嵧嶍嶦齠龆&M-48640;&M-48662;𠸿𦥵𦦌&C7-4B41;")
("2777" "㠀䍃䶟峊崛崡嶴臽馅齨𡿖𠂤𡺯&M-41893;&M-41907;𡴲𡵁&M-41535;𦥢𡸞𡸬&C6-4835;𡽈&C7-347B;𦦹&M-48747;𨽵&M-41922;&M-48809;")
("2778" "㟰㠜㰞嶼欪欿歃饮馔𣢜𣣳𣢋𣣸𣢄𣣯𣣨&C7-2B5E;")
("2779" "𡷔&M-48755;")
("2780" "㷗䝨䝳久夤奂欠灸炙烉負𨄚&M-38840;&M-37752;&C5-6472;𠔙&C6-3C49;𡕛𤊘𤉯&M-36733;𣣝&M-45957;𡖷𡖸𤌽&C6-626D;&M-38952;&M-37290;&M-39105;&M-36936;&M-39179;&M-49773;𤓫")
("2781" "䪥𧷎𦫭𪛁")
("2782" "勽灳酇𨜓&M-36873;&C5-5928;&M-47141;𠣦&M-39578;&M-47318;&C7-5E35;&M-39268;")
("2784" "㕢𠭸")
("2786" "𥌄")
("2787" "𤎡")
("2788" "𣢐𦠹𣣓")
("2790" "䊍䲷尔彙枭梟梷槃槳祭禦粲縏条夈棃糳𣔵𥟖𥺤𣘟𣓞𡕝𣗸𠟿𣝆&M-47055;𥽦")
("2791" "䄫䅋䅏䆋䋩䋼䌂䌑䌦秜租糶紀紐組経絕絶絻繩纔臲龝𥝧𥿎𥣞𥾊𥝦𥟽𥡪𥢓𦄓𥾚𥿒𤽰𥿲𥟷𥛁𥠢𦃥")
("2792" "䄦䄧䄪䅳䋄䋒䋚䋞䌪䌵䣋䳳匊秱移稝稠稰穋糿約紉紓絅絇絢絧綁綗綢綯綱網綳緺縃縎縐繆繘繝邾鄛鄡鴸鵴鷍𥾛𥿆𥿫𠞰𥞼𨜿𨝋𥾇𥾏𥾯𥿧𦐨𥟺𥠳&M-39671;𦄋&M-39700;𥣟&M-47150;&M-47369;&M-47399;&C5-7A5A;𥝢𥝼𥝤𠣧𥾞𥾡𥿷𥿸𥠁𥠈&C6-6345;𥡚𦂷𦂴𦃁𥢀𦃛&M-46787;&M-39706;&M-46840;𦅉𦆗𦆢&C7-5244;&M-47272;&M-47294;𦇾&M-47494;&C7-656D;")
("2793" "䆈䋟稧稳終綠緣緫緱縁縋縫緑𦁕𥤚𥠅𦃕&C5-6450;𦇗𥾠𥠡𦂐𦃐𥣦𦆣𦇶")
("2794" "䅓䋋叔秄稺級綅綴緅緞縀𥝔𥾤𠭥𦅀𥝥𥾌𥿦𥟒𦃘𥝐𥝻𣪖𥿑𥿱𥻫𦃌𦃈𦃏𣫩")
("2795" "穉絳綘緷繲释𥾢𥞜𦇙")
("2796" "䅂䅕䋧䌌穭紹絡緡𥠷𦅼𥿨𦂑𦃓𥉆𣡳")
("2797" "䋓䌊紀𦁐𥿓𦁴")
("2798" "㱁䅆䊻穥絘繏𣢰𥿇䆅𥣙𥣖𦆦𦇛𥤎𦆃𦆜𥤌𦇣𦇳")
("2799" "䋴称穄縔縩𥞛𦀉𥠊𦂋𦄜𥢽𥿰𦂞𦃨&C7-5C48;")
("2800" "乆𠔂")
("2802" "牏𤖭")
("2803" "𤗉")
("2806" "临")
("2810" "监盭纵鋚以𥁮𦥋&M-40753;𥃊𡓼")
("2811" "纥纶缆缢&M-48853;")
("2812" "纷绨𦑸𦐻&M-47998;")
("2813" "绘缣鲶&C5-7550;&M-33095;&M-49692;")
("2814" "敳缴鳆鳟𢻹𤯛𢽠𢼇𢽗𣦇𡐱𣦝𧗐")
("2815" "鲜")
("2816" "给缯蛿𧖼")
("2820" "㐺䖋仈似𢓅𣦸𠈽")
("2821" "㐹㑅㑶㠩㡮㣞仡伦伧作佺侳侻俭傞儖览貖魀魐𠊧&M-36519;𡖽𧇓&C5-532A;𧇞&M-45831;𧤟𧥈𠈨𢓓&C6-2E61;𤕴𧆫𡲡𠹨𤖌𧣥&M-45793;𤖚𧇐𧤄𡢔&M-39623;&C7-4B49;&M-34971;&M-45049;")
("2822" "㒆㣢䚫仱价份俢倫偸傟傷彾脩觞觴貐佾偷偂𠆵𢔢𠐉𧣵&M-48532;𡿬𠃰𢔜𢔍&M-36558;&C7-2A58;𧇾&M-36641;")
("2823" "㒇㣠䖺䚗伀侩倊倯倹傔儵彸虪飧飨鯈伶𢔋𠈪𠋡𠌡𠍵𠔨&C5-787C;𤕵𤕼&C6-643F;𥢁𠐣&M-33721;&M-48112;")
("2824" "㒈㣲㪇䱷仵併倣做傚傲僌僘儆儌幑復微徴徵徶徹徼徽徾攸敒敫敿鰴黴僔𠈅𠊷𢽋㪜𢕭𠐍𠈹𠍯𢾋&M-36553;𤚓𢖄𢿳𠐵𧈓𢻺𠈼𢼮𣁋𠊮𠊹𢽆𢽘𢽈𢕈𢕟𢕧𢕰𢕹𢿬𢖉𧤡&M-48513;𢖜𢖢")
("2825" "佯侮儀儛徉牂觧觯觲鞗侮𦍹𦍲𣨦")
("2826" "㣛㫦䶎䶐佮俗倃偤偺傖僧儈徻牄僧僐𠍹𧳫𠌪𧤕𠐼&M-36646;𠈻𢓾&M-36554;")
("2827" "佡")
("2828" "傱僋儉従從倐𢔩&C5-6A3F;&M-41636;𢕇𢕐&M-37551;")
("2829" "伱俆徐條絛&M-00472;")
("2830" "魜")
("2831" "䰴䱹鮓鮵鱃䰿&M-46282;&C5-6B38;&M-46983;&M-45992;&C7-4C51;&M-46455;")
("2832" "䰼䱵䲙䳷魪魵鮷鯩鸄&M-46273;&M-46996;&M-46692;&M-46953;&M-46206;&M-45035;&C7-5D7E;")
("2833" "㤰㦘䰸悠慫懲煞魿鯰鰜懲鱶𢞣𩸂𢛮&M-46056;&M-46349;&M-46477;𢚐𢢡𢢱𤏺&M-46248;&M-46556;")
("2834" "䰻䱔䲄䲎鮩鰒鱒鷻𩵹&M-46026;&M-46328;&M-46321;&M-46522;&M-46546;&C5-7B2A;&M-48129;&M-46609;")
("2835" "䱕䲑鮮鱵鸃&M-47454;&M-46616;&C7-647D;")
("2836" "䱽䲕鮯鯦鰌鱔鱠&M-46513;")
("2838" "䲂䲓&M-47241;")
("2839" "鮽鰷鵌")
("2840" "㛜聳处𦨈𦗷&C7-6058;")
("2841" "䑨舱舴艖艗艞艦𦨏&M-38093;&M-30530;&M-38160;𦣸")
("2842" "䑤䑯䑳䠼𦩞𦪙勶")
("2843" "䠲䠶舩舲艌𥎻𦨶&M-33353;&C5-573F;𤢝")
("2844" "䑫䑻𦩟䒆𣀐&M-30540;&C5-6376;&M-30553;&M-38054;𢿐&M-30570;𢍸")
("2845" "䒀䒉艤&M-30561;")
("2846" "䑪船艏艙谸谿&C5-502A;&M-38072;")
("2848" "&M-38142;")
("2849" "艅")
("2850" "㹐䩦𢵿𤙘𢶗")
("2851" "㸲牷㸱犔")
("2852" "㸮㹋𤘡𤘦𤚎𤛣𤛛")
("2853" "㸳")
("2854" "牧犜犪𤚖")
("2855" "䍧犧")
("2856" "𤙱𤚬𤛢")
("2859" "𤙛")
("2860" "䀺咎昝譥𥌟&M-36034;")
("2861" "鹺鹾𪊇𣱡𤽍𦧓&M-47543;&M-44560;")
("2862" "皊馚鹶𦧈𩠻𤽉&C5-6A6C;&C7-5247;")
("2863" "馦鹷鹻𤽿")
("2864" "㪫敀敂敋敌皏皦馥𢼉𪉿𢽡𢾷&C7-564A;&M-49953;")
("2866" "䭫馠𤾥𤾙&M-44505;")
("2867" "𤽦")
("2868" "鹼")
("2870" "&M-48586;")
("2871" "㟇㟋㼻亾兦屹岞崯嵯毺氆饩馐齕齚齸𡹳𣯨𪙉𣬫𣬿𣭝𡏩𣮹𡻘𣰎𠆦𡶊𡺬𣮩𣯾&M-48606;&M-48296;&M-48311;")
("2872" "䶖岎岒崘崳嶖饬饰齘𡵚𡺱&M-48604;")
("2873" "㟱岭嵄嵫嵰齡龄𪙊𡼓&C5-5979;𠤑&C7-5157;")
("2874" "㞰㠂嶟巙收缾饼馓𡵛𢽶&M-48656;𡹮𢆟&M-48810;")
("2875" "㟄嶬𡾮𡾞&M-48789;")
("2876" "㟏峆峪崷嵢嶒𡻵𪙎𡻡𡼾&M-48657;&M-48675;𡹒&M-48778;")
("2877" "&M-48683;")
("2878" "䶨嵷嶮")
("2879" "馀𡼺𡷣")
("2880" "㷏焂熧跾&M-38734;&M-39063;𤒮")
("2883" "&C7-4222;")
("2884" "𢿓")
("2890" "𥾺𦅾𥜄𣒼𣜥")
("2891" "䅬䋏䋮䌫秨稅税紇絁絟綐縊縒繿纜𥝖𥝬𡰇𦄙𥤟𡖗𥞀𥾨𥞙𥿪𦂛𦆧𦇲")
("2892" "秎稊稐紒紛紟紾綈綸緰𥣮𦇬𥾓𦂒𥠿𥿐𦂚𦆤𥤇")
("2893" "䅵䌗秢稔稴稵穟紷総縂縌縑繸繺𦁤𦂁𥝨&M-33225;𥣓𦅆𥾪𥠂𦁌𦂵&C7-2669;")
("2894" "敹稪絣緮緻繖繜繳𥞩𦅄𦇁𥠽𥢭𥢎𥢹𦥐𥝺𥿬𢿔𦇕")
("2895" "䋦絴𦇫𦆞")
("2896" "䅮給綌綹緧繒繕繪𥢶𦁃𦅊𦇃")
("2897" "䌣")
("2898" "䌞緃縦縱縼𦆀𥡬𦀢𦄚")
("2899" "䋡稌縧𥿜")
("2905" "牉𤗷")
("2910" "鍫")
("2911" "皝继绻𪐂")
("2912" "纱绡绱缈&M-33943;")
("2913" "蝵")
("2914" "缕")
("2915" "绊衅鳞")
("2918" "鳅")
("2920" "仦")
("2921" "㑽㒌䨂侊倦傥觥魈𩴠𢔑&C5-4B5D;&M-34907;&M-45928;𠌻𠎽&M-45827;𧈒")
("2922" "㡑仯倘僗儯徜軂俏𠈱𢓮觘𧣪𨾻𧈜𡭥𢆽𠉮𠋝&C5-4A23;&M-45041;")
("2923" "偿僽儻湬𠈖")
("2924" "㑞偻𠊶𠑄")
("2925" "伴僯")
("2926" "偗儅𤳿")
("2928" "伙倓偢償𧣹𤎥")
("2929" "侎㒉儝")
("2930" "𩵖")
("2931" "䱧𠒸")
("2932" "䲏魦鮹鯋鶖𩷼&C5-6678;&M-47133;")
("2933" "愁&M-46628;&C7-5A54;")
("2935" "鱗&M-46573;")
("2936" "鱨&M-46543;")
("2937" "&M-46557;")
("2938" "鰍𩵰𩸥&M-46150;&C5-724F;")
("2939" "䱊")
("2940" "媝&M-38039;𡡏")
("2941" "&C5-5029;&M-30568;")
("2942" "艄躺&C5-2F75;&C5-357A;𡮿&M-47336;𠢧&C7-274B;&M-30586;")
("2943" "䲍𥸸&M-30533;&M-33643;&M-33852;")
("2944" "&M-30460;&C7-274C;")
("2946" "䒅艡𤳔𤳮&M-49575;")
("2948" "&C7-4A4B;&M-49576;")
("2949" "𦪝𣚗")
("2950" "揫")
("2951" "犈𤛋")
("2952" "𤙜&M-45845;")
("2953" "㹖")
("2956" "㹙㹚")
("2960" "醔")
("2962" "䭱䴛&C7-3574;")
("2963" "㿩")
("2968" "舕&M-47548;")
("2969" "&M-44532;")
("2971" "䵸毩毯甃𡸩𣭱𣯢")
("2972" "峭嶗𢆷")
("2974" "嵝𣬗")
("2975" "嶙𡺹𡽤")
("2976" "巆𡽊")
("2978" "燄𡵼")
("2979" "嶸")
("2980" "&M-39058;&M-49770;")
("2988" "𤎢")
("2990" "𦂎")
("2991" "䅚絖継綣𦂙𣜨")
("2992" "秒稍紗綃緲𦀛𥟎𠢺𦄏𣟽𥞻𥢒")
("2993" "𥤗𥤅")
("2994" "𥣾")
("2995" "秚絆繗")
("2996" "𥢷")
("2998" "䆏䋺秋緂")
("2999" "䋛𦅌")
("3000" "丶")
("3001" "𥤶")
("3010" "㝞㝧㿾䀄䆙䆝䆸䆹䆾䥌塞宔宜宝宣室寍寷氵空窐窒鎏䀂瑬宐宐𥤧𥥊𥥐𡨾𥥷𥥻𡫷𡧩𡨠𥦐𥦊𥦨𡪺𥧘𥧚𥧬𥩔𡨈𡨆𧯜𥥣𡩉𡩬𡩦𡪖𡩿𡪏𡪂𧯳𡫓𡫼𡔂")
("3011" "㳘准宨汒沆泣注流涖淮渷湸滝滩滰滻漉潍潼澭澶濉濰瀍瀛灉灕灖灗灘窕窪竀𣶂𤅣𣼠𥧕&C5-4A7C;𤄖𤄛𥩌𡧪𣳥𣴹𣶑𥦠𣻰&C7-3B67;&C7-3D39;𥨮&C7-4E28;")
("3012" "㵝汸济淯済渟渧湇滂滈滳滴滽漓濟窷骞湾𥧲𠗵𥦅𡩥𡪅𣹿𡩻𣿱𣿕𡫞")
("3013" "㳖㵂䗕䗙汴泫洂湙滖滚滾漮潐澺濂濓濠瀌瀤瀼灋蜜𡨃𧕝𥥽𥦛𣿞𠘘&M-33804;&M-32905;𥥢&M-32938;𣼟𤁷&M-33723;&M-33717;&M-33715;&M-49697;&M-33805;𤅑𤅭𡬛")
("3014" "㴑㴒寖寝汶洨液淬淳渡漳澼窏淁𥨿𠗚𤀫𣳝𣴔𣹾𥧖𥨓𤂸")
("3015" "窢𣹫𥨳")
("3016" "涪湆湻溏滀𠗶𣾪𠗥𣷧𣽢")
("3017" "𥥨𡩧")
("3018" "䆱瀇𤎟")
("3019" "凉凜涼潗澟凛滦㳿𠗛𣻕𣽘𣾩𡫚𤀮𠘡𡫻𤃱𤃰")
("3020" "㝖䆑宁宆寕寜寥寧弿穸穹𡨴𥤣𥧯𡨨寧𡪎")
("3021" "㝟㝫㦾䄠䆓䙰凢宂完宛宱宺宼宽寇寛寬寵戹扈扉窄窿竉褅襢雇裗𢨪𡧭𥘭𧙀䘪窛𡫯𥨪𥤤𡧬𥤸𢩈𥥠𡩇𢩒𥦥𡩽𢩘𥛞&C5-6948;𢩢𥨻𡦹𢨤𢨩𡧜𢨴𢨸𢨷𢨹𡨓𡨥𥦀𥦲𥧊&C6-6234;&C7-3533;𡬃&C7-5972;")
("3022" "㝏㝑㝢㝦㝯㝰㝱㝲䄜䄢䆚䆷䘻䙗宥宵寈寎寡寪寯帍帘房扁扃扇甯祊禘禞窉窝窩窬窮肩褯鳸褵扅𡧂𡨅𥥏𧘟𥧮𧞓𡬙𢨺𥦁𥦢𥥾𢄏𦞫𥛚𥧱𥨡𥨲𡧋𡧘𢨲𢩁𥤽&C6-342C;&C6-342D;&C6-342E;𥥒𡨦𥥩𡩅𥦂𥦜&C6-5F75;𥦻𥦹𡫛𢐭𥨷")
("3023" "㝌㝩㥷㧁㲾䆣䆥䆲䆽䙑䙛宖家宸寙戾扆永礻禳窊窳衤袨戻𥥈𥥑𥧰𧝘&M-34245;𢩠&M-34551;&M-34627;𡬄&M-34760;𢨾𥤼𢩆𡩙𡩀&M-34333;𢞝𥛲&M-34587;&M-34693;&M-34695;𡬊𢥜&C7-592E;")
("3024" "㧀䘨䘸䘹寑寢戽祽穿竅𪓌𡫽𢩄𢩑𢩓&M-34365;𡫀𥨍&C5-5E3B;𡬓𢨦𢩇𥦵𡪢𥨊𡫒&C7-3B5E;𥨶")
("3025" "宬肁裤褲窚𥧻𥥤&M-34461;")
("3026" "㝛㧂䙒噟宿寣寤扂禟启𡩩𡪁𡬌𥦇𡪗窹𡫔𡧻𢩅𡩤&M-34607;𡬑")
("3027" "戶户戸窟𢩕𢩖")
("3028" "扊賔𡬖𥩒𡪶")
("3029" "㝥㦿䋀寐寱窱襍𡩢䆿𡬍𥦃𥧽𡬇𡪘&M-34352;𡪼𡬒")
("3030" "㝎䆳䆼䢍䢒䢦之寒窆迒迬這進逳遃遆遧適遮避邅这迹辶𨑑𥥋&C5-3056;&C5-3628;&C5-3629;&C5-4A54;&C5-516B;&C5-587C;&C5-5F31;&C5-6539;&C6-3C4D;&C6-3C4E;&C6-4551;&C7-2968;&C7-2970;&C7-3439;&C7-4376;&C7-5058;")
("3032" "寫窵騫鶱𥧓&C5-6F31;")
("3033" "㥶䆫䆶䵫宓寭悹惌愙憲窓窯窸窻𢞩𤌊𥧟𥧛𥨭𡧫𡨁𢛬𥦾𡪾憲𥧳𢤑𢤊𢥛")
("3034" "守𡬮𡨎𥩎")
("3035" "䇁")
("3037" "宀")
("3040" "㕠㝊㝍㝔㝕䆤凖叜字宇安宯宰宴寠準穻窔窙窣窭窶𥤨𥤹䆧𥦸𥤿𡨊𥥶䆯𥧭𥨎𡧌𥤪𡥜𡨞𥥞𡨧𡩠𥧜𡕹")
("3041" "㝪宄宠寃究寃𡨻𡩄𡪽𡦿𥤷𡪐&C6-636C;𥨖&C7-3D3A;𥨬𥨼")
("3042" "㝣䆜寓穷𥧗𡧚𥦧𡫭𥨵")
("3043" "䆖宊宎宏实寏寞穾突窫𥤮䆨𥥍𥦏𥦺𡫃𡫟𡨜𡨏䆩𡪿𡫩")
("3044" "㝤䆻窡𥤴𥦌𥦍𥧒𠂂𥤰𥥛𡨤𥦡𡪃𡫳𡫾")
("3046" "竆𥧺")
("3048" "寲窽𡫬𥨴𥩁")
("3050" "䆔䆘搴牢窂窜鞌𥤺𥥥𡨔𢮘𥦑𡪤𢳔")
("3051" "䆒窺")
("3052" "𡧴")
("3053" "䆕䆢実𥥌")
("3054" "䆭䇀𥦆𡨣")
("3055" "寗穽𥥼𥨗")
("3059" "𥦤𥧷𥨘")
("3060" "㝒㝓㝘㝜䁇䆟䆵䆺宕宙客宫宭宮害容富審窅窖窗窘窨謇𡨂𥥉𡨢𥈽𥧥𡨟𥥔𡨩𡨽𡪠𥧠𠿡𡧱𠹟𡩨𡫆&M-39980;&M-49874;")
("3061" "䆛𥒳")
("3062" "䆗寄𥥎𡫱𡫰")
("3066" "𡬚")
("3070" "讠")
("3071" "䆞䆠䆰它宅宒宦宧寋穵窀窇竁竄竈谁窤𥤩𡧮𡪣𡧗𥤻𥥗𥥧𡩾𥩊𡦽𡧏𥤫𥤭𡨉𡨇𥦪𥦩𡪥𡪆𥨔&C7-4626;𥨫𥩋")
("3072" "窃窈窌访谚谛谤谪𡧍𡧙𡧈&M-07069;𡧎𥤵𡩭")
("3073" "㝐㝗䆡寰良褰谯")
("3074" "谆谇𥦞𥦄𥦦&M-38650;")
("3076" "谙")
("3077" "官宻密寚崈窋窑窞窰𥧹𡧰𡧺𥥺𥥹𡺶")
("3079" "谅")
("3080" "㝙㝠䆦䆬䞿宍定宾寁寅寊寔寘實寳寶灾穴窴竇賓賨賽赛蹇寳𡨄𥥦𡩂𧶎𧶡𡦼𥥡𡨿𥥿𥦟𡧢𤇵𡨼𡨶𥦎𡩟&M-36741;𡪓𥦽𥧅&M-36790;&C6-6267;𡫜𡪴𤍘𡫅𡫮𤑖&M-49741;𥩐")
("3081" "䨈")
("3082" "𥨐")
("3084" "𡫄")
("3086" "𥧸")
("3088" "𡬅")
("3090" "䅁宋宗宲宷寀察寨寮案窠窼穼梥竂𡧯𡨀𡩡𣘿𡧖𥥇𥥸𡩣𥨑𥩀𡦾𣑄𥥓𡩁𡩈𥦈𡩪𡪔𡩼𥦼")
("3091" "㝭𡫁寴𡩃𥧔𡫝𥨕𥨰")
("3092" "竊𡫂𥧼𥦋𥨱𥩓")
("3093" "𥨽𥧴")
("3094" "㝮寂窲𥧇𥧞𥨢𥩂𥨒")
("3096" "𥦿𥧝𥧶𡩺𡪟𡬆")
("3098" "窾𡪡")
("3099" "㝝𥦝𥧙𥧵")
("3102" "𢗈")
("3110" "泸盓𣵹𡊺𥁡𡒖𥂳")
("3111" "㲺㳧㳹㵡㶁冱凐江汪沅沍沘沚沤泚泟洍洭洰洷洹浢涇涯淲渄渱湮湹溉溼滙漑漚潖澁瀖瀘瀝瀧灑㴰𣳊𠗊𣵾𣻐𧇦𤄽𤅷𣲳𣴥𣶖𠘌𠘟𤁦𣲁𣳋𣴑𣷻𣵨&C6-4A63;𣶕𣻝𤀶𤂢𤂆𤃁")
("3112" "㓅㴐㶚汀汅汚污沔沞沥河洏洐涉渉溤溮滆滒漘漹濔濡濿瀰灊灞馮𤁰𣸝&M-44856;𤅦𤆀𣲠𣴯𠗦𣶢𣶇𣻚𣽐𣽄𣽈𣾅𣽣&M-44770;𤂥𤅤")
("3113" "沄浱涱涿渋渜滤漲澐澞澪澽濏濾𣲑𤅒𣽗𣽏𤄦&C7-5F4A;𤅫")
("3114" "㳥冴汗汙汧汳泙洱浭涆淖渳溽滠滹潊潭瀀灄汧㴗𣳶𣲏𢽦𣸇𤁡𤄑𣳙𣵼𣶿𣸒𣼻𣽠𣿋")
("3115" "洅湃濊𤃸𠖱𣲐")
("3116" "㓈㳪㵢沰沾洒洦浯湎湝湢溍滣滷潛澑濬灀酒𤀹𣴨㴯𣽊𠗍𣷶𣿉𤁳𤃩𣶓𣶊𦥉𤃹𤄐")
("3117" "涵𪘏𤁧")
("3118" "㳁㴿㵐浈湏湞漇澒澦濒瀕瀩瀬灏灝灦頫𣲓𣶵𣹟𣻔𤁾𤁪𣽥𣿤𤀪&M-43556;𤁫𤅎𤅡𣴸&C6-544F;𤃣𤄹𤅆")
("3119" "㳅沶源溧漂潥凓𣼝𠘍𣿚")
("3121" "䃾䄈䄥䘣䘭凴甂祉祬禋裋裭裶褗褦褼襱襹𧛑𥛜䙔𥜦&M-34099;𡨍&M-34134;&M-34201;&M-34616;𥜰&C5-7B7E;𥘍𥙤&M-34318;&M-34433;𥛡𥛳&M-34657;𥜠&M-34721;𥜬")
("3122" "䙐禡禰禲袔袻裲褃褙襧騗襦&M-34102;𥘫&M-34494;&M-34685;𥘕&C6-4D52;𢄘𥜸")
("3123" "㵗䙇䙥祳裖&M-34276;𥜒&M-34631;&M-34687;𥙮𥜅&M-34748;")
("3124" "䢇禫衦衧褥襵䙅𧝓𢼐&M-34163;&M-34269;&M-34291;𥜚&M-34143;&M-34228;&M-34267;𢾥&M-34424;")
("3126" "祏福袥袩袹褔&M-34584;𥙫&C7-2627;𥛽𥜧")
("3128" "䙠祯禎禵禷褷襭顅顧𧚺&M-43361;&M-43724;&M-43643;&M-43672;")
("3129" "祘褾")
("3130" "䢋䢎䢚䢝䢥䢮迀迂迃迈迊迋迓返远迠迺逌逎逐逕逗逛逜逦逴逼遉遯遷遽邇邐还运𨒌𨔛𨔰𨗒𨙔&C5-276E;&C5-3059;&C5-305A;&C5-3626;&C5-362B;&C5-3C75;&C5-5877;&C5-6E29;&C5-7452;&C6-2E3A;&C6-2E3B;&C6-3464;&C6-3C50;&C6-3C54;&C6-4554;&C6-4556;&C6-455D;&C6-4F4D;&C6-5934;&C6-5939;&M-49768;&C6-593D;&C6-6334;&C7-296A;&C7-296E;&C7-343D;&C7-343E;&C7-343F;&C7-3441;&C7-3C59;&C7-4378;&C7-437C;&C7-5059;&C7-505A;&C7-554E;&C7-6155;&C7-626B;")
("3132" "𪁘")
("3133" "惉慿憑𢙁𣶾")
("3138" "𩔦&C5-6A5B;")
("3140" "𡜂𡝝𡝫𡜡")
("3141" "𡪸𣁿")
("3144" "𢾐")
("3146" "𡩛")
("3148" "頞頩&M-43528;")
("3150" "𦘟")
("3160" "&M-36167;")
("3161" "㼸")
("3162" "&M-44880;")
("3164" "𢾒𢾮𢾏")
("3168" "額额&M-43711;&M-43620;")
("3171" "㼠讧让讴讵证诓诬诳诽谑𤭒")
("3172" "订诃")
("3173" "诼")
("3174" "讦讶评谭")
("3176" "语谮")
("3178" "&M-43427;")
("3188" "䫤顁顮")
("3190" "渠")
("3198" "䫅&C7-5A30;")
("3200" "州")
("3207" "𢗮")
("3210" "㴊㶜业丬冽垽壍汌洌洲测浏浰涮淛淵渆渊測瀏鋈𠛪𣸛𣸠𠗗𠗜𠗢𠗧𣶄𥁩𣸟𣹨𥁷𥁼𣿖𤂄𤁴𤄉")
("3211" "㳋㳐㳝㳶㴩㴲㴳兆凒凗汑洮淫湚湩溰滮漄漞漼潂澄濎涶𣳫𤃶𠗝𣵱𣹵𤁯𣲞𣳴𣶟𣹉𤀆𤁺")
("3212" "㳨凘沂沜浙浵涁涔淅渐渪湍溈漰漸潙澌澎澵灣𣲀𣹊𣴖𠘋𤂊𣲸𣶁")
("3213" "㓇㴽㶏冰沃沠泒泓泛派涨添渁湀溪滍潻濦濮𣳛𣳯派&M-42587;𣺍𣹭𣽵𣿜")
("3214" "㳇㳵叢汘汦泘泜泝浖浮浽涎涏涭湲潑灂灇鼗鼝将涹𤂅𣳭𤀣𠘣𣸍𣸖𤀾𤃊𤃙𤄪")
("3215" "㴁凈淨瀞")
("3216" "㓉㴞㵌洉活涽涾淄湉湽潘𣸅𣽰𤀦𣵞𣴠𣽅𣾨𣽪𣿛𤄜")
("3217" "㴈㴙㶌㻡汕汹泏滔𣽮")
("3218" "浜湠𠘖𤁩")
("3219" "泺溗漅漴澲濼灤𣲲𣻬𣸔𤄏𣹌𤀇𤅇")
("3220" "㓲裫剜&M-34284;𠜺&M-34262;&M-34381;&M-34654;")
("3221" "㲢㲰㼐䙞䙣礼祧禠衽袵褈褫魙𧘐𧞪𣭺𥛟&C5-7749;𥙂𥙲&M-34511;&M-34659;")
("3222" "䄔䙖祈衫褍黹𧝉&M-34156;&C5-727C;&C5-782E;𢄁&M-34332;&M-34397;&C7-332E;𥛻&M-34681;")
("3223" "䙆䙎䙧氷祅祆袄襆襥𥙎&M-34230;&M-34208;&C6-3C29;&M-34666;")
("3224" "䘰祇祗禐衹袛褑襏𧛝&M-34115;&M-34378;&C7-3330;&C7-6372;")
("3225" "禨")
("3226" "䄆䄑䄕䙉襎𥛮𥚉𥙱&M-34326;")
("3227" "䙄袦𥙋𥛃")
("3229" "𧚃&M-47908;")
("3230" "䢑䢪䢬巡巡辿近迗迾适逃逅透逝逶遁遄遜遞邋邎迁逓𨒰𨓈𨔢𨖾𨙂&C5-2478;&C5-2B57;&C5-305C;&C5-3627;&C5-3C76;&C5-3C77;&C5-3C78;&C5-4A56;&C5-5163;&C5-5167;&C5-516C;&C5-5878;&C5-5F32;&C5-5F36;&M-38560;&C5-7150;&C5-783D;&C6-2E3C;&C6-3C56;&C6-3C58;&C6-4557;&C6-455A;&C6-4F50;&C6-4F51;&C6-4F53;&C6-4F55;&C6-4F56;&C6-593B;&C6-593E;&C6-5940;&C6-5941;&C6-5943;&C6-633C;&C7-2971;&C7-2973;&C7-2975;&C7-3442;&C7-344A;&C7-344B;&C7-3C5D;&C7-437E;&C7-5551;")
("3232" "&M-46936;")
("3234" "𡭎")
("3240" "丵嬱学聻𠝠𡞠")
("3241" "𣁶𣮯𣯌")
("3243" "奨")
("3251" "㲫")
("3260" "䤔割𠲻𠻡&M-42697;𠝒割")
("3261" "𤕋")
("3262" "彮")
("3270" "剆训𠞀剆")
("3272" "诱𣂞")
("3273" "&C5-6036;&M-34331;&C7-5D54;")
("3274" "诉诋诞诿谖")
("3276" "话诟诣谐")
("3277" "凿峾讪诎谣&M-48693;")
("3280" "氼")
("3281" "𣰨")
("3290" "業楽𠟪𣜅")
("3291" "𠄅𣯸")
("3300" "心必灬𢖩")
("3308" "&M-36938;")
("3310" "㙙沁泌𠖶𠧞𥁑𣱶&M-40141;𥂈𧗉")
("3311" "㳴㴉㴏㴵㵃㵥沇沋沱浝浣涳涴渲滬滱漥𣹧㴳𣲽𣲼𣵻𣸓𡪀")
("3312" "㴜㵳泞浦浳渗滲濘瀉㳙𣴩𣶆𠗿𤃼𤅳𣹷𣺴𣼡𤀨𤁭")
("3313" "㴃㴱㵕汱沭泳洑浗浤浪涋涘涙淚淧湥溛漒瀗状𣸋𠗈𣶍𣸘𤅊𣳵𣽬𣾫&M-33313;𤀋")
("3314" "㳎冹沷泼洝浚溥滓漃濅洴𣶉𣹦𤀑𣽡𣿈𣿟𣸈𣽧𣽦𤄘𤅪")
("3315" "㓕㳀㳚㳦㵄㵴㵶减泧洠浶涐淢淺渖減渽溅溨滅澸濈濺瀐瀸瀻浅𣻟𣿐𤄔𠗼𣺁𣽚𤁢𤃪𢦬𣴮𣴤𣶔𠗱𣸂𣽖𤂴")
("3316" "㴦㴭㴼冶治溶瀋")
("3317" "㵠涫滵沪")
("3318" "㵓泬淀滨演濱濵瀽𤅋")
("3319" "浨淙淭")
("3320" "祕补袐褂")
("3321" "䘼袉袕&M-34289;&M-34368;&M-34628;")
("3322" "䘢補襂黼褊𥜴&M-34749;𥙷")
("3323" "袱襁𧛗𧞰&M-34300;&M-34393;𤡵&M-34722;")
("3324" "䘝䙏祓袚黻&M-34311;&M-34160;&M-34248;&M-34561;")
("3325" "䄀䄉䘬䙁䙘祴裓襳襶𧛡𧚄&M-34589;&M-34684;&M-34699;𢧊&M-34243;&M-34329;&M-34403;&M-34451;&M-34706;")
("3326" "褣𢩙𧜅𥙉&M-34466;")
("3327" "䘾𢩝")
("3328" "䘺䙭䙯袕")
("3329" "䘤&M-34663;")
("3330" "䢓䢕䢤迖迨迯述迱逋逑逘逡逬逭遍遪邃𨒋𨖋𨖐&C5-276D;&C5-4A53;&C5-5F30;&C6-345F;&C6-5932;&C6-6332;&C6-6335;&C7-343A;&C7-3443;")
("3333" "惢")
("3340" "㜑𢖻𡟖")
("3344" "幷")
("3350" "肈")
("3360" "䁉吢啔")
("3366" "𢙈")
("3370" "讣")
("3371" "诧谊谧𢗺")
("3372" "谝")
("3373" "&C5-7B25;")
("3374" "试")
("3375" "诚诫谶")
("3376" "诒")
("3377" "𡶇")
("3378" "诶谳")
("3380" "&M-36982;")
("3385" "戭")
("3390" "䋯梁橤粱繠𣙤𣚘𥞹𦁞")
("3400" "斗")
("3402" "为")
("3403" "头")
("3410" "㓔㲼㳆㴬㴻㵱䀅對汁泭湗澍濧錃鍌鍙𥁇𣻠𤀢𥁭𧖶")
("3411" "㓐㳗㳳㳸㴶㴷㵁冼壮氿池沈沎泄洗洼流淔淕淹淽渣港湛溎溘滢滼漌漜潱澆濭灆灌灩港𣷾𣿅𠗌𣴣𣸚𤁮𤃫&M-04899;𣴧𣴭𣷝𣹆𣸆&M-18214;𣿑𤁉&C7-5F7C;𤅿")
("3412" "㓓㳍㵧氻汭沩泐泑洘洧洿浠涝淆淓渤渮湳満满滯滿漪潇潸澫濗瀟瀳灡灪𣶐𤁸𣲒𣷿𣹩𤃽𣺏𣼛𣽽𤁟𣿴𤂣&C7-4879;𤅠𤅢")
("3413" "㳒㳤㴀㵦㵭㵹汏汯汰法浓浹浾涟渶溒漆漠漢漺澾濍濛瀡𠗉𠗾𣻡𣽕𣽫𤁬𣲔𣵽&M-18021;𣾣𣽑𣿔𤀱𤂡𤄝")
("3414" "㓑㳃㵏凌汝汥泋波洊洔浡涍涛涬淩渀溡漭濤濩妆漤𣻞𣳰𣻿𣿝𤁊𤂹𣴰𣶃𣷟𣽇𤃕𤃂𤂇𤅨")
("3415" "㴖㵮㶓湋澕瀎𣸉𤃴𣿢𤂁𣴱𣿎𤂾")
("3416" "㳻㵔㵙㶆沽洁浩渃渚渵澔澘濇濳瀒瀦潴浩溚𣹡𣽋𣶥𣿏")
("3417" "泔𣲟𣳘")
("3418" "㓋㶇凟洃洪淇渎滇潢濆濋瀆灒𣽒𤂲𤄓𣵩𣿳&C7-2F42;𤄴")
("3419" "㳈㳜㵩冻凚沐淋淶渫渿溹潆潦潹澿濝湈㴕𠗨𣸃𠘆𤁱𣸡𣸑𤄶𤅅")
("3420" "祔衬袝&M-34120;&M-34483;&M-34623;&M-34159;")
("3421" "䄁䄋䙮社祂禃禥衪衴袏袿裗裺襓袣𧛾𥚊𥙭𥚧&M-49708;&M-34676;")
("3422" "䄎䘜䙃䙦衲袎袴裿襺襽𧝍&M-34231;𥛂&M-34465;&M-34624;𥜲𥚨&M-34639;𥜣&C7-547D;")
("3423" "䄏䙩祛袪裌裢褤襫襼&M-34529;&M-34710;&C7-6564;")
("3424" "䃽䘠祷祾禱衼被袸裬&M-34302;𢻠𢻄")
("3425" "禕褘襪襻&M-34508;")
("3426" "䄍祐祜祮祰禇禧袺褚褡𥜑𢩍𡪄𥛼")
("3428" "祺禛禶褀襩襸𧝒&M-34625;&M-34746;")
("3429" "禖襟褋&M-34482;𥛰&M-34638;")
("3430" "䢞䢡䢫䢱迆迏连迣迶迼造逨逩逪逵逽遀達違遠遰遳遶遼邁边达过选逺𨑬逇𨓳&C5-276B;&C5-276C;&C5-2B50;&C5-362C;&C5-3C74;&C5-4359;&C5-5876;&C5-587D;&C5-5F33;&C5-5F34;&C5-653B;&C5-653C;&C5-653D;&C6-2559;&C6-292D;&C6-292E;&C6-2E3D;&C6-3463;&C6-3C4F;&C6-3C51;&C6-3C52;&C6-3C55;&C6-4F4A;&C6-4F4B;&C6-4F4C;&C6-592E;&C6-5933;&C6-5935;&C6-5936;&C6-6338;&M-39061;&C6-633A;&C7-296D;&C7-437D;&C7-4A78;&C7-4A7A;&C7-4A7D;&C7-595A;&C7-595B;&C7-5D24;&C7-5D25;&C7-5F6A;")
("3433" "懘懟懣")
("3440" "婆𡣩")
("3442" "𠡓")
("3443" "𤂀")
("3450" "㨇")
("3454" "皲皸")
("3460" "碆𠴸𥆳𡭊𡁨")
("3462" "㔤𠢆")
("3465" "&C7-4B68;")
("3470" "计讨议谢")
("3471" "讹诖诜谌谎谨")
("3472" "勆讷")
("3474" "诗")
("3476" "诂诘诰诸诺")
("3478" "诙读谟")
("3479" "谋谍")
("3480" "&C5-516A;")
("3486" "𤣘")
("3490" "柒染")
("3494" "𣚩")
("3503" "呋𠦑")
("3510" "㳏㳞冲冿堻汫汼沖沣津洩浺𣳪𥂵𣸁")
("3511" "汍沌泩浇澅澧濜灃𣸀𤅱𣻱𣲃")
("3512" "凊沛沸泲涄清潚淸𣹥𤁿𣽉𤄵&M-49237;")
("3513" "㳛䗝决凑決泆泍泱洟浃浊湊溙漣漶潓濃瀜瀢灢𣷡𠘊𠘞𤃀&M-49209;𣶣𣷼𣺐")
("3514" "㴂凄淒湕溝漊漙𣲹𣶞𣼚𣽯𣲺")
("3515" "淎𤁥")
("3516" "㵆油浀湱湷漕潜𣹴𣶤𣻲𤅍")
("3517" "𣻛")
("3518" "㵒淟渍溃漬潰濻濽𣶏𠗘𤄸𣿙")
("3519" "凁凍沫沬洓洙洡涑涞涷湅溱溸滐𣷵𤃲")
("3520" "祌神衶&M-34114;&M-34241;")
("3521" "禮褹𥜪")
("3522" "𧚫𩰾&M-34183;𤀷𥘬&M-34558;&M-34579;")
("3523" "䃿䄃祑禯衭袂袟襛褳𧞸&M-34253;&M-34553;&M-34198;&M-34755;")
("3524" "䄛褠褸")
("3525" "袡𧛔")
("3526" "䄂䄚袖褿&M-34750;")
("3527" "䄝&M-34555;")
("3528" "䙡襀𧚨&M-34586;")
("3529" "祙祩袜袾襋&M-34233;&C5-4268;")
("3530" "䢖迍进违迪迭速連逮遗遘遣遭遱遺迧&C4-2827;𨒪𨓰&C5-276A;&C5-2B55;&C5-4357;&C6-292F;&C6-3C53;&C6-3C57;&C6-4F49;&C6-6333;&C6-6337;&C7-296B;&C7-296C;&C7-4379;&C7-437B;&C7-4A79;&C7-5F69;")
("3533" "㦁裱")
("3563" "㝬")
("3570" "讲")
("3572" "讳请")
("3573" "谴")
("3578" "诀")
("3579" "诔诛谏")
("3590" "𣑱")
("3601" "覕")
("3610" "㴄凅塣汨汩沺泅泇泊泗泪洄洇洎洳涃涠涸湐湘溷漍潿璗盪𠗃𣲷𣶦𣲶𣳲𣳦𣶡𡎺𣺀𣴵𣴺𣶎")
("3611" "㵾况況泹浥浧浬涀涅混渑温湟湦溫溾滉瀙灅灈覜况𣳤𣹮𣴟𣿓&M-34906;𩇟𤁣𤄷𣳄&C6-3921;𣴡𣵤𣵿𣺯𣹽𣽭𩇟𤅻")
("3612" "涓涡淠淿渇渭渴湂湡湯溻澷濁濞瀃瀱𣶀𣽴𣳧𣷢𣶜𣿘𤀰𤁻")
("3613" "㴓㴧㶎㶔㶞洖淏渨湨湶溴漗潶澴濕瀑𣽙𤃭𣾄𣿌&M-33628;𤄺𤅹&M-49211;𣹺𤀈")
("3614" "㵊㶠凙淂渂渒湒溭滜漫澤瀴𣿒𣳀𣴢𠘥𣳚𣴪𣽎𤀎")
("3615" "㓖㳌滭潬𠖹𣹤")
("3616" "㴘㵽㵿淐潪濐濖𣳮&C7-2458;𣽞𤀅𤃵")
("3617" "澏")
("3618" "㵋㵑浞浿湜溳潀潩𣲵𣴼𤀭")
("3619" "㵖㶟淉漯澋澡㳭㴪𤂽𤄗")
("3620" "䄄䙟祵祻衵袙袽裀裍𧛃&M-34224;")
("3621" "䄇䄓祝袒裡裩褞襬襯視裎𧛟𩲡𧡤𧢞&M-34396;&C5-794B;&M-35403;&C7-285F;𥜩&M-34754;")
("3622" "祸禑禓禢禤裐裼褐褟襡襣𦤢&M-48891;𥚈")
("3623" "䙨昶祦禗襮&M-34434;&C7-3B64;𥜏&C7-6148;")
("3624" "禝裨襊襗𥜃䙬&M-34531;")
("3625" "䘥禪襌𥛘")
("3626" "裮&M-34707;&M-34426;")
("3628" "禔禩褆&M-34225;&M-34577;")
("3629" "祼裸褓襙&M-34736;")
("3630" "䢲暹迦迫迴逞逷逿遇遈遌遏遑遝遢遻還邈邉邊邏逥逻𨒚𨓦𨓲𨔣&C5-276F;&C5-2B51;&C5-2B52;&C5-2B53;&C5-3C7A;&C5-4358;&C5-516D;&C5-697E;&C5-714F;&C6-4552;&C6-4553;&C6-455B;&C6-4F4E;&C6-4F4F;&C6-4F54;&C6-5937;&C6-5938;&C6-593A;&C6-6336;&C7-296F;𨗓&C7-3447;&C7-3C5B;&C7-3C5C;&C7-437A;&C7-4A7E;&C7-4B22;&C7-5959;")
("3633" "𢡂")
("3640" "𡢈")
("3641" "&M-34870;")
("3642" "𣂌")
("3644" "𤂃")
("3650" "𢴳")
("3651" "&M-34905;")
("3661" "覾")
("3671" "䙾")
("3672" "谒谓谔")
("3674" "谡谩")
("3678" "识误")
("3679" "课")
("3680" "燙")
("3681" "覭&M-45932;")
("3700" "冖门")
("3702" "邲𠨘")
("3708" "𣢠")
("3710" "䀀䀊冝垐埿塱盕盗盜鑿闩闫闰闺阖&M-40453;𠖚𤯦𥂖")
("3711" "㲸㲹㳑㵬㵯凂氾汎汛汜沉沑沮泡泥泦泾洆洈洫洬浘浼涩淝淣渔渢渥湰湼滟漋澀澠濪濯瀊瀣瀺灔灚灧𣲆𣲻𣽝𣲾𣶝𣶘𠗻𣽳𤀄𣿆𣿣&C5-6639;&M-49206;𠗅𣵬𣴻𣹠𣹣𣻭𩇝𣿍𤁍𤀧𤃗𤄻𤅌")
("3712" "㓊㓏㲽㴆㴫㴮㴸㵍㵎㶀㶄㶒䳦冯凋汋汐汮汿沏沕沟泀泂泃泖泷泻洞洵洶浻涌润涧淍淗淘淜渦渹湑湖湧溩溯溺滑滫漏漷漻潏潟潣潤潮澖澗澜濶瀥瀾灁灍灛灟翧邺闯鴵鴻鵼鸂鸿𣵦𣵷𣶈𤁹𤂷𤂶𤃷𤄎𪄰𤅩𠖷&M-39459;𠗽𠗺𣹯𣻫𣻗&M-39621;&M-39631;𤀵𤁵𤂂𤅽&C5-7C38;𣱴𠗄𣲿𣳱𣹍𠖜𣼣𣻩𣻍𣾭𣽔潮𣾬𤀳&M-46967;&M-47066;&M-47146;𤄨&C7-567B;&M-47189;&M-47174;&M-47295;𤅝&M-47303;&M-47398;&C7-604F;&C7-6338;𤅼&C7-656C;")
("3713" "㳮㴔㵤䗬沢泈泿涊淥淴渌渙湪溕溞漁漨潒澳濄蠭闽𧊒𠗋𣹞𣻢&M-33834;𣴦𣼢𣻨𣽓𤀴𤂻𤂿𤃚𠖧𠘤𤄩𤅁&M-33846;𤅛𩼪&M-33934;")
("3714" "㓎㲁㳩㵻㶅冣冺汊汓汲汷沒没泯洀浔浫浸浸涰淑溆溲溵潯潺澱濢濲瀔瀫𣹲𣻑𤃯𣸎𣹚𠘢𠬧𣲋𣴁&C6-3667;𣴫𣴬𣷽𣺲𠘇𣾮𠘒𣿡𤀯𤁌𤁨")
("3715" "净泽洚洢浄浑浲渾漽澥瀈阈𣳷瀞𣸙𣲕𣵢𣸏𣹼")
("3716" "㳷㵫沼沿洛洺涒涺湄湣溜滘漝潞潳澹瀂阔𠗂𠗴𣻥𣷤𣹢𣽃𠖠𣿠")
("3717" "淈淊滛𠗙𣳨𣽶𣿲")
("3718" "㳄㵣㵰㵵凕凝次次涣溟漱潠澬濑濥瀨瀷灨𣽟潨𤁤𣳩𣶋𣣑𣹱𣽌𠘝𣶛𣹎𠖣𤃘𤄕𤄚")
("3719" "㓗沵涤深漈潔澯渘𣻏𥛛𤁼𠖦")
("3720" "&C5-7C30;")
("3721" "㓂䘦䘽冗冠冦戺祀祖祪袍袓视闶阅阋冤冗𧘥𧚇𧞀𠕻𦫪𠕵𥘆𥙸&M-30429;𣣰𥛈&C6-646C;&M-34415;𥛿𥜔&M-34704;")
("3722" "䘟䘩䙀䙱冡幂礽礿祁祠祤祹禂禍翩袀袧袳裥裪裯襉襴闹鴧鵍鵳鵷鶣鸋鹇鼏初冪肎帰𧘏𧙥𥚍𥚩𧛞𩿇𧜣𧝃𣍟𠖄&C5-2766;&C5-2B45;𥘮&M-34221;&M-39565;&M-34473;𥛯&M-34598;&M-34689;&C5-7A59;&M-29248;𠨙&M-34151;𥙯&M-34277;𥛇𥛔&M-49928;&C7-427B;&C7-567C;")
("3723" "䘵䙈䙜䙤冢祿禊禒裉褉褖褪襐襖阏禄&M-34309;𥚦𥛝&M-34626;𠖔&M-34460;&C7-5930;&M-49709;")
("3724" "䄌祋祲衩衱裑裰襑闭𧚥𠖊&M-34137;𠖌&M-30406;𥛀𥛆&M-34478;&C7-3B60;&C7-3B62;")
("3725" "䙙禈衻袶褌阀𧚋")
("3726" "䄡祒袑袼裙裾褶襜𥛅𥛅𧝴&M-34501;&M-34688;")
("3727" "䘶䘿𥘰&M-34359;")
("3728" "䄙䄤襈襰𧜀𣢛&M-34667;&M-34655;&M-34697;&M-34731;")
("3729" "祢褬𥙨&C5-3C33;&M-47925;")
("3730" "䢊䢐䢙䢛䢜䢧䢰辸辽迅迉迌迎迟迡迢迥迳迵迻追迿退逄逈通逢逫逯週逸運過遐遙遚遛遟遦遬遲選遹邂邆邌邍闼迩遅遡𨑓𨑩𨓻&C5-2768;&C5-2770;&C5-305B;&C5-362A;&C5-362D;&C5-3C72;&C5-3C73;&C5-3C79;&C5-5165;&C5-5166;&C5-587B;&C5-5F35;&C5-5F37;&C5-653A;&C5-697D;&C5-6E28;&C5-7152;&C6-2557;&C6-2558;&C6-2E38;&C6-2E39;&C6-2E3E;&C6-3461;&C6-3462;&C6-3C4C;&C6-4558;&C6-4559;&C6-455C;&M-49767;&C6-5930;&C6-5931;&C6-593F;𣤎&C7-2972;&C7-3440;&C7-3448;&C7-3449;&C7-3C5A;&C7-3C60;&C7-3C61;&C7-3C62;&C7-3C63;&C7-4A7B;&C7-4A7C;&C7-4B21;&C7-554F;&C7-5550;&C7-5D23;")
("3732" "䳐鴓鶐&C5-6B39;&M-47002;&C7-6050;")
("3733" "凞恣慂闷𠖓𢚑𢛜𢞉&M-46283;&M-48146;𢛣")
("3740" "姿罕闵闻阌写𡣂𠖗𣺎")
("3741" "冤")
("3742" "䢿䴁翝鴳鶟郱鵧𠡑&M-39527;&M-47082;")
("3743" "𡗺")
("3744" "阚𣪮𢍔𣁻")
("3748" "阙𠖫")
("3750" "军軍闸阐𢫴𤙟")
("3752" "䴆郓鄆闱鶤&M-46935;")
("3754" "𣪻")
("3758" "𣣞")
("3760" "咨酱问间闾阁阃阊阍&C5-7A75;𠶳")
("3761" "㓃")
("3762" "鶷&C5-435A;&M-39544;&M-47152;&M-47175;")
("3763" "&M-35778;")
("3764" "㲅𣪯")
("3768" "𣣟𣣶")
("3771" "冟瓷讥讯记讽诅诡阄阉𤬦")
("3772" "朗词询诩诵调谬谰谲郎郞朗𪁜&M-39491;&M-46876;&M-47217;&M-47297;")
("3773" "谗闳阆餈𠕺")
("3774" "设诹𣫞")
("3775" "译诤诨")
("3776" "诏谘谵")
("3777" "诌谄阎𦈱")
("3778" "欴谀")
("3779" "𥽿")
("3780" "㷭奖烫焈資资闪阂阒阕阗冥𠕳𤏷𠔸")
("3781" "䒌")
("3782" "䎙䴐鄍鴪𪇕")
("3788" "𠖩")
("3790" "䋜冞栥桨楶浆秶粢罙闲阑𣑃𥿩𥺜𥹭𦂟𣝨")
("3791" "𠣺")
("3792" "鄴鸈&M-39467;𠖟&C5-772B;&M-39447;")
("3798" "㱉𣤹")
("3810" "塗汃汄泤𣴞𣲄&M-40675;")
("3811" "㓌㳾凎汔汽沦沧沲泎洤涗涚淦湓湤湴溠溢溬滊滏滗滥漧澨濫灠𣵺潅𣽆𤅴𣵸𣹪𣻓𤅸𠖸𣳁𠗎𣴶𣴾𣽩𤂦𤂺𤃾")
("3812" "㵸㶕汵汾沴涕淪渝湔溣滃漡潃潝瀄瀚瀹冷洕𤀥𤄙𠘅𤅲𣸜𤁶𤅰")
("3813" "㳂㴚㴨㵀㶖凇泠浂浍淞淤淰渼湌溓溔滋滺漾潕澻濨瀁飡𣻒𣻧𣸊𠗳𣿇𣻌𣽜𤂳𤃬&M-49238;")
("3814" "㳊㳺㴛㴾㵟㵺㶑㶘汻洴浒浟渰游溦滶滸漖漵潄潋潎潡澂澈澉澊澓澣激濣瀓瀲潵𤀤𣹶𣻪𣿊𣶌𠘄𣻜𣿗𤁲")
("3815" "㵲㶍洋海潷海")
("3816" "冾凔沿洽浛浴涻渞湁湭滄潧潽澮瀶𣻙𣸄𣽛𤄫𣻦")
("3817" "𣳬𣺱")
("3818" "㳬㵅㵪㶛湵漎漩澰")
("3819" "㳽凃涂滁滌瀿𣽤𣳅𣷦")
("3820" "&M-34097;")
("3821" "䘳祚祱袘裞裞裣褨褴襤𥙰&M-34427;&M-34496;&M-34542;𥜓")
("3822" "祄祶禴衯衸衿袗褕黺䏿𧞶𢃘&C5-582B;&M-34566;𥛙&M-34582;&C7-4F7D;&M-34735;")
("3823" "䄒䘴䙂祣禌禚禭衳袊襚&M-34412;&M-34423;𣵂&M-34440;&M-49706;")
("3824" "複襒𢽉𧛢&C5-3C34;&M-34594;&M-34633;𥘦&M-34112;&C6-3C28;𢾹𥚫")
("3825" "祥&M-34287;&M-34752;")
("3826" "䙢祫禉禬袷裕襘&C5-5E42;&M-34405;")
("3827" "&M-34469;")
("3828" "䙕襝&M-34569;&M-34572;")
("3829" "𥙄")
("3830" "䢔䢟䢢䢨䢩䢭迄迕迤迮迸送逆途逰逾遂遊遒道遨遫遵遾邀递𨖍𨗦𨘉&C5-2771;&C5-2B54;&C5-2B56;&C5-3057;&C5-3058;&M-39059;&C5-5164;&C5-5168;&C5-5169;&C5-5879;&C5-587A;&C5-5F2F;&C5-6538;&C5-6A21;&C5-7151;&C6-2E3F;&C6-3465;&C6-4F52;&C7-2974;&C7-343B;&C7-3444;&C7-3445;&C7-3446;&C7-344C;&C7-3C5E;&C7-3C5F;")
("3832" "&M-47232;")
("3834" "導")
("3842" "&C6-6065;&C7-5C3F;")
("3850" "肇")
("3860" "䁈啓啟噵晵啓&M-40012;")
("3862" "&M-35845;")
("3863" "&M-35679;")
("3864" "㪡")
("3866" "豁𧯉")
("3870" "认")
("3871" "讫论诈说谥")
("3872" "诊谕谫")
("3873" "讼谂谦&C7-4C22;")
("3874" "许𢼊")
("3875" "详诲")
("3876" "谱")
("3880" "㸂")
("3884" "㪦")
("3890" "䆃棨綮𣜦")
("3910" "鲨𡋷")
("3911" "㴴洸淃漟瀅𣻖𣴕")
("3912" "㴥沙消淌渺潲澇𣺰𣺌𣻘𣴷𣷩𣸌𣹝")
("3913" "㵞㶈漛濴灙𣴒𧋊𣲡𣹸𤀬")
("3915" "冸泮溿潾")
("3916" "渻澢瀯𤁽")
("3918" "淡湫溑濙瀵")
("3919" "洣潫濚瀠𤂵")
("3921" "裷")
("3922" "䘯䘷𥙬&M-34132;")
("3924" "褛")
("3925" "袢")
("3926" "襠")
("3928" "裧𤇷")
("3929" "&M-48251;𥽲")
("3930" "䢠䢯迷逊逍逖逤遴&C5-2B4F;&C6-5942;&C6-633B;&C7-2969;&C7-343C;")
("3932" "&M-44769;")
("3933" "鯊")
("3940" "娑")
("3950" "挲㸺")
("3960" "硰𩉀𥆝")
("3962" "𣹇𡮞")
("3971" "㲚谠")
("3972" "诮")
("3973" "裟谜")
("3978" "谈")
("3980" "&C5-4356;")
("3990" "桬𦀟")
("4000" "㐅乂义十𠂇")
("4001" "䧱䧵九尢尢左訄隿雄𡰠𡯳&C5-5239;𡉄&C6-5974;𡰒")
("4002" "力")
("4003" "㚒㻎厷大太夾奭爽𡙁𥇛𡗜𡘲𡗓𡗕𡘼𡚐")
("4004" "友")
("4008" "灰")
("4010" "㙓㚃㚗䥅冭土圡圭圶圹坴士壴壶壷壹壺壼夳奎查査桽盇盍盔臺𡗨𡘍𡘫𡌴䀁𦤼𥁅𤣼𥁈𡘰𡍊𤦃𦥂𤨻𥂙𡚛𡘄𤯗𥄂𥁋𡔦𡘟𥁓𡌬𡘵𥩴&M-05668;𡔹𣩉𡔼&M-40143;𡔾𥃀𡕍&M-49825;𤫍")
("4011" "㙲㙵㙻坑垃垚堆塶境墥壇壵𡗼𩇩𡍠𡎻&M-48865;𡊾𡔬𡏂&C6-597E;𡐎&C7-3527;&C7-4B4A;&C7-5974;&C7-5D34;&C7-5D35;&C7-5D36;&C7-615A;")
("4012" "䎝坊垿塙塝墉墑墒奫𦏷𡙨")
("4013" "㙥䖯墌壕壞壤桼螙蟗蠧&C5-7946;&M-33912;&M-32815;𡙌&M-33348;")
("4014" "坟垶埣埻墇壀鼖𡍓𡍨𡓊𡍔𡍩&M-48334;𡓑𡓣&M-48350;")
("4015" "㚜𡙮")
("4016" "培堷塘𡌮")
("4017" "垴")
("4018" "垓壙𡐝")
("4019" "㙫壈𡓔")
("4020" "夸奓才犷麥𡘆𡗟")
("4021" "㚝㡆㮅㹥䙽克冘圥在堯売奞帷幢犺猚獍獞隺壳兂𪌁𢅒𡚊𠒀𡗸𤢏𤢐𢁣𡥇𦒲𡋞𠒖𣨑𡙚𠒨&C6-596F;𡔻𠒶&M-34890;&C7-2A61;&C7-5124;𡚜&C7-5D39;&C7-5F7B;𡔙")
("4022" "㔎㺎䶓內内南夰夼奝奟巾布希有犭禸肉肴脅臡鼒冇内𡗦𡘴𤢒𢄎𤡢𢁛𠕐𢒊𢂯𢂩&C6-342F;𠳮&M-29337;𠕢𤠖&C6-567E;𤠻𢀃𢄿𠿧𢅍&M-48322;𣝧𣝻𡕌&C7-5C46;")
("4023" "㡉㹡㹹㺘夲犿獽玣𡗷𣏶𡘎𤠠𢄺𣳂𢃨𢄴𤢢𢅖𢅏&M-48175;")
("4024" "存帹幛幮狡猝獐皮𪌘𢃒𤢣𡕟𤠜𡑉𢅻")
("4025" "奯𦨅")
("4026" "狺𤟟𤠕")
("4027" "声𡔝𡱠")
("4028" "奒獷𪍿&M-29926;")
("4029" "猄")
("4030" "寸赱")
("4032" "䲥&M-44659;&M-46765;&M-44588;&M-46757;")
("4033" "㚠㣻㤲㥁㥣㥲㦞㸐办志态怘恚悳惪憙戁杰熹燾赤㣽𤋯𢙮𢤖𢗐𢙄𢚦𢞨&C7-2C36;𡚉𢠀𢡘𤎿")
("4034" "奪寺")
("4036" "赯&M-37023;")
("4040" "㚔㚣㚧夌女孛幸支本李爻耷辜麶𡥉𡜦𠦪𥆗䴺𪍇𡥈𡙐&C5-6B53;䵂𡚠𠬥𡗡𠬲𡗴𢆎𤕐𡜌𠦵𡙜𡕲𢾶")
("4041" "㜙㜲䧴妔妵婎嬗孊𡜋𢀡𡔵&C6-6373;&C7-3528;")
("4042" "㛩夯妨婷媂嫎嫞嫡姉𢂞𡣡𡦭&C7-6457;")
("4043" "㚐㛄㜳㜵䖁妶娹嫉嫝嫬嫶嬑嬚嬢嬤嬷孃𠫤𡔢𡣪𡣇")
("4044" "㚏㛙卉奔妏姣姦嫜孇弆轰卉𠦃𡗹𢌻𢍚𡘏𡞘𡙘𢌾𡔤&M-31908;&M-38445;")
("4046" "㛺㜃㜅㜍嘉娮婄𡞙&M-35535;𡡿&C7-5E3C;")
("4048" "姟")
("4049" "婛媇")
("4050" "牵羍舝车韋𡍦𤙏𤛉&M-43149;𡗢𢫀𢪿𦍒𣫴𢮟𠧈𢺋")
("4051" "䪒辘難鞡𩍅&M-43162;&C5-7460;&M-43173;&C7-5127;&M-43000;&M-43043;&C7-5A27;")
("4052" "㚕䩷韀𩌨&M-42914;&M-42988;")
("4053" "䩙䩾𩍖&M-43142;&C5-7172;")
("4054" "䩲较鞟韕𩊔𩎦&M-43001;&M-42897;")
("4055" "毐")
("4056" "䩧鞛")
("4059" "&C7-3548;")
("4060" "㕯㚚㫩古右叴吉喜嗇夁奋奢奤奮昚杏杳眘奢𠶮𧥢𡙬𠮫𠯛𡘐𣆕𥄽𡙄𣉑𠮣𠮷𠯌𣅎𡇛𤱒𡍬𡔯𣓩𠹫𤲝𠻮𡐑𡔶𡙲&M-35566;𠾂𤲷&M-40128;")
("4061" "䧸䧺䧿&C7-352A;𡕋")
("4062" "奇奛𡊦")
("4064" "壽𣋄𡔽")
("4066" "嚞楍𡙗𡚗𡕎")
("4068" "畞")
("4071" "㔺七壱夿奁奃奄奆奩直矗鼀鼁鼃直𠤎𡗥&C6-3C70;𡘹𠷔&C6-6370;𡚏&C7-3D44;&M-48279;&M-48269;&M-48275;")
("4072" "奅𡗝𣓚")
("4073" "䘮丧农厺去喪夽套袁𡘷𡗰&M-34227;𤯋𡕅")
("4074" "&C7-5660;𣡫")
("4077" "㚎㞭卋𡘣𠦔𡔥𡿊")
("4080" "㚄㶫䝱䞳卖灻疐賁賚賣賫賷贲赍走趇趡趭𤆍𧴥𧾍𧾙𧶠&M-37185;&C5-5E67;&M-37257;&M-37271;&M-37276;&M-37275;&M-37305;&M-37323;&M-37339;𡘂真&M-23237;𠔧&M-36722;&M-37092;𡔰𤊽𤕤&M-36737;&M-36770;&M-37146;𤴞&M-36796;𡐢𤴡𥈜𤏴&M-37236;&M-37705;&M-36884;&M-36914;&M-37286;&M-36937;&C7-5042;𤓉")
("4081" "黈&C5-5A62;&C5-6079;&C7-3529;&C7-5123;&C7-5255;")
("4084" "䵍&C5-6737;")
("4090" "㚓东來夵奈尞木杀杂柰槖索桒桒𣏂枽𣎳𡘝𥈸𦃦𣟘𣏅𠦙𣐁𥾥𣓑𣓟𣓪𠬇𣕿𡙸𣙲𣝷")
("4091" "㯆㰙㰚䨅杭柆柱桩梳椎樈樚橀橦檀雑𣑁𣖵𣚪𣟐𣠾𣓄𣖲𣟅&C7-5D3A;")
("4092" "㮄枋柿梈棛楌楟楴榜槁槦樀樆檇櫅𣙛𣠐")
("4093" "㭹㰅榱槉槺樜樵橠檍檺櫰欀𣐿𣘨𣟊𣟎𣟻")
("4094" "㭽㯅校梓棭椁椄椊榫樟檘櫠櫥欆𣔳𣖸&C5-4A51;𣘚𣘲𣐼𦆽")
("4095" "㯠")
("4096" "㯁棓榶槒𣚌𣚍")
("4098" "核櫎𣙃")
("4099" "㚞森椋榇檁檩𣟒𣟸𡙻𥢮𣞤𣠮")
("4101" "㐡㝼㞀㼪㼽䖊尪瓭虓𡯴𡯺𡯍𡯘𡯞𦓏𦔱")
("4102" "昞&M-44578;")
("4108" "䪴䫪頄頰𩑣&M-43340;&M-43509;&M-43394;&M-43713;")
("4110" "垆𣗃𥂱𧗑&M-47550;")
("4111" "㘩㙄㙈㙺圵址坃坘坯垣垤垭埡堐堙堩堰塸墟壃壚壢壾壠𡍷𡏀𡎪𥂇𡔉𧰡𡉠𤬪𡋮埴𤬿𤭝𡏲𡓐&M-48838;")
("4112" "圢圬坜坷塥墕壖壩𡋫𡓰𡑂&M-44748;")
("4113" "㙇㙊㙣坛堧墵壉𡉬&M-49836;")
("4114" "㙤圩坪埂墰鼔坂𣀧𢾩𧰘𡋱𡎩𢿷𡓳𡔋")
("4116" "㙧坧坫堛堦塷𡎵𧯻")
("4117" "𡎕")
("4118" "䫦塡填𡎴𩒮&M-43717;")
("4119" "坏塛塬墂𡊆𡍥")
("4121" "㡇㹵㺡㼙㼥㼹狂狉狟狴猅猇獹瓻龓𤜻𢃀𤠾𪚓𤣗𤜷𢁿𤝙𤞂𠒐𤞟𤡝𤭩𤡰𢁚𢁦𤝌𤜸𤝿𤞈𤞸𢃫𤠗𢄠𤭨𣯷𤡣&C7-2A5A;&C7-365E;𤣋𤣐𤣤")
("4122" "帄狮獁獅獮獳獼𤡤𢁢𤿆𤟝𤠙𤢵𤜳𤟨𠞲𥀭&M-49668;")
("4123" "㿵帪帳𤟦𤝃𤟔𤢓&M-36474;𤣝")
("4124" "㹴㹿㺛犴犽獶獿皯麫麪𢁗𤞢𤜵𤡹&M-20386;𢾠𢿨𢻦𤣒𢅼𣀺")
("4125" "獩")
("4126" "㹮㹳帖帞幅䴴𢃮𤢗𤝓𤞜𤡼&M-29696;𤣍&C7-5458;")
("4128" "䫨帧幀幁幊獗頗顢顤顭顴颇颟颧𤢺&M-43505;&C5-7179;&M-43722;&M-43430;&C7-4775;&M-43683;&M-43745;")
("4129" "幖狋獂𤠫𤡑𤡫")
("4131" "䞑䞓&M-37014;&M-46614;")
("4132" "鵟䞕&M-36994;&M-37026;")
("4133" "㤮㥈&M-46189;")
("4136" "&M-37015;")
("4138" "赬頳")
("4140" "麵𠧀&C5-5349;&C5-534A;&C5-7740;&C5-786F;")
("4141" "㚰㛒㜘㼬妅妣妧妩妪姃姖姪姫姬姮娅娙娾婋婔婭嫗嫟孋𡞡𡚨𡛘𡤌&M-06037;&C6-364C;𡟽𤕥𡢋𧇑")
("4142" "㚦妸婀媽嫣嫮嬬嬭奵䎟𡞚𡟣𡟪&M-44811;&M-44875;𡚯𡠔&C6-5A5E;𡢉𡢵𡢓𡤲")
("4143" "妘娠媆嫕嬺𡝍𡢇𥏷𡣭𡤘")
("4144" "㚥㛁㛅㛐㛞㛹㜤奸妍姸婥婹媷嫭姧𢼬𡤙𢻳𤕝𢽞𢾴𡢙")
("4146" "㚲妬娝娪媔媘孀𡡖𡜳")
("4147" "婳&M-06594;")
("4148" "㛲㜧䫶媜媫頍𩑛𩔄𡟫&M-43652;&CB04165;&M-43655;&C7-5251;")
("4149" "妚嫄嫖𡞮𡡥")
("4150" "轳")
("4151" "䩯䩽轭轾辄靰韁𩉫䪊&M-42757;&M-43124;&M-42834;&M-42847;&M-42868;&M-43178;&C5-6E4C;㔮&M-43039;&M-43035;&M-42723;&M-42818;&M-43134;&M-43156;&M-43019;&M-43065;&M-43225;&M-43099;")
("4152" "䩒䩫䩻轲辆靪𩉞䩹&M-43061;&M-43062;&M-42727;&M-43025;")
("4153" "䩘䩨韆韔")
("4154" "轩靬鞕鞭&M-43110;&M-43010;𢽁&M-42795;&M-42943;&M-42983;&M-49880;")
("4156" "䩞䪓辐𩋧&M-42816;&M-42919;&M-42906;&M-42806;")
("4158" "𩌦&M-42944;&M-43592;&M-42970;&C5-7C35;&M-42863;&M-43011;")
("4159" "&C7-3D5D;")
("4160" "&M-39950;")
("4161" "噽瓳𣬍")
("4162" "&C7-516E;")
("4164" "敧敼𢼣𢾀𢿩𢿿")
("4166" "嚭")
("4168" "䫑頡颉𩑶&M-43707;&M-43719;&M-43399;&M-43645;&C7-5D50;")
("4171" "㼭㽍䖔𤮀")
("4172" "𠳌")
("4174" "㪑㽑𤮽")
("4178" "䪺䫖&M-43385;")
("4180" "䞙䞛䞜䞝䞠䞪䞸䟊䟐赶趈趠𧺠𧻀𧻚𧽐𧽺&M-37078;&M-37077;&M-37090;&M-37136;&C5-4339;&M-37176;&M-37172;&M-37203;&M-37242;&M-37266;&M-37272;&C5-6963;&M-37295;&M-37344;&C5-7833;&M-37050;&M-37073;&M-37128;&M-49744;&M-37158;&M-37177;𤍕&M-37209;&M-37214;𤎪&M-37217;&M-37352;")
("4181" "𪏛&C5-5A63;𤮏𤭣𤮓")
("4184" "𢽀𢿠")
("4186" "黇&C5-6739;")
("4188" "䫏颠𪏃&M-43444;&M-43435;&C5-6B57;&C5-7272;")
("4191" "㭯㭱㮎㮒㮓㮜㯇㰌杌杠杫杬枇枉枑枙柜柩柸柾栕栣框桎桓桠桱梐梪棑椃椏椻極概榧榹槪樝樞橿櫃櫨櫪櫭櫮櫳欐欞枢𣙁𣐎𣐑𣒸𣒄𣖭𤭴𣘗𣚒𣜂𣝂𣜁𣐵𣒯𥒯𣘰𣘝&C7-2372;𣚛𣛼𣞘𣡛")
("4192" "㯊㯭朽朾杇柄柯栭桁椼榪槅樗檷檽欛櫔𣚊𣔯𣓈𣘣𣚀𣠟𣏜𣠌𣠽")
("4193" "㭬㮕㯌㯪㯫枟柡桭棖椓槱橒櫏櫖𣝓𣚝𣏳𣒬")
("4194" "㯉杅杆板枅枒枰栮梇梗棹楆楩榎榩槈橝橱櫌欇𢿞𣏽𢼢&C6-384A;𣒉𣖀𣘅𣛲")
("4195" "檅𣏛𣘭")
("4196" "㮌㰁枮柘栖栢栺桮梄梧楅楷榗樐橊橬檆檑櫺𣔸𣠚𣐸")
("4197" "桺𣡣")
("4198" "㰋䫐䫴桢楨槇槓橛檟櫇顂䫙𩓠𩕐𣏡&M-43673;𣘩𣚁𣛿&M-43547;𣝛&M-43684;")
("4199" "杯榞槕標𣖪𣚡𣐹𣙽𢷽𥤔")
("4200" "刈𠞮𠟰")
("4201" "㝽㞂㞈劜尨尰沊𣰋𡯢𡯵𡰋𡰖𡰢𤫯𡯪𡯭𣭶𡰄𡰑")
("4203" "抸")
("4206" "&M-44495;&M-44503;")
("4208" "&M-43642;")
("4210" "㓼刲圳錾𡍫𡊻𠞱𠝥𡎗&M-31480;𠟜𥃁")
("4211" "㘪㲨亄圠圫坵垗埵堹塏墔墱𡋨𡐥𡓍𣰛𧰠𠃸𡋸𣭳𡑊𤬗")
("4212" "㙐䵺圻埁塉塴墧彭斳𡌱𡐛𣂼𡐟𡐫")
("4213" "㙸坬墣壎蚻蜤蟚蟴𡑜&C6-6177;")
("4214" "圲坁坻坼垀垺埏埒堫墢𡍰𡐕&M-48332;𡓙")
("4215" "㙨埩")
("4216" "垢墦𡌩𧰀")
("4217" "塪壣𡍪𡎫")
("4218" "㙃")
("4219" "埰塖𡏫𡏪𡏮𡑙𡎽")
("4220" "㓟㓨刳猁猘蒯𢂥𠞘𠛘𤟆𠟋𢅚𠜗𤞹&M-29301;𠞝𣨗")
("4221" "㠲㡖㡗㡠剋毻氋犼狅狣狵獕獵玧𤜤𠒙𠒭𤜺𤝵&C6-6475;𤢪𣰻")
("4222" "㹞狾猯獑獢𢄹𢁘𤡭𤣑𤞝𤠥𤢠&C7-5A4A;")
("4223" "㡥㺈帐幞狐猤獛獯瓠𢁤𢁱𢁬𤝣𢃯𤠓𤢦𤜶𤝑")
("4224" "㡪㹝㹶㹻䴸狿猣猨𤝬𤞲𤝘𤞙𤟉𤟗&C6-5670;")
("4225" "猙")
("4226" "㡒㹺㺁㺕㿳幡狧𢃕𥀋𥀑")
("4227" "㺦幍𤝒𤝾")
("4228" "𤣈")
("4229" "㺐猻綔𤡨𤢴")
("4230" "刌")
("4232" "&M-46786;&M-46989;&M-47354;")
("4233" "惁𢜣𢞪")
("4240" "娳婣嬼荊荆䴮劐𠚽𠛄𡛢㲍𡜇𪌍&C5-534C;𡢱&C5-6734;&C5-6735;&C5-6F4D;𠚰𠞦")
("4241" "㚪㚱㛂㜉㜐㜠乹奼妊姚娷婬媑嬁姙𡜮𠃱𡛖𡜯𡝦𣭷𡞢𡠒𣯬𡜣")
("4242" "㣏妡娇媏媯嬌孈嬀𡜏𡟥𡡈𡡒𡤶𡝊𡡗𡣸")
("4243" "㜎㜻妖姂婖媸嬽瓡𡚸𡜁𡡐𡢆")
("4244" "㛵奷娐娗娞娫婑婩媛嬡𡛜𡞧𡟡𡚼𡛚𡝟")
("4245" "婙")
("4246" "㛥㛧㛴姡姤婚嬏𡝜𡜶𡡾")
("4247" "㛼奾嫍𡟢𡛛𡜪")
("4248" "㛶㜱娦&C7-5A7A;")
("4249" "㜰姀婇𡡊𦁝&C7-3663;𡤣&C7-5A7B;")
("4250" "靷鞩𠝟")
("4251" "㲟轧鞉䪉&M-42884;&C5-6E4F;&M-43203;&M-42741;&M-42969;&M-43192;&C7-5145;&M-43095;&C7-633F;")
("4252" "䩢䪎斩轿靳鞒鞽𩌮&M-43097;𢭓&C7-562B;&M-43220;")
("4253" "䩝䩶鞃鞵&C5-4B31;&M-43067;&M-42901;&C7-4B5F;")
("4254" "䩚䩠䩥轷鞖𩉬&M-42936;&C7-4470;&C7-4476;&C7-5D40;&C7-5D41;&C7-6569;")
("4255" "鞿")
("4256" "䪛辎鞜𩎽&M-42900;&M-42875;&M-43179;")
("4257" "鞱韜&M-42853;")
("4258" "&M-43082;")
("4259" "轹鞂&M-43018;")
("4260" "㓤剒剞晳暂皙剳𧬊𠝛𥓊𠟌𠟗𠟩𥕽&M-40015;𣇮𠟽")
("4261" "㐖𣯆𣯈")
("4262" "斮斱𣃈𣂦&M-35843;")
("4263" "㼋𤔎𤫶")
("4270" "刦𠛗")
("4271" "㽄甏𣰌𣭢𤯉𣰐")
("4273" "长")
("4276" "甛𤳗")
("4280" "䞣䞧䞬䞯䞺䞾䟁䟇剘赳赸赾赿趆趉趏趒趔趫𧼩𧽠𨅘䟏&M-37109;𠟒&M-37200;𠠄&M-37238;&M-37225;&M-37240;&M-37249;&M-37277;&C5-647E;&M-37309;&M-37364;&M-37036;&M-37039;&M-37168;&M-37175;&M-37198;&M-37235;&M-37232;&M-37243;&M-37244;&M-37281;&C7-5043;")
("4281" "𣯻&C7-5734;")
("4282" "斯䵎")
("4283" "&M-33221;&C5-607A;&C5-7873;")
("4290" "㭢㭭剎朻杊栦栵梸棩椞楋檦紮刹𣏀𣏖𠝝𥛱𠝚𣚄𣞗𠜽𠝱𠞁𣓇𣖊")
("4291" "㮔㲡札枆栀桃桤梔棰榿槯橇橙檵櫈杔𣮉㯿𣒇𣓆𣕅𣛽𣒈𣑿𣞚")
("4292" "㭊㭮㯕㰎彬杉析桥梣梤椯楀橋檙欈𣐰𣑹𣑂𣖷𣚠𣡩𢒞𣔔")
("4293" "㭃㭛㮇㯷枖枛枨柉柧栤楑榽槬樸檼櫄𣛹𣕊𣝙")
("4294" "㭔㭩㮃㯶杄柝柢桴桵梃梴椶楥橃欉𣏚𣖱𣏸𣞛")
("4295" "杽棦橓機")
("4296" "㭼栝桰棔椔楯橎𣒩&C6-535E;")
("4297" "㮑柮槄&C6-5D68;𣠭")
("4298" "梹櫍")
("4299" "㰃柇棅棌槂樔櫟櫯櫾檏檪𣠡")
("4300" "弋")
("4301" "尤龙𡯜")
("4303" "㹜犬")
("4304" "博犮博")
("4305" "𢦏𢦎𢦔𢦫")
("4310" "㙬䥭卦圤垄弌弍弎式盋盐盚𢎆𤯯")
("4311" "㙀坨垅垞垸埦埪墭")
("4312" "坾埔墋鸢")
("4313" "㙳䘁垘埃埌堗求𡌤&M-32826;&M-33071;&M-33691;&M-33926;")
("4314" "㙛坺垨垵埈")
("4315" "㘺㙎㚀城域堿墄臷蛓韯𢧜𡊸𢧑𧯥城𢧤𡒤")
("4316" "坮塎𡑛")
("4317" "𡑣")
("4318" "坹埞𡎖𡐔𡒨𡒆")
("4319" "墚𡊍𡋠")
("4320" "𢁽𢍻𢎐")
("4321" "㠶㡧帵犹狁𢃐𤝛𤟊𠒲𤝨𤝤𤟄&C6-462D;𤡙&C7-5971;")
("4322" "㡎㺑幓猏猵獰𢁼𤢶𢎀")
("4323" "㺇㺠幏幰犾狼献獄𤡜𤝯𤞰𤟑𤟪𤡧𤡮𢅪𤞿𤠒𤣊𤣛")
("4324" "帗狩狻猼𢄽䴳𤡺𤝜𤝏𢂑𤟫&C6-4D37;&C7-3662;&C7-572E;")
("4325" "㡨㦲㦽㹽㺂㺣㺤帴幟截戫狘狨胾𢃎𢧴𢒰𢄅𤠽𢦖𢂵𢦷𤢷")
("4327" "𢃙")
("4328" "㡦狖狱獱&M-20526;𤡗𤢅")
("4329" "猔𤝞𢃏𤡅𤢸")
("4330" "忒")
("4332" "䳣鳶鸑&M-44599;&M-47148;")
("4333" "怷怸憖𩻜𤌔")
("4335" "䳒䵧&M-37027;")
("4340" "妼聋麰麱䴬䴰䴱䴷䴼&C5-5A5E;&C5-6B52;")
("4341" "㚭姹娏婉媗𡯮𡡃𡡛")
("4342" "㜗姢媥嬣𤕞𡜵𡝏")
("4343" "㜣㹷娘娭嫁猋㛏𡝢𡤁")
("4344" "㚤㛖㛮妭姲娬𤕠𡛞𡜫𡞛𡞬&C6-3E54;&C6-4761;𡢷")
("4345" "㛾娀娥婶媙嬂孅戟娍𡛟𡟬𡠽𢧇𡣯𢦛𡞨𡠐")
("4346" "㜚妒始嫆嬸𡟲")
("4347" "婠")
("4348" "婝嬪𡣕𡡨𡣑")
("4349" "㛽婃𡝥")
("4350" "䪐&M-42783;")
("4351" "䩩䪑鞚𩎼𩋢&M-42759;&M-43155;&M-42910;&M-43201;&M-43169;")
("4352" "䪔辅𩊬𩌰")
("4353" "䩛䪀䪁𩎓𩊙𩎧&M-43017;&C5-7167;&M-43034;&C7-615C;")
("4354" "䩳䪙轼鞍韍𩌏𢎇&M-42822;")
("4355" "載载&M-43118;&M-42876;&M-42879;&M-43154;")
("4356" "辖&M-42948;&M-43038;")
("4357" "䩪")
("4358" "&M-43094;&M-43091;")
("4360" "𢎃&M-39770;")
("4365" "哉酨𤱱𥅰𢧉𢧨𢨣")
("4370" "甙")
("4371" "𤬩𢍺")
("4373" "裘䬥")
("4374" "𢎌")
("4375" "戡裁𨚵𢨎")
("4377" "𪙤𡽺&M-48757;")
("4380" "䞖䞭䟃䟈䟌貣貳贰赴越趤龚𧼭&M-37075;&C5-3C51;&M-37132;&M-37162;&M-37156;&M-37191;&M-37262;&M-37284;&M-37310;&M-37325;&M-37335;&C5-7449;&M-37349;&M-37091;𢎑&M-37312;&M-37338;")
("4383" "&C5-7872;")
("4385" "戴烖𪏇𪏊𢨚&C7-5B21;")
("4388" "&C5-6F4F;")
("4390" "弑朮术朴杺柲")
("4391" "㭇柁梡椀椌楦榓榨槴𣏞𣛷")
("4392" "㭪柠椮楄槣槮橣檸𣕄𣞐𣓖𣘕")
("4393" "栿桹梂棙榢橪櫁櫶猌𣔻𥏳𣚕𣛚𣛴𣟴𣡌𣟋𣚈")
("4394" "㭓弒杙柭栻桉桳梭榑榟榳樲𣖿𣔱𣞞")
("4395" "㭜㰄栰栽桙械棧棫椷楲槭樴橶檝櫼𣕀𣚙𣐋𣔮𣛸𣟵𢧺")
("4396" "㮥㮫㮷㰂枱楁榕樎𣖤𣙴")
("4397" "桘棺樒𣛱𣓠")
("4398" "㰗柼椗槟樾檳𣜀𣟯")
("4399" "㰑棕橑檫𣓅𣚎")
("4400" "㪺卄卅卌廾虁艹𣂏𠦌𠔀𢌬廾")
("4401" "㐤㝾㝿㞄㞆芞𠡃𡯐𡰝𡯄𡯏&M-30642;&M-30688;")
("4402" "㔹協𠠹𠠴")
("4403" "夶𡘋")
("4410" "㘰䑓䒱䒸䓝䓧䓰䔇䔲䕄䕊䖅䥍䥢坿埜基堇堼塟墓壄封尌耊耋芏芷苎苙苤苴苼茔茥荁荃荎荲荳莁莖莝莶莹菙菫菳萓萱萾葐葟葢董蒀蒕蓋蓥蓳蕫薑薹藍藎蘁蘲蘴虀鼞鼟茎韮蘯丗𦬚𦬹茊𦯖𦯀𦱇𦱃𡬾𦷳𦸃𦸀𦹆𦥎𧗎𨬛𪔣𪔢𧄼𧄸&M-31288;𥁹&M-31534;&C5-4934;&M-31936;𧗆𧯷&M-48333;&C5-6427;&M-40815;&M-32597;𡈿𦒳&C6-2D7D;&M-30968;𦍮𦍟𤦢&M-31300;&M-31290;&M-31298;&M-31296;&M-31291;𡎸𡎼&M-31408;𡏳𥂅&M-31701;&M-49801;𡐳𡐨𥂊&C7-2761;&M-31844;&M-31843;&M-31881;𤨙&M-31934;&M-32031;&M-32032;𡒎&C7-3A6E;&M-49634;&M-32158;&C7-3A74;&M-32050;&M-49633;&M-32280;&M-49662;&M-32367;&M-32357;&M-32444;&M-32421;&M-32447;&M-43196;&M-32499;𧗘&M-48375;&M-49674;&M-32645;&M-32669;")
("4411" "㐜㙪䓙䔼䗘地埯埴堪墐墝壒壦苝范茈茫茳茿荭莐莼菃菲菹蒞蓅蓺蔬蕋蕰蕴薀薽藱蘫荘𦯍𦰫塃𦶇𦻅𪔛𡍡𣺬&M-31511;&M-31846;&M-32278;&M-32235;&M-33725;&M-32553;&M-32589;𡊌&M-30960;&M-31068;&M-31499;&M-31628;&C7-2758;𡑷𡒲𡒣𥃕&M-32598;")
("4412" "㘦㘨㙢㙹䒒䓅䓷䔙䔽䕽劸勎勤坳垮埼堉堶墆墈翥芍药荺莇莎莺菏菿葝蒟蒲蓊蓦蔳蕅蕍蕩薃藰蘙蘬勤𠡟㙝𦵑𦺍𦒃薥𧃐𧆇&M-30867;&M-30885;&M-31657;&M-31666;&C5-5038;&C5-5747;&M-32135;&M-32226;&M-32229;&C5-6D42;&M-48367;&M-32643;𠢀𡍧𡏗&M-31353;&M-31697;&M-31643;&M-31667;𡐦&M-32227;&M-32365;&M-32380;&M-32460;&C7-605F;&M-32668;")
("4413" "㯟䗣䘄䘍埉塨塻塽壊茧莍菉萤蒎蒗蒺藌藜蘾蛬蜝蟇蠆蠜鼜蠚𧍷𦻂𧓿𧕐𡊀&M-31113;&M-33053;&M-31659;&M-33184;&M-31788;&M-33274;&M-32015;&M-33450;𡒯&C5-692F;&M-33809;&M-33849;&M-32631;𧰣&M-30982;&M-31350;&M-31484;&M-33063;𡐉&M-31822;&M-49615;&M-33296;&M-33310;&M-31926;&C7-3259;&M-33461;&M-33650;&M-49647;&M-33720;&M-33709;&M-48348;&C7-4F6B;&M-33782;&M-49700;&M-33876;&M-49671;&M-33919;")
("4414" "㘷㿴䓋䓑䓜䔊䕕䕪䕺坡堎塒壔樷皳皶皷荮菆菠萍葑蓤蔆蔋蕞薄薓薣薱藫鼓𡋯𦭰𦳙蓱𦽐𦼻𡍲&M-31901;&M-31974;&M-32488;&C6-5768;&M-32026;")
("4415" "䔐葏蕺藓蘵虃墷𦱂𦺇𧃖&M-31637;&M-31852;&M-31924;&M-32395;&M-31067;&M-31528;&M-31858;&M-32022;&M-32090;")
("4416" "䕋堵塔墙墻菬菭落萿蕗藩虂𦵩&M-31137;&M-31486;𡆒𡆐")
("4417" "坩蔧&C6-343F;")
("4418" "䕭䕱垬墳苡茨莰葓墴𦵸&M-31726;𧰊&M-31947;&M-32467;&M-32481;&M-32570;")
("4419" "㙩䔫堞蒤薸薻藻𡊉𦸂𡑢&C5-574A;&M-32671;𡍕&M-49588;&C6-6134;&C7-4231;&M-32310;&C7-4F5D;&M-32524;")
("4420" "㱳䒓䒚䔷夢夢棽犲考艼芕芗芧芩苧茤荹萝萨萼葶蓼蔘蕚薴梦𦒶𡖶&C5-217B;&M-30657;𢂆𤿋𤼱&C5-3B58;&M-31510;&M-32269;&C5-7B58;𦒱&M-30658;&M-30656;𤝔𤝦𡭌&C7-5252;&M-49673;")
("4421" "花苀苋苑苨苲茌茪茬茺荏荒荱莅莊莋莌莞莥莧莸菀萀萈萉萑萒萖葂葄葹蒐蒫蒮蓏蓭蔍蔖蔰蔻蕘蕥蕯薍薤薧薨薩薶藋藐藣藶藿蘆蘢蘼虇雈雚麓花蒄葻芁𤜴𦬂𦬖苊𦬺𡋰𦱔𢄍𤠡蔸蔲𦺷薼蘎𧄿𤜣𤞀&M-30899;𢃜&M-31104;&M-31305;𤠤&C5-422F;&M-31492;&M-31493;&M-34852;&M-31703;&M-31605;&M-31854;&M-31779;&C5-503B;&C5-5048;&M-32021;𣜺&M-32144;𣝥&M-32254;&M-32283;&M-32371;&M-32562;𧄍&M-32608;&M-48386;&C5-7B77;&M-32672;𠒌&C6-343D;𢂾𤞯&M-30956;&M-31037;&M-31096;&M-31120;&M-31131;&M-31187;&M-31320;&M-31276;&C6-4E37;𣮳&C6-5733;&M-31363;&M-31518;&M-31532;&M-31378;&M-31390;&C6-6063;&M-31547;&M-31567;&M-31624;&M-45796;𤡬&C7-276D;&M-31776;&C7-2778;&M-31772;&M-32003;&M-31938;𣝹&M-32368;&M-32428;&C7-507E;&M-32529;𣩾&M-32552;&M-32640;&M-32650;&M-48384;&M-32662;𡔚")
("4422" "㒼㔑㠻㡁䒡䒥䒴䒽䓄䓉䓟䓣䔕䔚䔭䔵䕍䕔䕗䕞䕡䕥䕳勀带帯帶幇幕幫朞棼狕狶猗獦玂繭艿芀节芥芬芮芳芴芹芾苈苪茅茢茼荇荋荕荫荷莂莃莆莠莦莴菁菕菛菵菷菺萕萧萮萳萵萷萹葋葕葡葥葪蒂蒍蒚蒡蒨蒻蒿蓆蓇蓠蓨蓩蓹蔄蔅蔏蔐蔕蔿蕂蕄蕎蕑蕭薚薡薦薷薺薾藺蘅蘥蘭蘮虉虋鼘勸苘苐茘㺃蓚䔥芇𦬣芿苚𦬷𦯔𦱀㺔𦳝𦳢𢄢𦸒𦺖䔺𪔜𪍳𠠸𤜜𠡄𢁩𤜽𢁻𢂊𣏟&M-30753;𢂐&M-30884;𤰈&M-31029;&M-31006;&M-31099;&C5-3B63;&M-31232;&M-31143;&M-31198;&M-31649;&M-31606;&M-31579;𤡪&C5-5037;&M-31791;&M-31993;&M-32033;&C5-5766;𤢨&M-32124;&M-32076;&M-32115;&M-32325;&M-32328;𣟈&M-32389;&M-32603;&M-32628;𡗾𤿒&C6-343E;&M-30843;𢂸𤰇𦒸&M-30969;&M-30974;&M-30970;&M-30980;𢃛𤟋&M-31022;&M-31103;&M-31275;&M-31299;&M-31161;𤠬&M-31370;&M-31522;&C6-5766;𠍳𤡁𤠹&M-31674;&M-31699;𤢃𦓁&C7-2753;&M-31849;&M-31856;&C7-277E;&C7-2821;&M-31755;𢅓&M-32030;&M-32172;&M-32134;&C7-423C;&M-32201;&M-32256;&C7-4549;&M-32359;&M-32311;&M-32398;&M-48356;&M-32526;&C7-573C;𦇂&M-32612;&M-32604;&M-32578;𢆄&M-32638;")
("4423" "㡕㺚㿹䓞䓳䔹䕃幙幪漐狹猿獏獴芐苯苰苽茯莀菮菸葔葲蒃蒙蒹蔃蔗蔟蔭蕤蕵蕽薕薞藂藘藤藨蘟辳苄获𦬙𦬔𦱁𦱄𦴊𦵧𤢍𦼫𦿍䵆𢁖𢂴&M-30965;&M-31171;&M-31507;&M-31377;&C5-424B;𤎗&M-31959;&M-31931;&M-32138;&M-32155;&M-32284;&M-32314;𤝂&M-49742;&M-30854;𢂿&M-29399;𣸕&M-31478;&M-31599;&M-31687;&C7-2825;𤢑&C7-3A5E;𤢻𤢩&C7-4F54;&C7-4F55;&M-32507;&M-38698;&M-32567;&C7-5F5D;")
("4424" "㹲䒫䓈䓮䔀䔖䕠䕧䕾䴭帔幬狓獲芨芽苻荐莜菔菧葞葠葭葰蒑蓐蔚蔜蔣蔽蕧薂薆薇藙藢蘉芽蔛蕟𦬁𧹞𦳧𦳋𥀂𦸣𦹡𦺉𧀮𤿏&M-30955;&M-31126;&M-31273;&M-31391;&M-31355;&M-31551;𤡶&M-31867;&M-31870;𥀙&M-32005;&M-31918;𦡨&M-32117;&M-32160;&M-32157;&M-32128;&M-32548;𥀹&C6-337A;&C6-4376;&M-49583;𢻎&M-31308;&M-31245;&M-31357;𥀇&M-31549;&M-31570;&M-49603;&M-31557;&M-32161;&C7-3B2C;&M-32166;&M-32332;&M-40151;&M-32561;&C7-606E;&C7-6529;")
("4425" "䔗䕙幃幭茂茷荈荗荿葎葳葴蒧蔑蕆蕣薉薎薢藏藦蔵茽𦺸𥀯𤠇&M-31429;&M-31797;&M-31910;&M-48370;𢃲&M-31481;𥀊&M-31859;&C7-2770;&C7-423E;&C7-4244;&M-32424;&M-48379;&M-48387;")
("4426" "䔒帾狜狤猎茩萜葿蓎蓓蓿蕏蕕薝藸蘑蘠猪猫𦽌𧄔&M-31118;&M-31051;&M-31221;𤠟𢄳&M-31907;&M-32260;𢅯&M-32351;𤿛𢅔&M-32045;&M-32006;𦾔&M-32136;&M-32374;&C7-5467;&M-32611;")
("4427" "䓛苮芦&M-30938;𡔘")
("4428" "帺幩猉獖獚荻蓗蓣蓯蓰蔙蕦蕨蕷藃藬蘈蘋𢂔𤡞&M-32525;&M-32533;&C7-2D53;𤢙&C7-4C75;𥀲&M-32393;&M-32618;&M-32655;")
("4429" "㹤㹯䕈䕨䕲狇猍獠茠葆蒝蒢蒣蓧蔯蔴麳𧃧𤞠𢃱𢄷&M-32209;𤟬&M-31159;&M-31295;&C7-277B;&M-31983;&M-32081;&M-32163;&M-32375;𢅿")
("4430" "㰈䒦䔎䔏䕖椘芝芝苓苳荩莲菦蒁蒾蓔蓪蓫蓬蓮蕶蕸薖薘薳藗藡蘧鼕𦶅𦺦𦽟𦼯&M-31144;&M-31472;&M-31525;&M-31686;&M-31683;&C5-5043;&M-32240;&M-32432;𡬝&M-31489;&C6-5755;&C7-276C;&C7-277A;&M-32159;&M-32239;&M-32241;&C7-493C;&C7-4F4E;&C7-4F50;&M-32607;")
("4431" "&M-46583;")
("4432" "䔍蔦蔫蕮薊藛蘍驀鷰𦭴𦶀&M-31306;&M-31533;&M-32247;&M-46916;&M-47018;&M-47286;&C6-2922;&M-46893;&M-47216;𧆆&M-47497;")
("4433" "㷊䓇䓌䓗䓤䔡䔳䲀恭惎惹愂愸慕慸懃懋煮燕爇芯苏苾荵莣菍菾葱葸葾蒠蒸蒽蔒蔥蕉蕊蕙蕪薏薫薰藯藼蘸赫慈蕜𦮼𢛖㥨𢜨𦳌𦶐𢡗𦿌𧁊𧄾𧆊𢛓&M-31313;&M-32178;&M-32288;&M-32237;𢤘&M-32373;&M-32423;&M-32615;𢘿𢚈&M-31102;&M-31070;&M-31318;𢜯&M-31527;&M-31445;&M-31702;&M-49605;𢟮𢟽&M-31817;𢠱𢡳&M-32044;&M-32290;&M-32320;𢤵&M-32456;&M-46402;&M-48182;&M-32609;&M-32663;")
("4434" "䒭䓁䔿荨莈蒪蓱蓴蕁&M-36997;&M-32096;𡭆")
("4435" "蘚")
("4436" "䕸赭")
("4438" "䕘")
("4439" "莯蘇")
("4440" "㜂㜸㯬䒘䒝䓍䓾䔂䔌䔞䕉䕫婪嬊孝孶孽攰艾芅芆芊芋芓芟芠芰苸苹茡茭茰茸草荌荸荽荾莘莚莛莩菨菱萃萆萋萎葁葺葽蒆蒌蒦蓃蓌蔁蔓蔞蔢蕈藑蘡蘷麮鼙麬芉𦭼𦯈葼𦳠𡠧𡠗𡠜𦺒𡣋𦽮𧀧𧂜𪔪䵃&M-30878;&M-31246;&M-31284;&M-31172;&M-31182;&C5-424F;&C5-4453;&C5-492F;&M-31664;&C5-5348;&C5-534B;&C5-6733;&M-32304;&C5-726E;&M-32549;&C5-754C;&M-32619;虁芋&M-30760;&M-31091;&M-31128;&M-31111;&M-31083;&M-49587;&M-31281;𠦶𣁙&C6-573E;&M-31498;&M-31509;&M-49585;&M-31503;&M-31580;&C7-2966;&C7-3231;&M-31886;𡣐&C7-3A7E;&C7-4239;𡤈&M-32378;&C7-4C76;&C7-545A;&M-32513;")
("4441" "㛪㛬㛯㛸㛻㭝䒖䒞䒲䓼䬡她妉姥姺娃娔媅嫤嬄嬈嬞嬯孉艽芤莬菟蓻薙蘶蘺芜𦽓&M-30861;&M-31194;&M-31487;𤕩&M-32215;&M-30698;&M-30849;&M-49586;&M-31460;&C6-5A5F;&M-32606;")
("4442" "㚴㛓䕮劳勃募妠妫姱姷婍婻嫷孏荔莮萬萭葧蒭蒴藭勱艻媠𡛙𠡭𦺜𡣾&M-31149;𠢓&M-31684;&M-31855;&M-31917;𠣅&C5-7123;&M-32614;&M-30979;&M-31098;𡟱&C6-6066;&M-31581;&M-32361;&M-32473;&M-32466;&M-32492;&C7-5A79;&C7-6173;&C7-6255;")
("4443" "㛍㜇䒨䓴䓺䔪䔸娡媖媴嫨嫫嬿樊芺莢莫菰萸葖葜葵蒵薁茣芖𦬞𡝩𡙠𡚻𡛠&M-30975;&M-30991;&M-31444;𡡌&M-32035;&M-32315;&C5-6D40;𡗿&M-31101;&M-33028;&M-31515;&M-49604;&M-31538;&M-32281;")
("4444" "㛘㸚䒟䒪䒵䓸䔻䕅奻妓婈婞媶嫐嫴嬦嬳苃茇茾荓莽莾萛萲葌葬葮蒰蕔薅藪葊𦭺莽荓𦿠𦿔𡛡𢌽&M-30761;&M-30815;&M-30957;&M-30917;&M-31512;&C5-4244;&M-31513;&M-31587;&M-32041;𦬠&M-30687;&M-49581;&M-49580;&M-49584;&M-31124;&M-31097;&M-31109;&M-31121;𢻏&M-31289;&M-31258;&M-31301;&C6-4E32;&M-49591;&M-49592;𤿹&M-49595;&M-49598;&M-31392;&M-49597;&M-31482;&M-31285;&M-49600;&M-49599;&C6-614F;&M-31679;&M-49601;&M-31836;&M-49613;&M-49614;&M-31842;&M-49610;&M-31857;&M-31824;&M-31863;&M-49612;&M-38375;&M-49624;&M-49625;&M-49626;&M-49621;&M-49619;&M-49622;&M-49620;&M-49618;&M-31900;&C7-3254;&M-32027;&M-49630;&M-49629;&M-32058;&M-49631;&M-49627;&M-49628;&M-49641;&M-49644;&M-49645;&M-49642;&C7-424E;&C7-424F;&C7-493A;&M-49652;&M-49653;𡤏&M-32437;&M-49657;&M-49658;&M-49654;&C7-4F63;&M-49659;&M-49664;&M-49665;&M-49666;&M-49667;&M-49669;&M-49670;&M-32624;&M-38679;&M-49675;&M-49677;𦧄")
("4445" "䔜媁嬅茙韓&M-31963;&M-32503;&M-49617;")
("4446" "㛭㜓㜴䓡䕒姑姞婼媌媎嬉嬙茄茹菇𡜲𡞯&M-31148;𡜴𡣌𡣰𡤮")
("4447" "姏")
("4448" "㜺娂娸嫃嫹嬻薿蘱𦭹𧆐&M-32104;&M-32452;&M-31673;𡢴&M-49616;")
("4449" "㛦婡媒媟媣嫽荪蓀𦾮𡜉𡜨𡞫𡣮&M-31021;&C7-2C2C;&M-32362;&C7-5250;𡤤&C7-6438;")
("4450" "㨍䒜䒠䒶䔣䖂䡤拲摯摹攀犎芛苺茟荤荦莄莑莓莗菚華菶葦葷蒘蓽蕇藆輂革鞤𦬕𦭷𦱊䓯蕐𦎷𩋮&M-30713;&M-30887;&M-31802;&M-31942;&M-31929;&C5-6125;&M-30763;𢮜&M-31283;&M-31479;&M-31529;&M-42788;&M-31845;&M-31782;&C7-4471;&M-48345;&M-48369;&M-49672;&M-43229;")
("4451" "䕼芄菈菢蓷轨靯靴靾鞋𦶂𩋊𩌍&M-31328;&M-42717;&M-31417;&M-32496;&M-42854;&M-32164;&M-42895;&M-42925;&M-42932;&M-43014;")
("4452" "䓆䔾䕤䕿䩭䪏勒茀莏蒱蔪蕲蘄蘜靹靿鞴韉韊𦮾𦼸𩍁韛&M-32563;&M-32616;&M-31490;&M-42798;&M-32252;&M-42990;&C7-5144;&M-43060;&M-43048;&M-49881;")
("4453" "䩡芙芵英苵荑荴辕鞑韃&M-42994;&M-42737;&M-31919;&M-43147;&M-43059;")
("4454" "䓓䔱䩸䪇䪝菝蓒蘀鞁鞯韄𦱒𩎔&M-31191;&M-31569;&C5-7958;&M-43090;&M-43230;&M-31092;&M-42739;&M-42731;&M-32174;&M-32098;&M-42890;&M-43164;&M-43180;&M-32376;&M-43223;")
("4455" "䒣䕏苒莪鞾韈韚韡韤𦳞&C5-504D;&M-42947;&M-48337;&M-32394;&M-30966;&M-49636;")
("4456" "囏菗萔葀轱鞊鞳&C5-5F64;&M-32200;&M-42950;&M-42982;&M-42791;&M-32101;&M-42862;&M-43187;&M-43051;&M-43219;")
("4458" "䔶䩿蓵韇韥䪄&C7-605A;&M-43098;")
("4459" "鞢韘𦾱&C5-5F66;&M-42962;&M-43194;&C5-6D3F;&C5-7121;&C7-323B;&M-32171;&M-32217;&M-32523;&C7-5D43;")
("4460" "㫷㬫䂲䒤䒷䒼䓂䓊䓏䓘䓠䓢䓿䔰䵿䶀䶁昔暮榃瞢瞽碁礬者耆苔苕苖苗苜若若苦苦苩苫苬茖茗茜茴茵荅莒莔莕莙莟莤菌菌菑菖菩菪萅营萫萶萺萻葍著著葘蒏蒥蒼蓄蓉蓍蓸蓾蔨蔮蕃蕾薈薔薗薯諅謩鼛𦬅者𦤄𦭮𦮂𦮽蒈𦴒𦵯𦵡𤲸𧀦𥄕𦒻&M-30848;&M-30859;&M-30976;𠵂&M-31117;&M-31093;&M-31311;&M-31519;&M-31471;&M-31401;&M-31496;&M-31671;&M-31543;𣊔&C5-5041;&M-32017;𠢷&M-32074;&M-48340;𥖫&M-32318;&M-48349;&M-32659;&M-32667;&M-32673;𠁤𦭝&M-30962;&M-30919;𥆇𦒾&M-31080;𦓀&M-31230;&M-31274;&M-31419;&M-31521;&M-31506;&M-31502;&M-31371;&M-31485;𠻚&M-31603;&M-31578;&M-31693;&M-35559;&M-31851;&M-31814;𣋅𥕗&M-31988;&M-32040;𥋚&M-32291;&M-48339;𣞖&M-49648;&M-42981;&C7-5461;𥗣&M-48368;𥍊&M-32623;&M-32639;")
("4461" "䓽䕢葃葩蓶𦳈𦺑𦺊𧃝&M-32011;&C5-6930;&M-48353;&M-31100;&M-49602;&C7-3250;𡅸")
("4462" "㖴㚡䓒䔅䕵劼耇耉苛苟茍荀荶菂萌葫蔀蔔藅藹蘤耈𧀄𦉚&M-31483;&C5-423F;&M-31608;&M-31700;&M-31688;𠢳&C5-5044;&C5-504C;&C5-5748;&M-31935;&M-31922;&M-32255;&M-31016;&M-31163;&C6-4D71;&M-31324;&M-31263;&C6-4E3B;&M-31526;&M-31604;&M-31669;&M-31793;𥊄𦓃&M-31930;𦉠")
("4463" "䕛䖆藈&M-31763;&M-31762;&M-31969;&M-32170;&M-32130;&C7-3B26;")
("4464" "㿲䔓攲皵莳蒔蔎薛薜薵蘐𦰲𥀁𤿠&M-32230;𥌱&C5-7941;𡜩𥧢&M-31769;&M-31775;&M-32275;")
("4465" "𦳦𧄹&M-32016;&M-32450;")
("4466" "䓵䔤䔯䕎䖀䖃喆囍蕌藞藟藠藷蘦虈&C5-707E;𣊣&M-32156;&M-32626;")
("4468" "𧂃&M-32347;&M-32133;")
("4469" "菋蔝𧄎")
("4470" "斟卙𠥻")
("4471" "㽎䒗䒰䒻䓃䓐䔘䕚䢽世也巷甍甚老耄艺芑芒芘芚芭芼苉苍苞苣茞荖菎菤菴葚蓖蓲蔇蕹虌芑芲茝䎜𦬃𦒷𦭯𧃘𠃒&M-30857;𢁂&M-30993;&M-31116;&M-31145;&M-31585;&M-31766;&M-48262;&M-32308;&M-32448;𠃟&M-49577;&M-30651;𡉵&M-30683;&M-30855;茝𢁀&M-31115;&M-31225;𤭦&M-39404;𣯕&M-31869;&M-32036;&M-32167;&M-32079;&M-32279;&M-32443;&M-39723;")
("4472" "䒛䒢䔢䖇劫勘芌芎芶苭茆茚荂莭萄葛蒒蓈蔼薌蘛鬱鬰𦫶莭𦴫𦿋&M-30729;&M-32251;&M-30689;&M-30850;&M-30971;&C6-442D;𢐯𦏡&C7-545B;")
("4473" "䒧䓹䙪䵽芸苌茕茛茲莨萇葨蒛蓑蓘蔉蕓藝蘘鼚𦬘𦬾𦿉𣓕&M-32642;&M-30752;&C6-4D74;𠬑&M-34441;&C7-3D73;&M-48336;&M-32327;&M-32363;&M-32528;&M-32666;")
("4474" "欝苠茋荍菣芪𡕮&M-32082;&M-30764;𤿜&M-31123;&M-31704;𥀥&M-32353;&M-32445;&M-32471;&M-32610;𣡸")
("4475" "蕼")
("4476" "𤯈")
("4477" "㟚䔄廿甘舊苢苷茁菅菡萏蔤𦯁𦳩𡿉&M-30932;&M-32303;&M-48346;𠀠𠦜&C6-2D79;&M-30978;&M-31028;&M-31027;&M-31169;&M-31315;&M-31309;&M-49594;&M-31827;&M-32162;&M-49637;&M-48752;")
("4478" "䔛蕻&C7-324E;&M-32103;")
("4479" "蘨")
("4480" "㪸㷼䒔䓦䔈䔬䕟䞗䞚䞨䞰䞽䟒䠂䠟䠠䠢共其斢楚炗焚燓爕羐芡苂荄荧荬莡菼萁萐萣萯蒖蒷蓂蔩蕡蕢薋薲藀藇藖藚貰贳赲赵趌趚趞趪趬趱趲躉躠黃黄煑𧺎𤊾𦳚䞥𧻰蕒𦺲𧽍𤑔𨆊𧃕𧄽𧆋&M-30973;&M-37042;&M-30987;&M-37059;&M-37074;&M-37082;𠓶&M-37121;&M-37163;&M-37164;&M-31750;&M-37196;&M-37184;&C5-5144;&M-37199;𤴟&M-37241;&C5-585D;&C5-5D7A;&C5-5E26;&M-37302;&M-37296;&M-32461;&C5-6D49;&C5-7127;&C5-7149;&C5-7447;&M-37356;&M-30653;𠔏𤆯&M-37049;𠔝𦍚&M-36687;𦲃&M-37103;𤋂&M-31389;&M-31469;𤍾&M-49608;&M-31850;&M-37213;&M-37205;&M-37202;&M-31889;&M-32168;&M-36895;&C7-4358;𤑒&M-32331;&M-32469;&M-32453;&M-32527;&M-32559;&C7-5E3E;&M-48385;𤓮")
("4481" "葅蘣蘳黆黊")
("4482" "䓎䔮勩萴䵋𧂆𧄞&M-32309;&M-31491;&M-31597;&C7-4242;&M-32602;")
("4483" "䵌𧂒&M-32600;")
("4484" "皾蔊蕿蘞𥀢&M-32510;&M-32416;")
("4485" "&M-31971;&M-32152;&M-32468;")
("4486" "䕰&C5-6F50;&M-32627;")
("4488" "㒹薟薠蘝苁𧄺𠔶&M-32037;&M-37332;")
("4489" "&M-49593;")
("4490" "㭟㯹䒕䒩䒬䒹䒺䓱䔁䕁䕓材村枓柎某树棻榭槲樹橥禁綦繤芣苶苿茉茦茮茱茶荥荼菄菒菜萊萗萦萰葇葉蓁蔂蔈蔡蔾蕖蕠薒藁藄藥藳蘂蘃蘌蘗蘩蘪蘻蘽虆虊枼荣䒳棊萘菓葈𣗳䔝薬蘖糵㭉𦬸𦱮𦳑𦳐𦵫𦷲𦂌𦺴𦼹&M-31088;&C5-3525;&M-31114;𣓏𣕁&M-31520;&M-31475;&M-31584;&M-31810;&C5-5758;&M-32154;𣝉&M-32220;𣟑&M-32370;&C5-7554;&M-30852;&M-30819;&C6-3444;&M-30964;&C6-442E;菜&M-31505;&M-31696;&M-31501;&C6-6149;&M-31586;&M-31672;&M-31853;𥡡&M-31992;&M-32024;𣛳𥢞&M-32329;&C7-4944;𣟶𥽚&M-32564;&M-32569;&M-32647;")
("4491" "㭠㭺㮱㯛㯵䕌䕯䕹朹朼杜杝杹枕枻栳桂梉植椹楂楂楏榷榼槿橈檯檶櫆櫙權萟葒蒓蒩蓕蕝藲藴藽蘊蘿𣒆荰𦳁𦶆𣔭𣓋&M-31379;𣖻𣖨&M-31675;&C5-494C;&M-32107;𣞓𣎹𣓘&M-31247;𣖁𣔶𣕈𣘇𣚖&M-32109;𣞕𣞑&M-32560;&M-32605;&M-32621;&M-32622;")
("4492" "㮁㯂䓶䔋䔟䔠䕆勑朸枘柨柪栛栯栲桍桸椅椭楕楠槆槗樠橗橢櫹欗莉莿菊菊菞菥葤葯蒳蒶蕛蕱薪藊藒藕䓭𣖾𣚋𦼰𦾿𣏑𣏕𣓃𣔷&M-31677;𠢱&M-32034;&C5-5D72;&M-32077;𣝏&M-32400;𣠝𣠷𣑥&M-31112;𣔎&M-31282;𣕉&M-31524;&M-31694;𣘡𣚂𣚥&C7-324A;𣜎&C7-586A;")
("4493" "㭕㯃㯖㰐䕴杕梜楧榬樉模橽檧檬櫣菘蔠藮蘕蘹蘓𦮺𣚜𧄝&M-31494;&M-31871;&M-31861;𣝈𣝘𣞷𣟆&M-32462;𣡊𣒏𣓙𣓎&C6-615A;𣚅&M-32038;&M-32206;&C7-6259;")
("4494" "㭙㯜䔑䔩䔴䕑枝枿柀栫桦桲棱榯榵橭檮檴欂菽蓛蔱薐藧萪𣒶𣘘𣙻𦼊𧃒𣏠𣓒𣔓𣝍&M-32266;&M-32381;&M-32442;𣡀𣔏&C6-4D7A;&M-31560;𣛵&M-32151;𦅕&M-32190;𧃒")
("4495" "㮖䕝椲樥樺檋櫗𣖂𧄕𣖥&M-49638;")
("4496" "枯桔梏棤楉楛楮榙榰槠檣櫧萂葙藉𣒅&M-31365;&M-31698;&M-31944;&C5-5E27;&M-32245;&C7-2822;𣛰𣞋&M-32286;&M-49639;&M-32364;&M-32535;")
("4497" "柑𦴑&M-31249;")
("4498" "䕀栱棋椟槙横橨橫檚櫝欑萩蔌藾蘏𦶓𦻊𧀖&M-31470;&M-32287;&M-32289;&M-32296;&M-32436;&M-32551;&M-31185;&M-32536;")
("4499" "㮈㮏㮟㮦㯎㯣㯤㯦㰛䔉䕩林棥棶椕楙楪楳櫀櫒欁菻蒜蕀蕬𣘻𦼪𣝔𧄠𣕎&M-31862;𣛻𣝒𣝾𣐾&M-31239;𣓜𣕑𤴜𣗂𣘑𣙳𣚨&M-31966;&M-32175;&C7-423A;&M-32577;&M-32599;&M-32625;")
("4501" "尵𡰌𡯥&M-29257;")
("4510" "㘫坤垏墊𥂕&C7-4B3B;")
("4511" "坉埶𡉒")
("4512" "坲埥")
("4513" "㚂块坱埭壝蟄𡐡𡒌𡋶&C7-4421;")
("4514" "塼塿")
("4515" "埲")
("4516" "堾")
("4518" "㙉墤")
("4519" "埬堜塐𧯾")
("4520" "㹭犻狆𤝽𤝚𢂝𤞗")
("4521" "㹠㿪犱狌𢄶𤜨&C7-2C2F;&M-33627;&M-33931;")
("4522" "帏狒猜𢂍𢂀")
("4523" "㠸㹟㹧㹫㺜帙独狭赨𢁪𢂒𢄱𤡟𢅫&C7-2C2B;")
("4524" "㡚㡞㹬㺏帱麩麯𤟺")
("4525" "𢃶")
("4526" "㡟𥀛𥀖")
("4527" "𢄣")
("4528" "㺓帻幘𤟃𤡱𢅙")
("4529" "帓獉𤝹𤠚𤿗𤟈")
("4531" "𢣞")
("4532" "騺驇鷙")
("4533" "慹熱𢟯&M-46434;")
("4539" "&M-37019;")
("4540" "妌妕妦妽麷䵄䴲𡚹𡠦&C5-7549;&C5-754B;&C5-773F;𡜄𣁞𦗙")
("4541" "執姓娆嫿嬎嬔嬧𡚺𡘺")
("4542" "勢姊娉婧韩𡞑𡛷")
("4543" "㜕妜妷姎姨婊妋𡞤𡠛")
("4544" "㜢姌嫥𡤛𢍠")
("4545" "媾")
("4546" "㜖妯媋𡞐")
("4548" "婕婰嫧嬇𡢲𦏙")
("4549" "妹妺姝娕娻媡嫀嫊𡠑𡣒")
("4550" "摰𨎌&C5-4429;&M-43130;&M-38506;&C6-6425;&M-42797;")
("4551" "䪆𩏚𦎃")
("4552" "&M-42768;&M-43122;")
("4553" "䩟䪈䪋转鞅韢𩏲&M-43213;&M-42989;")
("4554" "鞬鞲鞻")
("4555" "䩬韝")
("4556" "䩜轴")
("4558" "轶辏鞼&M-42998;&M-43204;&M-43081;")
("4559" "䪂靺韎&M-42846;&M-43143;&M-43140;&M-43183;&M-43106;")
("4560" "暬謺")
("4571" "𤮅")
("4573" "㙯褺𤮡")
("4580" "䞞䟄䟎贄赽趀趃趎𧻕&M-37062;&M-37195;&M-37294;&M-37120;&M-37148;&C7-3C39;&M-37263;&C7-3C44;&M-38127;&M-37270;&M-37796;")
("4581" "&C5-5A64;&C5-7976;&C7-2C32;")
("4590" "㭋㭌杖柛柹栧梙槷縶𣓊")
("4591" "㯸杶桡槸𣏒𣖮𣙶𣚆𣝄")
("4592" "杮枾柫梬棈橚𣐈𣚐")
("4593" "㭈㯈㯾枎柍柣桋棣楱槤槵橞檂櫘欜隸隷𣚢𣞝𣟌𣔴")
("4594" "棲楗構槫樓𣞜")
("4595" "柟棒")
("4596" "柚椿槽𣓐𣡘")
("4597" "槥樁")
("4598" "樍樻櫕𣓉𣙿𣛫𣜇")
("4599" "㭑㰉枺栜株梀棟楝榛榡榤樄𣟄𣡎𣠻")
("4600" "加")
("4601" "㞁㞅㞇旭𩲄𡯙&C5-2873;𡯬𠃳𡯻")
("4610" "㘻堌𥂸𧰒")
("4611" "㘿坦垷埋埕堭堽塊塭覲郌𡔁&C5-7C44;𡋳𡌗𥌵&M-49715;")
("4612" "埸堣堨堮場堺塄塌驾埍㙕𡒳𡌸𡑦")
("4613" "㙷壜𧉪𡑡&M-33031;𡏁")
("4614" "垾埤墁墿壧𡌹𡎎𡑇𧯿")
("4615" "墠")
("4616" "㙼")
("4617" "𡌕")
("4618" "垻堤塤𡐾")
("4619" "㙅㙞堁堢𡏱")
("4620" "㹢帕帼幗狛𤝍𤝱𢁯𤝗𤝼")
("4621" "㹸幌狚狸猑猩玀觀𪎆𤞾𢄊&M-34924;&M-45826;𢅩&M-34976;𤣓𢅾&M-45934;𢃚𤟡𤠞&C6-636B;&M-29754;&M-39697;&C7-5571;&C7-572F;&M-45946;")
("4622" "㡌㡢帤幆狷猲獨猬𤟍𤝐𦙺𢂱𤠐𤟕&M-29376;&C7-2D55;𤢞𥀤&C7-4570;")
("4623" "幒猥獧𤟧𤡠𤝲")
("4624" "㿸幔猂猈獆獋獌獔玁玃麲𦡇𢃍𤠎𢄸𤣎&C7-5A76;")
("4625" "㺗幝狎𤠺&C7-5A77;")
("4626" "㺧帽猖帽𢃑𥀜𤢹𤣠𤣣")
("4628" "㹱帜狽𢃰𤝖𤟥𤠔")
("4629" "幜幧猓𤢖𤡂𤞥")
("4631" "䚂覟")
("4632" "駕鴐鴽鸉&M-47091;&M-47481;")
("4633" "㤎恕想&M-46135;&C5-7146;𢦉")
("4639" "&M-37024;")
("4640" "㚳㚼如妿姻婟𪌽䴹䴽𪍽𡜧&C5-6B54;&C5-726F;&C5-754A;&C5-7870;&C5-7871;𡜍&C7-3661;𡣅")
("4641" "㚾㛕㜹㜼妲娊娌婫媓媪媲媼媿𨙾𡣫𧢜𡝚&M-34877;&M-45848;𡤢&M-34988;")
("4642" "㛫娚娟娲婂婸媀媦嬵𡢚𡣏&M-48530;𡣃𡤀")
("4643" "㛱勰娛媳嫼嬛媤𡟯𡟠𡢊𦤣&C6-364D;𡣱")
("4644" "娨婢嫚嬕孆孍&M-30409;𡟷𡡔𡤬")
("4645" "嬋𡠚&C7-4571;")
("4646" "㛎娼媢𡣈𡟤")
("4648" "㛝㜏㜥娖娱媞娯𡡍")
("4649" "婐媬嫘嬠&C7-5A78;𡤯")
("4650" "挐鞇&M-42777;&M-43139;")
("4651" "䚆䩤辊靼鞓鞰韞𩌃&C5-7B4C;&M-49877;&M-42855;&M-42856;&M-42953;&M-43184;&C7-6638;")
("4652" "䪅䪚鞙鞨韣𩌇&M-42880;&M-42930;&M-42915;&M-43045;")
("4653" "韅&M-42978;&C7-5D45;")
("4654" "䩰辑鞞鞸韟&M-43055;&M-43218;&C5-7B6D;&M-43208;")
("4655" "韠𦾏韠&M-42772;&M-43212;")
("4656" "&C5-5F70;")
("4658" "䪘轵鞮&M-43022;&C7-4B60;")
("4659" "&M-43202;&M-43015;")
("4660" "䂟𥆅𡄲&M-35449;")
("4661" "䰩覩魗&M-34938;&M-45915;")
("4662" "哿")
("4665" "奲")
("4671" "毠𧠉𧡪𣭠&M-39331;𤭪&M-49777;&M-34923;&C7-3334;")
("4672" "朅")
("4673" "袈䘫")
("4674" "𠬈")
("4677" "𪗬")
("4680" "䞟䞡䞶䞹䟂䟆䟉賀贺趕趗趧趩趮𧼐𧼮𧼨𧽒𧾎䟍𧾱&M-37055;&M-37174;&M-37157;&M-37211;&C5-5E6F;𡤗&C5-7A79;&M-37114;&M-37112;&M-37178;&C7-3374;&M-37311;&M-37346;")
("4681" "覿&M-45944;&M-34975;")
("4685" "䵐")
("4688" "𪏚")
("4690" "㭡㮯架枷柏柶栶桇梱棝棞椥槶檲相絮𥹡𣐏𥹌𥿃𥡮𣒪𥈷")
("4691" "㮰㯰䚅柦柷桯梎梘梩棍楻榅榥榲榸槐槻檉檌櫬欋欏𣡭𣓛&C5-6B29;𣠠𣒨𣗵&C7-3E43;&M-34966;")
("4692" "㭿㮙㯞㯮枴枵柺梋棉椤楊楐楞楬榻檰櫋柺𣙾𣓍𣕃𣝼")
("4693" "㮩椳楒檈樬𣝋𣟳𣑀𣔑𣚦𣞲")
("4694" "㮨桿棏椑楫槔槹槾樶橰檡櫻欔𣘱𣙵𣡠")
("4695" "㮿柙樿𣖹")
("4696" "梠榀櫑𣔺𣓡")
("4697" "𣡧")
("4698" "㮛枳梖椇𣚣&C7-2E6A;")
("4699" "棵樏橾欙椺𣝇")
("4701" "尥尮尯尳䫺𡯖𡯡𡰎&M-45979;𡯉𡯣𡰃&M-46649;")
("4702" "䲪䳊翃邥郟鳩鴆鵊鷞鸠鸩𩾢𩿅𨞜&M-39273;𡖳&M-46664;&M-46732;&M-46897;𠦢&M-46654;&C7-2B79;&M-46929;")
("4703" "协&M-46004;")
("4704" "㱽")
("4708" "㰰𤜹𣢌")
("4710" "䤰鋆鏧𡎷&M-40679;𣫒𣫨𡌰𡍭𥂩𥃃&M-40911;𣫤&M-41065;")
("4711" "㘲㯡䵷圮圯坈坥坭垝堄堍堸觐𡍤𣶅𡓦𧰕𡉶𡊬&C6-3E2B;𡎐")
("4712" "㘧㘬㘭䣇䣍䣛䲧䳏厀圴场圽均坞坰坸垌垑垧垹埆埇埛埽堈堋堝塢墎壛邽鄞驽鵱鷧切壻𪀦𡓲&M-39283;𡊁𡊶𡌲𡎧𦐰𡎮𡎾&M-39545;𡑹𧯼&M-47238;𡉳𡊤𡋝𡌟&M-39540;𡐐𡑏&M-39691;&M-46937;&M-47271;&M-49937;&M-47465;")
("4713" "㦤垠堟堠塚塜塠塳墺懿螜𧏌&M-32962;&M-33329;𧰇𣫣𡏈𡑟&M-33557;&M-48004;&M-33692;𦫒")
("4714" "㙍㙾㲄圾坄坍埐埠埱塅瑴𡊋埓𣪋𧯸𡎹𡏷&M-48380;𡊈𡊓𡎰𣕒𡒂")
("4715" "㘱坶埄堚墀𡉱")
("4716" "㙴垎堳塯𡄻𡕆")
("4717" "垇垍垖埳堀𡒈𡊊")
("4718" "㰪㰲㰻㱅坎坝埧塓歏𣣹𡓒𣣥𡓤&M-05602;𣤼")
("4719" "垛堔垜𣞙𡏭𡐤𣡆")
("4720" "弩𢐙")
("4721" "㡈㡙㺟㺥㿬匏帆帊幄犯狃狍狔狙猊猛猦皰翹飌𢁒𤜱𢂹𤜝𤜦𤜢𢂕𤞁𠒘𤟣𤠿𠓈𠓏𦫰𠘯𠫗𤜿𤜾𤝺𦫗𤠏&C6-5976;𦫞&C7-3D38;𥀨&C7-4451;&C7-5D33;&C7-6655;")
("4722" "㠴㡄㡅㹼㺒䳑䴃帑幱毊犳犸狗狥狪猢猧猾獝獡胬郀郁郗鄸酄鴮鵗鶜鶴鸏鸛鹤鹳𨚲𤡥𢅰𢁕𤜡𤜼𤿇𢂁𠨚𢂓𤝻&M-39399;𢂶𤞡𤟠𢄓𢄦𤡲&C5-5170;&M-39694;&M-47248;&M-47368;&M-47430;&M-47456;&M-47486;𤜛𤝠𤿉𢂬&M-39396;𢃂𢃖𦐢&C6-4D53;&M-39536;𢄛&M-29503;𤡡𢅂𤡦&C7-2A23;𦑱𦑽&M-48504;𤢧&M-39719;&M-39737;&C7-4C78;&M-47233;&M-39754;&M-47493;")
("4723" "㠽㡝㹣㺀㺅帿漀狠猭猰猴𢄐𤠘𢅗&M-36468;𢂻𢃭𢄟𢄵𢅱𤣜")
("4724" "㠷㱿幈彀殸殻殼殽猳獀觳豰麴𣪎𤠍䐨𤜫𤜯𣪗𤟚𢄌𥀎&M-37021;𣫧𢃣𣪛𤟻&M-37006;𣹬𤡘𣫁&C7-5A74;")
("4725" "㡓狦狰獬皹𤟤𤝕𤝷𤠵")
("4726" "㹦幨狢猸𤠑𢁾𢄜𢄰𤣃𢂽&M-29435;&C7-4C79;")
("4727" "㡊峱猺𤝳𢃗𤟎𤟅𤢋&C6-6064;&C7-3660;&C7-3E60;")
("4728" "㰭㺞幎欷歡狈猽獭獺𢁧𣤇𣣲𤡃𢅟𣤬𢅽𤝆𣣐𤡻&C7-2C2D;𤢔𢅭")
("4729" "㡜猕猱𤢘")
("4730" "㲆㲇")
("4731" "赩䞔&C6-4F30;&M-37011;")
("4732" "䞒䴏邿郝酀駑鴑鶦&M-39286;&M-39720;&M-46933;&M-47227;&C5-7535;&C5-7736;&M-47418;&M-47436;𦐼&M-46915;&C7-567A;&M-47372;&M-46579;&M-47431;&M-47504;")
("4733" "怒恏愨慤𢞒𢤶𢢢&M-37025;")
("4734" "赧赮鷇𡬻")
("4735" "&M-43235;")
("4738" "赥")
("4740" "卆姭孥攳翅聲麭𣣋䴯䴶𪌼䴿&C5-6074;&C5-6075;&C5-6B55;&C5-6F4B;&C5-6F4C;&C5-726C;&C5-726D;䵁𠬚𢻈𦖜𡢂𠮑𦘃&C7-524D;&C7-5731;")
("4741" "㚨㚮㚿㜄㜶䒎䶯妃妑妞妮姐姵姽娓娩婏婗媉嬥爼飆𠙆𡟰𡢘𡤋𡚱𡜆𡙕𦫛𡟳𡡟𦏚𡤩𡤹")
("4742" "㕁㚬㚸㚹㛚䎐劦努奶妁妈妤姁姛姠姰姼娜娴婅婤婦婿媧媩媰嫋嫏嫪嫺嫻孄孎朝翉郄郣郩鄚鳷鴱鵓鹁邚𨙸𩾾𡛾𡜃&C5-2B5F;𡞭𡟩𢱬&M-39584;&C5-5927;&M-39724;&M-46968;𡣽𡤖&M-47112;&M-47366;&M-47392;婦𡟦&M-05383;𣪤𡠟𡢸&M-39712;&C7-456F;&M-46992;𪂂&C7-4C77;&C7-524F;𡤡&C7-6177;")
("4743" "㚵㜊㜩㜯娽嬝𡜱𡟟𡟑𡟴𡠙𡝲𤠼&C7-4C7A;𡤥")
("4744" "㚫㚺㛛㜌㜒㜦㝅㺉報奴好姄姍姗娵娺婌婽嫂𡚾𡟭𡙈𡞦𡠸𣫌")
("4745" "㚩㛔㜨姆媈𡜬𡤒𡜜𡜠𤟴")
("4746" "㛰妱姳婮媚媹𡣁𡟔&C7-365F;&C7-5730;")
("4747" "㚶妇媱𡜥𡝛&C7-5A21;")
("4748" "㜛奺媍嫇嬩嬾嫰嬹嬾𤕟𣤾𣢩𡤚")
("4749" "㛊妳媃")
("4750" "䡰拏撀𤚼&M-43057;𢭋𢴸𢴷𦎼")
("4751" "䪌轻靵靶靻鞄鞔𩉹𩊛𩌑&M-42778;&C5-7667;&M-42792;&M-43128;&M-43117;&C7-3D54;&C7-447D;&C7-4528;")
("4752" "䣐䩑䩓䩕䪍䪕䳬轫辋郼鄿靮鞠鞫鞹韌鶧鷨靭𩉿𩊅𦑜𩊗𩋃𪄿𦑻&C5-524B;&C5-5F68;䩴&C5-6624;&M-42958;&M-42987;&M-42821;&M-42800;&M-42951;&C7-513D;&M-43029;&M-43042;")
("4753" "䩮䩼艱辗鞎𩎤&C5-5958;&C5-6A53;&M-43211;&C5-7959;")
("4754" "㨌䩔䪗毂轂辍靫靸𩏇𣪬𦎯&M-42866;&M-42871;&M-42959;&M-42968;𣪡&M-43114;𤚲&M-43152;&M-42917;&M-42916;")
("4755" "䩵韗&M-42733;&M-43056;&M-42830;")
("4756" "䪜轺辂鞀韂&M-42809;&M-42946;&M-43137;&M-42973;")
("4757" "&M-42886;")
("4758" "歎软𩌱𣥁&M-42726;&M-43115;&C5-7666;&M-43107;&M-43088;")
("4759" "鞣韖&M-42812;&C7-2A7D;")
("4760" "㲈㿦旮砮磬謦韾馨𥊨𥅄𠹢𣍆𥊧&M-39967;𡄒𤰛𣪥𣊮&M-39931;𥖗&M-39991;𡄈&M-35979;")
("4761" "䒐&C5-7559;𠙏")
("4762" "䎁翓翿胡郆都鄀鴣鴶鵲鵸鶓鶘鸪鹊鹋鹕𨞪𪇘&M-39471;&M-47371;&C5-796F;&M-47473;𠳫&M-39498;𡕑")
("4764" "嗀嘏殾瞉𦒺𣫐𣫀𣪸𥔳")
("4768" "㱇欯欹歖𣣩𣣿𣤺")
("4771" "乜𪕷𣭄&C5-526B;𠤙𡙺&M-48260;&M-48866;")
("4772" "䲺䳓切刧却夦邯鵪鹌𦐞鷀&M-46640;&M-39683;&M-47068;𤯐&M-47381;&M-47492;&M-39497;&M-39620;&M-46740;𣫘&M-47145;&M-47147;&M-47265;&M-47419;")
("4773" "厹袃䭌𧘽𧞹&C5-5978;&M-34671;&M-34719;")
("4774" "㲉䍍叝𠫳𣪹𠬫&C7-5E48;")
("4775" "刼")
("4777" "罄𡹹&M-48733;&M-48629;&M-49954;")
("4778" "㰥㰦歁𣤶𣢓𣢟")
("4780" "㷫䞤䞦䞫䞴䞵䞷䞻䞼䟋起起赹赼趂趄超趋趍趐趑趓趘趜趢趣趨趯趦𧺖𧺤𧼪𧽎𧽋𧽻𧾣&M-37051;&M-37064;&M-37099;&M-37088;&M-37130;&M-37134;&M-37193;&M-37239;&M-37261;&C5-5E70;&M-37254;&M-37264;&M-37330;&M-37351;&C5-7835;&C6-3C3E;&M-37068;&M-37145;&C6-5869;&M-37139;&M-37170;&M-37208;𤎮&M-37234;&M-37223;&M-37289;&M-37283;&M-37324;&M-37333;&M-49745;")
("4781" "觌飙&C5-6738;𦫜&C7-563F;")
("4782" "䢼䳍䳢䴅䵏期翸鷏鷬&C5-4361;&C5-516F;𠠠&M-47235;&M-47353;&M-39745;&C7-5733;&C7-594A;&C7-5B22;&M-47339;")
("4783" "&C7-6179;")
("4784" "㷤&C5-754F;𣪳")
("4785" "&C5-7271;")
("4788" "欺歕𣤘𣤥")
("4790" "㯏䋈䅽𣖫𣫙𥻦𣝝&M-32656;𥡛𥼆𦅬")
("4791" "㭄㭸机杋杞杷杻枧枫枹柅柤柽栬桅桖梎梚梶棿楃楓楹櫂欃杞𣐊𣘛𣐓𡑚𣚟𣏝𣔖&M-34941;𣝊𣟇&C7-5641;")
("4792" "㭁㭨㮋㮝㮧㮲㮶㯗䢶䳵朷杒杓杛杨杩杼枂枃构枊枸柌柕柳栁栒栘栩桏桐桶桷梆梛梮棚棡棢椆椈椰楇楈楖楜榈榍榒榔榾槨樃樛樢橌橍橘櫚櫩欄欘郲郴閷鶆鷋鷯鸫鹩𣘙𣛺𣟬𪃏𣎸𣐒𣒂𣖣&C5-3F71;𣗐𣖼&M-39594;𣘪𣘥𣚔𣠼𣠸&M-47447;𣏐杓&M-49163;𣔒𣓓𣕋&M-39650;𣚑𣚚&M-49838;&M-46872;𣝗&C7-5722;𣡞𣡴&C7-663A;")
("4793" "㰀柊根梕梞椂椽楔楤楰榐槌槰橡橼檛檭櫞櫲欚樋𣔹&M-33422;𣔲𣕍𣚉𣡃")
("4794" "㮴㯍㰘权杈杍杸极柵栅梫棳棴棷椒椴椵榖榝樧樳樼檓殺穀糓縠穀殺𣒃𣔬𣚯𣫓𣏘𣑪𠮁𣪩𣖽&C7-5823;")
("4795" "㮮枏栙桻楎樨檞櫸𣑭𣐶")
("4796" "㮞㮭㯝柖格桾椐楣榴槢檐櫓𣓗𣓂𦃆")
("4797" "㭒㭾㮀桕榣")
("4798" "㯘㯢㯯㱈杴栨棂榠樌樕橮櫴款歀𣖬𣝅𣞔𣤷𣠜𣐌𣣙𣤂𣟨𣠙")
("4799" "㮪桗棎楺槡樑𣘤𣒺𣘖𣝌𣚃𣟍")
("4801" "㞉尬尴尷馗𡯨𠆷𡯔")
("4804" "𢼈㪎")
("4806" "𧮯&M-44494;")
("4810" "䀇䀋盩&C7-3D62;")
("4811" "㙂圪塧塩墘壏𡍻𡉛𡊇")
("4812" "㘯圿坅坋埨堬塕塲")
("4813" "坽垁墲螫蟼埝𡌧&C6-6178;𡑞𧰋&C7-5158;")
("4814" "㙏坆墩墫墽壿救㪈𡐣𡏯")
("4815" "㙁㙚垟𡌖")
("4816" "垥墖増增墡")
("4817" "𡌙")
("4818" "㙡")
("4819" "𡌘")
("4820" "𢐧&M-31122;")
("4821" "㡃㺝帨犵狏猃猐𪌇𢅡𢂃𢂘𤠝𠓎&C5-6E61;𤣟&C6-372C;𤟽")
("4822" "㠹㡏㡐㺄㺋帉幯狑𢁮𤜰𠞪𤢌𢅹&C5-7242;𢃪𡣤&C7-5657;")
("4823" "㡘㺊㺌幠狯𤡀𢅕𢅑𢃓𢃧&C7-4C7B;")
("4824" "㬼㺖帡帲散獓獙獥䴵𢿲𤡄𤡳𢅎&C5-6E42;𢼘𤝴&M-30856;𢼥𣁒𤟸&C7-2C2E;𤣙&C7-5A75;𢆃")
("4825" "𦍕𢅵")
("4826" "㹾帢猞猶獊獪𤞞𤢊𢅋𤝰𢂲&M-44496;")
("4828" "獫𤡆𢅐")
("4829" "狝狳𣘒")
("4832" "驚鷔&M-46993;")
("4833" "㥿慦憗憼𢠜𢟻𤎦𤐳")
("4834" "赦")
("4836" "&M-37007;")
("4840" "㜫倝姒娰嫯麧𪍑䴾𤕢&C5-773D;𡥽&C7-3E61;𠐱䵅")
("4841" "㛗㛨㜋㜮㲦乾妰姾嫅孂雗亁娧𡢒&M-44005;𡤱")
("4842" "䮧妎妗妢姈娣婨媊媮嬆翰鶾婾𠢕𠢇𡟞𡛐𣎍𡡽&C7-5253;")
("4843" "妐媄嫌嫵嬘嬨𡡂𡟝&M-37022;&M-46384;𡜅")
("4844" "㜜㢣㪍姘媕媺嫩嬍嬓幹敎教斡𡞪𡠞𢾳𥀐&M-30522;𡡹𡢝&M-30507;𡣷&C7-524E;")
("4845" "姩娒婵嬟𢧢𡣆&M-43185;")
("4846" "㜝姶娢媨嫸嬒𡡑𣉙𡣔&M-39962;𡞝𥉏")
("4847" "𡜊")
("4848" "㜡嫙嬐𤌹")
("4849" "㚷榦𡝙")
("4850" "擎")
("4851" "䩐轮辁𩊭&M-42888;&M-42984;&C6-6427;&M-43145;")
("4852" "䩱䩺轸输靲&M-42725;&C5-7846;&M-42980;")
("4853" "&C5-4B2D;&M-43148;&M-42954;&C7-597E;")
("4854" "䪃䪖辙鞥𩋩𩋟𢾝&M-42801;&M-43037;&M-42740;")
("4855" "&C5-5249;&M-42942;")
("4856" "鞈鞧韐")
("4858" "𩏩&M-43074;")
("4859" "䩣")
("4860" "嗸謷警𣊁&M-40092;")
("4864" "㪚故敬敬𣀘")
("4871" "&M-39585;𠄊&M-48297;")
("4873" "㽐")
("4874" "𢾤𢻱")
("4877" "嶅")
("4880" "䞘䞢䞩䞮䞱䟀䟑赺趁趖趛趝趥𧻓𧼱𧼯𨅚𧾐𧾏𩕀&M-37065;&M-37144;&C5-6965;&M-37056;&C7-3379;&C7-4359;&M-37306;&C7-553E;")
("4882" "黅")
("4884" "𢼭𤉧")
("4890" "朲朳枞檠𣘢")
("4891" "㭫㰖杚枪柂柞栓梲棁椪椸榄榏槎槛樦権檻欖𣏙𣒻𣔫𣖰𣡶𣐍𣕆𣝃")
("4892" "㮬㯓㰏枌枍枔柃梯棆椾楡榆樇橁檎檹櫛櫛𣘠𣙱𣜤𣟹𣛖")
("4893" "㭚㮳㮸松栚棇棜棯検榚槏樣橂橅檖檤様𣜃𣔾𣖺𣖯𣛘𣛶")
("4894" "㮘㮵㮹㯙㯳杵枚栟栟栴椱樽橄橔檄檊櫢𢽳𢽟𣕌𣘧𣝁𣘮𣞒𣟺𢻾𣔼")
("4895" "㮆㰕样梅檥梅𣝕𣟲")
("4896" "㭘㭲㯚柗梒楢槍橏橧檜櫡𣓌𣜆𠎙𣘜𣘞𣚞")
("4898" "㯀樅檢檨檱𣝎𣠺𣒀")
("4899" "梌樤𣠹𣐐𥻳")
("4901" "𡯩")
("4911" "垙埢堘")
("4912" "㝻埫")
("4914" "𡏰")
("4915" "坢")
("4918" "埮燅𡏶𡓴")
("4920" "狲")
("4921" "&C6-6068;")
("4922" "㠺帩猀𦙧𢅮𤞚𠜓𢅲")
("4924" "&C5-6732;")
("4925" "獜&C6-4352;𤢯")
("4926" "𤢎")
("4928" "狄𢃔𤟇𢃸&C7-2C2A;")
("4929" "𤝸")
("4933" "悐")
("4940" "䵀麨&C5-773E;")
("4941" "姯婘𡠠")
("4942" "妙嫦娋&C7-4572;")
("4943" "㜆")
("4945" "姅嫾靽")
("4946" "𡞞")
("4948" "婒")
("4949" "嬫𡮱&C7-3E5F;")
("4950" "𢸧")
("4951" "鞺𩎸")
("4952" "䩖鞘鞝韒𩊮&C7-3542;")
("4955" "辚")
("4958" "鞦&C5-6A4F;")
("4961" "𤲽")
("4972" "尠")
("4978" "𤯇")
("4980" "赻趙趟&C5-3C4E;&C5-647C;&C7-293C;")
("4988" "&C7-5254;")
("4990" "㭂")
("4991" "桄棬樘橩𣜧")
("4992" "㭞㭻杪桫梢橯𣕂")
("4993" "欓")
("4994" "㰔楼橕𣒹𣒁")
("4995" "柈榉橉")
("4996" "㮐檔櫿")
("4998" "㰊梑棪楸")
("4999" "橖")
("5000" "㐄丈中丯串事史吏扌扩曳申聿肀車丰𦘒𡗒𠦆&M-21788;𠁴𠦴")
("5001" "㧤䡉䡴丸抗拄拉掋推摊摌摝摬撞擁擅攍攠攡攤軴轆丸𨾚𢯻&M-38401;𢷹𢺆𢺑𠁦𢱅&C6-502A;&C6-502C;&C6-6372;𢹬𢺠")
("5002" "㧍㧸㨈㩦挤揥揨搒搞携摘摛擕擠韦&C6-6329;&M-38456;𢹓")
("5003" "㨰㩝㩠㬰夫夬央夷抃拡挔摭撨擿攘𢮂𠁗𨎊𢸣𢰜&C5-437E;&M-38509;&M-38535;&M-38554;𢳘𢴶𢸬")
("5004" "㨃㨦㨩㩳䡶抆挍捬捽掖接摔擗較𢬵𨌮𢬪𢳋&M-38344;&M-38431;𢯪&M-38517;")
("5005" "撁擵&M-38510;")
("5006" "掂掊揞搐搪攟𢴨𢹲&M-38404;&M-38434;&M-38471;𢫾")
("5008" "㧡擴輆𢰍&M-38561;")
("5009" "掠攗輬攈𢱨𢳀&M-38350;&M-38557;𢹐&M-38617;")
("5010" "䀆晝畫盅盎盡蛊蠱衋𠄬𥁞𧗁𦦜𠄤𡥅𥁉𥁫𦘕𣌽𦤿𤲯𠁕𤲿𦥆𧗊𧗚𧗙")
("5011" "䖻虻蚢蛀蜼螰蟺&M-48871;&C5-7944;𠁰&M-33455;&M-33586;&M-33684;&C7-6140;&M-33922;")
("5012" "䗤蚄蛴蜟蝏螃螪螭蠐鸯𧏸&M-33420;𦑢&M-33283;&C7-4270;")
("5013" "䗧䗯䗷泰虫蚿螏蟅蟭蟲蠊蠔蠢蠰蠹隶𧕄&M-33471;&M-33644;&M-33620;&M-33759;&M-33911;&M-32901;&M-33043;&M-33092;&M-33442;&M-33451;&M-33565;&M-33770;&M-33794;&M-33850;&M-33952;&C7-6542;")
("5014" "蚊蛟蜳蜶蝷蟀蟑𧌊&C5-3B72;&M-33135;&M-33897;&M-33556;&M-33838;")
("5016" "䗈螗")
("5018" "&M-32989;&M-33540;")
("5019" "䗫&M-33235;")
("5020" "㽕𡱋𦘔𠂙")
("5021" "&M-34950;𠘸&C7-2A5B;&C7-3526;")
("5022" "冑巿帇畁粛肃肅胄青靑𢺶𠂔𠛸&M-32856;𦘘𢄖𦘝")
("5023" "𠥽𣲴𤰰𠁱𣷛")
("5024" "麦")
("5026" "㫪")
("5027" "𠁧")
("5030" "专枣")
("5031" "䏋")
("5032" "鴦𢙻𦘛&M-47260;")
("5033" "忠恵患惠惷憃焘𢗱𢞯")
("5034" "寿寿專")
("5040" "㔼㕜叏叓妻婁𡛽&M-03151;𡝤𡞔𢜤𡙹")
("5041" "&C7-3525;&C7-4B4D;")
("5042" "𠡸")
("5043" "奏𡚀")
("5044" "冉𢍁𨋌𢍣𠬼")
("5050" "奉毒𤰶𣫯&M-42785;")
("5055" "轟")
("5060" "旾春書由砉軎𣅾𣆊書𤱪𣌼𡈋&M-41924;𦘠")
("5061" "&C7-5122;")
("5062" "𦦺")
("5064" "𦦾&M-07459;")
("5066" "㮺𡴡𡴩")
("5071" "㕀屯㼜𣬛&M-38247;&M-48268;𤰴𤕣&C7-3E69;")
("5072" "甹")
("5073" "叀囊表衷&M-34328;𠔘&M-38177;&C6-3C47;&M-34690;")
("5074" "𠬻&M-38544;")
("5077" "击畵舂𠳋𠙹𦦱")
("5078" "𤱫")
("5080" "㶳䝴夹疌責貴賮贵赉𠆴𤍐&M-32860;&M-41935;𤇝𤴝&M-36757;&M-49738;")
("5090" "㯱㯻㰆未末朿束来東柬棗橐櫜秦素耒𣓧𣎺𣘯𣚇𣟏𣠔𣏃𣏲𣐺𥿏𣝐𣞉𣡏𣡪")
("5091" "&C5-5947;𦔛𦔭")
("5092" "䎮耪𦔓")
("5093" "耲𦔩𦔗")
("5094" "辢𦆾")
("5096" "䎧耱𦔑𦔝")
("5099" "䆐纛𥠼")
("5101" "㧚㨤㩖䎠䡇䡖䡿扛扤扯批扼抂抏抚抷拒挃挋挳捱排掗揠揯摡摣摳擓攉攊攎攏攦軏軖軛軭輊輒輕輫轣轤㨢㧗𢭃𢬴𢮎𢳍𢴬𢴮𢶉𢶍𢺰𢬀𢮉𤭔&M-38597;&M-38600;𢪔𢪑𢫮𤬺&M-38185;&M-38230;&M-38219;&M-38258;𢲖𢳖𢳢&M-38323;&M-38405;𢶐𢸉&C7-6269;")
("5102" "㧫㩀打扝抦抲捗掚掯揹搹摴擄擟擩軻輀輛轜𢫱𢯼𨎪&M-11801;𢫲&M-38175;𢬲&C5-515D;&M-38489;𢩨𢮔𢰚𢯯𢳃𢵏&M-38462;&M-38578;𢺞𢺬")
("5103" "㧻㨎㩕抎拤挊振掁摅據擫攄輭𢫻𢲀𢴾&M-38553;&M-38229;&M-38331;𢶘𢷭𢺂")
("5104" "㧎㨜㨿䡊扜扞扳抨挕挭挵掉掫搙搟摄摢撢擾攝軒軙軯𢪊𢫳&M-38191;&M-38221;&M-38383;𢶚&M-38613;𢯬𢱼𢴻𢶁𢷛𢺕")
("5106" "㧵㩅㩡䡡䡼拈拓拪指捂揊揩搢撍擂輏輻𢫦𢲸𨏒&M-38313;&M-39781;&M-38256;&M-38460;𢸲𢸰")
("5107" "&M-38347;")
("5108" "㨗㩪䡠揁摃撅擷攧𩑖㩩𢭅𢱾&C5-443A;𢶃𢶄&M-43494;&M-43732;𢴦𢹟")
("5109" "抔搮摽&M-38458;𢵍")
("5110" "鑋𢿫")
("5111" "䖱䖻䗂䗎䗵虹蚅蚍蚖蚟蚷蚽蛭蛵蜌蝘蠦蠬𤭹𧔀𧕯𧖜&M-32834;&M-32862;&M-32942;&M-33472;&M-33640;&M-33635;&M-33737;&M-33816;&M-33355;&M-33488;")
("5112" "䗡䘈虰蚵蛃蛳蜽螄螎螞蟕蠕蠣𧉄&M-33230;&M-33425;&M-33706;&M-32822;&M-33246;&M-33652;&C7-587B;&M-33941;")
("5113" "䖶䗅虾蜄蝡𧏿&M-32910;&M-33619;&M-33791;&M-32870;&M-33520;&M-33476;&M-33688;")
("5114" "虶虷蚈蚜蚲蟫蚈𧋑&M-33013;&C5-5053;&M-33335;𣀂&C5-712F;&M-33899;")
("5116" "䖨蛅蛨蝒蝔蝠𧋋𧒽𧕅&M-33017;&M-33437;")
("5117" "&M-32904;&M-33344;&M-48660;")
("5118" "蝢蟩&M-32879;&M-33238;&M-33464;")
("5119" "螈螵蟝&M-32898;&M-33127;")
("5121" "㼩&C6-5034;")
("5122" "𧥚")
("5123" "&C5-7162;&C7-353D;")
("5124" "㪩𧥙")
("5126" "&M-42662;")
("5128" "䫆顑顣&M-43428;&C5-5F75;&M-43529;&C7-354F;&M-43501;")
("5131" "甎")
("5132" "䳲")
("5134" "𣀨")
("5138" "䫲")
("5141" "甊㼮")
("5144" "𢿘")
("5146" "𠕟")
("5148" "䫔䫫顜𩑺")
("5151" "虦")
("5161" "𧈕")
("5168" "頔&M-43692;&M-43712;")
("5171" "𧈖")
("5174" "𢻴")
("5178" "頓顿")
("5180" "𨆪&M-37935;")
("5184" "𢿒")
("5188" "䫭颊𩔳&M-43702;")
("5191" "㼯耟𦓪")
("5192" "耓")
("5193" "耘")
("5194" "㪝繛耨耰𦓬𢍫𢆬𣀪")
("5196" "𦔆")
("5198" "頛頼𩑷&M-43403;&M-49885;&M-43640;")
("5200" "㓝㧃㨽䡂䡅划刔刜剚挒捌捯揦𠛉𠜒𢫧𢱦𢶏𢷶𢯩𢪉𣭂𢮓𢳐&M-38410;𢷚")
("5201" "㧌㨟扎托拞拰挑捶揰搋摧撜撬擸軋軞軠𢬯𢮊𢷖𢫷𢬳&C5-3C71;𤳘&M-38521;𢭊𢮤𢰛&M-38294;&M-38322;𢴹𢴫𢶎𢷼𣰠")
("5202" "㣋㩗䡳折拶挢揣摲撕撝撝撟攜斬輲轎扸𢭆𢯺𢱣&M-38612;𢒈𢭍𢳕𢲽𢹂&M-38525;")
("5203" "㧓㨙㩄䡏扷抓拆挀掭揆摦摾撲軱轐𢷏𨏈𢫢&C5-3054;𢱟&M-38310;𢷍&M-38608;𢫂𢪺𢲕𢴴𢷎")
("5204" "㨑㩊㩱扦扺抵挺挻挼捊捋捼授援撥軝軤軧𢯸𢯳&M-38417;𢹚𢺥&C5-7A3E;𢰏𢶛𢹄&M-38589;&C7-6566;")
("5205" "抙拝挿掙𢯈𢴰&M-38362;")
("5206" "㧨㧷㧺括捪揗播輜輴輺轓&M-38384;𢬸&M-38394;")
("5207" "㧄拙捳插揷揺搯摇轁韬𢩳𡵎𢫽𢰔𢹴")
("5208" "㨏&M-38491;&M-38516;&M-38579;")
("5209" "㨀採搎摷擽轈轢擈𢭁𢰂𢸫𢺈&M-12846;&M-38466;&M-38576;")
("5210" "劃埑塹虯蚓蛚蜊蜵蝲銴鋬鏨𠜻𧍡&M-33029;&C5-504F;𠜚𡌁𡌒&M-49684;𠟱&M-33346;")
("5211" "䖴虬虴蚝蚯蝩螔螘蠟&M-33527;&M-33757;")
("5212" "䘎蚚蜏蜥蝺螹蟖蟛蟜蟡蠵𧋍𧍒𧔇&M-33325;&M-32912;𢒖&M-33069;&M-33231;𣃂𣃏&M-33594;")
("5213" "䖣䖰䗱䗼蚸蛌蜇螇蟋𧑓&M-33282;&M-33172;&M-33460;&M-33511;&M-33657;")
("5214" "蚔蚳蜉蜒蜓蜲蝂蝬蝯&M-33100;&M-33139;&M-33051;&M-33406;")
("5215" "蟣&C5-7B67;&M-32973;")
("5216" "蛞蟠𧌏&M-33022;&M-33409;")
("5217" "䖦𧍘&M-33345;&M-33951;")
("5218" "&M-33459;&M-33777;")
("5219" "蟍&M-33375;&M-33563;")
("5220" "㔅𠜙𠛔")
("5221" "覱𣬪𣰊&C7-4B48;&M-45909;")
("5222" "𩇕𢂼𢃴𢄤𢒌𧣯")
("5224" "㿱")
("5225" "靜")
("5230" "剸")
("5232" "䳻&M-46906;")
("5233" "䱫悊慙焎𢝗")
("5240" "㓶㜞娎𠞭𦖨𢼺&M-29111;𦗚")
("5241" "氀𣰟")
("5243" "𤬏")
("5250" "㨻剗揧")
("5252" "𣂧")
("5260" "䀸剨哲晢暫硩磛誓𠝩&M-42678;𠞷𠟆")
("5271" "㼊乴𢀄")
("5272" "𢏨")
("5273" "裚䭁䭕")
("5277" "㟻𪘼&M-48679;")
("5280" "䟅烲踅蹔&M-36890;𣮌")
("5289" "𥡯")
("5290" "䋢刺剌梊椠槧紥𠛐𠛨𥻌𠝁𠠅")
("5291" "耗𣭵𦔉")
("5292" "䎰")
("5293" "㼍㼑𤫷")
("5294" "䎫𦓽𦅻")
("5295" "耭𦓺")
("5296" "䎩")
("5299" "𣝞")
("5300" "㦮㧙䡎戈戋扑抋掛曵刱𠀋&M-38196;𢪗")
("5301" "㧖㨭㩆㩙䡐䡝扰抁抭拕拢挓挖捖捥控揎搾撹攛軶輐𢯶𢲼𢶊𢹑𢱮𢳙𢰉𢱱&M-38338;&M-38403;")
("5302" "㨳㩷䡢䡪拧捕掮掺揙搧摻擰輔𢮍&C6-314F;")
("5303" "㧋㩃㩎䡙䡾挨捄捩揬搲撚撡撼擜攇攐攨轗㩵𢰇𢫯𤝟𢰃𢱿&M-38292;&M-38327;")
("5304" "拔拔拚拭按捘搏軷軾拼𢲷𢴧𢯴𢱇𢩮𢪴&C6-4930;𢯱&M-38252;𢲻&M-38461;𢺦")
("5305" "㧔㧴㨓㨔㩥㩬找掝搣摵撠撪撺擑擮攕輚輱𢫨𢬿𢶋𢷾𢷿𢹖𢭂𢹍&M-38604;𢳒𢴠𢷘&M-38515;&M-38547;&M-38582;")
("5306" "㨧㩈䡥抬揢搈搳摍軩輽轄𢴀&M-38340;&M-38414;&M-38514;")
("5307" "㨸捾輨𢷈")
("5308" "㧒掟摈擯攓𢲘𢳡𢷤")
("5309" "㧲擦𢴱𢮄")
("5310" "㦯㦶䖩彧或戜盏盙盛盞𡌳𢧌𤦒")
("5311" "䖳蚘蛇蛖蜿蝖螲𧉃&M-32936;&M-33140;&M-32975;𣹹&M-33332;&M-33454;&M-33629;")
("5312" "䗿蜅蝙𧎥𧑗&M-32920;&M-33790;&C6-4E46;&M-33716;")
("5313" "䘆蛷蜋蜧&M-33630;&M-33648;&M-33921;&M-33177;&M-49693;")
("5314" "䗚蚮蛂䗏𧈺&M-32943;&M-33012;&M-33654;")
("5315" "䗃䗩䘂䘋蛑蛾蜮蝛蟙蠘&M-32945;&M-33011;&M-33045;&M-33314;&M-33697;&M-33863;")
("5316" "螛𧉟&M-33366;&M-33569;&M-33655;")
("5317" "䗆")
("5318" "螾蟘蠙𧎢𧑅&M-32937;")
("5320" "咸威戊戌戍成戚烕成𢦟𢧒𢧦𢦓𢦡𢦠𢦞𢦨𢦩𢦹𢧟𤋆𢧿")
("5321" "䰥𢧩&M-45852;")
("5322" "旉甫觱𢃤𧤅𧥀𧥑")
("5323" "㳼𤜲𤝮")
("5325" "&M-49535;")
("5328" "靛")
("5330" "𡿿")
("5332" "𪂵")
("5333" "惑感慭慼𤒉𤒜")
("5334" "尃")
("5335" "𢨋")
("5340" "戎戒𡞣")
("5344" "𢌵")
("5350" "戔𢦦")
("5354" "&M-38623;")
("5355" "&M-49756;&M-38586;")
("5360" "㦴戓𢧔𤰭𠳆𢧆𢧋𥇙&M-47554;")
("5362" "𤱤")
("5364" "𢧸")
("5365" "𢧬&M-49789;")
("5370" "戉𢦙")
("5375" "㦼&M-49705;&M-49776;")
("5377" "䶠𤮼")
("5380" "蹙𤉹𠎶𢦶𤊸𢨇&M-36827;𤒓")
("5385" "𤈮")
("5390" "𦁓𦄉")
("5391" "𡩆")
("5392" "𦔁")
("5393" "𦔅")
("5394" "𦔍")
("5395" "𢧧𣒭")
("5396" "耛")
("5400" "抍抖拊軵轛𢩭𢩱𢰙𢷋𢌭𢩩𣁱𢱃𢱹")
("5401" "㧥㧧㧯㨁㨒㨷㩲䡜䡷奿扏扗扡抌抛抴拋挂掩揕搉搕撎撓擡軌揸𢪎𨍰𢯽&M-38273;&M-38376;&M-38531;𡉘𢬹𢯿&M-12654;&M-38450;𢹵")
("5402" "㔗㧆㨅㨚㨥㨺䡃扐抪拗拷拹挎捞掎揇搚摕撱擖軜軪輢轕轥抐𢬱𢮌㨊𢸳𢫭𠡯&M-38406;𦘓𢬾𢰒𢱪&M-38365;&M-38493;𢺃𢺊𢺴")
("5403" "㩚䡌抾挞挾捇摤摸撻軑軚轅𨏕𢪂𢫿𢳑𢺉𡗻𢵎𢷓𢸅")
("5404" "㿮䡈䡋技抜披拵持挬捹掕搑擣擭輘𨍷𢰆𢱺&M-38537;&M-38606;𢳎𢹕&M-38601;")
("5405" "㩢𢮇𢯷𢯹&M-43123;𢰎𢱂𢸆")
("5406" "㨋拮捁措掿描搘搭撦擆軲轖𢬷")
("5407" "拑")
("5408" "䡩䡹䡽拱拻掑搷撗攢輁轒𢴢𢷺&M-38528;𢷇𢷐&M-38583;&M-38590;&C7-5C7B;")
("5409" "㨆捺揲搽撩擛攃轑㨲㩰𢱢𢫬𢱴𢫩𢭒𢬺𢮕𢰀𢷌𢺌𢺇")
("5410" "䖞蚁蚪蚹蝌𧐇𧐝𠢦")
("5411" "虵蛙蝰螼蟯蠸豔&M-33148;&M-33136;")
("5412" "䖷䗁䗶蚋蚴蛕蛠蜐蝻螮蟎蠇蠨蜹&M-32952;&M-33015;𠡫𠡾")
("5413" "䗢䗮蛺蝧螆蟆蟽蠓𧉧𧋒䗹&M-32909;&M-32859;&M-49688;&M-33441;&M-33378;&M-33904;&C6-6168;&C7-3268;&M-33783;&M-33830;")
("5414" "䖹䗀蚑蚾蟒蠖蠎&M-33370;&M-33559;&M-33356;")
("5415" "蝆蠛𧍫𧑍&M-33613;&M-33907;&C7-4F6E;")
("5416" "蛄蛣蜡蝫蝫蟢蠩&C5-425C;&M-33702;&M-33269;&M-33651;")
("5417" "蚶")
("5418" "蜞蟥蟦&M-33765;")
("5419" "䗋蚞蝶蟟蠂𧎳&M-33297;&M-33766;")
("5421" "𩇜&C7-4466;")
("5424" "䨼𢺷")
("5432" "&C7-5238;")
("5440" "㪹")
("5441" "𡰍")
("5442" "𠢉")
("5450" "斠")
("5453" "𡘢")
("5460" "䂮")
("5462" "𢆅")
("5482" "勣𠢥")
("5484" "𤿶")
("5490" "𦆫")
("5491" "䎨𦓯𦔏")
("5492" "勅耡耢𠡠")
("5493" "䎭䎯𦔃𦓷")
("5494" "㩽耚耯𤿖𦔋𦔠")
("5496" "耤𦔌")
("5499" "㯲𦓹")
("5500" "㐩䡛丳丼井扙抻拽捙𢪋𢫫𢯰&M-38267;&M-38305;𠁷&M-38562;&M-38595;&M-38610;&M-38609;&M-38607;")
("5501" "㩇扥执扽挠軘兓&M-38192;")
("5502" "㧊㩋弗拂掅輤")
("5503" "㚘㧼㩨䡍䡺扶抉抰抶挗挟捸揍摙擃攮軮軼輳轋𢮨𢸦𢯵𢸀𢫼𢰁𢴥&M-38146;&M-38522;")
("5504" "捜揵搆摟摶轉捿")
("5505" "抩捧攆")
("5506" "抽軸𢲵&M-38490;𢳏&M-38448;")
("5507" "㨹摏轊")
("5508" "㩌捵捷摜撌攅𢶝&M-38526;&M-38565;")
("5509" "㧣㨂㨞抹抺拣拺捒揀搸朄轃搩𣌾𢱠𢷜𢸨𢸩")
("5510" "㻃坓垫蚌蚛蛼豊豐&M-32978;&M-33040;&M-33342;𥁖&M-32992;𣍈𧯮𢑹&M-33768;")
("5511" "蛲&M-32837;")
("5512" "蜻蟰鸷")
("5513" "䖵蚗蚨蛈蛦蛰蟪𧎯𧐖𧖒&M-41929;&M-33618;&C5-7430;&M-33879;&M-33036;&M-33433;&C7-3B41;𧰅&M-33963;")
("5514" "螻&M-33551;")
("5515" "蚺蜯蝳螬")
("5516" "蚰蛐蝽&M-33639;")
("5517" "彗&M-33524;")
("5518" "蛱蜨𧐐&M-33169;&M-33605;&M-33589;")
("5519" "蛛蝀螓𧔬&M-33101;&M-33340;&M-49680;&M-33391;")
("5520" "𢏪")
("5521" "𠙐𠒹𠓆")
("5522" "𢂏䐌&C7-4548;𦘨")
("5523" "汬農")
("5526" "𧭃")
("5533" "㤟慧热𢘍𢣡")
("5540" "𠦈𢻝𤯽")
("5542" "势𠢠𠡂𥝃")
("5543" "𡘉")
("5550" "輦辇𠦒")
("5555" "冓")
("5560" "曲曹替𥄱𣇺&M-39862;𣊄𤾞𣍘&M-40090;&C7-637A;")
("5566" "𣊛&M-33942;")
("5568" "𤲣")
("5569" "𣍖")
("5572" "𢏇")
("5580" "僰典熭費賛费贽")
("5590" "絷耕𣍃𣓝𦓮𥺠")
("5594" "耬𦔪")
("5595" "耩")
("5598" "耫")
("5599" "㯥棘𥡀𣘐𣡍")
("5600" "㧢㧽㨡㩛䡒扣抇拁拍捆摑攌𢮖𨍲𢪷𢪾𢬼𢪏𢫥𢬻𢭇")
("5601" "㨪㩴㩹䡚拀担挰挸挹捏捚掍揘揾搵摫擺攞規軦輥輼轀韫邫𢱧𢶀𨍧𢹮𢱫𢷕&M-38478;&M-38626;&M-39325;&M-38492;")
("5602" "拐捐掦掲揚揭搨擉擤暢輰輵𢷒𢯮𢪶&M-38333;𢶔")
("5603" "㩧䡯捑揋揌搝摁摆摠擐轘𢫸𢮚𢰌𢵃𢷑𢸃𢹯&C7-5954;𢺖𢺱")
("5604" "㧹䡟䡬捍捭揖摱撮擇攖攫輯𢫵𢱩𢶓𢰊𢰘&C5-5F2A;&C5-7A7A;𢬽𢮧𢮆𢰐𢱻𢱰&M-38371;&M-38523;")
("5605" "䡲押撣𢳂")
("5606" "捛撂攂轠𢯾&M-38407;")
("5608" "抧捉损提損軹𣉄")
("5609" "捰摞撔操輠㨐𢺢")
("5610" "蚎蛔蜘蜠蝈蟈蜖&M-32954;&M-33054;&M-33131;&M-33112;&M-33762;&M-33123;&M-33448;&M-33727;")
("5611" "䖧䗌䗑䘃蜆蜫蝗蝹蝹螕螝蟶蠷蝇&M-33098;&M-33064;&M-33463;")
("5612" "蜎蜗蜴蝎蝟蝪蠋𧍪&M-32980;&C7-2835;&M-33351;&M-33714;")
("5613" "䗾蜈螅螑蟌蟔蠉&M-33312;&M-33324;&M-33647;&M-33767;&M-33853;&M-33311;&M-33439;&M-33813;")
("5614" "蜱蟃蠌蠳蠼&M-33276;")
("5615" "蟬𧏻")
("5616" "䗉蝐蠝𧐋")
("5618" "蛽蝭&M-33206;&C5-5E34;")
("5619" "蜾螺&M-33598;")
("5621" "靚&M-34819;")
("5622" "鬹𠸮")
("5628" "𠷓")
("5632" "𪄯")
("5633" "𢤎𢤙")
("5640" "嫢𡦑")
("5641" "䚉𧢃&M-39505;")
("5643" "𡙭")
("5645" "𤱣")
("5651" "覯")
("5661" "𤾳")
("5671" "䚎")
("5681" "䚍覥")
("5690" "槼耞𦓾")
("5691" "䙿䰤䎱𦓼&M-34886;𦔬𦓵&M-34860;")
("5692" "耦𦓻𦔨")
("5694" "䎪𦔎𦔔𡭂𦓸𦔕𦔥")
("5698" "𦔜𦔂𦔐")
("5700" "㓞")
("5701" "㧩㧪㨕㨮䒋䡕扟扭把抯抱抳拯挽掜揑握摼撧擢攙攪艳艴軐軓軳軽輓輗抱𩖬𢩫𢩰𢪕&M-38227;&M-38216;𠷏&M-38263;&M-38298;&C5-462C;𢹳𢦕𢬆&M-38174;𢦻𢭨&C6-3771;𢭌𢮢")
("5702" "㧅㧇㧈㧕㧦㨄㨛㨝㨯㨶䡔䡘䡧扔扚扪扬抅抈抑抒抝拘拥拸挏挪挶捅捓捔捣捫掃掃掆掏掤掬揈揟揤揶搁搊搗搠搦搰摀摎撊撋擱擲攔畃畅軔軥輖輞輣輷轇邞邦韧鳺鴂鴺挷𨙰𢪃𢦚𨚓𨚗𨊷𨋮𨎫𢺡&M-39297;𢪼𣌨𦐋&M-38215;&M-38226;&M-38277;&M-38259;𢲰𢲾&M-39622;&M-46703;&M-46728;&C5-586C;&M-38433;&M-46902;&M-46838;𢸴𢺄&M-49762;&M-39355;𠜥𢫤𢬃&M-38224;&M-38205;𢰕𢰗𢰄&C6-494A;𢰓𢱳&M-38316;&M-38352;𢶈𢴿𢵁&M-38377;&M-46707;&M-38421;&M-46845;")
("5703" "㧾䡫択拫掾揔換揳搀搌搔搥摓撾擙攭輾𢮋𢶑𢫺𢭄𢷻&C5-6533;𢮞𢮑𢱸&M-38291;&M-38355;𢶂&M-38418;𢷝𢸪")
("5704" "㧶㩔㩭䡑扠扱投报抿拠掇掓搜搬搱摋摒撄撏軗輈輙輟轏摪𢬶𢯫𢩴𢩲𢪈𢮒&M-38225;𢱷&M-38332;𢴼𢶙&M-38486;𢎶𢪄&M-38270;𢱥𢱲&M-38423;&M-38457;")
("5705" "㩣䡣拇择挣挥捀揮摨攑軔𢭎&M-38293;𢺟&M-38222;𢴡")
("5706" "㨉㨨㨱招挌捃据摺擔擼軺輅輑𠲱𨎲&M-38422;&M-38476;")
("5707" "㧮扫掐掘搖輡𢭈𢬞𢮮&M-38307;𢶵&M-38470;")
("5708" "㨠扻换掀掼揿摗撰撳擨擬擹攋軟𢸯&M-38306;𢴪𢷗𢪵𣢘𣢧𢰅𢰑𢶆𢶦𢶖&M-38472;𢸈𢸂𢹰")
("5709" "䡦探揉搡摖輮挅𢳚𢴲挆&M-38244;")
("5710" "䪠墼䪡𩐋𡊷𤩯")
("5711" "䖠䖡艶艷虮蚆蚬蚭蛆蛏蛫蜢蜺蠅蠗&M-32806;&M-33331;&M-33326;&M-33860;&M-33126;&M-33224;𦘣&M-33638;&M-33686;")
("5712" "䖮䖲䖼䗇䳋虭虳蚂蚏蚐蚼蛡蛥蛧蛹蜔蜩蜪蝄蝍蝑蝴蝸螂螐螖蟉蠮蠾鄷酆𧌈𧍕𧑐&M-33018;𦑍&M-33222;&M-33141;&M-33419;&M-47026;&C5-712E;&M-33935;&M-32861;&M-32934;&M-33153;&M-33280;&M-33611;")
("5713" "䗓䗔䗦䗨蚇蛝蛪蝝螁蟓蟿𧌍𧍳𧑄𧒖&M-33636;&M-33646;")
("5714" "虸蚒蛶蝃蝦蟳𧌓𧓬&M-32853;&M-33194;&M-33382;&M-32911;&M-32957;&M-33000;&M-33678;&M-33800;")
("5715" "蚦蛜蜂蠏𧉅𧉯&M-33050;")
("5716" "䗜蛁蛒蜛蝞蟾𧐔&M-33814;&M-49691;")
("5717" "蜬蜭&M-33436;&M-33175;&M-33234;")
("5718" "㰩䗰蝜螟蟤蠀蠍𧐄&C5-6D4C;&M-33826;𣤁𣤐&M-33483;&M-33755;&M-33761;")
("5719" "蝚蟂𧉰&C5-3C22;&C6-4E47;&M-33587;&M-33763;")
("5721" "䪢氂翘靓靘䪣&C7-4B6B;&C7-5148;𧈗")
("5722" "䎘䳙幚觢郕郙郬鵏鶄鷫帮𦚨𦑘&M-46907;&M-47078;&M-47380;𦑆&M-30555;&C7-5F3E;")
("5723" "洯")
("5724" "𣫦")
("5725" "静")
("5728" "㰹歗")
("5732" "鄟鷒𪈐&M-46867;𦒝&M-47323;𦑵")
("5733" "恝𢡴𢢞𢛑&M-46599;")
("5734" "𡬨")
("5740" "㛃𦕥𡢖𡕞𪌛")
("5741" "觏&C7-4578;")
("5742" "䎃䣚郪鶈鷜&M-39504;𡗆&M-47117;&C5-725E;")
("5743" "契")
("5744" "𢍆")
("5748" "𣤋")
("5750" "㸷挈撃擊轚")
("5751" "&M-38206;")
("5752" "䳞鄻")
("5753" "𠜵")
("5760" "㗉䛚礊𠿉&M-40048;𥖳")
("5762" "䣟䣠邮𪂹&M-46827;")
("5764" "毄𣪭𡳧")
("5768" "𣍜")
("5771" "㼤𤮈𣭭𤮛")
("5772" "邨&M-47261;&M-39291;")
("5773" "&C7-5152;")
("5774" "𣪠")
("5777" "罊齧")
("5778" "𣤢")
("5780" "𤉟&M-49737;&M-36894;")
("5781" "规")
("5782" "郏鄪鄼&M-47256;")
("5788" "𣤈")
("5790" "䌠栔檕絜繫")
("5791" "耙耝𦫕𦓨")
("5792" "䎤䣂䣢鵣鶇鶒&M-39337;𦐾&M-46780;𦓥𠣩&M-49775;&C7-364E;&M-47329;")
("5793" "䋤𦫎")
("5794" "耔𦔘")
("5796" "𦓱𦃅𦔢")
("5797" "耜")
("5798" "欶賴赖𦔫𣤭")
("5799" "𣞰")
("5800" "扒拟")
("5801" "㧉㨴㩜䡭扢拖拦拴挩挫捝捡捦掽揓搓搤攬輇轞&M-38265;𢲶𢭉𢶅𢷙")
("5802" "㨣㨵㩉㩶扮扲扴抮挮掄揃揄摥擒擳擶軡軫輪輸𢸄𢶌𢪆𢪅𢵀&C7-3431;𢷔𢹱&M-38602;")
("5803" "㨾䡆䡵扵拎捴捻搇搛撫擌攁螒軨𢮁𢱤𢳇𢸥𢱶&M-38447;𢪌𢮈&M-38379;𤏠𢶕𢹗")
("5804" "㨖㩐㩤㪄拼揜撇撒撖撙撤撴撽擀擏擻軿輧輹轍𨋼𢳆𢳓&M-38348;𢷸𢫹&M-38223;&M-38200;𢲳&M-38563;")
("5805" "㩘挴轙𢯌𢸤𢮡𢴩𢹘&M-38545;&M-38444;&M-38599;")
("5806" "拾捨揂揝搶摿撘撯輍輶捨𢵈𢴣𢶒𢷷𢰈𢲹𢲺𢵄&M-38449;")
("5807" "𢰖")
("5808" "㧿䡮摐撿𢳄𢺅𢭀&M-38388;")
("5809" "㩍㩯捈攥&M-38345;&M-38245;𢸮&M-38556;")
("5810" "整鏊鳌𡏴𢿋𣦔")
("5811" "䗒虼蚱蛻蜕蜣螠𧎵&M-32965;")
("5812" "䗄蚙蚡蚧蜦蝓螉豑骜𧋘䗛&M-33554;蠄&M-33871;&M-33349;&M-33482;")
("5813" "蚣蛉蜙螊螯蟱&M-33560;&M-33776;")
("5814" "䖫䗗䗴蚥蛢蝣蝮蛢𧎄𧑒&M-33323;&M-33025;&M-33185;&M-33492;&M-33656;")
("5815" "䘊蛘蟻&M-33821;&M-33865;&M-33129;")
("5816" "蛤蝤蟮&M-33073;&M-33188;&M-33457;&M-33869;")
("5817" "&M-33046;&M-33227;")
("5818" "䗥蜁&M-33478;&M-33739;")
("5819" "蜍")
("5820" "𠩺")
("5821" "釐靝")
("5822" "剺𢄡")
("5823" "漦𣸗𢟤&M-46448;")
("5824" "嫠孷敖敷𢾾𢽊𠭰𢼆𢼋𣁟𣀣𢿍")
("5825" "犛")
("5826" "𧫬")
("5829" "斄𣘬")
("5832" "驁鷘")
("5833" "慗懯熬鰲𢚅&M-46465;")
("5834" "𢾭")
("5840" "聱")
("5843" "獒")
("5844" "數𢍛𢿙")
("5850" "㧳摮")
("5860" "&M-35695;&M-35898;")
("5864" "𢾜𢆟")
("5866" "𦧶")
("5871" "㲠鼇")
("5877" "&M-48719;")
("5880" "贅赘")
("5884" "敟")
("5890" "䎣")
("5891" "䎢𦓰")
("5892" "耣𦔟")
("5894" "敇敕𢼡𢽬𦔞")
("5896" "耠𦔦𦔡")
("5898" "𢖗")
("5901" "挄捲摚輄&M-38382;𢶇&M-38497;")
("5902" "抄挱捎撈輎𢮐𢮙𢯭&M-38378;")
("5903" "攩𢪍𢷥")
("5904" "搂撐𢬰")
("5905" "拌搼撑撛轔&M-49759;")
("5906" "擋𢹙&M-38546;")
("5907" "挡")
("5908" "掞揪𤆎𢱡𢹔&M-38419;𢴵𢸱")
("5909" "㩒㩞𢴤")
("5911" "蜷螳")
("5912" "䖢蛸蟧𧌽&M-33820;")
("5913" "&M-32906;&M-33449;&M-33637;")
("5914" "蝼&M-33870;")
("5915" "䗲")
("5916" "蟷𧍖&M-33874;")
("5917" "&M-33726;")
("5918" "䗊&M-33394;")
("5919" "蠑𧎾&C7-3266;&C7-3B47;")
("5921" "靗")
("5962" "𡮦")
("5992" "耖耮𦓴耥")
("5994" "耧")
("5996" "𦔄")
("5998" "䎦")
("6000" "口囗罒")
("6001" "㕸㖢㬯㽘䀮䁴吭唯啦喨噇噰囃暀曈甿疃盳睢瞳𠰍𥉶𣆖𠴹𥆜𠿞𣋊𥋨𥍃𡅹𣅇𠵷𠹂𡄸𣌖")
("6002" "㕫䁎䁤哜哼唷啼喭嗃嗙嘀嘃嚌昉眆瞝𠲗𠻗𠳻𠶴𠴽𣉽𠿘𡄘𤳬")
("6003" "呟嗻噍噫嚎嚷昡眩瞧𡂘𠹋𠻫𠻞𥈚&M-34463;𤳌𥉽𡂓𣋟𡃩𥌜𥌾𡆡𣋳𡄖")
("6004" "㖕㖡㘐䁹呅咬唼啍啐喥噼旼晈晬暲盿睟瞕𥇜𠻜𡁈𥅟𠻎𥌍𠵒𥇒𥊁𡃥𥌲𡅼")
("6005" "𠲲")
("6006" "㖣㗜唁喑暗瞊𠹔𠳺𠶧𥈛𠽜𠽪𥇋")
("6007" "𠷄𡁫")
("6008" "䀭咳嚝晐曠畡矌𥊆")
("6009" "㗱䁁嘛晾𠳹𡅁𥈘")
("6010" "㫔㫫㬪㽮呈呈囯囶囸国圔圼墨壘日旦星昰昱昷显曐曡曰疊目罜罝罡罣罿里量疉𦊂𥁕𣈍𥁯𡇓𡈀𦋳&C5-5155;𣋣𥃇𠮡𡆨𣄾𡇆𡆷𣅋𡇉𣅣𦉷𡋘𣌬𡋵𣆞𣆹&M-40137;𡇽𥁰𠘀𠹜𧖸𠻖𤲲𦋠𤳏𡈮𤴁&M-41006;")
("6011" "䟘䟽晁罪跓踓蹗蹱躔雖𨆁&M-37792;&M-38019;𣆷&M-37514;𡈚&C7-5575;&C7-5D37;")
("6012" "㘤䠙勗昮昻蜀趽跻蹄蹢躋𦉹𦐇𨃤𦋅𣉛&M-37703;𠧥𠕥")
("6013" "暴罫虽跡蹠躟&C5-2F26;&M-37827;𡇋&M-49682;&M-33233;&M-33456;&M-33523;&M-37839;&M-33710;𤴂")
("6014" "晸最跤踤踥踱躃躕𨇯&M-37517;&C5-4344;&M-37559;𡆴&M-37601;&M-37704;&M-37749;")
("6015" "國罭")
("6016" "踣踮&M-37734;𦌕&M-37754;&M-37873;")
("6017" "囙&M-39270;")
("6018" "&M-37500;&M-37771;&C5-744A;𦍂")
("6020" "号曑𦉬𦊃𣄿𠰡𡇘𡇕𠕝𣆚𠻝𦌀")
("6021" "㒻㒾㘢㫕㫯䍜䍡䍥䍦兄四囥园囮晃罷見𦌿𥃺𣅷𡇰𣋍𣌅&M-45945;𠯚𡆶𡇗𣆧𡇹&C6-4057;𦊫&M-34857;𦋤&M-34865;&C7-2A60;𦋾&C7-4453;&C7-4B4C;")
("6022" "㫹㬅䍤叧吊呙囧囫囬囿圀圃圇圊圌圐易昘昜昦昺晑晜暠曏畀界罞罤罥罱罽羃肙胃冐㘣𣅻𥅙𠕦𡈪𥊽𠕰𠮠𠱮𦊈&C5-3042;𢑢𡈌𦋞𡂗𡇇𡇊𥄊𦊤𥅫𥇴&C6-5722;𠚙𡈖&M-48324;𣋥𣍓𦌫𦍇")
("6023" "㫤㬄囦圂園晨曧眔罛𥄳𡙷𦊽𦋯𥅀&M-36348;𡈭")
("6024" "䍓团罻𦌠𦋉𠰎𦋲𣍑𡅝𡅾")
("6025" "晟𦌬𠕠𥅛")
("6027" "𣇯")
("6028" "昃𣋷")
("6030" "㫡囹图𦊓𠮚𠯁𠘗𦌻")
("6031" "&M-48065;&C5-6121;&M-48190;")
("6032" "䴎罵鷕𡈊&M-48148;&C5-7743;&M-48194;𢘖𡈎𡈙")
("6033" "㘠㤙㫱㬎䍢思恩惖愚慁罳罴羆黑黒𡿯𢝝𪓃𠮰𢜹𦋰&M-48198;𢘇𥄧𢙍𢙶𢚊&M-39316;𢛝𢝮𢝕𤋁&M-46065;&M-48184;")
("6034" "㝵㝶䙷団圑團&C5-6F55;&M-48115;𥃷𡈣")
("6036" "黯")
("6038" "𦌸&M-46524;")
("6039" "黥")
("6040" "㘝㚻㫗䍐䍟咠囝囡図圉圛早旱旻晏曱曼田畟睪罦罩妟嘦𤰞𥄎𦌁𥃪𣅝𤰠𡢑𠯊𣅐𠭁𡇔𡜑𣆉𤰯𥄐𡜰𡜸𠵀𤲋𤲜𥇝𥇡𣊴𦌃𡦩")
("6041" "㒿䨃䨉冕旯𠕤𡇲&C7-2A5E;&C7-3D40;&C7-3D41;&C7-5574;")
("6042" "㘞另男禺𣋶𣈦𠢿")
("6043" "㕦䍔吴因奰旲昊狊𡈗𡗽𣅳𦉼𦋆𡚤&M-36987;")
("6044" "㘟㫒㬊昇昪最罬𥃲𥃲𢌿𢍰𣈠𣁜𡇄𡆼𣅹𥅳𢍧")
("6050" "㘡㽚䡞圍晕暈曅曓甲畢罼𠰅𦋈𣌦𣅼𠦤𦊏𤲃𦎝𣊚𦌂&M-38463;𢸇𦌭")
("6051" "㬮𦍀𡆎")
("6052" "围羁羇羈𣆽")
("6054" "𦌖")
("6055" "囲𤳅𦍈")
("6060" "䍛䍝冒吕呂啚回固囼圁圄圕圖圗昌晷暑畕畧碞礨罟罯署罶罾詈謈冒暑𦊔𦊾䍣𠰝𡇈𠱑𣆗𥄲𡇱𦊴𡈉𦊼𦋿𠯮𣅊𡇌𡇍𡇢𡇪𡇣𡇡𠴿𡇵𡇾𡈇𡈕&C6-5B59;圖&M-35773;&M-35953;")
("6061" "&C7-3D43;&C7-5D38;")
("6062" "罰𡇳𦊒")
("6063" "𡈟𣊕𥌡")
("6064" "冔罸𦊯")
("6066" "品晶畾瞐𦌵&M-34858;𦋹&M-36132;&M-36133;")
("6067" "&M-42692;")
("6069" "𡈸")
("6071" "㒽㫐䍖囤囵圈圏昆毘罨置邑鼂黾𣅖𥃩𦉾黾𦌡𡆳𡇖𡇠𦊳𦊐𡆠𡆲𡆰𠯕𡇃𤰣𥄀𤰵𦊁𣆠𣇣𦋋𦋍&C7-352C;&C7-366D;&C7-3D42;𢁐𣰭𣰸&M-48295;")
("6072" "䀚昂昴曷罚𡇼𠮲𡆸𦊑𣋓")
("6073" "䍗䍚囜囩圜昙曇曟曩畏睘瞏罢褁𡆩𡇁𡆻𡆾𡇎𡇴&M-34592;&C7-452A;")
("6074" "䍕囻罠𦌩𡆿𠷛")
("6075" "𡈑")
("6077" "喦嵒旵罍𡇑𦋣𡾔𡶩𡆵𡶸𣅽𣆻𣆵𠕣𦊿𡈘")
("6079" "㘥𡈱")
("6080" "㬃只员員囚圆圎圓圚昗是炅異貝買足具呉𡆣𣇳𧻻𦌔𤇀𠶵&M-37423;𠯵𠔓𠴩𣇪異𣈩𦋊𠔱&M-48039;𣊂𦌷")
("6081" "䝬貥賍&C5-7444;&C7-2A5F;&C7-5128;")
("6082" "𦋴&M-36868;")
("6083" "䝮𧸖&M-36966;𦌣")
("6084" "賋賥&M-36848;")
("6086" "賠𧶆")
("6088" "眾賅贔𨆬𡈍𦌗")
("6089" "䝶")
("6090" "㫧㬌㬥㬧㮂䋰呆喿困囷圞景杲果櫐累纍罘罺䍒䍘𦃙𡈳𠕖𠰓𡇒𦊧𦊜𦋡𦌆𦌒𦅔𦍁𡆧𦊎𥅼𦀤𣉰𡈢𦌮&M-28395;𡈷")
("6091" "罹羅𡈏𦋽")
("6092" "䯫羂𡇿𦌢")
("6093" "𦌶𦌾𦌟&C7-5F3C;𦍆")
("6094" "羄𠕭𦌉𦀒𦋝𠕮𦌅")
("6098" "𦌊𦌪")
("6099" "圝罧羉𣇰𣊡𡈹")
("6101" "㕶㖶㖸㗾㫵㬁䀴䁦叿吡呃呒呕呲呸咂咓咥咺哐哑哣唖唬啀啞啡喱嘔嘘噓嚦嚧嚨嚯囇旺昛晅晊暅暱曤曥曨曬毗疅盶眍眐眦眰眶睚矐矑矓矖嘅瞘𠲮𥄷𣇥𤱥䁥叱𠮵𠯔𠯡𠰐𣅥𥃽𠳍𥅨𠸳𥆚𥆦𠹌𠹿𥇞𣉓𥈂𤮋𥉿𡁓𡃢𥌮𠯞𥆆𥆖𥆍𣈶𠼕𣉖𤭳𥈔𠽥𠽧𣉾𥉢𠿙𠿜𡁭𡂥𡄊𡅗𣌟")
("6102" "㖇㘅㬏㽭䀎䀪叮呖呵咑哬啃啊啢嗎嗝嘕嘴噖嚅曘曞町盯眄眪𠮱𠯗𥅡𥉅𡂖𣆝𠶪𥇑𥉊𠿎𠿛𥌃𡄣𥃳&M-23126;𠻢𠽴𥊕𡁑𥋃𥌎𡅿𥍗")
("6103" "㖘㬉㬡䀖䀼吓呍咔啄噁噱噳眃𠱚𠳃𤱼𥇔𤲬嚈𠯝𠷀𥆋𥈇𠿗𤳟𥋞𥄆𠴴𤲘")
("6104" "㗔䀘吁呀呯咞咡哢哽啅喓嗄嗕嗫嘑嘾嚘囁旰旴昄晫曋畈盰盱眅眲瞫咞䁏𠯘𤰟𣆳𠷋𠷊𠰑𠱢𠳰𣆙𠹘𥇍𡁁𡁇𡂩𥍉𠶺𣌍𣌘")
("6105" "嘎噦𡂣𡅺𠻔")
("6106" "㘊㬐䀡䁮呫咟哂唒唔喈喕喖噆晒晤𠸸𠳱𠵠𠼘𥅭𥆐𥈅𥌼")
("6107" "嚙𥄝𠶲")
("6108" "㖽㘖䁰嗊嗔噘噸嚬暊瞋𥈗𥈿&M-43483;&M-43502;𥋣&M-43630;𥌨&C5-795A;𠯬𣊠𣊥𥊂𥋄&M-49887;𡄙𡄶")
("6109" "㬓吥喍嘌眎瞟呩㗚㗪𠱙𠱟𠹦𥄙&M-23200;𥈐𠾋")
("6110" "㙱𧰑")
("6111" "䠊䠡趾跐距跮踁踂蹮躘躧𨁶𨂷𨂿𨄅𨆱&M-37411;&M-37455;&M-37483;&M-37495;&M-37576;𤭼&M-37664;&M-37989;&M-37986;𣌜&M-37377;&M-37421;𤭺")
("6112" "䟓䟚䟰䠃跒踄蹐躎&M-37971;&M-37380;&C6-3C40;&M-37725;&M-37902;&M-37988;")
("6113" "䠆躆躚𨁿&M-37422;&C7-4362;&M-37894;&M-33806;&M-33938;&C7-6370;&C7-6541;")
("6114" "斀硏趶趼踔蹑蹰躡趼𧿂&M-37710;&M-37831;&M-37966;&M-37565;")
("6115" "䠩&M-37395;")
("6116" "跕跖跴踾䟯&M-37561;&C5-696E;")
("6118" "䫳蹝蹞蹶顕𨆌&M-43393;&M-37857;&M-37915;&M-37959;&M-37665;&M-37626;&M-37674;&M-37885;&M-43646;&C7-5F62;")
("6119" "&C5-5E78;䠕&C5-6970;&M-49746;&M-37509;&M-37800;")
("6121" "號瓹𧇼𥍕")
("6122" "&C7-6473;")
("6124" "敡&M-48325;")
("6128" "䪽顎颚𩕾&M-43432;&M-43709;")
("6131" "黖黫黸&M-48239;")
("6132" "&M-48161;")
("6133" "㸃&C5-7875;𢙸𠾦𢤃")
("6134" "䵟䵦&M-48104;&M-48171;")
("6135" "&M-48216;")
("6136" "點")
("6138" "顋顯&M-43486;&M-48160;")
("6141" "㼴𦥁")
("6142" "&C5-7C23;")
("6144" "㪋𢿕")
("6148" "顒&M-43749;")
("6150" "𡁉&M-43104;")
("6151" "𧈍")
("6153" "辴")
("6162" "𤳠")
("6164" "㪞")
("6171" "&C7-4C26;𤮦")
("6173" "饕&C7-5153;")
("6174" "𢆜")
("6178" "䫘&M-43426;&M-43468;&C7-3553;")
("6180" "㷡㼵匙煚題")
("6181" "䝽䞁貦贚&M-36795;")
("6182" "&M-36927;&M-36971;")
("6183" "䞂賑賬&M-36689;&M-36794;")
("6184" "販贉&M-36853;𣀕")
("6185" "&M-36948;")
("6186" "䞅䞊貼&C7-503F;")
("6188" "䫟𧶸&M-49886;")
("6189" "&M-36715;")
("6190" "𣜍")
("6191" "㼫𣘫𤮉")
("6194" "敤𢿾")
("6198" "顆顥颗颢&M-43549;")
("6200" "㖄㘌㫼䀕吲咧哵唎唰喇嚠甽𥃧𥇕𠰙𥃹𠴼𠷌𥈙𠮧𠛭𠜠𠜟𠺓𥋠")
("6201" "㕰䁗䁽吒吼咝咷唾啂喠嗁嗈嗺嘊噔晀暟爴畽眊眺睡瞪𠮜叽𤱩𠽶𥉘𠿓𡂏𥃤𠰋𠲷𠴯𥆙𠹛𣇦𠽲𣋲𠮪𥄩𥄄𥄼𤔗𥆎𣈧𠾊𥊅𥋍𤳶𡅘")
("6202" "㖗㬙㬞㽯䀐䀿吖听哕哳唀唽喘嘭嘶嘺噅昕晣晰盺𡄴𥍋𢒯𣂽𠰗𥈋𣊙𣋌")
("6203" "㕭㗭䂅吆呱哌嗘嗤噗暌曛眨眽睽瞨矄吆畖𤰕𠰈𤰝𥉐𠰏𡁋𥃼𥇐𠻯𤲺𥉍")
("6204" "㖟㗶㫝㫞㬭㽟䀒䀽䁓䁔䂃吀呧呼哔哷哸哹唌唩喛噯嚼暖暧曖眂眡瞹𠷑𣆴𠲺𥆑𠸷𥈒𥍚𠲐𥅢𠶽𤲫𥋀𡆑")
("6205" "嘰睜瞬")
("6206" "㖃㖔㖧㗍㫟䀨咶噃睧瞃𠴲𠹗𠳂𥅠𣇲𠽹𥆠𠼜")
("6207" "㕳㗀㗖咄喢昢嗂𥉰𥈊")
("6208" "𤲖𡂒𠽭𥉚")
("6209" "㗼咊啋嚛睬𠹀𠻥𥊈𥋙䁻𥌣𣋵𠷘𤲎𡁖𥌭")
("6210" "㓻劅𠞈𠠯&C5-2B4D;&M-37424;𥂄&M-37803;𠠡")
("6211" "䟬䠪毾跳踵蹏蹬躐㲲𣭻𣯎&M-37660;&C5-652C;&M-37855;&M-37908;&M-37367;&M-37538;𣯉&M-37591;&M-49752;")
("6212" "䟷踹踽蹦蹻&M-37534;&M-37573;&M-37977;𢒡&M-37833;&C7-4A65;&M-37978;&M-38011;")
("6213" "㼔䟪䟴䠏跃跅跹蹊蹼&C5-3C61;&M-37611;&C5-714C;&C7-504A;&M-37950;")
("6214" "䟗䟡䟦䟹跸踒蹳&C5-514E;&M-37702;&C7-3427;&C7-4361;")
("6216" "踏踲蹯")
("6217" "䟖蹈躖&M-37468;&M-37723;&M-37976;&M-37405;")
("6218" "踬躓")
("6219" "跞踩躒&M-37805;&C5-7A3B;&C7-3C3D;𥣷")
("6220" "㓵別剐剔剈𠞋𠞍𠞫𠟔")
("6221" "氍𧠘&M-34814;&M-34851;")
("6222" "𣂿𢒗𢒠𣂨𢒧𢒦𣃊𣃖")
("6224" "𠭙𡥺𡕺")
("6226" "𥆞")
("6229" "𥟙")
("6230" "䵞𠠁")
("6231" "䵝䵯𪐞𣮊&M-48201;&C7-5E41;")
("6232" "&M-48085;&M-48162;&M-47299;")
("6233" "𪒢𢥽𢝔𤋇")
("6234" "&C5-6B5D;")
("6236" "䵬&M-48120;")
("6237" "黜")
("6240" "别𠟎𠜹𠞅")
("6241" "𣭸")
("6243" "𡚇")
("6260" "𠳇𠷒𠟟𠟑")
("6261" "毷")
("6262" "㫀")
("6270" "㓭")
("6271" "毼𥇾&M-44011;")
("6273" "&C7-5644;")
("6277" "&M-48793;")
("6280" "㓳則𡺔&C6-345A;𦧪𠟻")
("6281" "㲘&M-36764;")
("6282" "&M-36783;&M-36845;&C5-695E;&C5-695F;&M-36685;")
("6283" "貶&M-36762;")
("6284" "貾&M-49735;")
("6287" "&M-36849;&C7-3369;")
("6288" "&M-36973;")
("6289" "&M-36905;")
("6290" "㔀劋𠜴𠟘")
("6291" "氉𣮔𣮰")
("6292" "影")
("6293" "𤬁")
("6294" "𢒳𣚤")
("6300" "䀣卟吣咇𥃨")
("6301" "㕱㗌㗧㽙吮呝咙咤哤唍啌啘喧噈噻晥晼暄畹睆睕睻𥄻𠲪𠴧𥉓𥉺𣅸𠻩𠽱𠾰𥊱")
("6302" "㽩䀯咛哺嘇嚀晡眝矃𥊀𠱝𣇬&M-23315;𡅶")
("6303" "㫰㬗䀵䀶䁭吠咏哴唉唳嘫囐昹畎眿睙𠹁𠿑𣅤𠴃𠷂𠷖𥊶𤳒𡂔𥋰")
("6304" "㕹㗘㬍唆嚩晙畯咹睃𥈃𠱔𥄜𥅞𠷃𠿆𥉛𣇚𥅥𠻕𠽬𠽢")
("6305" "㖅㖑㖪㘍㽣䁍哞哦哰喊喴嘁嚱晠眓眸睋睵𠲎𥆏𥊬𠲌𣆒𠷧𠷼𠸹𠻏𥇿𠽦𠿠𥉷𡄑𥍀𥅜𥅩𠽤𢧷")
("6306" "咍喀嗐噾眙瞎𠹒𥈾𠹍𥊉𠺀𠽨")
("6307" "嘧昈𠯖𠴨𠹓𥉴𥄅")
("6308" "㘔啶瞚矉𥄴𥇓𠻤𠽰𡄓𡁃")
("6309" "嚓曗𠰲𥄵𥌀𠾯𥊻")
("6310" "䟔䟤盢")
("6311" "䠁跎踠蹴躥&M-38016;")
("6312" "蹁&M-37586;")
("6313" "䟮䟵蠈踉蹨𤟩𤢜𤡴&M-46084;&M-37901;")
("6314" "䟼跋踆&M-37804;")
("6315" "䟠䠞戢戥戵踐蹿&M-37929;&M-37996;&M-38029;")
("6316" "跆蹜&M-37689;")
("6317" "䠉")
("6318" "&M-37995;")
("6319" "䟣踪")
("6321" "&M-45803;&M-34986;")
("6323" "猒")
("6325" "㦹𢨐")
("6330" "&M-48043;")
("6331" "䵨黦&M-48060;")
("6332" "黪黲")
("6333" "㦔默黙𢣉&C7-605C;")
("6334" "黓黢黢")
("6335" "黬𪑝&M-48177;")
("6336" "&M-48140;")
("6340" "𠨃")
("6343" "𤢕")
("6345" "𢧀")
("6352" "𠿽")
("6355" "戰")
("6360" "䁿𥊷&M-42684;")
("6363" "獸")
("6364" "&M-40019;")
("6365" "𡃣")
("6380" "&M-36657;𡄱")
("6381" "䝹")
("6382" "䝵貯贂&M-36976;")
("6383" "賕")
("6384" "賐賦賻贆&C5-432C;&M-36740;&C7-4A45;")
("6385" "戝賊賤賳贓&M-36769;&M-36797;&M-36735;&M-36758;&M-36916;&M-36904;&M-36939;&M-36933;")
("6386" "貽")
("6387" "&M-36912;")
("6389" "賩")
("6400" "㬣䀞叫叶吋呌呏咐嘝嚉旪时𠷻叫")
("6401" "㕤㕪㗐㘆㘕㽢䀓䁆䁱叱吐吪呓呭咾哇唵啿喳嗑嘵噎嚾晆晻暁曀曉畦眈眭睦睳瞌矔𥈩𥈻𥉑𡀽𣋞𣅟𥄒𥆈𠷸𠷆𠹆𠻨𣉒𣉪𠿅𡄳𥌯𣌓𥃸喳𣉊𥉂&M-49373;")
("6402" "㗢㗣㫑㽖䀷叻吶呐呦咘咵哊唏唠喃嗋嗬嘜嘞噧噶嚆囒晇晞暔暪畸眑睎瞞𥅚𡂕𥌋𣅚𠰖𣅺𥄋𠲵𤱎𠴳𠶾𥇟𥇚𥊪𡁐")
("6403" "㖁㽠㽧䀹䁐䁧吰呔呿哒哝哧唊嗼嘆噠嚇嚥囆囈暎暯暵曚曣瞙矇䀹𤳉𡁏𥋢𡃨𥌩𠯈𠳷𠶫𠹤𠻟𥊸𥋿𥌞𠰵𠹅嘆𠹎𠻛𤲻𥉖𥍂")
("6404" "㫲㫴㬒㬦䁄䁳吱哎哗哮哱哶啈啵喯嘙嚄嚋時晔畤疇睖矆𠱥𤱍𠿺𠱜𥅗𠵃𥆔𠹊𠻱𠿤𥌆𣅢𡜭𥄏𥄌𤲔𠻶𤲵𠽿𥊊")
("6405" "㗆䁾喡嘩暐曄瞱哶𠶿𥆶𥈖")
("6406" "咕咭哠唶喏喵嗒嗜嘻暏暿睰睹瞄瞦矒𣈏𠻧𠽻𥉙𥉌𠳈𠽳")
("6407" "咁𠷅嚿𠴢")
("6408" "䀧咴哄唗唭噴嚏嚔囋晎曂𡂝𤱨𥆥𠿝𡀺𥌚&M-04409;𥌪")
("6409" "㕲㖠㖼咻唻啉喋嗏嗦嘹噤囌晽暸睞瞭瞸𤲓䁋𡂠𠱞𠻬𣊝𠴬𠿚")
("6410" "斣跗𠦫&M-37410;𡬺𥁻𡭈&M-37859;")
("6411" "䠑䠰跇跣跬踛踸蹅蹺𧿒&M-37401;&M-37537;&C5-514C;&M-37632;&M-37799;&M-37892;&C6-4534;&M-49750;&M-37832;")
("6412" "跨踦蹒蹛蹣躏躪䟜&M-37893;&M-37768;&M-37735;&C7-5045;&M-37926;&M-38030;")
("6413" "䟩躂𨁂&M-37593;&M-33855;")
("6414" "㿺跂跛跱踍踜躊䠜𨇨&C5-5152;𢻧&C5-7651;𤿮&M-37484;&M-37510;&M-37622;&M-37663;&M-37891;&M-37956;")
("6415" "&M-37505;&M-37695;&M-37696;")
("6416" "跍踖踷蹃躇躤𨃚&M-37508;&C5-4A44;&M-37828;&C5-652A;&C7-4A60;&C7-5541;")
("6418" "跿踑蹎躜躦&M-37974;&M-37751;&M-37911;&M-37943;&M-37975;&C7-6376;")
("6419" "蹀&C5-5E7A;&M-37909;&M-37618;&M-37667;&C7-3C3C;")
("6421" "䙸覐𡎯")
("6422" "㔥")
("6424" "𥀦𪔈&M-32441;")
("6431" "黕黤黮&M-48150;&M-48227;&M-48199;")
("6432" "黝&M-48152;&C5-7979;𢣢&C7-6652;")
("6433" "𪐝𪑿&M-48064;&M-48235;𤋰")
("6434" "&M-48121;𣌏&C5-7C4A;&M-48183;")
("6435" "&M-48224;")
("6436" "䵭䵱黠&M-48176;")
("6437" "黚")
("6438" "黩黰黷𪒰&M-48090;")
("6439" "𪑚𪑧&C5-6B58;&C5-7278;&C7-5258;&C7-525A;")
("6444" "𤿧𥀗")
("6453" "𤲍")
("6454" "𥀕")
("6460" "&M-37898;")
("6461" "𤴀")
("6462" "㔣勖")
("6464" "𢻪𥀴")
("6472" "㔠&M-39372;")
("6480" "財韙&M-36672;&C7-652C;")
("6481" "貤&M-36686;")
("6482" "䞈勋勛賄贎&M-36981;")
("6483" "&M-36752;")
("6484" "䝸䝰&M-36684;&C7-2932;&C7-336A;")
("6485" "贜")
("6486" "賭&M-36723;")
("6487" "𧵊𡁩")
("6488" "贖𧷒&M-36917;&M-36940;&M-36991;")
("6489" "&M-36806;")
("6491" "𣜣")
("6494" "𢻔𢻥&C7-6059;")
("6495" "&M-43016;")
("6500" "㕩㖀㖂吽呻唓畊眒盽𠰜𣆘𠷈𠵡𥆓")
("6501" "㗲吨哓嚍旽晓甠盹𠹃𣉗𥊮𠮬𤯠")
("6502" "㬘䀟䀻咈啨嘨嘯昁昲晴睛𥄔𠲽")
("6503" "㘑㫙㬩䁃䁸吷呠呹咉咦嗹噥嚖囔映昳曃畉眏眣眱瞣䀗𣅡𤰮𥄑𠵢𥌰𣇨𠻣𣋏𥊵𡂞𥌿")
("6504" "㗕䁣唛啛嘍囀暷畘睷瞜𥉇𠸻𠳴𠶭")
("6505" "呥唪")
("6506" "㖆㖺嘈晧暙睶𣉿𡅰")
("6507" "嘒暳")
("6508" "㫸唺啑啧嘖嘳晪曊睓睫瞔瞶𡂐")
("6509" "㖦䀳味咮嗉昧昩暕眛眜睐嗪𠲿𠰌𠲋𠱤𥅦𤲚𥉜")
("6510" "跩&C6-4531;&M-37513;")
("6511" "跷&M-37936;")
("6512" "䟛&M-37441;&M-37440;&M-37849;")
("6513" "䠈趹趺跌跠蹥&C5-5860;&M-37596;")
("6514" "踌踺&M-49747;&M-37809;")
("6515" "&C5-5153;")
("6516" "踳蹧&M-37862;")
("6517" "蹖&M-37546;")
("6518" "䠄踕蹟蹪&M-37964;")
("6519" "䟱跊跦踈&M-37445;&M-37525;&C7-3C41;")
("6521" "&M-34893;")
("6523" "𣉺")
("6524" "&C7-4C49;")
("6530" "𪑯")
("6531" "黗&M-48053;&M-48054;")
("6533" "𪒡𪒜&M-48219;")
("6538" "&M-48193;")
("6539" "䵢")
("6541" "㽒")
("6543" "𢾔")
("6555" "𣫹")
("6561" "𤳭")
("6580" "賗韪𣈡&M-36967;")
("6581" "貹贐")
("6583" "贃&M-36716;&C7-5C71;")
("6584" "&C5-646F;")
("6585" "購")
("6586" "賰")
("6588" "賟𧸃")
("6600" "㕷㖥䀠吅呬咖咱咽啝啪嘓昍睏𠴱𠯐𠱠𥇘𤲭𠰸𠱖𠳁𠷝𣋗")
("6601" "㖏㫛㫜㬈㬬䁛䁜䁼䂂呪呾哩哯唈唣喅喤嗢嚜嚫囉晛暒曪眖睈睍睲瞡𠴡𠴺𠷚𠹇&C5-4641;𥉎𡆆𣆿𥆢𥆰𥆒𠹡𥇊&M-34881;&C7-3B6A;&M-45894;")
("6602" "㗁㗄㬂䁑呺啺喁喝喟噣晹暍暘畼睊睗睤矊矏𠴭䁌𠲸𠷟𠹥𠿋𠸵𥈎𠿐𠿥𥋛𥌗")
("6603" "䁫䁵喂嗅嗯嘿噮嚃嚗曝瞁𠱐𠷉𥉀𥌁𠶼𠾪")
("6604" "㘁㘙㽡䁒䁺䂄哻唕啤嗥嘬嘷噑嚊嚶晘暤暭曍曎曮睅睥暥䁙𥍓𠷾𠶻𠻦𥊴𥌽𣌗𠷙噑𥋭")
("6605" "呷嗶嘽暺")
("6606" "唱晿曙𥈆𥉞𡄗𣌈𡅜")
("6608" "㖷䁚呮哫唄嘪睼𥆘𠹚𥇏𡄷𡅙𠽯𠽮")
("6609" "噪暞暻矂𥉒𣇫𠹑𥉹𤴈𥍔")
("6610" "䟧䠅壨瞾跏踟鑍𠶬𡓿𠱯𥆤𠹈&M-37572;𡀓𡓶𡅚")
("6611" "躣䠘&M-34878;&M-37583;&M-37584;&C5-7A3D;&M-38031;&M-49749;&M-49774;&M-37662;&M-49782;&C7-5554;&C7-6442;")
("6612" "踢踼蹋躅骂&C5-4A35;&M-37945;")
("6613" "䠐䠗𨆰𧕦𧕦&M-37968;&M-33317;&M-37758;&M-37918;&C7-6267;")
("6614" "䠋躩𨁽𠵪&M-37557;&M-37853;&M-37914;𠹣")
("6615" "䠤蹕&M-37449;")
("6616" "䠦")
("6618" "䟺䠝踀踶&C7-4364;")
("6619" "踝躁&M-37733;")
("6621" "㒭咒瞿覞覨&C5-4A7B;𠻰")
("6622" "𥉁𥌂𠳯𥋡&C5-7C2D;𢃋𥋬&C7-4223;𥌖&C7-657C;")
("6623" "&M-36384;")
("6624" "㗗嚴𡆉𡃫𡅔𡅮")
("6625" "䑝")
("6630" "&M-48130;")
("6631" "䵣䵪&M-48102;&M-48067;")
("6632" "䵮喌駡鷪鸎𪑦")
("6633" "愳𪒾𢠸&M-34953;&M-48244;")
("6634" "&M-48202;")
("6639" "䵲")
("6640" "㖾嬰斝矍𥆣𥊿𣉬𥈍𤕧𥊐")
("6641" "𥋥&M-34998;&M-39501;")
("6642" "嬲𤲶𠾧𢣲")
("6643" "哭𥈀𥈏")
("6644" "𥈪")
("6650" "㖐單𢦸")
("6651" "&M-45800;&C7-4B25;")
("6656" "𤲰")
("6660" "㽞嘼譻&C5-654D;𡃷𧮥𤴑")
("6666" "㗊嘂噐器嚚嚻囂𠾖𡅻𧮣𡼚𡄹𠾅𡂨𡄛𤳳𤳹𡅱𤴄𡅽𤴇𤴌𣡺𤴐𦉩&M-47526;&M-47527;")
("6669" "𤳻")
("6671" "䣈甖鼉鼍𠻌𥋁𣰡𠸶𣰣&M-45888;&M-39673;&C7-5555;")
("6672" "㕺咢")
("6673" "𦤪")
("6674" "𤕦𠽽𡄉")
("6677" "罌𦦄𡷇𦈯𡼯")
("6680" "焸煛𧶞𧡨𠸭𠽝𠽸𥋫")
("6681" "䚋䚑䞋貺")
("6682" "賜&M-36959;")
("6683" "&C6-5857;")
("6686" "賵")
("6688" "䁲賏𤑽")
("6690" "𠷽𠸱")
("6699" "槑")
("6700" "𤰨")
("6701" "䁅䂁叽吜吧呢咀咃咆唲喔嚁嚵昵晚晩晲曜眤睌睨矅𥃵𥄿𥋝𠮙𠰘𥃴𠱲𠱓𠱨𠲶𠳉𤱌𥄹𠴶𥅧𠷍𠽵𥉝𥉸𠽼𣋋𣄻𠯎𠱎𣅴𥃶𠲫𠱱𣆓𣆜𠴾𥅣𠷕𠾁𥉗𡁅𡂑&M-43250;")
("6702" "啕啣啷喎喞喲嗍嗚嘐嘟嘱嘲噊嚪囑旫旳昀明昒昫晌晍晭曯朙畇疁盷眀眗眮眴眵睭瞗瞤瞩瞯瞲瞷矙矚鳴鸣嗗𠯜𤰩喐𠶸𡅭𠮭&M-39275;𠰄𣅉𠱣𠱳𥄛𥄞𠲾𥄸𠴵𠵑𠵹𠴷𥅬𥆌𠹕𥈓𠽫𥉄𥉾&M-46858;𡂛𡃦𥌻&M-47334;𠮤𠳀𥄶&C6-3D7C;𤱬𥅹𤲮𤲹𥊺𡄠&M-47134;&M-47214;&M-47264;&M-47296;𡆏")
("6703" "㖨㗋㗓㫽㬇㬋䁩咚哏唿喉喙喚喫噢昸眼睩睺𤱞㗻𠲹𠹖𣉔𥈉𠿔𡂙𥌐𥌛𠰿&M-03952;喫𣇤𠹏𥈑𥉕𡁂𡁬𡁄𣋉")
("6704" "㖩㗇䀑叹吇吸吸吺呡呶唚啜嗖噚噿昅暇畷眠睱瞍矎𠴫𠿍𡁕𥃫𥄗𠲴𠲳𣆔𠶩𣆲𥆉𠻍𣉜𥉟𡀿𡄔𠯍𣅧𤱕𠴪𠸀𠺏𠿊𡁒𥋂")
("6705" "㖓䀱吚呣喗晖暉睁睴𠹙𠱡𠲓𠿇")
("6706" "㗃㗩㫥㬆䀩䁊䁕咯噡嚕昭曕略眧眳睸瞻𠰉𠲰𥇄𠻐𡂜𥋯𡄵𠹄𠼣𠻙𠾈𠿌")
("6707" "㕧㖤咿啒啗嗂囓暚𥇌䁘𠲼𥇵𠽣𥇤")
("6708" "㖵㗵㘈㘋吹呎呗唤嗽噀噷暝欥欭畂瞑&C4-4F73;𡁌𠶨𣇧𠾗𠿣𠿖𣊞𥊫𡁎𡃧𠰊𠲭𤱐𠸰𡁍𥋻𡃤𡃪𣋸𥌝𡄺𥌶𥍌")
("6709" "㖻㗫㽥嗓嘄噄暩哚㘀𥉻𥊯𠰚𠳸𥅘𤱧𣉕𥉼𠹠𡀐")
("6710" "㙒墅曌琞盟𤦼𧖽𥂗")
("6711" "䠎跁跑跙跜跪躍𧿔&M-37385;&M-37384;&M-37472;&C5-4343;&C5-4A47;&M-37629;&M-38003;&M-37487;&M-37666;&C7-614F;&M-49753;")
("6712" "䟙䟥䠬䠱䳴䴑趵跀跔跢跼踊踋踘踯踴踻蹘蹫躑躙躝躢郢野鴠鸀鹭𨞕𨄙𨆀𪇰&M-39407;&M-37511;&C5-4348;&M-39547;&M-37577;&M-37594;&C5-4A64;&C5-5151;𦑲䠒&M-39682;&M-37740;&M-37794;&M-37916;&M-37992;&M-37998;&M-37530;&M-37659;&M-37729;&M-39705;&M-37802;&M-37890;&C7-4A56;&M-37905;&C7-604C;&M-38007;&C7-6153;&M-47503;")
("6713" "䟿嚟跟跽蹆蹍&M-37692;&M-37722;&M-37728;&M-37711;&M-33547;&M-37761;&M-37830;&M-33567;&M-33872;")
("6714" "䟕䟝䟨䟸䟾䠍螋趿跚踙踧蹡𨃟&M-37488;&M-37512;&M-37720;&M-37770;&M-37418;&M-37462;")
("6715" "跭𧿹&M-37712;&C6-5872;")
("6716" "䠧䠨路踞蹓𨄌&M-37896;")
("6717" "䠇䠛")
("6718" "䠣䠫䠭歜𨂂𣣴&C5-514F;&M-37420;&C6-586C;&M-37598;&M-37721;&M-37991;")
("6719" "跺蹂&C5-6521;&M-37793;")
("6721" "䬗覎&C5-506A;&M-34823;𣈟&M-45794;&M-34931;&C7-5121;")
("6722" "卾嗣郻鄂鴞鵑鶚鷐鸜鹃鹗𨟠&M-39345;&C5-3062;&M-47125;&M-47512;𦐽𦑉𢄾")
("6723" "𣊤")
("6724" "𣪆")
("6731" "䵥𪑱𪑲&M-48042;&M-48243;&M-48058;&M-48111;&M-48110;&M-48136;&M-48200;")
("6732" "䵠鷺黟𪃄&M-39502;&M-48066;&M-44800;&M-47282;&M-49955;&M-47007;")
("6733" "喣煦照𢢤𥈈&M-48119;")
("6734" "𠮊&M-48084;&M-48157;&M-48174;&M-48221;")
("6735" "&M-48089;")
("6736" "黵&M-48214;")
("6737" "&M-48092;")
("6738" "㱄㱎歞𪑩𪒄𣢱𣣦&C7-5E72;")
("6741" "𦦿")
("6742" "䣞䣤䳚䳛翤郹鄤鶪鷃鸅鸚𨛴𨟙&M-39368;&M-39515;&M-47128;&C5-6F45;&C5-7C2F;&M-39417;&C7-3450;")
("6744" "𠬱")
("6748" "歝𣤵")
("6750" "㨼𢯲𤜔")
("6751" "𪓽")
("6752" "翈鄲鴨鷝鷤鸭&M-39665;")
("6753" "囅")
("6755" "𤱋")
("6758" "𣢗")
("6760" "㿢𥉦𣋐")
("6762" "郘鄙鸓𣊧𪂇𠠐&M-39714;&M-47136;")
("6771" "𪓮")
("6772" "䴉翾鵾鶡𡀒𦒬")
("6773" "䬭")
("6778" "歇")
("6780" "焁𤍓&M-36911;𧤘𢅨")
("6781" "賉𧵅&M-36742;&M-36867;&M-49957;")
("6782" "䝭䴍賙賿郥郧鄖鵙鶗鶰鷶䝧𧵈𧵣&C5-3049;&C5-6474;&M-36924;&C7-3367;&M-46799;&C7-5F5E;")
("6783" "䝲䞀&M-36870;")
("6784" "貱賯&M-36875;&M-48231;")
("6785" "賱")
("6786" "㷖䝻賂贍&M-36954;&C7-5948;")
("6787" "&M-36760;")
("6788" "㰨䝪")
("6789" "賝")
("6790" "䌎𡂢")
("6791" "𡂟")
("6792" "夥鄵&C5-3633;&M-39503;&C5-7C29;𠟯&M-46971;&M-47498;")
("6800" "㕥㽗叭𠳎𣅁")
("6801" "㖹㘛㫓㽨䀬䁟吃呛咋哾唑唫唴嗌嗟噬嚂昨暆暛暣盵睉睑𠷇𥆟𥌈𠱕𥅁𠴻𠵰𠯏𣅠𤰢𥅓𥇉𥈕𣉼𡅞")
("6802" "㖒㘉㫻㬛䁯吟吤吩喻嗡嗲噏噙昐昑昣暡畍畛盻盼眕睇睔睮瞈喩𠯋𠷁𥈌𤳈𥉈𥌺𤰪𥄍𠴣𣈥𡃝𤲕𡃮𥌉")
("6803" "㕬㗛㘂㬠䀢䁠呤咲哙唸唹嗛嗞嗾嘸昖昤眹瞴𠸺𠴮𠻠𠿼𠿏𡂊")
("6804" "㕮䁶吘呚啽嗷嘋噂噉噋噭旿暾曒畋瞮瞰矀曔𤲒𡂡𠱘𥄖&C5-3365;𥅪𠹐𠼚𠾀𣊶㬚𣊟𥊭𡆅𥄺𠹞𣈨𤲧")
("6805" "㬕㬢䀲䂀咩哖嗨晦曦畮眻𣉚𠽩𣉫𥋟𥌇")
("6806" "㗳㬝㽪䀫䀰䁬哈唂唅啥喒嗆噌噲瞺晗𠽾𠴰𥆡𥊳")
("6807" "𠾌")
("6808" "㗰䁢嗿噞嚽暰暶瞛瞼𠿢𡀹")
("6809" "唋畭𠰒𣆋𤱏𥇎𥉉")
("6810" "㘴趴&M-37417;")
("6811" "䟭䟶趷跄跧踫蹉&M-37536;&M-37589;&M-37595;&M-37592;&M-37425;&M-37453;&M-37523;")
("6812" "䠯趻跈踚踰蹹&M-37419;&M-37414;&M-37556;&M-37785;&M-37834;&M-38033;")
("6813" "䠔跉踗&M-37816;&C5-6D75;")
("6814" "䠥跰蹲躈躨𨂤&M-37825;&C5-652F;𣀠&M-37869;&C7-2944;&C7-5545;")
("6815" "踇躌𨇤&M-37506;&M-37870;&M-37923;")
("6816" "䠓跲蹌蹭&M-37883;&M-37895;")
("6818" "踨蹤&M-37553;&M-37934;&M-37518;&M-37933;")
("6819" "䟢䟻&M-37485;&C7-4367;")
("6821" "覹𥂺")
("6823" "飸𥏬")
("6824" "敭𢽵𠭲")
("6831" "𪑙&M-48046;")
("6832" "䵰黔𪐲𪒭")
("6833" "𪒛𢡑&M-48098;&M-48195;&C7-5737;")
("6834" "黭𪒠&M-48068;")
("6835" "黣𪒹")
("6836" "䵳&M-48107;&C5-7874;")
("6838" "&M-48218;")
("6839" "&M-48080;")
("6844" "斁𢽛")
("6854" "㪤")
("6864" "𣀡𣀬")
("6881" "䝫䝯賹&M-36957;")
("6882" "䝩")
("6883" "賺&C5-6D6F;")
("6884" "䞃敗賆贁&M-36931;")
("6885" "&M-36776;")
("6886" "賶贈&M-36823;")
("6888" "𧸘")
("6889" "賒賖&M-36697;")
("6894" "𣀉")
("6901" "咣晄畻睠瞠𥇆𤱦𤱳𠻘")
("6902" "吵哨唦嘮眇睄𥇇𤰬𣇢𣆺")
("6903" "曭瞇矁矘𠿈𠯙𥉋𥇫")
("6904" "𡀼𡄕𥍆𥆵𥊼")
("6905" "㫠噒暽畔疄眫瞵𡁆𤳩𥌌")
("6906" "㗂噹嚐𡂚𥋐𡆓")
("6908" "吙唙唢啖啾嗩晱炚睒瞅𥊰𠻪𡂋𥇃𥍏")
("6909" "㘇咪眯𥊲")
("6911" "踡蹚")
("6912" "䟞䠀䠮踃𨂅")
("6913" "𨄇")
("6914" "躞&M-37879;")
("6915" "跘蹸&M-37957;")
("6916" "&M-37919;")
("6918" "踿&M-37614;&C5-6D74;")
("6919" "&M-37541;&M-37897;")
("6932" "&C5-6B5B;&C5-7B5B;&M-47135;")
("6933" "𢡸")
("6938" "&M-48118;")
("6971" "𣰍")
("6980" "𤓐")
("6981" "&M-36744;")
("6982" "尟&M-36784;")
("6988" "䞆䞉賧&M-36922;")
("7010" "埅壁璧鐾𣦢")
("7011" "雎驻骓")
("7013" "骧")
("7018" "骇")
("7020" "𢐦&M-41553;𣩩")
("7021" "㸕㼎䬜朣肮脏脽膧膻臃阬陮隡雅雕骯䬃膔䏠𦙴䐮䬏𩗬䬓䬘𩪉&C5-5F7D;&C5-6563;&C5-6A5F;䑉&C5-6E5C;&M-41652;&C6-462E;&C6-5023;𩖰𣄷&C6-6438;𠒱&C7-2B4F;&C7-3D48;&C7-556F;&C7-5A42;&C7-5C41;")
("7022" "䧚䧛䧡劈幦肪肺脐脝膀臂臇臍防隮髇腣髈䐧䐱𦝑𦝞&M-38666;&M-41644;&C6-6453;&C7-2734;&C7-3E34;&C7-487D;")
("7023" "㵨䧇胘膲臆臕𩨬臁𤬚䑋𩪣&M-41584;𦚫&M-41814;𦠸&M-41901;&C5-7850;&M-36491;")
("7024" "㬵䧐䧪朜脺腋腑膟障隦骹胶𦛛𦞠䑀&M-38647;&C5-6653;&C5-6A7A;&C5-7674;&M-41801;&C7-3A65;&C7-4921;&C7-556C;")
("7026" "䧜腤陪隌膪䏽膅𩪙𣍵&M-35281;&M-41799;&C7-5D61;")
("7027" "脑")
("7028" "胲陔骸𨽏𦢎")
("7029" "髍𦟟")
("7031" "䭺䮵䯁駐騅騼驙𩥮&C5-5A2A;&C7-5166;&M-45037;&M-45050;&C7-657A;")
("7032" "䮦䮰䮺騯鷿&M-44837;&M-44951;&M-44864;&M-44938;")
("7033" "䮄䮽憵驤𩣴")
("7034" "馼駮騂騿&M-44793;")
("7036" "&M-44746;&M-44899;")
("7038" "駭&M-45061;")
("7039" "䮶&M-44988;")
("7040" "䢃嬖孹𠮃𡣀")
("7041" "难&C7-3536;")
("7044" "&M-38660;")
("7050" "擘")
("7051" "&C6-5975;")
("7055" "&M-38664;")
("7060" "礕譬")
("7061" "&C5-6E43;&C7-3532;&C7-3D3C;")
("7064" "辟")
("7071" "甓鼊鼤𨾛䶆𪕹&C5-5223;&C5-6126;&C5-6A40;&C5-787A;&C6-5972;&C6-6377;&C7-3D3D;&M-41179;")
("7072" "&C7-5B36;")
("7073" "襞&M-41202;&M-41205;")
("7076" "䛗")
("7080" "躄")
("7081" "赃")
("7086" "赔")
("7088" "赅")
("7090" "檗糪繴")
("7091" "𥽱")
("7102" "𡴈")
("7110" "䀈䇒塈𥁆𣦯𡋴𦣠𡍱𡏃𡏇𠽺𠿦&M-40864;")
("7111" "驱")
("7112" "骊骘")
("7113" "䘌瓥蜃螶蟨𧓽𧓱𧔞&C7-2847;&M-33373;&M-33679;&M-33933;")
("7114" "𢾌")
("7118" "䪶&C5-6E56;")
("7119" "骠")
("7120" "厂胪")
("7121" "㒫㕇㕋㕍㕎㻺㽁䖎䖐䧢厄厇压厏厓厔厖厘厜厞厪圧壓旤朊朧歴歷肛胚胵脛脰腓臚臛阢阨阮阯阰阷陋陘陛陫陻陿隁隴雁颬颭飋骴魇魘䏓肶厩膒龎㱘䬚飃髗𦙗䏘䏕𦙫𠩫𦚞𦚠𦚟䏶䫹𤭛𦝪䯈𩩋䯗𩘟𩴣𠨬𦘪𨸖𠩁𦘵𠩎𦙜&M-41588;𦚹𦚸&M-41662;𣍴𤭄𦛖𦜖𠪑𠪒𦝟𦞥&M-41827;𡐰&M-41840;&C5-5972;&C5-5975;𦡻𦢫𧗖&C5-7235;&C5-795B;&C5-795C;&C5-7A4E;&C5-7A7E;𠑶𠨰𠂘𠨱&M-45634;𠨷𣍠&C6-2877;𠙊&C6-2D64;𠩟𠩜𠩧𤬶&C6-3B30;&M-41671;𠩽𤭁𠪉𠪈𠪍𣎄𤔜&M-41773;&M-41797;&M-41793;𠪤𠪜𠪪&M-41833;𠪹&C7-2739;&M-41858;𤔮&C7-3167;&C7-355E;&C7-355F;&C7-3D6E;&C7-4521;&C7-4522;𠫈&C7-5126;𤬜𠫎")
("7122" "㕂㕊㕐䐴䦺䧞厅历厉厕厠厮厲胹胻脼膈膌臑阿陃陑陟隔隬隭鬵鳫鴈肟胢䯊𠨴𨻳䯒𦢈𩣹&M-41539;𠩪&C5-3D51;&M-41846;𠪺𦠌𦠓𢅠𣎩&M-47337;&C6-2548;𠩄𠩝𣃞𠵲𠪋𣍷&C6-4D41;&C6-5A48;𠟄&C6-625B;&C7-316D;&M-29897;&C7-4926;&C7-5172;&C7-556D;&C7-5A44;&C7-5A4C;")
("7123" "㕄㕈㕔厡厭厯憠胩脤脹臄豚辰陙陾餍腝𠩏𠩘𠩩𠪊䐁𦟥𧝏𩪥𠨸&M-41577;𠩗𦤻𡙽𦟙&M-41862;&M-41884;&C5-717E;&C5-7B21;𠨶𣱷𠩂𥎦&M-38684;𣥉&C6-2D65;&M-38685;𠩸𠪏𤟐𠪝𠪥&M-41835;&C6-6454;𠪳𠪰𠪼&M-49694;&C7-4925;&C7-5D63;𠫐𠫒")
("7124" "㕃㕌㕏㕑㪒䐺厈厊厎厗厚厦厨厫厰反肝胓腰阪陬骭骾𨸗䏏䏪𠪆𠪇骬𠪚𨻲𠪮𦣀𠨺𠨻𠨹𦙀𠩲𢽩𢽧𦜒&C5-3D36;&C5-4B54;𠪯𥀬𣀥𡓸&M-41913;𠨯𠬡𠩋𠩍𡕣𠩞𠩭𠩰𠩨𢼞&C6-3B2F;𠩹𠩻&C6-4357;𡲠𠪘𠪔𠪫&C6-606B;&C6-606E;𠪭&C7-4C38;")
("7125" "㕅㕒䑞厍厙厣厴擪𠨭𠨵𠩿𠩀𠩙𠩯𢴺")
("7126" "㕆㕉厝厢厬曆磿脂腷腼阽陌階靥胋脴脜𦝨䐶&M-41647;𦟕&M-41848;𥌅𧯏𥐘𠩊𠩌𣅛𠩚𠩛&C6-337E;𠩮𠪄䏸&M-41736;𠪞&C7-2737;&C7-4C3A;")
("7127" "厒𤯍𩪲𠪟&C5-7A26;𡸡𠪦&M-48736;&M-48780;")
("7128" "㷴䪵䫃䫗䫚䫢仄厌厥厧厱贋贗赝頋頎願顝顾颀灰脄䐓𠪙𨻺𩪗𦙻&M-41722;𣅦𠩦𠩠𠩱𠩼𤈲𠪌&C6-5961;&C6-5A33;𠪛𣣾&C6-6430;&M-43470;&M-43460;&M-43443;&C7-3165;&M-43521;&M-41902;&M-43626;𠫉&M-43739;")
("7129" "䧣原厤膘阫际肧橜𠩤䏡𦞰𦃢&C5-7236;𠩬&M-41699;𠪓")
("7131" "䮾駏駓駤騑驅驉驢驪駆&M-44731;&M-44753;&C5-7A4C;&M-44657;&M-44742;&M-44741;&C7-357A;&M-45097;")
("7132" "䭶䭼䮥馬騭騳驫鷢&M-46752;&M-44766;&M-44933;&M-44922;&C5-6F46;𤇟&M-44601;&M-49905;&M-44883;&M-45023;&M-45055;&M-45093;")
("7133" "㥦䮱悘愿慝鱀黶𤇴𢟪𤎝懕𡿰𢟲&M-44959;&C5-796A;𢗬𢛚𢥧&M-45021;")
("7134" "䮆䮓䯀辱馯駍駬騕驔𩦎𢾯&C6-644F;&M-44885;&M-44893;")
("7135" "䮹&M-44754;")
("7136" "䮏䮠驑驦𩢷𩣚&M-44854;")
("7137" "駵𩤷&M-49909;")
("7138" "驥&M-44997;&M-43718;")
("7139" "騵驃")
("7140" "䭴娿嬮𡡕𡕒𡝌𡠷")
("7141" "&M-48829;")
("7142" "&M-44573;𠡿")
("7143" "&M-36416;")
("7144" "斅馵&M-44640;")
("7148" "䫎&M-43388;&C5-4B41;&M-43336;&M-49883;")
("7150" "㸦馽")
("7158" "顐&M-43363;")
("7160" "㫳䢈唇靨𦟧&C5-5841;𤳪𤘉&M-44596;𥕳")
("7162" "&M-44913;")
("7164" "敯𦖫")
("7168" "䫒䫬𩔉&M-43485;")
("7171" "㔯㔰㔱㔲㔳㔴㔵㔶㔷㔸㼢䶄匚匛匜匝匞匟匠匡匢匣匤匥匦匧匨匩匫匭匮匯匰匱匲匳匴匵匶匷匸匹匼匽匾叵巨既瓺甌臣鼫鼯鼴匪瓯匿區区医𠤰𠤴𦣞𧈟𠤼匬𠥐𠥙𠥦𠤮𠥮𠥰𠤹𠤺𠥁𠤿𠥵𠥉𠥌𤬴𤬵𠥖𠥜𠥝𠥞𤮖𠥢&C5-6129;&C5-612A;&C5-612B;&C5-6B62;&C5-7556;&C5-7660;&C5-7B78;&C5-7B79;𠄔𠤱𠤯𠥯𠤳𠤵𠥱𦣝𠤸𠥂𠥀𠤾𠥴𠥃𠥋𠥊𠥶𠥎𠥒𠥑𠥛𠥚𠥣&M-41174;&C7-3D29;&C7-4443;&C7-4D2A;&M-48282;𠥺𠥫𠥬")
("7172" "镾&C7-603C;")
("7173" "䮍長镸饜&M-41102;&M-44670;")
("7174" "敺𢻷𢼧&M-41143;𦕁𦕌")
("7177" "&M-44649;&C6-4163;𤘍&M-38687;&C7-5262;")
("7178" "䪸䫀頣頤颐&M-43362;&M-43412;&M-43417;&M-43555;&M-43661;&M-43379;&M-43441;&M-43472;&M-43525;&M-43735;")
("7179" "䦊")
("7180" "㷳蹷&M-37899;&M-41103;")
("7183" "赈")
("7186" "贴")
("7190" "㮣䊠䯂檿𥾩𣐃𡭳")
("7191" "𤬾")
("7194" "𢾂𢾪")
("7198" "颡")
("7210" "㓸䯶䰃䰐䰔丘刞劉坕垕驯髬髽𩭇𠀉&M-45527;&M-45575;𠀈𡊣𠠇&M-45415;&C7-4C40;&C7-5178;&C7-565D;&M-45600;")
("7211" "㲯髭𩬛𩬱&M-45423;&M-45528;𣱄")
("7212" "斲斵骄髿𣃃𣃋")
("7213" "䰁䰍乓&M-45531;&M-33827;𥁔&M-32868;&M-33223;&M-33393;&M-45444;&M-33528;&M-45472;&M-49698;&M-45614;")
("7214" "&M-45579;")
("7215" "&M-45625;")
("7218" "䯸骥")
("7220" "㓮㓹㓾䯯乒刖刚刷剛剧剭劂劚髩鬖鬡剮𠂆𠛒䏖𠜾𠞄𠛚𠜳&M-45394;𠠏𠠝&M-45515;𠠮𠚾&C6-2879;𠛰𠛧𠜛𠝾𠞂&C6-4D4B;")
("7221" "䯆䰈䰕兏卮巵朓脁腄腫膗膬臘虒阠陲隀隑隥颩颲颳髠髡髨膯䫽䐩𨻵䬆䬐𩗲𩮴䬟𦘴𦛐𢒝&M-41778;𦞡&C5-4B47;&M-45405;&M-45408;&C5-5973;&C5-5974;𦠿&C5-6022;&C5-6632;&C5-6634;&C5-6637;&C5-6A78;&C5-6A7D;&C5-6E74;&M-45536;&M-45564;&M-45574;&C5-7849;&M-45619;𢀴𠃤𠂬&M-38683;𠑿&C6-3C6A;𡲌𣭼𣭽&C6-4627;&C6-4D4E;𣮱𣮮&M-34850;&C6-5A4B;𣯅&C6-6456;𣯱&C7-2A56;&C7-2B34;&C7-2B51;&C7-3561;&C7-3A63;&C7-3D6F;&C7-3D70;&C7-3E2E;𣰢&C7-4221;&C7-4526;&C7-4B7A;𤰀&C7-5639;&M-45558;𦨃𦨄&C7-6161;&C7-6165;&M-49914;")
("7222" "䧦䯮䯰䯾䰑䰓帋彫所斤斦斸肜肵膨髣髳髵髾鬀鬄鬅鬋鬌鬗䏒䏳腨𩫿𩬝䯚𩭠𩮜𦢿鬜𩯜𢁹𣂤𦓚&C5-4B57;&C5-4B58;&M-45428;&M-45449;&M-45453;&M-45495;&C5-6B23;&M-45529;&M-45608;𠂰𢁺&C6-3423;彫𣂥&M-45362;&C6-6069;&C6-6366;&M-45368;&M-28892;𦓙&M-45389;&C7-2B5A;𣃁𦓝&C7-3168;&C7-3169;&C7-316A;&M-45448;&C7-444B;&C7-4928;&C7-492B;&M-45518;&C7-517C;")
("7223" "㼌䧙䧝䧤䰒斥爪瓜胀胍脈膎臐阥隱鬑鬞隠𤫵𦝢𩪀𩪛&M-41598;𦚝𦞲&M-45367;&C5-5279;&M-45457;𦣛𠨮&C6-2878;𣂙&C6-3424;𠃄&C6-4D4C;𢇏&C7-2B54;&C7-4927;&M-45545;")
("7224" "䐘䧌朡朡胝脟脡脬脮腇阡阺骽髲骶䯕脠&M-41573;𦙆𡥭&M-41730;&M-45401;&M-45483;&M-45505;&M-45551;&M-45583;&M-45591;𣂑𣍶&C6-5966;&M-41832;")
("7225" "㬹䰏𩯩𦠄&C5-7965;&M-45393;&C7-4929;&M-45628;")
("7226" "后盾腦腯膰䏦䯏䐉骺𢩋&M-41729;𦞖𦡅&C7-3E31;")
("7227" "䧟朏胐𩨸𩭪𢨯&M-41759;𦝥𢑚&C6-3B33;&M-41753;&C6-567A;&C7-362B;")
("7228" "䯼䰌貭质鬚䑇𩯭&M-41794;&M-41781;𣎐")
("7229" "䧨隟髹䑈䧰𤫺&M-41795;&C5-7238;𦣋&C5-7675;&C7-273A;&C7-3E33;&C7-4C47;𦆩&C7-4F3D;")
("7230" "䮋馴鬔𩬔&M-45017;")
("7231" "䭷䮔䮭䮴馲駈駣騛𩤽𩥉𩧆&M-44782;&C5-6A6D;&C7-357D;&M-44762;&C7-5167;&M-44974;")
("7232" "馸驕驨𩤚&M-45549;&C5-7269;&M-45010;&C5-7B2B;&M-44684;&M-47168;&M-45073;")
("7233" "䰄騤騱𢗹𩡻𩮀𢤐&C5-723E;&M-46405;&C5-7964;𤇡&M-44635;&M-45458;&M-45486;&C7-4C35;&M-45590;")
("7234" "䮑䮗䰊駳騣驋𩣞&C5-747C;&C7-2B48;&M-44940;")
("7235" "&M-44972;&M-45005;&C7-564E;")
("7236" "䮳&M-44792;&M-44836;")
("7237" "䮢&M-44639;&C5-6E70;&M-44740;&M-44881;")
("7238" "&M-45056;&M-44877;&M-44939;")
("7239" "騬驜&M-45054;&C7-564F;&M-45081;")
("7240" "䯭䯴䯹䯿刐删刪氒髶鬉鬘𠟉䰀𠚹&C5-5A37;&C5-6046;&M-45478;&M-45530;&M-45385;&M-45381;&M-45431;&M-45491;&M-45510;&M-45521;䰋")
("7241" "㲣髧𩭒&C5-7B26;&M-45358;")
("7242" "彤&M-45569;")
("7243" "鬕&M-45451;&M-45508;")
("7244" "䯵䰉髪髮𠦛&M-45547;&M-45620;&M-45630;")
("7245" "䯷&M-45582;")
("7247" "𠮐𡵕")
("7250" "髼鬇𩬶𠛹𠜂&M-45427;")
("7251" "𣬭")
("7252" "髴")
("7253" "𩯏&C7-565B;")
("7255" "髥髯&M-45465;")
("7260" "㓢㔆䭮䯺䯽啠昏髫髷髺髻鬊鬐鬙鬠𥄇𩬺𩭈𩮈𩭺𩮠𩮝𠯓&M-45407;&M-45388;&M-45413;&M-45450;&M-45482;&M-45485;&M-45504;&M-45537;&M-45441;&M-39975;&M-45463;&M-45452;&M-45497;&M-45502;&M-45573;&C7-5A47;&M-45599;&C7-5F5B;&M-44516;")
("7262" "鬍")
("7264" "𩯦&M-45629;")
("7265" "&C5-747B;")
("7266" "𩰂")
("7270" "刡剾𨲞𠛓𠛵")
("7271" "䯲髦髰髱鬈鬣鼮鼶鼷鼸髢𨱵鬛𦥻&C5-5939;&M-45437;&C5-6F5E;𠂩𣬮𣱎&M-41111;&M-39336;&M-45360;&M-41137;&M-41165;&M-41198;")
("7272" "髟𣂻𩬗𩬵𩯝&M-41188;&M-41185;𦦇&M-45509;")
("7273" "䑑䯳镺鬟鬤𩭨𩰉&C5-7134;𣱋")
("7274" "孵氏氐&M-41152;𠬿&M-41124;&M-41132;&M-45374;&M-41161;&C7-457C;&C7-565C;&C7-5E46;&C7-617D;")
("7275" "&C5-5225;")
("7276" "𪖇&C7-3E22;")
("7277" "岳𩬚𩬷&M-41119;&C5-6661;&M-45557;𤯁𦥝&M-45364;&M-45416;")
("7279" "𨲁")
("7280" "䰅䰎䰖兵则劕質髸鬂鬒鬓鬢𩯳&M-45571;𠔊&C6-645B;&M-49913;𠠧鬒&M-45621;")
("7281" "𤬡")
("7282" "𢒵&M-45517;")
("7283" "贬")
("7284" "贩")
("7290" "䯱䰂乐剁檃櫽鬃髤𩬻䰆𩮳&C5-5A38;&M-45493;&M-45496;&M-45532;&M-45566;&M-45581;&C5-7676;&M-45396;&M-45466;&C7-5D6C;")
("7291" "&C5-6B24;")
("7292" "鬁鬎")
("7293" "鬆")
("7294" "&M-45467;&M-45565;&C7-6038;")
("7298" "鬏𩮶")
("7310" "𡍵")
("7312" "骖骗骟")
("7313" "&M-33155;")
("7314" "骏")
("7316" "骀")
("7320" "䏟&C5-5278;&C6-2D62;")
("7321" "䬄胧脘腔腕膣臗阭阸陀陇院颱髋髖肬腟飇䏵䬁䫾䬂𩖶颰𩨭䯔䬎䯘𩘎𩘰𣍥𦞟&C5-5970;&C5-5F7C;䯛&C5-6652;&C6-346F;𤫳&M-41682;&C6-5A35;&C6-6437;&C6-643A;&M-41868;&C7-355D;䬒&C7-4C36;")
("7322" "脯陠䯙䐔𦜛𦡲&C5-6A79;&M-41634;𠃃𣃐")
("7323" "䧮朖脙膙肰脉𦠎䯖𤟢𦞭&C6-4D4F;&C6-5673;&C7-3164;&C7-316B;&M-41890;")
("7324" "㢥朘瞂胈胺脧腁腻膊膩陖陚髆脦骮䯋&M-41739;𦞤𥋜&M-41760;𠪻")
("7325" "䧕䧖戙膱隇隵𦛙䏼𦞁𦟠𢨛䑎&C5-2B66;䏬𢦿𢧘&M-41798;𦠾&C5-6A7B;𢧕𤟵&C7-4922;&C7-4924;")
("7326" "胎𦞨&M-41811;&C5-522F;&C5-6E73;&C6-4D3E;&C6-5672;")
("7327" "𦡆&C6-4D3C;&M-41777;")
("7328" "䧑䧬腚膑臏髌髕𦟘𦙮&C7-3E2D;")
("7330" "駜")
("7331" "馻駀駝駹&M-44814;&C5-6644;&M-44799;&M-44706;")
("7332" "䮒䳮騙騸驂&M-44723;")
("7333" "䭾駺騃&M-44701;&C5-7474;&C6-644C;")
("7334" "䮁䮂䮟䮨駿騈")
("7335" "㦺䮅䮙駥駴騀驖𩤥&M-44745;&M-45028;&M-44884;&M-44971;&C7-6031;&M-45053;")
("7336" "駘髂&M-44923;")
("7337" "馿")
("7338" "䮿驞&C7-602C;")
("7339" "騌")
("7345" "戏")
("7360" "㗤")
("7370" "卧")
("7371" "鼣鼥鼧䶈&C5-6745;&C5-797D;&C5-7B36;&C7-646A;")
("7372" "𨲸")
("7373" "&C7-4D2B;")
("7374" "𦦐")
("7375" "&M-41138;&C7-656F;")
("7376" "&M-41171;")
("7378" "&C7-457B;&M-41196;")
("7379" "&M-41149;")
("7381" "贮")
("7384" "赋赙")
("7385" "贱贼")
("7386" "贻")
("7389" "赇")
("7390" "𥼿")
("7410" "墮驸𧖺&M-40517;𡎶𥁺𥂠")
("7411" "驰")
("7412" "助骑𠡍")
("7413" "螱𧏆𧕈&M-33252;")
("7414" "驳骅𤿚&M-45585;")
("7418" "驮骐")
("7420" "㷉䦹尉肘胕阧阩附肞𣂄𦡷𣂀&C6-4D45;")
("7421" "㬸㬻䐈䐠䑏肚腌膮阤陞陸隓隢飉髉髐肍肔胿骩䐦颹𨸒䏙𦞦𩖺䬀𡐠𩗄䬅𩗆𦠉䬉䬊䯓𦡂䬋𩘝䬝䬞𩙚𩙛𦘳&M-14344;𦛏&C5-443B;&C5-5261;&C5-5946;&C5-596F;&C5-6023;𦡽&C5-6635;&C5-6636;𤬠&C6-3429;𠙙&C6-4636;䐍&C6-5677;&M-41789;&C6-643B;&C7-2738;&C7-2B32;𤬎&M-41876;&M-41898;&C7-4523;&C7-4B79;&C7-4B7C;&C7-507D;&C7-5173;&C7-556E;&C7-5570;&C7-5655;&C7-5D62;&C7-6026;&C7-6474;")
("7422" "励劶朒肋肭胯腩阞陏陓陭隋骻勵脇脪䯇䯐臈䑅䯝𤘌䐒䐭𦢩𪓏𠠻𠡁&M-41640;𠡲𠡰𠡮𦛒䐀𦝦&C5-6657;&C6-2C23;&C6-4359;&C6-4D46;&C6-4D49;䧦𠢭&C7-2736;&C7-453F;&C7-5653;")
("7423" "㼉朠朦肱肽胁胠脓脥膜膝膸臙阹陜陝隨髓䏯随䑃髄𦢪𦛘&M-41881;𦢐&C6-3421;𡬰&M-36418;&C7-3A62;&C7-6327;")
("7424" "㿭肢脖膵臌臒陂陵隯骳髒肗䏢𡜝䐛𩨝䐻𩩉𦡰𦢸𩪭𡊃𦙈𡦝𦡴&C5-6656;&C5-7237;𠫌&C6-3B2B;&C6-6458;&C7-3629;")
("7425" "臟阵䐙𦝛䯦𦛥&C6-5678;&C7-4C39;")
("7426" "㬶腊陹陼骷𦙶𦛩䐗𦛚&M-41779;𦠏&M-35587;𦢧&M-41670;&C6-606D;&C7-417D;")
("7428" "㬴䐜䧆膹臢陡隫𦛣䐵𩨿&M-41861;&C5-6562;&C7-4923;&C7-5256;")
("7429" "䧒胨脎腜陈䐑䏫&C6-4D3D;&C6-4D44;&C7-2A52;&M-49850;&C7-5A43;&C7-5C42;&C7-5D64;&C7-5F3D;")
("7430" "䮛駙&M-45052;")
("7431" "䮤馳馾駪騹驍驩𩣱𩤉&M-44931;&M-44936;&M-45051;")
("7432" "䮎騎&M-44646;&C5-7727;&M-44689;&M-44739;&M-44738;&M-45015;")
("7433" "䮃䮬慰隳馱駄騻驠&M-45006;&M-45057;𢡢𢢠&M-46205;&M-46441;&M-45016;&M-45045;")
("7434" "䮚䮮䮻馶駁駊騲鸌𩣺&C5-4B53;&M-45033;")
("7435" "驊")
("7436" "𩢴&C5-6650;&M-44900;&M-44996;&M-44668;")
("7438" "䮲騏𩥄&M-45032;&M-45060;")
("7439" "䮌䮜騋驝&M-45059;")
("7440" "对斞𡡙𡟨𣂊")
("7441" "𠬜")
("7442" "劝")
("7444" "雘𤿵")
("7448" "䵊")
("7450" "犚𢲴𡬬")
("7451" "毑")
("7460" "䜐")
("7461" "𣋯")
("7464" "𡝪")
("7470" "尀𡬠")
("7471" "䦈鼭鼵&C5-6128;𦥟&M-41136;")
("7472" "劻𨱧𠢔&C5-593A;&M-49837;")
("7473" "褽&M-41148;")
("7474" "𤿕&M-41108;&M-41139;𢺾𦦰&C7-5E44;")
("7476" "𠷞&M-41167;")
("7477" "嶞𡺆𡽃")
("7478" "贕&C7-617E;&M-41206;")
("7479" "镽")
("7480" "熨𡭓")
("7482" "贿𠣆")
("7486" "赌")
("7488" "赎")
("7490" "㯐")
("7494" "𢻚")
("7510" "驶𧋗𤦨")
("7511" "骁")
("7512" "骋")
("7513" "螴")
("7520" "肼肿胂阱陣肨𡲭&M-41587;𡲝")
("7521" "肒肫胜骫體䐸𩖤颫䫼𩖼𦠖𩘹𩘺&C5-5971;&C5-5F7E;&C5-6021;&C5-6E5F;&C5-6E60;&C6-2D67;𤫭𤫰&M-49689;&M-33440;&C7-4B78;")
("7522" "胇胏腈䐹&C5-603F;&M-41607;")
("7523" "䑊䦼䧅䧥瓞胅胦胰腠膿陕䏐肤骵𦚭脿𤫬&M-41618;𦝏&C6-3B2E;&C7-2B52;&C7-4B42;")
("7524" "䐟䧠腱膞膢髏&M-41605;&C5-4A79;𡭐&C6-337C;&C6-3C6C;&C6-4621;&M-41745;𡭍")
("7525" "䏥䏾")
("7526" "䧊䐏䐬")
("7527" "陆")
("7528" "腆隤脻膭𦟜䯣&M-41697;𦠻")
("7529" "膆陎陳脨䏞&C6-5675;&M-41834;&C7-4F3C;")
("7530" "䭽䮇駛𩢲&M-44708;")
("7532" "馷騁驌")
("7533" "䭿䮊駃駚𤊯&M-44653;&M-44975;")
("7534" "䮫騝&C5-5271;")
("7536" "䮞駎騞")
("7537" "&M-44947;")
("7538" "&M-44796;")
("7539" "駯駷䮪&M-44655;&M-44797;&M-45072;")
("7544" "&C5-6D37;")
("7570" "肆&C6-457D;")
("7571" "鼪鼬鼱䶇&M-33458;")
("7572" "䑔𦥥")
("7573" "㲳镻𨽸𦦅&M-41191;")
("7578" "賾赜")
("7579" "𦥦")
("7580" "贒")
("7610" "驷")
("7611" "𧠢&C5-6460;")
("7613" "骢&M-33920;")
("7619" "骒骡")
("7620" "䧃胉胭膕阳䐃𦝔𦞢腘&C7-5654;")
("7621" "䤚䧉䧋脭腥腽膃膍臞覛覵邝隍隗颸颺胆䏹䬖𣍦𦛞𧠙䐊䫻𦞙𧠿𧡋𧡎𦡃䬑䬛䯠𦙿𦚢&M-41668;𦛠&M-34822;&C5-4B46;𣎔&C5-5833;&C5-6026;&C5-6E75;&M-34982;𦣇&C6-3478;&C6-3B2C;𤔑&M-34832;&M-41765;𣬑𠒰𤔩&C7-3560;&C7-3D71;&C7-3E30;&C7-4527;&C7-5174;&C7-563C;&C7-5A32;&C7-5A33;&C7-5D53;𦤲")
("7622" "䧎斶腢腸臅陽隅髑腭𩨴䑄䯜髃𦝖&M-41744;𣎅𦝲&M-48512;𩩲腗&M-41758;&C6-5679;&C7-453D;")
("7623" "㼒腮腲腺隈隰𦞜𣎗𦢊䯥𦜃𦝳𦞗&M-41767;𣎚𦡹𦡵𦢺𣎱𦣜&M-41717;&M-41761;𤬒")
("7624" "脾陴髀䏷䐕𦞵𩩙䑍𦜄&M-41769;𦟣𦠍䐾𦣒&C6-4D48;𠕩&M-41842;")
("7625" "胛䐷&M-41852;")
("7626" "𦛗&M-41853;𦢏&M-41857;𡂶")
("7628" "䟟胑陨隄隕䐎䐣𦛤&C7-2B50;")
("7629" "臊髁腂䐯&M-41711;&M-41774;&M-41830;")
("7630" "馹駟駰𩢱&M-44829;𠺎&M-44781;")
("7631" "䣖騉騜騩𩥈𩧘&M-44830;")
("7632" "䮷駽騔&M-44852;&C5-6E6C;&M-44842;&M-45034;")
("7633" "騡騦驄𢠬")
("7634" "駻騴驛")
("7635" "驆驒")
("7636" "䮖&C7-564B;")
("7638" "騠")
("7639" "騍騾")
("7641" "&M-34894;")
("7642" "𠂄")
("7646" "𣍔")
("7651" "&C6-4561;")
("7671" "鼰鼳鼹𪕈鼺&M-34834;&C5-6F5C;&C5-6F5D;&C5-727E;&C5-7557;&C5-7558;&M-34833;&C7-6622;")
("7672" "䑗𦥶𦦊&M-41200;")
("7673" "㥸&C7-5263;")
("7674" "&M-41153;𦦣&M-41180;𥏏")
("7679" "&C6-6357;")
("7680" "咫")
("7681" "贶&M-34994;")
("7682" "赐")
("7691" "𦣲")
("7710" "㙠㻨㼂䝂䥣䦌䦔䦗䦟䦦且叠垦堅堲墬壂壆朢毉瑿璺皿盥竪舋豎鋻閂閆閏閚閨閸闉闓闔闛昼𨳝𦊨𤥔𤦁𨳳𨴗𡒊𥂤𨵮𤩱𩰔𤪐𨶬𨷅𡉷𡊂𣥙𡌯𥁎𠁁𡌭&M-41245;&M-41316;&C5-655A;𦦯𧗕&M-40861;&M-41480;&M-41502;𥃔𠀃𠀇𡊴𡊎𦊕𥁚𦊍𦊝𦊩𧖳𠨣𤯲&C7-2176;&M-40486;&M-41164;&M-41435;&C7-3D2E;&M-41439;&M-41437;&M-45643;𥂼𦌜𦦛𡓓𤪭&M-49841;&M-41491;𡓵𥃖&M-41518;𥃘𥃜")
("7711" "屔驵鬥鬮𨵈𠤫&M-41507;&C5-7B68;&M-41255;𦋛&M-41418;&M-49840;&C7-6027;𣫫")
("7712" "䢸翳邱閯闒闟马驹鬬鬭鴡𩿨𠢈&M-39663;&M-47383;&M-47435;𦥕&C6-6341;&M-39660;&C7-3451;&M-45650;&C7-5A49;")
("7713" "䗟䦢䵖蜰蜸蟁閩骚骤𧎰𧎮䵖&C5-2B61;&M-33405;&M-33760;&M-33847;&M-33906;&C6-4443;&M-33197;&C7-283D;&M-41395;&M-33789;&C7-5477;&M-33845;&M-33823;&M-33916;&M-41530;")
("7714" "䦯毀毁闘闞驭骣鬪&M-41466;𣪷𦋵&M-41511;")
("7715" "䍞閾驿")
("7716" "闊骆骝&M-41377;&M-49839;")
("7717" "驺𨶟")
("7720" "䰘閁閅𠕊&M-41257;𦦞𦦡𦦼")
("7721" "閌閱閲閵阻陉陒隆隉雤風颮颶颼颾飀飂飑飓飕鬩鳳䏣胒脃脃腉鳯䬕䬙飍𠘧𠘳𡰥𨸔𠑹䏎𠙈䏔𨸰𡱌𨹸䫸𡲪𦜕𩖛𩨒骪𡳆𡳅𨴐䫿𩖴𩨜䯌骲𣎜䬍𡳬𨶳𩘲𩁕𡰽𡱂𦙉𡱷𦚲&M-41213;&M-41673;𡲀&M-34825;&M-41733;&C5-3D4B;𡳂𡲮𦝚&M-41276;&C5-443C;&M-41303;&C5-4B45;𡳑&C5-5226;&M-41344;&C5-5238;&C5-5262;𧇜&C5-596E;&C5-5A35;𣎜𦡪&C5-6025;𦡱&M-34944;&C5-6638;&C5-6658;𦦩&M-41493;𣩺&C5-717B;𡳸&M-41521;&C5-7C47;𡖆𤓱𠘵𡰭𦉭𠘾𠘼𡰼𤓳&C6-2876;𠒅𤓷𤓶&C6-2D63;𠒍𠱰𡱕𡱓𦊗&C6-3425;𠙒𡱤𡱧𡱲𡱹𠙗&C6-3B2A;&C6-3B32;&M-41675;𠃾𠙘𡱻𡲃𦊡&M-41709;&C6-462C;𡲙𡲩𡲔𦋌&C6-4D40;𧖴&C6-503D;&C6-503E;&C6-503F;𡲵&C6-5A36;&C6-5A49;&C6-5A4A;𡳈𤔢𦋜&C6-635F;&C6-6369;&C6-6439;&M-41349;&C7-2B33;&C7-2B35;𡳟𦋼𦌏𡳫&C7-4524;&C7-4525;&C7-4B7B;𦌼&C7-563A;𤕉&C7-5E47;")
("7722" "㒳㒺㞔㞕䐚䐞䢳䣅䣑䣝䦏䦞䦵䦽䧁䧓䲩䲿冂円冈冋冎冏卩卪同周咼囘局屌屑屙属屩屫屬岡帠月朋朐朤用网罔翢肑肕肠胊胴胸腎腡腳膠膷臀臖觷邤郈郮郳郿鄏釁閍閒閙闁阴陊陱陶隖隝骨髎鬧鳲鵩鵬鵰鶂鶋鶌鶞鶥鶻鷉鷳鷴鷵鷼鸊鸦鹏鹘鹛周阝肳䏛脚卿𠔼冃𡰾𡱣䏧屚䏱𨹹𨳚𨳜𨜸𨴀𨳵䐢𩿊䑁𨵦𦦝䯞䑌𨷲𠘱&M-41537;&M-41542;&M-39285;𦙨𡱑𢂗𦙸&M-39363;𦚧𡱿𦛪𦜂&M-39458;𡲜𢃵𦝓&M-39519;&M-41254;&M-41234;𢄚𡳏𦜜𦞚&M-41293;&M-41294;&M-41336;&M-41331;&M-41346;&M-46704;&M-48320;𣎛𦠈𧤑&C5-5A58;𦡌𦦑&M-41417;&M-46898;&M-39709;&M-46975;𦦧&M-39733;𦢨&M-41509;&M-47181;&M-47293;&M-45658;&C5-7C39;𠔽𦉫𦉪𠕃𠕁𠕈𠨖𡰬𡰯𦉳&C6-2547;𠄗𠕒𡰺𦉯&C6-287A;&C6-287B;𠕘𠕚𡱃𠕛𠱬𡱎𡶬𦉸𦊖䏤&M-41639;&M-41642;𠄷𦥡&M-39450;卿&M-02878;𠵁𡱺&C6-435C;&C6-435D;&C6-4360;𦥩&M-41703;&M-41713;𢃹𣇱𣍸&C6-4D3A;𡲳𡲻𦋢𡳇𡳍𦁒䐰&C6-6071;&M-41319;&M-41321;&M-45638;𠕬&M-41856;&C7-3166;&M-41374;&M-45642;&M-46826;&C7-3A61;𦌞&M-46969;臋&C7-487E;&M-39743;&C7-5175;&C7-5656;𠕲&C7-5D66;&M-47310;&M-41529;&C7-642D;")
("7723" "㞏㞗㞘㞙㞟㞡㼖䢅䢉䦠䧘尽尿屒展澩爬瓝瓟腞腴腿膇膖膼閇閼限隐隩爮䬤𡱐𦚣䏰䐅䐂𨳲𨳿𦞣䐳𨴯䐿𨵰𩛻𩪌𤔀𡱰𡱱𡱽𢛥𦜎𦝝𦝰𦝜&M-41310;&C5-4B5B;&M-41873;&M-41427;&M-33713;𣫥𤓲𡱁&C6-3428;𡱢𡱴&M-41672;𡱦𡲑𡲘&M-36375;&M-41256;&C6-567B;&M-36383;&C6-5968;&C6-606C;&M-41350;&M-41355;&C7-4C3C;&C7-4C3D;𦦬𦦶&M-33939;")
("7724" "㕞㞋㞌㞜㲀䏜䦻叚叞孱屏屐屖屛屡屢履屦屨服殿股腏腶閉闙骰𣪍腵膄臎𨸜𡰿𦙱𡱥𨹺𠬝&C5-2221;𠬮𡰫𤘅&M-41555;𦘿𡱡𡱾𡲁𦝒&M-41236;&M-41734;𤿳𦝷&C5-4B55;&M-41854;𣎟𦠅&M-41390;𥀣&C5-6655;𠬨𠬩𡰸&M-41608;&C6-3422;&C6-3426;𠭊&C6-3B29;𠭜𡲎𤈫𡥷𡲟&M-49199;&C6-4D3F;&C6-4D42;𡲱𡲯𡲾𡲲𡳉𡳡𡳐𦌍𦌤&M-41471;&C7-4C37;")
("7725" "䏺犀羼閥降胟胮腪𡲛𨼬𡳞&C6-2D66;&C6-3B2D;&M-20042;𡲣𡲕𤚌𣎤𤑂𦌳")
("7726" "㞒㞓㞛䐲䦲䧂䧄居屇届屠層眉胳腒膽骼屠脗䐇𡰪𡳄𦞧𡲚&M-41869;𡰶𡱔𡲖&C6-5674;&C6-606A;&C6-6363;&M-41353;&M-41851;&M-41457;")
("7727" "㞚䐄尸屆屈陷䏨𡲗&M-41626;𦛓𦜇𡳘&C5-5A36;𡰩𡲒&M-41712;&C6-4D43;𡲬𡲶")
("7728" "㰮㰺㽰屄屓屣屭欣歄歋閡䯉臔𣢁肷𦠆䑂𣥀𣢞𦙬𣢬𣣉𣣒𣤔&M-41841;𥌏&C5-7673;𡰦𣢀𣢂𡱍𡱒𣢚𣢭𣢨&M-37381;&M-41706;&C6-4D4A;&C6-4D50;𣣣𣤀𡳠&M-41886;&C7-417E;&M-41908;&C7-4F3B;&C7-5865;&C7-6328;")
("7729" "㞖屎屧屪脲際杘屟腬䐖𡱏𨹄䐼𦚩𡱼𦜊𡲰𣙰&C6-3473;𡲴𡳨")
("7730" "閝闥&C5-715A;𦥧&C6-5A37;")
("7731" "䭵䮀䮘䵴颿駔&M-44585;&M-44786;&M-44827;")
("7732" "䣕䭹䮈䮐䮩䮸䳔舃舄闖馰駉駒駠駧駨駶騆騊騧騶驈驧鷖鷽鸒𩣽&M-44685;&M-44666;&M-41455;&M-41473;&C5-6E62;&M-44956;&M-44979;&C5-784E;𠨝𤉡舄&C6-5A44;&C7-2B43;𦋻&M-44744;&M-49902;&M-44722;𪃹&M-44882;&C7-5A3A;&M-45014;&M-44980;&C7-6471;")
("7733" "㤻㦛䦝恳悶惥慇熙閟闗騄騘騷驟鱟黳𢘁𢝅𨶢𩥇𩧋𢘼𢰋𢞭𢣠&M-41453;&M-41482;&M-41479;&C5-6E40;&M-44903;&M-44952;&M-41517;𦏗𨷻𢘒𢘓𢙦𢘴&M-41226;𢛩𢛇𢞰𢟬𦋮&M-41342;𢡥𢠶𢡙𢣟𢤒&C7-4B3D;𢤀𦌲&C7-643A;")
("7734" "䮕导馭馺駸騢騪驏𦥘𩣸䦙&M-41382;&M-44717;&M-44866;&M-45062;𡬯&M-44879;&M-44896;")
("7735" "䮝&M-45091;")
("7736" "駋駱騮騽")
("7737" "&M-44721;&M-44806;")
("7738" "&C7-6472;")
("7739" "䮣騥&C5-6646;&M-44987;")
("7740" "䍑䦴又叟夓婜婴媐嫛孯學殳聞閈閔閕閛閮閺閿闄闅鬦𠬸𨵉𡥍&C5-3642;𡢕&M-41373;&C5-655E;𥽳𦉻𡝑𡝞𡝨&C6-4F7D;𡕯𦋄𦋚&M-41320;𡡋𡡼𦥼&C7-2A4D;𡢗𡕻𦌑&M-41431;&C7-4573;𡣿𦗶𠧑")
("7741" "观𠭋&M-41212;&M-41469;")
("7742" "䢷䦱舅邓鄋鴅鸡鹦𥝊𦦻&M-41348;𥝅𥝇𥝈&M-49931;𥝋")
("7743" "䦬臾艰閎関闃闃闋&M-41345;𡘩𦦉𦧂")
("7744" "䦕䦤丹冊段毌舁開閞鬫册舁𣪂𢍱𢌺𢌴&C6-3074;𣆼𢁅&M-41287;𦋖𦥸&C6-6358;&M-41304;𢍯&M-41391;&M-41392;&C7-347A;𢍲&M-41438;&M-41494;𢍹")
("7748" "欢闕&M-49193;")
("7749" "&C5-655D;")
("7750" "㩓㹂䍙䦐掔擧母舉轝閘閳闈闡𩋆𢹏𣫬&M-41292;&M-41371;𤛱𢸁𦏜&M-41485;𦥙𢫪𢮗&M-41286;𦥹𦌎𦦙𦌱&M-43013;𦧁")
("7751" "闚&M-48856;𣫰&M-48265;")
("7752" "䳇𨴒&M-39306;&M-39403;𦐎𦋱")
("7753" "䦑䦫&M-41275;&M-45637;")
("7755" "冄毋&C5-4A70;&C6-2359;𠕋&M-41393;𦍊")
("7760" "䁂䁷䃜䦒䦓䦖䦚䦜䦣䦭䦮冨問嚳昬留瞖硻礐礜羀誾譽醫間閣閤閫閭閶閽闇闍闣𨵥𧫦𣌧𤲗&C5-522A;𠿟&M-41422;&M-41424;&M-41443;&M-41454;&C5-6A3B;𠕑𠰔𣆫𣆾𣆩𦊭𣇀𦊟𦊪&M-35371;𦋑&M-35491;&M-41280;𦋧𦋫𣎭𦌝𦦤&C7-5935;")
("7761" "𨶃")
("7762" "閜鶹𨵤𦑹&M-47020;&M-47223;&M-47338;&M-39451;𦋬&M-46951;&M-47156;")
("7764" "闢")
("7766" "闆&C5-6E41;&C5-7954;𣉈")
("7768" "歠𣤌𣣏𣣤𣤑𣤒")
("7769" "&M-49845;")
("7771" "㔾㽇䦍䰗䶂巳巴巸閐閹闀闂黽鼠鼨鼩鼲鼦𠨎𦊀𨳷䶅𣱈&M-41104;&M-41225;𣮈&M-41232;&M-41278;&C5-444B;&M-41318;&M-41296;&C5-5A6D;&C5-5A6E;&C5-6127;&C5-612C;&C5-6746;&C5-6747;&M-48287;&C5-7321;&M-41204;𦉮𠙉𣌩𦊣𦊠&M-41113;𣮫𤭠𦋘𦋙&C7-2C39;&M-41404;𣱒&M-49501;𠨧&M-45645;𦦭&M-48276;&M-48284;&C7-5E42;𤬢𤬣")
("7772" "䢹䦪䦳䲭䳎卬卯印即卵卿邸郾鄳鴄鴖鴟鶠鷗鸥鸱䳭𪕱𪕺𠁾𠨥&M-46760;&M-46842;&M-45561;&C5-7B50;𦉿&M-02865;&M-41112;&M-39541;&M-41123;&C6-5948;&M-39581;&M-46912;&C7-4576;&C7-4D29;&M-49785;&C7-5E45;")
("7773" "䦘县艮閬闤&M-41231;&M-34459;&M-34548;&C5-6028;&M-46104;&M-34644;𦣴𦊶&C6-643C;&M-34484;&C7-3B58;&M-34661;&C7-4C21;&C7-5645;&M-49843;")
("7774" "㝀㱼殹毆毈民臤殴𦥠𨳶𣱓&M-41107;&M-41253;𠭃𦊞&C7-3E6F;&C7-3E70;&C7-6060;")
("7776" "䶉")
("7777" "䦡凸凹岊嶨罂臼镼門閰閻關𦥑𠕄𠚆𡹩&M-41277;𦥳𠚞𦉝&M-41512;&M-48691;𤕪𦥓𡵹𡶓𦥔𠂼𠥓𡷦𠚖𠵓𡸧𦣤𦣩𦥮&M-41274;𦦀𦦂𡽬&M-41757;𠥩𠥪𠚡𦦥&C7-5F77;")
("7778" "㰝㰼㰽歐镹欧𣢣𣢎𦥞𣢮")
("7779" "𨷱")
("7780" "㒷㷂㸑䝿具尺巺巽巽焛燢爂爨爨舆與興貫貿賢贀贯贸輿閃閧閴闐闠鬨黌𨃨𧸧𠨠&C5-4A48;𤏿&M-41423;𦦪𦦫&C5-6E3C;𦦲&M-45652;𤓕&M-45660;𠔜&M-01487;&M-41259;&M-36775;𦥷𢁌𤌑𦋭𦌨𤐫𦦚𠔹&C7-5075;&M-49844;&M-45656;&M-45655;𤓟")
("7781" "鼆𦌓&C7-6426;")
("7782" "购鄮𪇬&M-39593;&M-39726;")
("7783" "赆")
("7784" "闝𠮆")
("7786" "赂赡")
("7788" "歟閦𦧅")
("7790" "䊆䦨朵緊繄閑闌闑朶𣎿𦊋𣐻𣑸𦦆&M-41328;&M-41347;𦦗𣝑&C5-655C;𥽂𣎻𣐉𣐷𦊘𦊮𥺋𦀥&M-41266;𠕨𡮧&M-41327;&M-45640;𣟰")
("7791" "𦋟𦌐𦌴")
("7792" "&M-38680;")
("7793" "𣡉𦍃")
("7794" "毇")
("7799" "䦥𡳭𦋗𦈇")
("7810" "䜿坠墜監盬鍳鐆鑒鹽𡑘𡒓𤪋𥃉&C5-7173;𡉡𧗄𥃡")
("7811" "验𣱑")
("7814" "骈&M-48383;")
("7820" "閄队𦘲𦘩𣍞")
("7821" "䖙䬔肐胙胣脞脫膉覧覽阣阼陁险隘髊脱𨸛䏗𦝤䐤䬈𩘞𦙋&C5-443E;𦞝&C5-4B48;𧇬&C5-5976;&C5-6633;&C5-6E5D;&C5-6E5E;&C6-2D68;𤫼𣯛&M-41818;&C7-2735;&C7-2B53;&C7-417C;&C7-4B45;&M-43263;")
("7822" "䐥朌肣胗腧阶陯隃骱肦䏲腀膓肹&C6-596B;&C6-6455;&C6-6457;&C7-3A64;")
("7823" "㼓䐋䧔䯟䯡朎朕脍腍膁膴阾陰隂隊隒隧䑆䯍𤀩𦣍&C5-3B50;𦝴&M-41837;&C5-6654;&M-41637;&M-49695;&C7-4C3E;&C7-544F;")
("7824" "㬳㬿䧗䯎敐敶肸胼腹隞骿𢽲𦜍𣀼𢻮𢽷𤉺𦟔&M-41802;𦠐𢻻𣍮&C6-567D;&C7-2B55;𣎣&C7-5652;&C7-5C43;")
("7825" "䧧脢羘𦡫𣎮&C7-642A;")
("7826" "䧍膳膾䏩𦛜𦞛𦠇䯤&M-41596;&C5-3D35;𦝵&C5-6659;𣍬&C6-4D4D;&C6-567C;&C7-362A;&C7-3E32;")
("7827" "𦚥")
("7828" "臉險𣎓𣎓䐫&M-41638;&C6-435B;&C6-435E;")
("7829" "除𥼅&C6-3427;")
("7830" "&M-44575;&C6-5047;")
("7831" "駞駩駾駾騐&M-44898;&M-45044;&M-44603;&M-44643;&M-44697;&M-44765;&M-44828;&M-44826;")
("7832" "䭻駗騚騟𩥎&M-44606;")
("7833" "䮉愍駖&C5-7472;&C7-347D;&C7-444C;&C7-453C;")
("7834" "䭸䮡䮯駇駢驐&M-44846;")
("7835" "&M-44926;")
("7836" "騇驓&C7-5A39;")
("7837" "&M-44737;")
("7838" "驗&C7-6034;")
("7839" "駼&M-44674;")
("7840" "𢿭𡦋")
("7841" "𠮄")
("7843" "㥖")
("7844" "㪢𢼪𣀭")
("7850" "擥𨏊𢱯&M-38439;")
("7860" "暋睯譼𥊇&M-42672;𣇻&C7-2922;&M-35761;&M-39986;")
("7864" "𢾞")
("7867" "𣊽")
("7870" "臥")
("7871" "㽉䑘鼢𨲠䶃&C5-6748;&C5-774B;&C5-787B;𠥸")
("7872" "䦇&C7-5261;&M-41199;")
("7873" "䭆&C5-784A;&M-41115;&C7-3D32;")
("7874" "䦋攺敃𢼕𢼑𢽇&M-41109;𢾺&C5-6B61;𢿛&M-41173;&C7-3E6E;&M-41192;")
("7875" "&M-41175;")
("7876" "臨&C5-6A35;&M-41133;&M-41163;&C7-5264;𦣷")
("7877" "㟩𦉞𡼐")
("7878" "&M-41178;")
("7879" "䑐")
("7880" "𤎩𤑾")
("7883" "赚")
("7886" "赠")
("7889" "赊")
("7890" "㯺𣔿𥽐𥽏𣠿")
("7892" "𣜹")
("7912" "𡮻")
("7921" "塍胱腃膛隚颵飚颷飈䯑𩘌&C5-3643;𠗲𣍺&C5-443D;&C5-6024;&M-41619;𤫾&C6-5A34;&C7-563B;")
("7922" "䏴勝幐腾陗隲騰𩨡䏚&C7-3E2F;")
("7923" "滕螣鰧黱𣎲𦡗")
("7924" "媵髅𣍹𣎌")
("7925" "胖膦隣&M-41892;")
("7926" "膡謄𦡁𣎒&C7-4C3B;")
("7928" "䐝賸阦腅䐐&C5-4377;&C5-5E76;&C6-435F;")
("7929" "榺縢脒隙𨻶")
("7931" "駫")
("7932" "驣&C5-4B4F;&C7-5A3F;")
("7933" "𩥱")
("7935" "䮼驎&C5-526D;")
("7971" "𪖀&C5-6B63;")
("7972" "&C5-4A6B;&M-41186;")
("7976" "&M-41160;")
("7988" "赕")
("8000" "人入八")
("8010" "㒰㿽並亼亽仝仺企佥佱兰坌玍盆益盒盖盦盫金釜全𦍌𣥳𦥈𡋛𧯚&M-44017;𡌆&M-49803;&M-40168;𡌫&M-29416;&M-40194;&M-40244;𤫆")
("8011" "䥝气氢氩氫氬氯氲氳釯鈧鉒鉝銃錐錱鏕鏟鏡鐘鑫鋶𨭖𣱠&M-32865;&M-41011;&M-41079;𣱖𣱦&M-40835;&C7-4B4E;&M-41058;&M-41062;&M-41085;&C7-646B;")
("8012" "侴爺翁翕翦鈁鈰錥鍗鎊鎬鎸鏑鏞鐫鑇𦐈")
("8013" "㒪䥋䥥䥰蚠蠤鉉銥鎄鏣鏮鐎鐮鐿鑣鑲𨮹&M-32896;&M-40732;&M-33024;&M-33413;&M-40666;&M-33662;&M-33918;")
("8014" "䤳鉸鋅錊錞鍍鎨鐴𨫏&C5-6555;𣀚𩠰&M-41042;")
("8016" "錇鎕&M-40901;&M-40961;")
("8018" "䤤羡羨鑛&C7-5D2C;")
("8019" "鏶")
("8020" "㐱㸘个丫兮爹今𠔆𠆤𠇏")
("8021" "㲵䶳乍兊兌兑尣差氕氖氘氚氛氝氪氰氱羌羗羞雂麄龕𡯂𪛓𠇃𣱕𠒁𠈢𠈑𣱚𣱙𦍛𠙠𡯷𠭳𠎛𡢣𡰕&M-48825;&M-48831;")
("8022" "㸗介侖养分前剪弟斧爷肏龠俞䏌𠋁𢃬𠁭𠓪𠔕𢄔𦛝𢅊𠓡𢒃𢁰𢁭𢁥𢂂𥜼𤕓𠌈𠌺𠞽𢄕𠎚𠭻𤕨&C7-3638;&C7-4547;𠑂&M-45647;&C7-5225;&C7-5F75;")
("8023" "㒸兪兼汆淾羕鮺𣴴𣲎𠊺𣴲&M-28488;")
("8024" "㿯𠬬𠭶")
("8025" "羲舞𨌅𦏁𠩖")
("8026" "𧪰&M-48892;&M-35544;&M-49943;")
("8027" "𡰤𠋓")
("8028" "𤈩")
("8029" "𪎨")
("8030" "令&M-38701;")
("8031" "忥氡&C6-597B;")
("8032" "鶿𩿈&M-46853;")
("8033" "㤣㥐忩念忿怎恙悆愈慈無煎缹羔鯗𢗊𢙅𠔥𤎰𤆋𢖴𢗁𢙽𠔥𢛪𢝑𤋃𢞥&M-46392;")
("8034" "尊𡬴")
("8040" "䓥仐伞傘午复夔姜孳攵父𢆉𠓝𠓧𢻶𦔯𠭦𠓠𠦍𠓥𡴌𦔵𠈾𠔟𠍘𤕘𦗊")
("8041" "氨雉龛&C6-502D;&C7-3D45;")
("8042" "禽𠎘")
("8043" "奠矢美羹关𠓷𥎸𠓱𡙫𡚈𥐄")
("8044" "并弅弇𠇋&C5-3D4C;𢌯𤕑𣁊𢍜𥏔")
("8050" "䡨单年拿毎每羊𠔈𠇚𤘝𠓽𦍐𠎃")
("8051" "㲴㲷毓氟氠氧羶𦏆𣱮")
("8052" "弚羛")
("8053" "羮𠔯𠌉𦏨𣍄")
("8054" "羻")
("8055" "搻義羴")
("8060" "㑹㒲㒶㕣㸙倉兽合含善善普曾會畣畬畲着舍舎谷酋酓首𪉵𠓤𠔌𧮫𥄘𡇤𡇷𠏇𠮦𠔋𥃦𠰞𠓮𣌭𠵊𤱭&M-44027;&C6-472C;𤽽𦎍𡈤&M-39890;&M-40495;𤳋&M-39972;𦏯")
("8061" "㲶䧻䧾䨄氜氤氥𣱜𣱫&C7-4455;&C7-5129;")
("8062" "命")
("8064" "&C5-5F41;𦏟")
("8066" "譱韽&M-36172;")
("8068" "&M-44497;")
("8070" "钅铲")
("8071" "䭗䭚䭩乞氙爸瓫瓮钪铳锍锥镜飳饘甆㐌𠔄𠆭𠓟𠆹𦈢𠇜𠤒𢀻&C6-347D;&C6-3521;𠊋𤕕&M-39628;&C7-5646;&C7-5B2B;")
("8072" "䭣钫铈镌镐镑镛镝𩝝&C5-5267;&C5-602A;&C5-6A62;&C5-6A63;𠔃𢎦𥫡𠋒𦉙&C7-4C23;")
("8073" "䭖䭠会侌公兹衾铉铱锿镰镱镳镶食飰養饟&C5-784C;𠫥𠫟&M-44015;&C6-5A38;")
("8074" "䍊屰铰锌镀餃")
("8076" "䍌锫餢餹饝")
("8077" "㒴仚屳岔峹嵞缶齹𦥭𠔒𠋔𠚗𠓳𠓴𦥴𦥽𦥾𡽚𦦓")
("8078" "䬵𦈲")
("8079" "䭧")
("8080" "仌关兾炃羑羙貧貪贪贫仌𤆅𠓫𤴘𤈣&C5-5154;𠔁𠈏𠈮𤇇&M-37369;𠊌&M-37388;𦎅㷢𠍺𦎙&C7-2B3A;𤎯&M-37709;&M-36941;&M-37856;")
("8081" "氦氮𣱛")
("8082" "&C7-5C40;")
("8088" "众僉")
("8090" "㮍佘余尒尓氽籴枀𣒫𥿅𠎳𦍎𠔗𣔕𠓸")
("8091" "䨀氣氭雓𢘔𥠌")
("8092" "樖𢘈")
("8093" "&C7-444E;")
("8094" "𣁏")
("8099" "橆𠓭𣜈𣞣𥣠")
("8101" "𣱤")
("8102" "𢗔")
("8110" "&M-40246;𥂲𥂾")
("8111" "㽂䤠䤵䤷䥤䥶釭鈓鈚鈺鉅鉔鉕鉟鉦銍鋀鋞錏鏂鑎鑨鑩鑪鈋&M-49815;&M-40995;&M-40330;&M-49810;&M-40493;&M-49832;&M-41036;")
("8112" "䤮䥎䥮釘釫釾鈣鈳鈵錒錹鎘鎶鎷鐪鑈鑐&M-40380;𥐃&M-49835;")
("8113" "鉲銾鋠鋹鐚鐻鑢&M-40521;&M-40606;&M-33513;")
("8114" "䥳釪釬鈃鈑鈙鉺銒銔鋄鋽錽鎒鏬鐔鑷&M-40586;&M-40662;&M-41090;")
("8115" "鐬")
("8116" "䥄䥧鉆鉐銆鋙鍇鍢鏀鐂鐕鐳&M-41056;")
("8117" "鑡&M-40471;")
("8118" "鍞鎭顉&C5-6A5D;&M-43602;&M-40895;&M-40993;&M-41057;")
("8119" "䥔鈈鏢")
("8121" "㼶䝇尩瓴𤬰𤭌𠔠&M-48900;")
("8122" "&M-48890;")
("8126" "龤")
("8128" "䫄籲頒颁龥𩑟&M-43514;&C5-662A;&M-43420;")
("8131" "甉甒𤮐𧆺")
("8132" "𠄖")
("8134" "㪠")
("8138" "䫞䫡領领𧈁")
("8141" "㽀䂑瓶甁矩短𥏝𥎬𥎹")
("8142" "𥏼𥎵𥏁𥏴𥏾")
("8144" "𥎿")
("8146" "啎𥏪")
("8148" "頩𩑤𩒕&M-43476;")
("8151" "䍽羥𦍼𦎣𦍭𤭐𦎢𦍘𦍞𦏰")
("8152" "羺𦏌")
("8153" "𦎇𦍝")
("8154" "䍬𢼝")
("8156" "䍼𦎥𦏩𦏪")
("8158" "𦏅")
("8159" "羱𦏈")
("8161" "㠮㼨䜫甑豅𤭏𩠛𠼞𧮽&C5-6A6B;𧯙")
("8164" "㪨敆谺𢼽𣀖")
("8166" "𧯕")
("8168" "䭭頜頷颌颔&C5-7176;&C7-3D6B;")
("8171" "䬧䬹䵹缸缻罏钜钰钲钷餖饇𧆦𩚚𤭬𧇍𩟯&C5-3649;&C5-4444;&C5-597D;𦉐&C5-6039;&C5-784B;&C6-4638;𦈵𣱪&C7-2B37;&C7-3567;&C7-5221;𤮫&M-48298;")
("8172" "钉钙钶锕镉飣餰𦈣𦈥𦉏&C7-515E;")
("8173" "餦餪𩞈&C5-7221;&C6-5042;&C7-2B3B;")
("8174" "䍂䍈罅罈铒镊镡飦飯餌㪂𦈨&C6-4C72;&C7-4530;&C7-6029;")
("8175" "饖")
("8176" "䍄䬯䭙钻镭𦈶𦉟𦉢&C5-602D;&C7-515D;")
("8177" "&C5-6038;𦈮")
("8178" "镢頌颂𩑔&M-43367;&C5-6030;&M-43621;&C6-642F;")
("8179" "䬪钚镖&C5-4442;𦈧")
("8183" "𥏂")
("8188" "顩")
("8190" "榘")
("8191" "𣱯")
("8194" "敍𢿸")
("8198" "&M-43422;")
("8210" "㔐䤛䥷剉剑釗釧鈏鉶銂鋓鍘𠛮𨦙𨭚𠟅𠟊𠠃&M-41003;𠛲&M-49814;&M-40743;")
("8211" "釓銋銚銸錘錷鍾鎧鏙鐙鑞锺𨪉𠃽𣮧&C5-4A67;&C5-592F;&M-40561;&M-49812;&M-49827;")
("8212" "䤫䤯䤱䤺䥴釤釿銟銹鍴鏩鐁鐈鑴𢒐&C5-6556;&M-40903;&C6-6350;&C6-6351;&M-40420;&C7-5D30;&M-41060;")
("8213" "䤨䥀釽鈲銩鍨鎃鏭鏷鑂𨥧&M-40971;")
("8214" "鋋鋌鋖鋝鋢錌鍐鍰鏺鑀錗&M-40221;&M-40670;")
("8215" "錚鐖&M-40209;")
("8216" "銗銛銽錉錔錙鍎鍿鐇&M-40618;")
("8217" "䤾鈯鍤𨥥&M-40241;")
("8218" "鎻鑕&M-49821;")
("8219" "鉌鏁鏫鑠")
("8220" "㓱剃𠚼𠞊𠜑𠟖")
("8221" "䶵毤毹𣬩𡯲")
("8222" "𣂮&M-48885;")
("8223" "㶗𤫫")
("8224" "𡡚")
("8226" "𦧎𥇮")
("8229" "龢")
("8230" "刢𠟃𠠆")
("8231" "𣬹𣯇")
("8233" "懖𤫲𢤌")
("8240" "㔍剣矧𠝢𠛶𠞼𦗦𦗾𦘉")
("8241" "𥎺𣰚𣰖")
("8242" "矯𢒑𣃍𥐀")
("8243" "矨𥐁𥎽")
("8244" "矮𥏎")
("8247" "䂐")
("8250" "𠠀")
("8251" "䍮𦏫")
("8252" "羏𦎋")
("8254" "羝䍴")
("8255" "䍵𦏑")
("8256" "羳")
("8257" "𦍦")
("8258" "羰")
("8259" "䋣")
("8260" "㓣㓧劊創劄睂𠟂𠟏")
("8261" "䜲𣯽&M-39946;")
("8262" "㣒𣃀𣃑")
("8263" "豀")
("8264" "𧮮")
("8265" "㧱")
("8266" "𧮶")
("8270" "㓡刉刏创刽钊钏铡𠛀𠛛")
("8271" "䭓钆铠铫锤镫飥飪餆餁𦉂&C5-5265;𦉎&C5-6027;&C5-6A68;&C5-6E63;&C6-3522;&C6-3C77;&C6-5A42;&C7-356F;𦉖&C7-4532;")
("8272" "䭨钐锈&C5-6032;&C6-463B;&C7-4C24;&C7-5D56;")
("8273" "䍇䭡铥飫𩚮&C5-663F;")
("8274" "䬫钎钣铤锊锾餒餧𩛝𦈴&C6-5A40;&C7-2B40;&C7-3D7E;&C7-515A;")
("8275" "饑")
("8276" "缿锱锴餂&C5-4B4A;&C5-5A25;")
("8277" "锸飿饀&C5-4B4D;")
("8278" "镤")
("8279" "铄&C5-5A22;&C5-6A67;&C5-7670;&C7-356E;&C7-3E21;&C7-4531;")
("8280" "劍𠟬𤏼")
("8282" "矫")
("8283" "𣲝")
("8285" "𢪽")
("8305" "㦰𢦜")
("8310" "釙鈊鉍")
("8311" "䤞䥉鈗鉈鋎鋺鍹鑹&M-40816;&M-40788;&M-40936;")
("8312" "䥱鋪鍽鏒鑏&C6-6353;")
("8313" "銢銶鋃鋐錑鎵鏹钀𨬃&M-40664;&M-40962;&M-33825;")
("8314" "䤹釴鈸鉽銨鋑鋱鎛鉼&C7-3C78;")
("8315" "䤦䥫鈛鉞鉾銊銭鋨鋮錢鍼鏚鐵鑯韱𨦭𢦺&M-40726;&M-41098;&C7-4441;&M-40809;&M-40912;&M-40959;&C7-5965;&M-41025;")
("8316" "鈶鎋鎔鏥鑙&M-40527;")
("8317" "錧")
("8318" "錠鏔鑌鑳𨬓&M-40834;")
("8319" "鉥錝鑔")
("8320" "𠟐")
("8321" "𡯠")
("8325" "𢨍")
("8328" "&M-36899;")
("8332" "&M-47476;")
("8335" "𢧥")
("8340" "剙")
("8344" "𥎱")
("8351" "䍫羦羫")
("8352" "羜")
("8354" "䍸羧𦍺")
("8355" "羢羬𦎗𦎘")
("8356" "𦎱𦎩")
("8361" "㞃谾")
("8362" "舖&M-44504;")
("8363" "猷𤡿")
("8364" "&M-44493;𢎒")
("8365" "䜮䤋戧馘𧮺𢨉")
("8366" "𧯆&C7-5067;")
("8367" "舘")
("8370" "钋铋飶𠧩&C6-3C76;")
("8371" "铊&C5-4441;&C7-3563;")
("8372" "䍆䭢铺餔𩞀")
("8373" "锒镓&C5-5264;&C5-6A64;𦈭&C7-5163;")
("8374" "钹铵铽餕餠餺&C6-5A3B;&C7-3D77;&C7-3D7C;")
("8375" "䬻戗钱钺铖锇镩餓餞𦈸&C5-7222;&C5-7470;&C5-766F;&C5-795D;𦈻&C7-5159;")
("8376" "飴&C5-663B;")
("8377" "館")
("8378" "锭镔")
("8379" "镲&C5-746E;")
("8380" "㕗")
("8385" "𢨔")
("8410" "針釮鈄鉜鑆𡓉&M-40327;")
("8411" "䤶䥃䥵釚釶釷鈂鉪銈銑銠鋩錴錵鍖鍷鎑鐃鑉鑵&M-40193;&M-40245;&C7-6271;")
("8412" "䤭䤻勜釛鈉鈽銙銪銬鋤錡鏋钄𨧨𨬍𨭛&M-40967;𠢄&M-40476;&M-49831;")
("8413" "䥦釱鈜鈦鉣鋏鋕錰鎱鏌鐽鍅鍈")
("8414" "䥈䥑䥬釹鈘鈹銌鋍錂錛鑄鑊鑝鑮𨨲&C5-5933;&M-40668;&M-40697;&M-40883;&M-40832;&M-41028;")
("8415" "䥠鍏鏵鑖鑶鑻")
("8416" "鈷銡鋯錨錯鍣鍩鍺鎝鐑鐯𨪌𨪓&M-40481;&M-41039;")
("8417" "鉗")
("8418" "錤鎮鐼鑟鑽鐄&M-49829;")
("8419" "䥡鈢銝錸錼鍱鎍鐐鐷&C5-517B;&M-40393;&M-40574;&M-40898;&M-41086;")
("8420" "𣁺")
("8421" "𡜎𡯛𤿑𡯸")
("8422" "勧&C7-5D74;")
("8424" "㿷𤿫𥀞")
("8426" "𡱨𡲞")
("8428" "&C5-5852;")
("8436" "&M-46575;&M-46623;")
("8440" "𥎧")
("8441" "𥐓")
("8442" "㔙𥏜")
("8443" "𥎰")
("8444" "䂔矱𥏢")
("8446" "䂒")
("8450" "𣁵")
("8451" "𦏊𦍔𦎉𦎻𦎺")
("8452" "勄劷")
("8455" "䍷𦎚𤕛")
("8456" "𦍩")
("8458" "羵𦏢")
("8460" "𣁴")
("8461" "䜪")
("8462" "𠢙𠢡𠡼")
("8463" "谹𧯀")
("8464" "𡞜𥀟")
("8467" "𧮳")
("8468" "谼豄")
("8470" "针钭&C5-4447;&C5-6034;")
("8471" "罐钍铑铣餣餷饁饉饐饒饚𦈰&C5-3647;&M-40680;&C5-602F;&C5-663E;&C5-766E;&C7-3D7B;&C7-515C;&C7-5A34;")
("8472" "㔕㔦䍎䭉钠钸铐铕铹锄餙餚餝𠠶&C5-3D4E;&C6-4639;&C7-515F;")
("8473" "䭊钛链饃饛𩛣&C5-7226;&C7-2B3C;&C7-356B;&C7-452E;&C7-5648;&C7-5A36;")
("8474" "䭦缽钕铍铧锛镬餀餑餴𩛏𩞑𩟓𢻂&C5-4B49;&C5-4B4B;&C5-597B;&C5-746F;𦈫&C6-6443;&C7-5A35;")
("8476" "钴锆锗锘错锚饎&C5-597C;&C6-5A39;&C7-3D7A;&C7-452F;")
("8477" "钳𩚵")
("8478" "镆镇饙饡&C5-6E64;")
("8479" "䭎䭟铩镣&C5-602E;")
("8490" "斜")
("8510" "鈝鉂鉮銉鋛&M-40539;")
("8511" "䤜鈍鉎&M-41063;")
("8512" "鉘錆鏽&M-40274;&M-40332;")
("8513" "鈇鈌鉄鉠鉢鉵銕錶鏈鏸&M-40604;&M-40793;&M-41066;")
("8514" "䤡鋳鍵鏄鏤𨪋&M-49807;&C7-3464;")
("8516" "鈾鏪鐟&C7-506B;")
("8517" "鏏")
("8518" "䥊錪鐀鐨鑚")
("8519" "銇銖鋉錬鍊")
("8520" "&M-38488;")
("8521" "&M-32884;")
("8552" "䍨𦍜")
("8553" "䍺羠&M-33722;")
("8554" "𦎹")
("8556" "𦏋")
("8558" "𦎸")
("8559" "䍪䍶")
("8561" "𧮭")
("8566" "䜬")
("8570" "䭄钟")
("8571" "䭍钝铙飩&C6-463A;")
("8572" "锖&C7-3565;")
("8573" "䬬䬱䭤缺蝕钵𩞍&C5-6A65;&C5-7225;&C7-3566;")
("8574" "䭈铸键")
("8576" "铀&C5-6A66;&C7-515B;&C7-5161;")
("8577" "&C5-663D;")
("8578" "铁铗镄饋&C7-5D55;")
("8579" "䬴铢铼餗&C5-597A;&C7-452D;&C7-6028;")
("8610" "䤧釦鈤鈿鉑鉫鉬銣銦錮&M-40473;")
("8611" "䚊鉭鋥鋧鋰錕鍟鍠鎞鎠鎤鑸鑺鑼𨪈䥯&M-40395;&M-49813;&M-49820;")
("8612" "䤢䥟蠲銱鋗錦錫鍔鍚鍝鍻鎉鐊鐋鐲&M-40748;&M-40836;&M-40944;")
("8613" "䤽䥪鋘鍡鍶鎴鏓鐶鑤&M-40660;&C6-634F;&C7-3D22;𦒥&M-33808;&M-41084;")
("8614" "銲錍鍓鏝鐸钁&C7-443B;")
("8615" "鉀鏎")
("8616" "鋁錩鑘&M-49818;")
("8617" "&M-40829;")
("8618" "鉙鋇鋜鍉&M-40914;")
("8619" "錁鏍鐛鐰")
("8621" "覦観𧠝𡯒&M-34827;&M-34987;𡯧𡰂")
("8622" "䶏𠕧")
("8626" "&M-48889;")
("8640" "知聟𥏯𥎶")
("8641" "䂓矲&M-34895;&M-45814;&C7-4B26;")
("8642" "𥏫")
("8644" "𥏠𥐑")
("8650" "䍰𦍾")
("8651" "𦎔")
("8652" "羯𦏕")
("8653" "䍹𦎀𦏉𦏖")
("8658" "𦎊")
("8660" "䣽智&M-44514;")
("8661" "䚐&M-39687;")
("8662" "&M-40010;𧯐")
("8664" "䜰䜱朇𧯌")
("8665" "𧯔")
("8668" "&C7-4A4E;")
("8670" "䭅钼钿铂铟铷锢&C5-7229;&C6-5043;")
("8671" "㲛䭂钽锂锃锟餛餭餽饠鼅鼅&C5-5268;&C5-526A;&M-34845;&C6-5A3A;")
("8672" "䬼铞锅锡锣锦锷镯餲餳&C5-5A21;&C5-663C;&C5-7227;&C5-7228;&C7-356A;")
("8673" "䭒锶镪餵罎𩝠𩟁")
("8674" "䭞锝镘饅𩛧")
("8675" "钾饆&C6-5A3C;𦉕")
("8676" "铝")
("8678" "䍉𦉁&C7-5162;")
("8679" "䭋䭘锞镍镙餜")
("8680" "䝷")
("8691" "覙")
("8710" "塑")
("8711" "䤟䤥釔釠釩釲鈀鈕鈮鉋鉏銫鋔錳鏗鑃鑱𩗩𡎬𦫫&C5-6A31;&M-40326;&M-40331;&M-40933;&M-40930;&M-40964;&M-40963;")
("8712" "䣃䤝䥏䥨卸釕釖釢釣釰釸鈅鈎鈞鈟鉚鉤鉰鉹銁銄銅銿鋣鋦鋼鋾錋錭鍆鍋鍧鍸鎁鎙鎢鎯鏅鏐鐍鐗鐧鑭钃鵭鶲鷁鷑𨥨𨝫&M-39397;&C5-3065;&C5-435C;&M-39548;&M-40532;&C5-5935;&M-40796;&M-40881;&M-47092;&C5-7733;&M-47400;&C5-7A40;&M-39603;&M-40582;&C7-443C;&M-47196;&M-41068;")
("8713" "䤸䥂螸鉖銀錄録鍃鍥鍭鍯鎚鏠鐌鐭鐹鑗&M-40714;")
("8714" "釨釵鈒鈠鈱銏銵鋟鋷錣鍛鍜鎩鎪鎫鏘鐞&M-40177;&M-40894;&M-40460;")
("8715" "䤿鉧鋒鍕&M-40412;")
("8716" "䥁鉊鉻銘鋸鍲鎦鏴鑥&M-40494;")
("8717" "䤴鈻錎鎐𨧱&M-40655;")
("8718" "䥗䥲欽歙鏆鏉鐉鐝𨯺𣣼𣣽&M-40974;&C7-6273;")
("8719" "䤪䥛鉨鍒鎟鎳&M-40551;&M-40856;&M-41043;")
("8721" "䒊觎䬇𪛕𣩭𡰊")
("8722" "䲸邠鄃鳹鳻鵜鸙鹈鹣&M-39318;𦑺&M-46762;𦒈&M-46925;&M-47129;&M-39320;𦑦&M-46997;&C7-5245;&M-47455;")
("8723" "龣&M-48902;")
("8724" "&M-48897;")
("8728" "㰡欦歈歉歓龡𣢍𣢏𣢲")
("8732" "翎邻鄦鴒鶼鷡鷷&M-47309;")
("8733" "愬慾憌")
("8738" "𣣈𣢝𣣵")
("8741" "㸖艵𥎾")
("8742" "朔郱鄭鴙鵧&C5-3C7B;&M-46721;&M-47088;&M-49939;&M-47496;")
("8743" "䂕")
("8744" "矪𥏞𣫑")
("8745" "剏")
("8746" "䂏𥏵")
("8747" "𥏘")
("8748" "欮𣢴𣤏")
("8750" "&M-38409;")
("8751" "䍯䍲羓羟𦏍")
("8752" "䣡䴊翔郸鴹&M-39390;𦎰&M-39716;&C6-3466;𦍗𦍨𦍻𦍿𦎈")
("8753" "冁")
("8754" "䍳羖𦎆")
("8755" "䍭𦏘")
("8758" "䍻")
("8759" "𦎤")
("8760" "&M-39912;&M-35788;&M-40009;")
("8761" "䒏谻𧮬𧮷&C7-5B31;")
("8762" "䎏䎖䜯䳺卻朆翖舒豂郃郤鄫鄯鄶鴿鵒鵨鶬鸽鹆𨛭𧮻&M-39443;&M-39569;𧯘&M-39535;&M-46964;𧯋𧯎𧯓&M-47482;")
("8763" "𧯂𧯁")
("8768" "㱃欱欲𣢺𦧸𣤗")
("8771" "䬿钇钒钮钯铌铯铿锰飢飷飽饞𩚖𩛟𩝸&C5-3D4D;&C5-4443;&C6-5A3F;&C6-6442;&C7-4529;&C7-5A37;")
("8772" "䬢䬨䬲䬷䭇䲲郐钌钓钔钢钥钧钨钩铆铘铜铴锎锏锔镧飹飼餇餉餬餶鹚𩛽𪂾&C5-3648;&C5-364A;&C5-4445;𦈺&C5-5266;&C5-5A23;&C5-602B;&C5-6037;𦒟&C6-5044;&C6-5A41;&M-46678;&C7-2B3D;&M-46708;&C7-3D7D;")
("8773" "䬶䭀䭔银锪餯餱馋𩞧&C5-5A24;&C5-7224;&C5-722A;&C6-6441;&C7-452C;&C7-5647;")
("8774" "钗锓锵锻锼餟餿䬦&C5-3071;𦉇&C7-3569;&C7-3A46;&C7-3D79;&C7-4C25;")
("8775" "铎铮锋餫")
("8776" "䬰铅铬铭锯镅镏镥餾馏𦉉&C7-356D;&C7-3D76;&C7-5649;")
("8777" "餡&C6-6445;")
("8778" "㰟欫罆钡钦锨锲飲饌&C5-597E;𣢆&C7-3D78;&C7-602A;")
("8779" "𩜷")
("8780" "&M-37888;𤒡")
("8781" "俎")
("8782" "劎郑劒&M-46751;")
("8784" "𣫢𣫍")
("8785" "劔")
("8788" "歛𣤉")
("8790" "䌓槊𦃗")
("8791" "糴")
("8792" "䣄䳜&M-47446;")
("8794" "叙")
("8800" "从𠓜")
("8810" "䇘䇛䇠䇥䇪䇰䇸䇺䈽䉡丛坐竺笁笙笠笡笪筀筌筮箜箠箮箽篁篂篕簊簋簠簦簺籃籉釞釟鉯鳘𥳘𥶊𥸀𥭭𥮖𥮭𥮍𥯑𥲠𥲥𥴀𥴡𥵧𡔗𥬚𥬛&M-40243;𥭤𥭧𥯰𥱆𥱐𥴁𥴓𥵭𥶞𥶴𥷛𥷟䉹")
("8811" "䈌笵筂筄筑箲籈籦釳鈼鉇銓銳銼鋭錓鍦鎈鎎鎰鑑鑬𥬮𥬶𥭙𥬳𥸗𥬑𥬻&M-40202;&M-49808;𥰤&M-40552;𥶎&M-41097;")
("8812" "䇵䈬䈮䈳䈵䉧笃笉笻筇筠筯箌篛簜鈐鈖鉁鉓銻錀鍮鎀鎓鑰𥰚𥴰𥵣𥵥𥬿𥭀𥱀𥯙𥲊𥲟𥳷&M-40756;𥴴&M-41077;𥯘&M-40852;𥷢&M-41041;")
("8813" "䉁䥖䥙箓籙蠞鈆鈴鉃錜鎂鎌鎡鏃鐩𥳎𥭑𥮤𥰱𥴵𥸢𥭥𥯠&C7-2B39;𥱄&M-40949;")
("8814" "䈣䥕䥞䥩敛箃箥篈簿鉼鍑鏾鐏鐓𥱼𨩺𥰅𢿴𥰛𥲝𥳣𥵪𥵢&M-40871;𥷨𥸘𥮓&M-40677;𥴾𥵓&M-40830;")
("8815" "䈅籖籛籤鋂𥳒𥷰")
("8816" "䈃䥘箈箔簬籓鉛鉿鋊鋡鎗鏳鐠𥮒𥯛𥵄𥃙&M-40932;&C7-5969;𥸐")
("8817" "篲𥮢𥲌")
("8818" "笖篊鏇鏦鐱𥳧𥶛𥲄")
("8819" "鉩鏼𥲚𥴽")
("8820" "䇡笒箩篸𠁥𥬯𥫙𥭋𥭢𥯢𥯳𥲪𥳦")
("8821" "䇮䇻䈈䈭䉱尲竼笎笐笕笮筅筦筧筰箎箢箷箼篧篪篼簄簅簆簏籊籗籚籝籠籭籯籱&C3-6168;𥰭𥲤𥳱𥬱𥭬𥰘𥲎𥲁𥲜𥳲𥳌𥴯𥶓&M-45927;𥷜𥷬𠒃𥫺𥬾𥭨𥰾𥳸𥷖")
("8822" "䇖䇙䇟䇤䇶䇷䈁䈑䈒䈝䈥䈪䈻䉍䉮䉲竹笍笏笫第笭筋筒筕筩筲简箅箐箒箫箭箾篅篇篙篟篣篱篽簡簢簥簫籋籣籥簘𥳑𥬵𥭖𥯕𥰢𥳔𥴱𥴩𥵨𥷙𥫳𥫴𥬬𥬭𥬼𥭕𥭞𥭘𥮪𥮐𥰧𥲈𥲋𥳥𥳜𥳐𥵬𥶆𥶽𥶿𥷄𥫚𠕞𥫶𥭦𥮩𥮫𥯷&C7-316F;𥲫𥳫&C7-413C;𥴥𢅸𥵵𥵸𥷉𥷑𥷝𥷽")
("8823" "䇚䈆䉀䉉䉌䉫瀪笊笟笨箊篆篌簇簒簶簾籇籐𥬷𥰠𥴧𥫸𥱂𥰟𥵜𥶔𥶌𥶻𥰉𥶼")
("8824" "䈔䈗䈜䈸䉃䉄䉈䉠䉨䉬䉰䉷攽敓敚笈笌符笩筱箙箯箳簈簰㪁𥰦𥰙𥳆𥳊𥴫𥴨𥴤𢾄𥯖𥯞𥯯𥰹𥲉𥱿𥲖𥳴𥳇𥷱𥬖𥭪𥭸𥯼𥲬𥲼𥳨𥵩𥷲𥸇")
("8825" "䉏䉔䉞筏筗筬箴箻篾簚𥯣𥳞𥶒𥬫𥳏𥴸𥵞𥶹&M-38543;")
("8826" "䈹篃篖簷𥶋𥴿𥴔&M-36099;")
("8827" "𥮝𥬍")
("8828" "篵簁簴𥲗𥳗𥵯𥶐𥷅𥸊𥰽𥸜")
("8829" "篠篨籘𥮜𥭫")
("8830" "䉦笗笾篴篷簉簻籧籩𥯧𥱻𥲽𥶷𥲆𥳿𥳪𥳟𥴦𥴪𥳤𥳠𥸅")
("8831" "篞𥶸")
("8832" "䈴䉆䉣篤篶𥶘&M-47252;𢤉")
("8833" "䈚䈡䉑䵵怂慜篜鰵𥮘𥯨𥳝𥷀𥭜𥭡𥮨𥰝𥲡𥲅𥳬𥳋𥳚𥴺𢥰𥸈𥯱𥴲𥶙𥶟𥵴𥷾")
("8834" "敜等筹篿𥭐𥳰𥳍")
("8835" "䉳")
("8836" "𥷫𥸣")
("8838" "𥵝𦏠")
("8840" "䇯䈇䈉䈊䈦䉶夎竽竿笅筊筟筳筵筸箄箤箰箿篗簍簟籰耸𥬏𥯦𥫜𥫝𥫞𥫢𥭟𥲑籆𢆑𡴤𥯴𥰺𥰞𥵳")
("8841" "䉅䉜矬笼籬𥫹𥬗𥲇𢼠")
("8842" "䈀䈧竻篘簩𥶶𥷚𥫷𥭝𥯔𥮙𥏻𥰬𥳭𥵱𥷤&M-43084;&C7-6432;&M-47472;")
("8843" "䉛笑笶筴箛𥬇𥫵𥮯𥯮𡚅𥯝𥯫𥯪𥯬𥱁𥲦𥱶𥱹𥳢𥏀𥮅𥰥")
("8844" "䈂䈛䈠䈲䉸笄笧笯笲筓筭算簙簳籔𢼶𥰰𣀔𥫼𥬒𥬕𥮎𥲏𥶈𥶜𥷁𥎪𥫠&C6-6023;𥯹𥱏𥱅𥰩𥲯𥶝𥷂𥷭")
("8845" "𥬪𥴣")
("8846" "䉋矰笳筎𥏲𥶫")
("8848" "𥸡𥯺𥱩𥲩")
("8849" "𥶗𥽧")
("8850" "䇝䇨䇩䉊笋笚笺筆箋箏篫篳簞𥭗𥰪𦍏𥫯𥬐𥬴𤛎𥯤𥳶&M-38570;𥫻𥬽𥴂")
("8851" "筢箍範𥷘𥱍𦍥𥰳")
("8852" "䇽䈰笰箉羒羭簕𥷴𦍪𥮚𠁮")
("8853" "䇦䇲䉖䉥羚𥳺𥬟𦎴")
("8854" "䉗䉟䍩敏篺籜𥴮𥷐")
("8855" "䉝箨篝簼𥯟𥬰𥯿𥱎𥲙𦏣𥷪𦏭")
("8856" "䉐筘簎簵籀籒𥴻𥮠𥶪")
("8857" "箝")
("8858" "簐羷𥳳")
("8859" "䍱")
("8860" "㫺䁞䇢䇧䇱䇹䇾䈋䈍䈏䈞䈶䉒䉕䉢笘笛笝笞笤笿筁筃筈答筥筨筶箁箇箘箬箵箸箺篬簂簪簭簮簹𥯶𥰸𥱽𥵟𥬝𥭚𥭠𥭮𥭒𥯾𥰶𥰻𥰣𥲍𥱵𥲢𥶕𥶚𥶇𥭛𥮦𥮑𣊦𥰫𥰷𥲞𥱾𥳙𥵶𥷠𥸑&C7-637E;")
("8861" "𥯡𥯭𥵽")
("8862" "笥笱笴筍篎篰𧮱𧮰箶𥯩𥰵𥳩𥭔𥰮𥳉𥳕𥶏𠷜𥯽𥰯𥲮")
("8863" "𪗲𠏧𥷿")
("8864" "㪉籌豃𥴬")
("8865" "𥯒")
("8866" "䉪谽𧮵𥷇&M-44511;")
("8870" "䬮飤&C6-3C78;&C7-2B3E;")
("8871" "䇫䇼䉚䉭䬣䬽竾笀笆笓笔笣笸筐筪箆箞箟箧篋篚篦篭篹铨锉锐镒飵餼饈䇭籄𥫱𩚤𥫟𥬙𥭯&C5-4446;&C5-5269;𥱸𥱺𥳈𠉒𥬌𥭱𥭣𥭷𥮞𥯓&C7-2B3F;&C7-356C;𥲻")
("8872" "䈓䬾節篩簖籪飭飻飾𩝧&C5-3D4F;&C5-6035;&C5-6A69;𥵦𥬓&C6-5046;𥰴")
("8873" "䇗䈘䉴䍅䭃䭐䭑䭥筤篡簑籑铃餸餻䉙䉵𥬔𥫛&C5-4448;𥯜𥶑𥮔&C7-3564;𥲘&M-33484;&C7-4C27;")
("8874" "㩿䭛笢罇镦餅饊敏𩛅𥫽&C5-6033;𥷮𢼏&C7-5160;𥷣𥷯")
("8875" "䬺镎")
("8876" "䭝铪镨餄饍𩝞&C7-3570;")
("8877" "䇞䈄䈱䈼笜管𥯥𥮛&C6-6444;𥸖")
("8878" "镁镞镟餩餩&C5-6A6A;&C5-722B;")
("8879" "餘&C6-5A3E;")
("8880" "䇜䈕䈯䈿䉯筫箑箕箦篔篢簀簣簤簧簨籅籫𥬹𥮏𥱷𥷔𥫰𥱇𥳡𥴹𥴶𥷞𥷼𠉭𥯗𥳹𥵐&M-43753;")
("8881" "𥲨")
("8882" "䈟簛𥭓𥰨𥲣𥵲𥶖")
("8884" "斂簸")
("8888" "簽籢𠈌𠑲𥰲𦏇𥵫")
("8889" "𥶺𥷕𥰂")
("8890" "䇣䇬䉂䉎策筡箂築篥篻簝籞繁纂筞𥬲𥮮䈎䈢𥰼𥲀𥣚𥬎𥬞𥮧𥮣𥲧𥲕𥴷&M-26673;𥸉𥬸𥭰𥯲&C7-264D;𥰿𥲒𥳮𦅪𥷃𥸋")
("8891" "䉩籮𥯸𥮕𥰜𥳛𥳵𥴢𥷈𥷩")
("8892" "䈫䈾筣箣箹簃𥳓𥮥𥮗𥴭𥵰")
("8893" "䈺筷絵𥷗𥵅𥵮𥶾")
("8894" "䈖䈙敘𥰡𥲛𥵠𥶍𥷆𥵡𥵤𥶵𥸃")
("8896" "䈷箱籍籕𥯚𥲐𥳖𥳯𥷸")
("8897" "䈤")
("8898" "䈐篍簌籟")
("8899" "䉓䉘箖𥵹")
("8910" "釥")
("8911" "銧錈鎲鏜")
("8912" "䤬鈔銷鋿鏛鐒")
("8913" "钂&C5-517C;")
("8914" "&M-40725;&M-41027;")
("8915" "鉡鏻")
("8916" "鐺")
("8918" "鈥錟鍬鎖鑜")
("8919" "銤鏿鑅")
("8922" "㝺")
("8941" "𥏙")
("8942" "𥏟")
("8962" "𧯍")
("8965" "𠵵")
("8968" "㷕")
("8969" "𧯊")
("8971" "锩镗饄𩜇")
("8972" "钞销&C6-5045;&C7-3568;")
("8974" "镂")
("8975" "䬳&C5-6E65;䬳")
("8976" "&C5-7223;")
("8977" "铛")
("8978" "钬锁锬锹餤𦈦")
("8979" "饓")
("9000" "小忄")
("9001" "㤝㦃㦇忙忼惟憧憻戂𢛛𢟴𢡒𢢓&M-10606;𢝋")
("9002" "㤃㥬悙慵懏懠𢟢㥔𢞟𢢘")
("9003" "忭怰惤愱慷憔憶懐懡懷懹𢜺𢙇𢟰𢡏𢜚𢟦")
("9004" "忟恔悴惇愯慞𢜬𢟳𢡐&M-10955;𢤈")
("9005" "𢣾")
("9006" "㥉㥫悋惦愔慉")
("9007" "恼")
("9008" "㤥懭")
("9009" "惊懍𢥄𢛐𢤭𢥐")
("9010" "㷑坣堂尘烾鲎鲞𤇙𥁠𣥺𧯦𡔨𤆂𤇁𥁸𥹿𥻎")
("9011" "&M-48859;&C7-4452;")
("9013" "䖭尐𧈨𧒾")
("9017" "当&M-07486;𢑐")
("9020" "㗬少𢒮")
("9021" "㝸光党灮炛覍觉雀麊兤𥹆𩀯𡭪&C7-352B;&C7-5F79;")
("9022" "㡀券奍尚帣常肖觠尙𩱙𠒿𡭙&C6-2D6B;𠝂𡖹𥼇")
("9023" "豢𠓌")
("9024" "牚𣁣")
("9025" "㷠粦")
("9030" "𡭿")
("9032" "䲵駦&M-46665;&M-47052;")
("9033" "㥕㦂鮝黨𢘻𢤤&C7-2B6C;𢠴&C7-6423;")
("9040" "娄𡜈𤌸𡜛𡜽𡝣𤈬𥹢𤋬&M-32571;")
("9041" "㝹𡭾")
("9042" "劣労劵")
("9043" "尖类𠔉𡭟𥾀")
("9044" "灷𥹻𥸶&C6-2C5D;𢍊𥸭𡮁𢍕𢍨𤍚𥻔")
("9050" "举半拳掌牶韏𢦢𡮕𥼈&M-38498;")
("9053" "𡙪&C7-6422;")
("9055" "𥻰")
("9058" "&C7-6424;")
("9060" "営嘗畨當省眷誊𤎭&M-35627;𥋤𣅱𥃻𡮀𠹉𤌻&M-39904;")
("9061" "𤒀")
("9071" "卷巻瓽𣭮𡭠&C6-455E;")
("9072" "弮")
("9073" "㷃尝裳飬餋𤆟&M-34272;&M-34395;")
("9077" "甞齤𤆽𦈹")
("9080" "䟫兴火炎烡糞賞赏黉𡭞𧴪𡭩𤎫𥻪𤑋")
("9081" "㸀炕炷焳熝燑𤏶𤐷𤓒")
("9082" "㸄熇熵焴㷰𤎱")
("9083" "炫熫燋燫燱爊爙")
("9084" "炆烄焞焠焲𤑴")
("9086" "焙煻𤉮")
("9088" "烗焱爌")
("9089" "燣燺𤉬𤒢")
("9090" "尜桊棠泶燊米絭𡭴䄅𡭝𡭯栄𡭽𡮂𣙂𥼢")
("9091" "䊒䊳粇粒粧糡𥹷𥼷")
("9092" "䊞𥻿𥺞𥻭")
("9093" "糠𥼚𥽬")
("9094" "粹𥹜𥻬𥽅𥼁𥼉")
("9096" "糖")
("9098" "䊯")
("9099" "尛𥽰")
("9101" "㤱㤴㥛㥱㦭忨怃怄怇怌怔恆恇恎恒悂悱惬愜愝慨慪憈𢙼𢛟㥾&C4-434E;𢖬𢖷&C5-2438;𢛄𢟵𢣒𢤱𢤩𢚯𢛢𢝎")
("9102" "㤚㥼忊怲懦𢤆𢡤𢣚𢥻𢗃𢝒𢟶𢢛")
("9103" "忶悵愞懅懨𢣿𢠟")
("9104" "㤆㤉㥝㦆忓怦悼憛懮懾𢖳𢙱𢙾𢝠𢟹𢥝")
("9106" "㤳怗恉恓悟愊愐憯𢘆𢚺𢟧𢙖𢡄𢤓")
("9108" "㥧恹愩愼懻𢠷&M-11454;")
("9109" "㥳怀慄慓憟𢡅𢢙")
("9110" "𡔇")
("9121" "甐𧇲")
("9124" "𢼯")
("9128" "&M-43475;&C5-596D;&M-43694;&M-43729;")
("9132" "𩧔")
("9133" "𢛈")
("9140" "𡞟")
("9141" "㽊")
("9144" "𣀱")
("9148" "類&M-43474;")
("9150" "𢰨")
("9154" "叛")
("9158" "頖")
("9161" "㼳㽆")
("9168" "顲&M-43747;")
("9172" "&C7-664B;")
("9174" "𣀏")
("9178" "&C7-3D6A;")
("9180" "&M-37937;")
("9181" "㸌灴炡炬烜烴煙熰爏爐爧爖𤬬𤐀𤉑𤏚𤎠")
("9182" "灯炣炳烆燸爄𦓒𤆏𤊷𤏙𤐨𤓠")
("9183" "㶹㷾烼煗燯爈")
("9184" "敥炍焯燂𤆝㸎")
("9186" "㶺炶炻焐煏煔煯熸𨟽𤌜")
("9188" "烦煩顃烣&C7-504C;")
("9189" "炋熛𤌓")
("9190" "㮡𥽑")
("9191" "䉺粃粔虩虩𥹂𥹚𥽥𥾂𥺘𥽛")
("9192" "粝糥糯糲𥸧𥸯𥸴𥻥𥹴𥽮𥾁")
("9193" "粻𥼞𥼸")
("9194" "䊤粄粳𥽶")
("9196" "粘粞粨糆糣𥻄𥻅")
("9198" "纇頪𥜛&M-43567;𥽣")
("9199" "𥼠")
("9200" "㤡恻悧惻懰")
("9201" "㤛㥴忹怟恌恺愷慛憕𢝆𢛉𢣎𢖪𢖲𢚇")
("9202" "忻惭惴慚憉憍𢙿𢠹𢥘𢘏𢤮")
("9203" "㤇㦩怅悿慀懚𢘌𢜽𢦈𢢥")
("9204" "㥅忏忯悸惾愋𢚀𢜻𢠺𢥚𢚃𢛊𢢟")
("9205" "𢨈")
("9206" "㤧恬惛惱憣𢞮𢣊")
("9207" "㤕忷慆𢙉𢚰")
("9208" "懫")
("9209" "㥒㦡𢟊𢢜𢘨𢜼")
("9210" "&M-40669;")
("9220" "㓬㔂削粼𠚺")
("9221" "㲖亃𦧿&M-37032;")
("9222" "斴𣃌&M-48896;")
("9223" "𤏞")
("9232" "&M-47109;")
("9233" "𢝲")
("9250" "判揱𢱀")
("9263" "㼕")
("9270" "𠠜")
("9271" "𤭰")
("9280" "剡灲𠝿𤆑𤊶")
("9281" "㲜㲭灹烑煄熣燈爉𤈯𤎞")
("9282" "炘烿煓煸燆燍𤈰𤍖")
("9283" "燻𤑿𤇚")
("9284" "烀烰烶烻煖燰爜爝𤉦𤌁𤓡")
("9286" "㷔焝燔𦧡𤊲𤉣&M-19245;𤏾")
("9287" "灿炪𤊿𤒤𤇱")
("9289" "烁爍秌𤍝")
("9290" "粌𣕇𥻃𦂗")
("9291" "籷粍𥼂𥽊")
("9292" "䉼𥼤𥺈𥺚𥻁")
("9293" "䊝𥼜")
("9294" "䉻䉿粁粰糉𥹽")
("9295" "𥼘")
("9296" "䊩")
("9297" "籼")
("9299" "𥽗𥼄𥽸")
("9300" "㣺㤈怭")
("9301" "㤞㤶忧悾惋愃憱惨𢠊𢞲𢠠𢣝𢚍𢥼")
("9302" "㤖悑惼慘懧&C6-3136;𢛙")
("9303" "㤹㦓㦥悢悷憾𢗗懞𢝀𢜿𢡖𢢕𢤪")
("9304" "㦐恜悛愽𢖺𢜶𢢒𢘀")
("9305" "㤜㥇怴恈悈惐慽懺𢜩𢚄𢜾")
("9306" "怡愘愹𢠲𢞐𢞏𢜥")
("9307" "悩悺")
("9308" "𢣐𢠡𢟫")
("9309" "怵悰𢚗𢣼")
("9310" "𡓛")
("9313" "蠽&C7-5471;")
("9321" "䆪")
("9323" "𤡩")
("9325" "𢧵")
("9380" "烞")
("9381" "炨烢烷焢焥煊熩𤐒")
("9382" "烳焪煽𤆼𤍦𤍜")
("9383" "㶼烺燃𤏘𤏟")
("9384" "炦焌煿𤑧")
("9385" "烒煘熾𤈪㸍𤇽𤉫")
("9386" "炲熍熔")
("9387" "炉")
("9389" "炢㷘㸁")
("9390" "𥹅")
("9391" "𥹳𥹈")
("9392" "䊇糁糄糝𥹍")
("9393" "粮糨𥽇")
("9394" "糐𥹇𥻮")
("9395" "䊱𥻇𥼀")
("9396" "𥹋𥽴")
("9398" "𥹼")
("9399" "䊉粽")
("9400" "㤔忖𢥓")
("9401" "㤬㤺㤿㥀㥺㦉忚忱怈恅恠愖慌慬憢懂懛懽恾𢜳𢣏𢙳𢞕𢟾𢘪𢞑&C6-526C;𢟠&C6-5D26;𢤦")
("9402" "㤢㥓㦅忇怖怮恊恗恸悕惰愶慟慲懄懜憜𢗉𢛘𢠿𢞎𦑑𢢖𢚆𢞧𢟼𢟡𢣛")
("9403" "㤸忕忲怯恡悏慔慡慥憽懗懞𢙺𢢰𢤄𢣖")
("9404" "㤊㤒㥄㦜忮忰怶恃悖悻懤愺𢖵𢗛𢝉𢟨𢡇")
("9405" "㦊愅愇懱")
("9406" "㤑㥩㦋㦧怙恄悎惜愭憘懎懵𢜪𢞇𢥃𢙵&M-11260;𢤬")
("9407" "㤌")
("9408" "㤨㥍㦫恢慎憤憷懥慎𢤋&M-11336;𢥎")
("9409" "㦗恘惏惵憭𢜮")
("9410" "墯")
("9412" "𠡱")
("9421" "韑黋")
("9422" "&C7-657D;")
("9424" "𤿨")
("9425" "㒯")
("9433" "𢝍")
("9450" "㪵")
("9455" "&C5-6A57;")
("9472" "勌")
("9480" "炓")
("9481" "㷈灶灺烍烓煁煃熆燒爟𤌍𤎣𤐩𤋨𤑆𤒬𤒽")
("9482" "㶧㶭烠烤烯烵熁燤爋爩焫爤𤊹𤌃𤑳𤐟𤓝")
("9483" "焃煐熯燪爀爑爡㷬𤓦𤑢")
("9484" "㶿㷹烨燽𤐰𤉻𤓄𤓭")
("9485" "煂煒燁")
("9486" "焅焟熺𤏸𤐞𤌕")
("9487" "㶰𤊼")
("9488" "烘熿燌燲𤐗")
("9489" "炑烌煠煤燎𤓈")
("9490" "料籵籿𥹃")
("9491" "䊁䊋䊦糂糚")
("9492" "䊖䊟䊪勬糒糒糷𥼓𥽼")
("9493" "䊔糙糢")
("9494" "䊭籹粋𥹸𥺙𥸳")
("9495" "𥽘")
("9496" "䊀䊰糦")
("9497" "粓")
("9498" "粠粸䊣𥽷")
("9499" "𥻈𥻨")
("9500" "㤤㤦忡𢘊𢘽𢗒𢘶")
("9501" "㦎忳性𢝈𢟸")
("9502" "㤄怫情")
("9503" "㤓㥆㥭快怏怢恞慩憓憹懳爞𢗲𢘷𢠮𢠻𢥞")
("9504" "悽慱慺𢞡𢘦&C6-5D24;")
("9505" "𢜗𢝂")
("9506" "怞慒𢝇𢥱")
("9507" "𢟩")
("9508" "㥏㥽憒𢣜")
("9509" "怽悚愫𢗿𢛔𢙀&M-10929;")
("9513" "&M-33758;")
("9515" "㷯")
("9529" "𠒵")
("9545" "𠣇")
("9548" "𠢣")
("9580" "炐")
("9581" "炖烧燼𤆚")
("9582" "炜炥熽𤌛")
("9583" "炔炴烛")
("9584" "煡煹熡𤆿𤐭")
("9586" "㷮𤊴𤓗")
("9589" "㶬炼煉")
("9590" "粀𥹞")
("9591" "𥸵")
("9592" "䊥精䊘𥼥")
("9594" "䊕䊜")
("9596" "粙糟𥻍&C7-4144;𥽾")
("9598" "䊧𥼃")
("9599" "䊂粖𥹵𥻂")
("9600" "㥵怕怬恛悃慖𢛍𢛕𢘄𢙆𢘾𢛅")
("9601" "㦬怛怳悒悓悜悝惃惶惺愠愧愰慍懼𢚋𢞗𢙃𢚉")
("9602" "㥥悁惕愒愓愕愣㥜𢚻𢞠𢢗𢣔𢤇𢛡𢢔")
("9603" "悞悮愄愢憁懁懪𢝓𢟿𢡀𢡎")
("9604" "㥂悍慢懌戄𢛞𢜱𢡋")
("9605" "憚𢘉𢝟𢞙")
("9606" "㦍㦒𢥑𢙲𢝌")
("9608" "惿愪𢠼")
("9609" "惈憬懆𢥟")
("9611" "&M-39588;")
("9621" "䚏&C5-363C;&M-45829;&C7-2978;&M-39657;")
("9624" "𠓋")
("9651" "&C6-4F58;")
("9661" "䚇")
("9663" "𥽙")
("9680" "烟")
("9681" "䙺炟炾焜煋煌煜煴熀熅爅爠覢𤈑𤎲𤉊𤈥&M-39315;𤌼𤌋𤌒")
("9682" "㷎㷒焆焨焬煟煬燭𤑼𤒫")
("9683" "㷵煨煾熄熜爆𤋀𤒁")
("9684" "焊焷焺熳熶燡𤏵")
("9685" "㷸炠熚燀爗𤐲𤌖")
("9686" "煰𤊻𤓊")
("9687" "𤋪")
("9688" "炽熉熼")
("9689" "㷄燥𤒺")
("9690" "粕糰𥹉𥹊")
("9691" "䊐䊗䊫粯粴糧𥽃𥽺")
("9692" "糃𥻑𥻉𥺳")
("9693" "糗糫糨𥻏")
("9694" "䊡粺𥼺𥻯𥼶𥺛𥽉")
("9696" "糬")
("9698" "䊓𥼟")
("9699" "粿𥼾")
("9701" "㦕忆忋忸怉怚怩怪恑恤悗慳憴忛𢡉𢤯𢥋𢖭𢗑𢗌")
("9702" "㣼㣿㤯㥃㥊㥌㥮㦖㦦㦨忉忬怐恀恂恟恦恫悀悯惆惘愑愲愵憀憪憫憰㥠𢝞𢜭𢡿𢣻𢗇𢝁𢞜𢞬𢖸𢗋𢗕𢗘𢘕𢛠𢡓")
("9703" "㤏㥚㥟㦀恨惚愌愡慅懊𢠽𢚁𢜴𢜵𢞶𢥯𢥾")
("9704" "㣾㥰忣怋怓惙惸憳𢛏𢚌𢝄𢗎𢘎𢟝")
("9705" "恽惲懈𢘃𢘸𢤫𢜲")
("9706" "怊恪惽慴憺𢞦𢞓")
("9707" "惂愮𢞊𢞳")
("9708" "㦏忺惞惧惯慏慣懙懝懶𢦅𢘧𢙊𢢚𢤳𢥡")
("9709" "憏㤾㥡𢜸𢟺")
("9712" "䣘")
("9721" "耀𦧾𠄈𦫢&C7-4D2D;")
("9722" "䣊䳤䶴翷鄰𨙹𨛍𦐺𪄹&C5-6725;&M-39690;𦒪")
("9724" "㲂𣪼")
("9725" "輝辉")
("9727" "𦥿")
("9728" "𣢒")
("9732" "䣣")
("9741" "飊&C5-7A4A;")
("9762" "𨜜&M-39729;&M-47417;")
("9781" "㷐㷥炄炮烃烅熞熤燿煈𤇶𤈦𤆾𤇛𤊛𤏯&M-48861;")
("9782" "㶤㶦㶯㶲㶴䣔䲴灱灼炀炯烔烱焖焗煳煼熌熓熪熮燏燗燘燜爓爛爥邩郯焵𤆞𤑺&M-47024;𤑷𤒻𤊵&M-39669;")
("9783" "㷓㷟炵烬煥熢熥燠燳煺𤊺")
("9784" "㷆炈烐煅煆燖燬𤈧")
("9785" "烽煇𤐕𤑱")
("9786" "炤烙煝熘熠𤉝𤌐")
("9787" "焰熎𤏭")
("9788" "㷷㸊欻歘炊焕焮熐𤒾")
("9789" "煣燦")
("9791" "䊃䊊䊮籶籸粈粑粗𥺣𥼡&C5-717C;")
("9792" "粅粡粷糈糊糏糑𥺝𥽭𥸬𥹠𥻤&M-46900;&C5-796D;𥸾𥹝")
("9793" "䊚粶糇糔𥺶𥼙")
("9794" "籽粣䊛𥼹𥹤𣪿")
("9795" "𥹾")
("9796" "䊅𥻓𥺸𥺢")
("9798" "粎𥻩𥽁𥼻𥸷")
("9799" "糅𥻐")
("9801" "忔怆怍恮恱悅悦惍愾懢忾𢘐𢚂")
("9802" "㤋㦢忦忴悌惀愉慃慯𢡁")
("9803" "㥞忪怜惗慊憮懩𢛒𢟣𢢝𢛨𢞖𢛌")
("9804" "㦑忤恲愎慠憞憿𢠳𢠵𢙋𢝽𢜰")
("9805" "悔惮悔𢥌")
("9806" "㤷㥢恰愴憎懀憎𢡽")
("9808" "憸")
("9809" "悇憡")
("9810" "鐅鳖𡐞")
("9811" "龞")
("9813" "蟞")
("9820" "𥻋")
("9821" "䨆斃&C7-4325;")
("9822" "幣𠟈𢄞&C7-273C;")
("9824" "敝敞𢽐𢿽")
("9826" "&C7-3572;")
("9832" "鷩𪅶&C5-7233;")
("9833" "㥹憋鱉𢢌")
("9840" "嫳𣁢𦗥")
("9843" "獘𡚁")
("9844" "弊数")
("9850" "撆")
("9860" "暼瞥")
("9861" "𤑓")
("9871" "氅鄨鼈𣰉&C7-6342;")
("9872" "彆")
("9873" "&C5-5E41;")
("9877" "𦦢")
("9880" "蹩&M-36877;𤎨&C7-434F;")
("9881" "炝炧炸烂烇熂爁爦𤑸")
("9882" "㷍㷙㸅炌炩焍熻爚𤐯𤌏𤓀")
("9883" "㷻炂烩焧煫熑燧𤉪𤓚")
("9884" "炇燇燉燩𤒦𤍗𤏮𤏽𤏰")
("9885" "㷣烊烸燨爔")
("9886" "烚焀焓煪熗熷燴𤎳")
("9887" "𤈒")
("9888" "㷿")
("9890" "䌘")
("9891" "籺粚糮𥹁𥹲𥺡𥸽")
("9892" "粉糋𥼝")
("9893" "糍糕𥻧𥻖𥹕")
("9894" "敉糤𢿵𥼼𥹎")
("9895" "䊈")
("9896" "糌糩")
("9898" "䊴")
("9900" "𢖹")
("9901" "恍惓憆𢣙")
("9902" "悄惝憦𢛎𢛗")
("9903" "戃𢟱𢞞𢤨")
("9904" "㦪")
("9905" "怑憐𢣶")
("9906" "慻𢥏𢜫𢟷𢡾")
("9908" "惔愀𢙹𢥥")
("9909" "𢘺")
("9910" "䝁塋瑩鎣")
("9912" "䎕")
("9913" "螢")
("9921" "焭覮𡮡")
("9922" "膋𢄋𤍔&C7-3A5F;")
("9923" "滎𤬐")
("9932" "鶑鶯")
("9933" "憥𢥒")
("9940" "嫈燮𡦃𤏻𦖽𤍛𤎬")
("9941" "㷀煢")
("9942" "勞𤎤𠣁")
("9950" "犖&M-38474;")
("9955" "𤌌𤍧")
("9960" "㽦䁝䃕䪯營謍醟")
("9971" "甇")
("9973" "褮")
("9977" "嵤罃")
("9980" "㸉熒")
("9981" "熦")
("9982" "炒焇𤉤")
("9983" "爣𤓔")
("9984" "𤋩")
("9985" "燐𤐪")
("9988" "㷋炏煍燚")
("9989" "爃")
("9990" "榮禜縈")
("9991" "䊎糛")
("9992" "䊑粆𥹶")
("9993" "𥽻")
("9995" "䉽")
("9996" "𥼽")
("9998" "䊏")
("9999" "檾𥻕𥻒𡮐")

)
